/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr.pacman;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.jxr.pacman.ClassType;
import org.apache.maven.jxr.pacman.ImportType;
import org.apache.maven.jxr.pacman.PackageType;

public abstract class JavaFile {
    private Set<ImportType> imports = new HashSet<ImportType>();
    private List<ClassType> classTypes = new ArrayList<ClassType>();
    private PackageType packageType = new PackageType();
    private final Path path;
    private final String encoding;

    protected JavaFile(Path path, String encoding) {
        this.path = path;
        this.encoding = encoding;
    }

    public Set<ImportType> getImportTypes() {
        return Collections.unmodifiableSet(this.imports);
    }

    public ClassType getClassType() {
        if (this.classTypes.isEmpty()) {
            return null;
        }
        return this.classTypes.get(0);
    }

    public List<ClassType> getClassTypes() {
        return this.classTypes;
    }

    public PackageType getPackageType() {
        return this.packageType;
    }

    public void addClassType(ClassType classType) {
        this.classTypes.add(classType);
    }

    public void addImportType(ImportType importType) {
        this.imports.add(importType);
    }

    public void setClassType(ClassType classType) {
        this.classTypes.clear();
        this.classTypes.add(classType);
    }

    public void setPackageType(PackageType packageType) {
        this.packageType = packageType;
    }

    public Path getPath() {
        return this.path;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

