/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.validation;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.validation.ModelValidator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ModelValidator.class)
public class DefaultModelValidator
implements ModelValidator {
    private static final String ID_REGEX = "[A-Za-z0-9_\\-.]+";

    @Override
    public void validateRawModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Parent parent = model.getParent();
        if (parent != null) {
            this.validateStringNotEmpty("parent.groupId", problems, ModelProblem.Severity.FATAL, parent.getGroupId());
            this.validateStringNotEmpty("parent.artifactId", problems, ModelProblem.Severity.FATAL, parent.getArtifactId());
            this.validateStringNotEmpty("parent.version", problems, ModelProblem.Severity.FATAL, parent.getVersion());
            if (DefaultModelValidator.equals(parent.getGroupId(), model.getGroupId()) && DefaultModelValidator.equals(parent.getArtifactId(), model.getArtifactId())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, "The parent element cannot have the same ID as the project.");
            }
        }
        if (request.getValidationLevel() >= 20) {
            ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
            this.validateEnum("modelVersion", problems, ModelProblem.Severity.ERROR, model.getModelVersion(), null, "4.0.0");
            this.validateStringNoExpression("groupId", problems, ModelProblem.Severity.WARNING, model.getGroupId());
            this.validateStringNoExpression("artifactId", problems, ModelProblem.Severity.WARNING, model.getArtifactId());
            this.validateStringNoExpression("version", problems, ModelProblem.Severity.WARNING, model.getVersion());
            this.validateDependencies(problems, model.getDependencies(), "dependencies.dependency", request);
            if (model.getDependencyManagement() != null) {
                this.validateDependencies(problems, model.getDependencyManagement().getDependencies(), "dependencyManagement.dependencies.dependency", request);
            }
            this.validateRepositories(problems, model.getRepositories(), "repositories.repository", request);
            this.validateRepositories(problems, model.getPluginRepositories(), "pluginRepositories.pluginRepository", request);
            HashSet<String> profileIds = new HashSet<String>();
            for (Profile profile : model.getProfiles()) {
                if (!profileIds.add(profile.getId())) {
                    DefaultModelValidator.addViolation(problems, errOn30, "profiles.profile.id must be unique but found duplicate profile with id " + profile.getId());
                }
                this.validateDependencies(problems, profile.getDependencies(), "profiles.profile[" + profile.getId() + "].dependencies.dependency", request);
                if (profile.getDependencyManagement() != null) {
                    this.validateDependencies(problems, profile.getDependencyManagement().getDependencies(), "profiles.profile[" + profile.getId() + "].dependencyManagement.dependencies.dependency", request);
                }
                this.validateRepositories(problems, profile.getRepositories(), "profiles.profile[" + profile.getId() + "].repositories.repository", request);
                this.validateRepositories(problems, profile.getPluginRepositories(), "profiles.profile[" + profile.getId() + "].pluginRepositories.pluginRepository", request);
            }
        }
    }

    @Override
    public void validateEffectiveModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        this.validateStringNotEmpty("modelVersion", problems, ModelProblem.Severity.ERROR, model.getModelVersion());
        this.validateId("groupId", problems, model.getGroupId());
        this.validateId("artifactId", problems, model.getArtifactId());
        this.validateStringNotEmpty("packaging", problems, ModelProblem.Severity.ERROR, model.getPackaging());
        if (!model.getModules().isEmpty() && !"pom".equals(model.getPackaging())) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "Packaging '" + model.getPackaging() + "' is invalid. Aggregator projects " + "require 'pom' as packaging.");
        }
        this.validateStringNotEmpty("version", problems, ModelProblem.Severity.ERROR, model.getVersion());
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        for (Dependency d : model.getDependencies()) {
            this.validateId("dependencies.dependency.artifactId", problems, d.getArtifactId(), d.getManagementKey());
            this.validateId("dependencies.dependency.groupId", problems, d.getGroupId(), d.getManagementKey());
            this.validateStringNotEmpty("dependencies.dependency.type", problems, ModelProblem.Severity.ERROR, d.getType(), d.getManagementKey());
            this.validateStringNotEmpty("dependencies.dependency.version", problems, ModelProblem.Severity.ERROR, d.getVersion(), d.getManagementKey());
            if ("system".equals(d.getScope())) {
                String systemPath = d.getSystemPath();
                if (StringUtils.isEmpty((String)systemPath)) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "For dependency " + d.getManagementKey() + ": system-scoped dependency must specify systemPath.");
                } else if (!new File(systemPath).isAbsolute()) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "For dependency " + d.getManagementKey() + ": system-scoped dependency must specify an absolute systemPath but is " + systemPath);
                }
            } else if (StringUtils.isNotEmpty((String)d.getSystemPath())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "For dependency " + d.getManagementKey() + ": only dependency with system scope can specify systemPath.");
            }
            if (request.getValidationLevel() < 20) continue;
            this.validateVersion("dependencies.dependency.version", problems, errOn30, d.getVersion(), d.getManagementKey());
            this.validateBoolean("dependencies.dependency.optional", problems, errOn30, d.getOptional(), d.getManagementKey());
            this.validateEnum("dependencies.dependency.scope", problems, ModelProblem.Severity.WARNING, d.getScope(), d.getManagementKey(), "provided", "compile", "runtime", "test", "system");
        }
        DependencyManagement mgmt = model.getDependencyManagement();
        if (mgmt != null) {
            for (Dependency d : mgmt.getDependencies()) {
                this.validateStringNotEmpty("dependencyManagement.dependencies.dependency.artifactId", problems, ModelProblem.Severity.ERROR, d.getArtifactId(), d.getManagementKey());
                this.validateStringNotEmpty("dependencyManagement.dependencies.dependency.groupId", problems, ModelProblem.Severity.ERROR, d.getGroupId(), d.getManagementKey());
                if ("system".equals(d.getScope())) {
                    String systemPath = d.getSystemPath();
                    if (StringUtils.isEmpty((String)systemPath)) {
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "For managed dependency " + d.getManagementKey() + ": system-scoped dependency must specify systemPath.");
                    } else if (!new File(systemPath).isAbsolute()) {
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "For managed dependency " + d.getManagementKey() + ": system-scoped dependency must specify an absolute systemPath but is " + systemPath);
                    }
                } else if (StringUtils.isNotEmpty((String)d.getSystemPath())) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "For managed dependency " + d.getManagementKey() + ": only dependency with system scope can specify systemPath.");
                }
                if (request.getValidationLevel() < 20) continue;
                this.validateBoolean("dependencyManagement.dependencies.dependency.optional", problems, errOn30, d.getOptional(), d.getManagementKey());
            }
        }
        if (request.getValidationLevel() >= 20) {
            Reporting reporting;
            HashSet<String> modules = new HashSet<String>();
            for (String module : model.getModules()) {
                if (modules.add(module)) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "Duplicate child module: " + module);
            }
            ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
            Build build = model.getBuild();
            if (build != null) {
                for (Plugin p : build.getPlugins()) {
                    this.validateStringNotEmpty("build.plugins.plugin.artifactId", problems, ModelProblem.Severity.ERROR, p.getArtifactId());
                    this.validateStringNotEmpty("build.plugins.plugin.groupId", problems, ModelProblem.Severity.ERROR, p.getGroupId());
                    this.validatePluginVersion("build.plugins.plugin.version", problems, p.getVersion(), p.getKey(), request);
                    this.validateBoolean("build.plugins.plugin.inherited", problems, errOn30, p.getInherited(), p.getKey());
                    this.validateBoolean("build.plugins.plugin.extensions", problems, errOn30, p.getExtensions(), p.getKey());
                    for (Dependency d : p.getDependencies()) {
                        this.validateEnum("build.plugins.plugin[" + p.getKey() + "].dependencies.dependency.scope", problems, errOn30, d.getScope(), d.getManagementKey(), "compile", "runtime", "system");
                    }
                }
                this.validateResources(problems, build.getResources(), "build.resources.resource", request);
                this.validateResources(problems, build.getTestResources(), "build.testResources.testResource", request);
            }
            if ((reporting = model.getReporting()) != null) {
                for (ReportPlugin p : reporting.getPlugins()) {
                    this.validateStringNotEmpty("reporting.plugins.plugin.artifactId", problems, ModelProblem.Severity.ERROR, p.getArtifactId());
                    this.validateStringNotEmpty("reporting.plugins.plugin.groupId", problems, ModelProblem.Severity.ERROR, p.getGroupId());
                    this.validateStringNotEmpty("reporting.plugins.plugin.version", problems, errOn31, p.getVersion(), p.getKey());
                }
            }
            this.forcePluginExecutionIdCollision(model, problems);
            for (Repository repository : model.getRepositories()) {
                this.validateRepositoryLayout(problems, repository, "repositories.repository", request);
            }
            for (Repository repository : model.getPluginRepositories()) {
                this.validateRepositoryLayout(problems, repository, "pluginRepositories.pluginRepository", request);
            }
            DistributionManagement distMgmt = model.getDistributionManagement();
            if (distMgmt != null) {
                if (distMgmt.getStatus() != null) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "'distributionManagement.status' must not be specified");
                }
                this.validateRepositoryLayout(problems, (Repository)distMgmt.getRepository(), "distributionManagement.repository", request);
                this.validateRepositoryLayout(problems, (Repository)distMgmt.getSnapshotRepository(), "distributionManagement.snapshotRepository", request);
            }
        }
    }

    private boolean validateId(String fieldName, ModelProblemCollector problems, String id) {
        return this.validateId(fieldName, problems, id, null);
    }

    private boolean validateId(String fieldName, ModelProblemCollector problems, String id, String sourceHint) {
        if (!this.validateStringNotEmpty(fieldName, problems, ModelProblem.Severity.ERROR, id, sourceHint)) {
            return false;
        }
        boolean match = id.matches(ID_REGEX);
        if (!match) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, "'" + fieldName + "'" + (sourceHint != null ? " for " + sourceHint : "") + " with value '" + id + "' does not match a valid id pattern.");
        }
        return match;
    }

    private void validateDependencies(ModelProblemCollector problems, List<Dependency> dependencies, String prefix, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        HashMap<String, Dependency> index = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            String sysPath;
            String key = dependency.getManagementKey();
            if ("pom".equals(dependency.getType()) && "import".equals(dependency.getScope()) && StringUtils.isNotEmpty((String)dependency.getClassifier())) {
                DefaultModelValidator.addViolation(problems, errOn30, "'" + prefix + ".classifier' must be empty for imported POM: " + key);
            } else if ("system".equals(dependency.getScope()) && StringUtils.isNotEmpty((String)(sysPath = dependency.getSystemPath())) && !this.hasExpression(sysPath)) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, "'" + prefix + ".systemPath' should use a variable instead of a hard-coded path: " + key + " -> " + sysPath);
            }
            Dependency existing = (Dependency)index.get(key);
            if (existing != null) {
                String msg = DefaultModelValidator.equals(existing.getVersion(), dependency.getVersion()) ? "duplicate declaration of version " + StringUtils.defaultString((Object)dependency.getVersion(), (String)"(?)") : "version " + StringUtils.defaultString((Object)existing.getVersion(), (String)"(?)") + " vs " + StringUtils.defaultString((Object)dependency.getVersion(), (String)"(?)");
                DefaultModelValidator.addViolation(problems, errOn30, "'" + prefix + ".(groupId:artifactId:type:classifier)' must be unique: " + key + " -> " + msg);
                continue;
            }
            index.put(key, dependency);
        }
    }

    private void validateRepositories(ModelProblemCollector problems, List<Repository> repositories, String prefix, ModelBuildingRequest request) {
        HashMap<String, Repository> index = new HashMap<String, Repository>();
        for (Repository repository : repositories) {
            this.validateStringNotEmpty(prefix + ".id", problems, ModelProblem.Severity.ERROR, repository.getId());
            this.validateStringNotEmpty(prefix + "[" + repository.getId() + "].url", problems, ModelProblem.Severity.ERROR, repository.getUrl());
            String key = repository.getId();
            Repository existing = (Repository)index.get(key);
            if (existing != null) {
                ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
                DefaultModelValidator.addViolation(problems, errOn30, "'" + prefix + ".id' must be unique: " + repository.getId() + " -> " + existing.getUrl() + " vs " + repository.getUrl());
                continue;
            }
            index.put(key, repository);
        }
    }

    private void validateRepositoryLayout(ModelProblemCollector problems, Repository repository, String prefix, ModelBuildingRequest request) {
        if (repository != null && "legacy".equals(repository.getLayout())) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, "'" + prefix + ".layout = legacy' is deprecated: " + repository.getId());
        }
    }

    private void validateResources(ModelProblemCollector problems, List<Resource> resources, String prefix, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        for (Resource resource : resources) {
            this.validateStringNotEmpty(prefix + ".directory", problems, ModelProblem.Severity.ERROR, resource.getDirectory());
            this.validateBoolean(prefix + ".filtering", problems, errOn30, resource.getFiltering(), resource.getDirectory());
        }
    }

    private void forcePluginExecutionIdCollision(Model model, ModelProblemCollector problems) {
        List plugins;
        Build build = model.getBuild();
        if (build != null && (plugins = build.getPlugins()) != null) {
            for (Plugin plugin : plugins) {
                try {
                    plugin.getExecutionsAsMap();
                }
                catch (IllegalStateException collisionException) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, collisionException.getMessage());
                }
            }
        }
    }

    private boolean validateStringNoExpression(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, String string) {
        if (!this.hasExpression(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, "'" + fieldName + "' contains an expression but should be a constant.");
        return false;
    }

    private boolean hasExpression(String value) {
        return value != null && value.indexOf("${") >= 0;
    }

    private boolean validateStringNotEmpty(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, String string) {
        return this.validateStringNotEmpty(fieldName, problems, severity, string, null);
    }

    private boolean validateStringNotEmpty(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, String string, String sourceHint) {
        if (!this.validateNotNull(fieldName, problems, severity, string, sourceHint)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        if (sourceHint != null) {
            DefaultModelValidator.addViolation(problems, severity, "'" + fieldName + "' is missing for " + sourceHint);
        } else {
            DefaultModelValidator.addViolation(problems, severity, "'" + fieldName + "' is missing.");
        }
        return false;
    }

    private boolean validateNotNull(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, Object object, String sourceHint) {
        if (object != null) {
            return true;
        }
        if (sourceHint != null) {
            DefaultModelValidator.addViolation(problems, severity, "'" + fieldName + "' is missing for " + sourceHint);
        } else {
            DefaultModelValidator.addViolation(problems, severity, "'" + fieldName + "' is missing.");
        }
        return false;
    }

    private boolean validateBoolean(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, String string, String sourceHint) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            return true;
        }
        if (sourceHint != null) {
            DefaultModelValidator.addViolation(problems, severity, "'" + fieldName + "' must be 'true' or 'false' for " + sourceHint + " but is '" + string + "'.");
        } else {
            DefaultModelValidator.addViolation(problems, severity, "'" + fieldName + "' must be 'true' or 'false' but is '" + string + "'.");
        }
        return false;
    }

    private boolean validateEnum(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, String string, String sourceHint, String ... validValues) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        List<String> values = Arrays.asList(validValues);
        if (values.contains(string)) {
            return true;
        }
        if (sourceHint != null) {
            DefaultModelValidator.addViolation(problems, severity, "'" + fieldName + "' must be one of " + values + " for " + sourceHint + " but is '" + string + "'.");
        } else {
            DefaultModelValidator.addViolation(problems, severity, "'" + fieldName + "' must be one of " + values + " but is '" + string + "'.");
        }
        return false;
    }

    private boolean validateVersion(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, String string, String sourceHint) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if (!this.hasExpression(string)) {
            return true;
        }
        if (sourceHint != null) {
            DefaultModelValidator.addViolation(problems, severity, "'" + fieldName + "' must be a valid version for " + sourceHint + " but is '" + string + "'.");
        } else {
            DefaultModelValidator.addViolation(problems, severity, "'" + fieldName + "' must be a valid version but is '" + string + "'.");
        }
        return false;
    }

    private boolean validatePluginVersion(String fieldName, ModelProblemCollector problems, String string, String sourceHint, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
        if (!this.validateNotNull(fieldName, problems, errOn31, string, sourceHint)) {
            return false;
        }
        if (!(string.length() <= 0 || this.hasExpression(string) || "RELEASE".equals(string) || "LATEST".equals(string))) {
            return true;
        }
        if (sourceHint != null) {
            DefaultModelValidator.addViolation(problems, errOn30, "'" + fieldName + "' must be a valid version for " + sourceHint + " but is '" + string + "'.");
        } else {
            DefaultModelValidator.addViolation(problems, errOn30, "'" + fieldName + "' must be a valid version but is '" + string + "'.");
        }
        return false;
    }

    private static void addViolation(ModelProblemCollector problems, ModelProblem.Severity severity, String message) {
        problems.add(severity, message, null);
    }

    private static boolean equals(String s1, String s2) {
        return StringUtils.clean((String)s1).equals(StringUtils.clean((String)s2));
    }

    private static ModelProblem.Severity getSeverity(ModelBuildingRequest request, int errorThreshold) {
        return DefaultModelValidator.getSeverity(request.getValidationLevel(), errorThreshold);
    }

    private static ModelProblem.Severity getSeverity(int validationLevel, int errorThreshold) {
        if (validationLevel < errorThreshold) {
            return ModelProblem.Severity.WARNING;
        }
        return ModelProblem.Severity.ERROR;
    }
}

