/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.interpolation;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.interpolation.BuildTimestampValueSource;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.interpolation.PathTranslatingPostProcessor;
import org.apache.maven.model.interpolation.ProblemDetectingValueSource;
import org.apache.maven.model.path.PathTranslator;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStringBasedModelInterpolator
implements ModelInterpolator {
    static final String DEFAULT_BUILD_TIMESTAMP_FORMAT = "yyyyMMdd-HHmm";
    private static final String BUILD_TIMESTAMP_FORMAT_PROPERTY = "maven.build.timestamp.format";
    private static final List<String> PROJECT_PREFIXES = Arrays.asList("pom.", "project.");
    private static final Collection<String> TRANSLATED_PATH_EXPRESSIONS;
    @Requirement
    private PathTranslator pathTranslator;
    private Interpolator interpolator = this.createInterpolator();
    private RecursionInterceptor recursionInterceptor = new PrefixAwareRecursionInterceptor(PROJECT_PREFIXES);

    protected List<ValueSource> createValueSources(Model model, final File projectDir, final ModelBuildingRequest config, ModelProblemCollector problems) {
        Properties modelProperties = model.getProperties();
        Object modelValueSource1 = new PrefixedObjectValueSource(PROJECT_PREFIXES, (Object)model, false);
        if (config.getValidationLevel() >= 20) {
            modelValueSource1 = new ProblemDetectingValueSource((ValueSource)modelValueSource1, "pom.", "project.", problems);
        }
        Object modelValueSource2 = new ObjectBasedValueSource((Object)model);
        if (config.getValidationLevel() >= 20) {
            modelValueSource2 = new ProblemDetectingValueSource((ValueSource)modelValueSource2, "", "project.", problems);
        }
        ArrayList<ValueSource> valueSources = new ArrayList<ValueSource>(9);
        if (projectDir != null) {
            PrefixedValueSourceWrapper basedirValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

                public Object getValue(String expression) {
                    if ("basedir".equals(expression)) {
                        return projectDir.getAbsolutePath();
                    }
                    return null;
                }
            }, PROJECT_PREFIXES, true);
            valueSources.add((ValueSource)basedirValueSource);
            PrefixedValueSourceWrapper baseUriValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

                public Object getValue(String expression) {
                    if ("baseUri".equals(expression)) {
                        return projectDir.getAbsoluteFile().toURI().toString();
                    }
                    return null;
                }
            }, PROJECT_PREFIXES, false);
            valueSources.add((ValueSource)baseUriValueSource);
            String timestampFormat = DEFAULT_BUILD_TIMESTAMP_FORMAT;
            if (modelProperties != null) {
                timestampFormat = modelProperties.getProperty(BUILD_TIMESTAMP_FORMAT_PROPERTY, timestampFormat);
            }
            valueSources.add((ValueSource)new BuildTimestampValueSource(config.getBuildStartTime(), timestampFormat));
        }
        valueSources.add((ValueSource)modelValueSource1);
        valueSources.add((ValueSource)new MapBasedValueSource((Map)config.getUserProperties()));
        valueSources.add((ValueSource)new MapBasedValueSource((Map)modelProperties));
        valueSources.add((ValueSource)new MapBasedValueSource((Map)config.getSystemProperties()));
        valueSources.add((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                return config.getSystemProperties().getProperty("env." + expression);
            }
        });
        valueSources.add((ValueSource)modelValueSource2);
        return valueSources;
    }

    protected List<? extends InterpolationPostProcessor> createPostProcessors(Model model, File projectDir, ModelBuildingRequest config) {
        if (projectDir != null) {
            return Collections.singletonList(new PathTranslatingPostProcessor(PROJECT_PREFIXES, TRANSLATED_PATH_EXPRESSIONS, projectDir, this.pathTranslator));
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String interpolateInternal(String src, List<? extends ValueSource> valueSources, List<? extends InterpolationPostProcessor> postProcessors, ModelProblemCollector problems) {
        if (src.indexOf("${") < 0) {
            return src;
        }
        String result = src;
        AbstractStringBasedModelInterpolator abstractStringBasedModelInterpolator = this;
        synchronized (abstractStringBasedModelInterpolator) {
            for (ValueSource valueSource : valueSources) {
                this.interpolator.addValueSource(valueSource);
            }
            for (InterpolationPostProcessor interpolationPostProcessor : postProcessors) {
                this.interpolator.addPostProcessor(interpolationPostProcessor);
            }
            try {
                try {
                    result = this.interpolator.interpolate(result, this.recursionInterceptor);
                }
                catch (InterpolationException e) {
                    problems.add(ModelProblem.Severity.ERROR, e.getMessage(), (Exception)((Object)e));
                }
                this.interpolator.clearFeedback();
            }
            finally {
                for (ValueSource valueSource : valueSources) {
                    this.interpolator.removeValuesSource(valueSource);
                }
                for (InterpolationPostProcessor interpolationPostProcessor : postProcessors) {
                    this.interpolator.removePostProcessor(interpolationPostProcessor);
                }
            }
        }
        return result;
    }

    protected RecursionInterceptor getRecursionInterceptor() {
        return this.recursionInterceptor;
    }

    protected void setRecursionInterceptor(RecursionInterceptor recursionInterceptor) {
        this.recursionInterceptor = recursionInterceptor;
    }

    protected abstract Interpolator createInterpolator();

    protected final Interpolator getInterpolator() {
        return this.interpolator;
    }

    static {
        HashSet<String> translatedPrefixes = new HashSet<String>();
        translatedPrefixes.add("build.directory");
        translatedPrefixes.add("build.outputDirectory");
        translatedPrefixes.add("build.testOutputDirectory");
        translatedPrefixes.add("build.sourceDirectory");
        translatedPrefixes.add("build.testSourceDirectory");
        translatedPrefixes.add("build.scriptSourceDirectory");
        translatedPrefixes.add("reporting.outputDirectory");
        TRANSLATED_PATH_EXPRESSIONS = translatedPrefixes;
    }
}

