/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.interpolation;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.interpolation.AbstractStringBasedModelInterpolator;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

@Component(role=ModelInterpolator.class)
public class StringSearchModelInterpolator
extends AbstractStringBasedModelInterpolator {
    private static final Map<Class<?>, Field[]> fieldsByClass = new ConcurrentHashMap(80, 0.75f, 2);
    private static final Map<Class<?>, Boolean> fieldIsPrimitiveByClass = new ConcurrentHashMap(62, 0.75f, 2);

    public Model interpolateModel(Model model, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        this.interpolateObject(model, model, projectDir, config, problems);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interpolateObject(Object obj, Model model, File projectDir, ModelBuildingRequest config, ModelProblemCollector problems) {
        try {
            List<ValueSource> valueSources = this.createValueSources(model, projectDir, config, problems);
            List<? extends InterpolationPostProcessor> postProcessors = this.createPostProcessors(model, projectDir, config);
            InterpolateObjectAction action = new InterpolateObjectAction(obj, valueSources, postProcessors, this, problems);
            AccessController.doPrivileged(action);
        }
        finally {
            this.getInterpolator().clearAnswers();
        }
    }

    protected Interpolator createInterpolator() {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.setCacheAnswers(true);
        return interpolator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InterpolateObjectAction
    implements PrivilegedAction<Object> {
        private final LinkedList<Object> interpolationTargets;
        private final StringSearchModelInterpolator modelInterpolator;
        private final List<? extends ValueSource> valueSources;
        private final List<? extends InterpolationPostProcessor> postProcessors;
        private final ModelProblemCollector problems;

        public InterpolateObjectAction(Object target, List<? extends ValueSource> valueSources, List<? extends InterpolationPostProcessor> postProcessors, StringSearchModelInterpolator modelInterpolator, ModelProblemCollector problems) {
            this.valueSources = valueSources;
            this.postProcessors = postProcessors;
            this.interpolationTargets = new LinkedList();
            this.interpolationTargets.add(target);
            this.modelInterpolator = modelInterpolator;
            this.problems = problems;
        }

        @Override
        public Object run() {
            while (!this.interpolationTargets.isEmpty()) {
                Object obj = this.interpolationTargets.removeFirst();
                this.traverseObjectWithParents(obj.getClass(), obj);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void traverseObjectWithParents(Class<?> cls, Object target) {
            if (cls == null) {
                return;
            }
            if (cls.isArray()) {
                this.evaluateArray(target);
            } else if (this.isQualifiedForInterpolation(cls)) {
                for (Field currentField : this.getFields(cls)) {
                    Class<?> type = currentField.getType();
                    if (!this.isQualifiedForInterpolation(currentField, type)) continue;
                    Field field = currentField;
                    synchronized (field) {
                        block37: {
                            boolean isAccessible = currentField.isAccessible();
                            currentField.setAccessible(true);
                            try {
                                String interpolated;
                                Object value;
                                if (String.class == type) {
                                    String interpolated2;
                                    value = (String)currentField.get(target);
                                    if (value != null && !Modifier.isFinal(currentField.getModifiers()) && !(interpolated2 = this.modelInterpolator.interpolateInternal((String)value, this.valueSources, this.postProcessors, this.problems)).equals(value)) {
                                        currentField.set(target, interpolated2);
                                    }
                                    break block37;
                                }
                                if (Collection.class.isAssignableFrom(type)) {
                                    Collection c = (Collection)currentField.get(target);
                                    if (c == null || c.isEmpty()) break block37;
                                    ArrayList originalValues = new ArrayList(c);
                                    try {
                                        c.clear();
                                    }
                                    catch (UnsupportedOperationException unsupportedOperationException) {
                                        currentField.setAccessible(isAccessible);
                                        continue;
                                    }
                                    for (Object value2 : originalValues) {
                                        if (value2 != null) {
                                            if (String.class == value2.getClass()) {
                                                interpolated = this.modelInterpolator.interpolateInternal((String)value2, this.valueSources, this.postProcessors, this.problems);
                                                if (!interpolated.equals(value2)) {
                                                    c.add(interpolated);
                                                    continue;
                                                }
                                                c.add(value2);
                                                continue;
                                            }
                                            c.add(value2);
                                            if (value2.getClass().isArray()) {
                                                this.evaluateArray(value2);
                                                continue;
                                            }
                                            this.interpolationTargets.add(value2);
                                            continue;
                                        }
                                        c.add(value2);
                                    }
                                    break block37;
                                }
                                if (Map.class.isAssignableFrom(type)) {
                                    Map m = (Map)currentField.get(target);
                                    if (m != null && !m.isEmpty()) {
                                        for (Map.Entry entry : m.entrySet()) {
                                            Object value2 = entry.getValue();
                                            if (value2 == null) continue;
                                            if (String.class == value2.getClass()) {
                                                interpolated = this.modelInterpolator.interpolateInternal((String)value2, this.valueSources, this.postProcessors, this.problems);
                                                if (interpolated.equals(value2)) continue;
                                                try {
                                                    entry.setValue(interpolated);
                                                }
                                                catch (UnsupportedOperationException e) {}
                                                continue;
                                            }
                                            if (value2.getClass().isArray()) {
                                                this.evaluateArray(value2);
                                                continue;
                                            }
                                            this.interpolationTargets.add(value2);
                                        }
                                    }
                                } else {
                                    value = currentField.get(target);
                                    if (value != null) {
                                        if (currentField.getType().isArray()) {
                                            this.evaluateArray(value);
                                        } else {
                                            this.interpolationTargets.add(value);
                                        }
                                    }
                                }
                            }
                            catch (IllegalArgumentException e) {
                                this.problems.add(ModelProblem.Severity.ERROR, "Failed to interpolate field3: " + currentField + " on class: " + cls.getName(), null, e);
                            }
                            catch (IllegalAccessException e) {
                                this.problems.add(ModelProblem.Severity.ERROR, "Failed to interpolate field4: " + currentField + " on class: " + cls.getName(), null, e);
                            }
                            finally {
                                currentField.setAccessible(isAccessible);
                            }
                        }
                    }
                }
                this.traverseObjectWithParents(cls.getSuperclass(), target);
            }
        }

        private Field[] getFields(Class<?> cls) {
            Field[] fields = (Field[])fieldsByClass.get(cls);
            if (fields == null) {
                fields = cls.getDeclaredFields();
                fieldsByClass.put(cls, fields);
            }
            return fields;
        }

        private boolean isQualifiedForInterpolation(Class<?> cls) {
            return !cls.getName().startsWith("java");
        }

        private boolean isQualifiedForInterpolation(Field field, Class<?> fieldType) {
            Boolean primitive = (Boolean)fieldIsPrimitiveByClass.get(fieldType);
            if (primitive == null) {
                primitive = fieldType.isPrimitive();
                fieldIsPrimitiveByClass.put(fieldType, primitive);
            }
            if (primitive.booleanValue()) {
                return false;
            }
            return !"parent".equals(field.getName());
        }

        private void evaluateArray(Object target) {
            int len = Array.getLength(target);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(target, i);
                if (value == null) continue;
                if (String.class == value.getClass()) {
                    String interpolated = this.modelInterpolator.interpolateInternal((String)value, this.valueSources, this.postProcessors, this.problems);
                    if (interpolated.equals(value)) continue;
                    Array.set(target, i, interpolated);
                    continue;
                }
                this.interpolationTargets.add(value);
            }
        }
    }
}

