/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuildingEvent;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.DefaultModelBuildingResult;
import org.apache.maven.model.building.DefaultModelProblemCollector;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.FilterModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingEventCatapult;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingListener;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.building.ModelCacheTag;
import org.apache.maven.model.building.ModelData;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorExt;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.composition.DependencyManagementImporter;
import org.apache.maven.model.inheritance.InheritanceAssembler;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.management.DependencyManagementInjector;
import org.apache.maven.model.management.PluginManagementInjector;
import org.apache.maven.model.normalization.ModelNormalizer;
import org.apache.maven.model.path.ModelPathTranslator;
import org.apache.maven.model.path.ModelUrlNormalizer;
import org.apache.maven.model.plugin.LifecycleBindingsInjector;
import org.apache.maven.model.plugin.PluginConfigurationExpander;
import org.apache.maven.model.plugin.ReportConfigurationExpander;
import org.apache.maven.model.plugin.ReportingConverter;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.ProfileInjector;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.model.superpom.SuperPomProvider;
import org.apache.maven.model.validation.ModelValidator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ModelBuilder.class)
public class DefaultModelBuilder
implements ModelBuilder {
    @Requirement
    private ModelProcessor modelProcessor;
    @Requirement
    private ModelValidator modelValidator;
    @Requirement
    private ModelNormalizer modelNormalizer;
    @Requirement
    private ModelInterpolator modelInterpolator;
    @Requirement
    private ModelPathTranslator modelPathTranslator;
    @Requirement
    private ModelUrlNormalizer modelUrlNormalizer;
    @Requirement
    private SuperPomProvider superPomProvider;
    @Requirement
    private InheritanceAssembler inheritanceAssembler;
    @Requirement
    private ProfileSelector profileSelector;
    @Requirement
    private ProfileInjector profileInjector;
    @Requirement
    private PluginManagementInjector pluginManagementInjector;
    @Requirement
    private DependencyManagementInjector dependencyManagementInjector;
    @Requirement
    private DependencyManagementImporter dependencyManagementImporter;
    @Requirement(optional=true)
    private LifecycleBindingsInjector lifecycleBindingsInjector;
    @Requirement
    private PluginConfigurationExpander pluginConfigurationExpander;
    @Requirement
    private ReportConfigurationExpander reportConfigurationExpander;
    @Requirement
    private ReportingConverter reportingConverter;

    public DefaultModelBuilder setModelProcessor(ModelProcessor modelProcessor) {
        this.modelProcessor = modelProcessor;
        return this;
    }

    public DefaultModelBuilder setModelValidator(ModelValidator modelValidator) {
        this.modelValidator = modelValidator;
        return this;
    }

    public DefaultModelBuilder setModelNormalizer(ModelNormalizer modelNormalizer) {
        this.modelNormalizer = modelNormalizer;
        return this;
    }

    public DefaultModelBuilder setModelInterpolator(ModelInterpolator modelInterpolator) {
        this.modelInterpolator = modelInterpolator;
        return this;
    }

    public DefaultModelBuilder setModelPathTranslator(ModelPathTranslator modelPathTranslator) {
        this.modelPathTranslator = modelPathTranslator;
        return this;
    }

    public DefaultModelBuilder setModelUrlNormalizer(ModelUrlNormalizer modelUrlNormalizer) {
        this.modelUrlNormalizer = modelUrlNormalizer;
        return this;
    }

    public DefaultModelBuilder setSuperPomProvider(SuperPomProvider superPomProvider) {
        this.superPomProvider = superPomProvider;
        return this;
    }

    public DefaultModelBuilder setProfileSelector(ProfileSelector profileSelector) {
        this.profileSelector = profileSelector;
        return this;
    }

    public DefaultModelBuilder setProfileInjector(ProfileInjector profileInjector) {
        this.profileInjector = profileInjector;
        return this;
    }

    public DefaultModelBuilder setInheritanceAssembler(InheritanceAssembler inheritanceAssembler) {
        this.inheritanceAssembler = inheritanceAssembler;
        return this;
    }

    public DefaultModelBuilder setDependencyManagementImporter(DependencyManagementImporter depMngmntImporter) {
        this.dependencyManagementImporter = depMngmntImporter;
        return this;
    }

    public DefaultModelBuilder setDependencyManagementInjector(DependencyManagementInjector depMngmntInjector) {
        this.dependencyManagementInjector = depMngmntInjector;
        return this;
    }

    public DefaultModelBuilder setLifecycleBindingsInjector(LifecycleBindingsInjector lifecycleBindingsInjector) {
        this.lifecycleBindingsInjector = lifecycleBindingsInjector;
        return this;
    }

    public DefaultModelBuilder setPluginConfigurationExpander(PluginConfigurationExpander pluginConfigurationExpander) {
        this.pluginConfigurationExpander = pluginConfigurationExpander;
        return this;
    }

    public DefaultModelBuilder setPluginManagementInjector(PluginManagementInjector pluginManagementInjector) {
        this.pluginManagementInjector = pluginManagementInjector;
        return this;
    }

    public DefaultModelBuilder setReportConfigurationExpander(ReportConfigurationExpander reportConfigurationExpander) {
        this.reportConfigurationExpander = reportConfigurationExpander;
        return this;
    }

    public DefaultModelBuilder setReportingConverter(ReportingConverter reportingConverter) {
        this.reportingConverter = reportingConverter;
        return this;
    }

    @Override
    public ModelBuildingResult build(ModelBuildingRequest request) throws ModelBuildingException {
        DefaultModelBuildingResult result = new DefaultModelBuildingResult();
        DefaultModelProblemCollector problems = new DefaultModelProblemCollector(result);
        DefaultProfileActivationContext profileActivationContext = this.getProfileActivationContext(request);
        problems.setSource("(external profiles)");
        List<Profile> activeExternalProfiles = this.profileSelector.getActiveProfiles(request.getProfiles(), profileActivationContext, problems);
        result.setActiveExternalProfiles(activeExternalProfiles);
        if (!activeExternalProfiles.isEmpty()) {
            Properties profileProps = new Properties();
            for (Profile profile : activeExternalProfiles) {
                profileProps.putAll((Map<?, ?>)profile.getProperties());
            }
            profileProps.putAll(profileActivationContext.getUserProperties());
            profileActivationContext.setUserProperties(profileProps);
        }
        Model inputModel = this.readModel(request.getModelSource(), request.getPomFile(), request, problems);
        problems.setRootModel(inputModel);
        ModelData resultData = new ModelData(request.getModelSource(), inputModel);
        ModelData superData = new ModelData(null, this.getSuperModel());
        LinkedHashSet<String> parentIds = new LinkedHashSet<String>();
        ArrayList<ModelData> lineage = new ArrayList<ModelData>();
        ModelData currentData = resultData;
        while (currentData != null) {
            lineage.add(currentData);
            Model tmpModel = currentData.getModel();
            Model rawModel = tmpModel.clone();
            currentData.setRawModel(rawModel);
            problems.setSource(tmpModel);
            this.modelNormalizer.mergeDuplicates(tmpModel, request, problems);
            profileActivationContext.setProjectProperties(tmpModel.getProperties());
            List<Profile> activePomProfiles = this.profileSelector.getActiveProfiles(rawModel.getProfiles(), profileActivationContext, problems);
            currentData.setActiveProfiles(activePomProfiles);
            Map<String, Activation> interpolatedActivations = this.getProfileActivations(rawModel, false);
            this.injectProfileActivations(tmpModel, interpolatedActivations);
            for (Profile activeProfile : activePomProfiles) {
                this.profileInjector.injectProfile(tmpModel, activeProfile, request, problems);
            }
            if (currentData == resultData) {
                for (Profile activeProfile : activeExternalProfiles) {
                    this.profileInjector.injectProfile(tmpModel, activeProfile, request, problems);
                }
            }
            if (currentData == superData) break;
            this.configureResolver(request.getModelResolver(), tmpModel, problems);
            ModelData parentData = this.readParent(tmpModel, currentData.getSource(), request, problems);
            if (parentData == null) {
                currentData = superData;
                continue;
            }
            if (currentData == resultData) {
                currentData.setGroupId(currentData.getRawModel().getGroupId() == null ? parentData.getGroupId() : currentData.getRawModel().getGroupId());
                currentData.setVersion(currentData.getRawModel().getVersion() == null ? parentData.getVersion() : currentData.getRawModel().getVersion());
                currentData.setArtifactId(currentData.getRawModel().getArtifactId());
                parentIds.add(currentData.getId());
                currentData.setGroupId(null);
                currentData.setArtifactId(null);
                currentData.setVersion(null);
                currentData = parentData;
                continue;
            }
            if (!parentIds.add(parentData.getId())) {
                String message = "The parents form a cycle: ";
                for (String modelId : parentIds) {
                    message = message + modelId + " -> ";
                }
                message = message + parentData.getId();
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage(message));
                throw problems.newModelBuildingException();
            }
            currentData = parentData;
        }
        problems.setSource(inputModel);
        this.checkPluginVersions(lineage, request, problems);
        this.assembleInheritance(lineage, request, problems);
        Model resultModel = resultData.getModel();
        problems.setSource(resultModel);
        problems.setRootModel(resultModel);
        resultModel = this.interpolateModel(resultModel, request, problems);
        resultData.setModel(resultModel);
        this.modelUrlNormalizer.normalize(resultModel, request);
        this.configureResolver(request.getModelResolver(), resultModel, problems, true);
        resultData.setGroupId(resultModel.getGroupId());
        resultData.setArtifactId(resultModel.getArtifactId());
        resultData.setVersion(resultModel.getVersion());
        result.setEffectiveModel(resultModel);
        for (ModelData currentData2 : lineage) {
            String modelId = currentData2 != superData ? currentData2.getId() : "";
            result.addModelId(modelId);
            result.setActivePomProfiles(modelId, currentData2.getActiveProfiles());
            result.setRawModel(modelId, currentData2.getRawModel());
        }
        if (!request.isTwoPhaseBuilding()) {
            this.build(request, result);
        }
        return result;
    }

    @Override
    public ModelBuildingResult build(ModelBuildingRequest request, ModelBuildingResult result) throws ModelBuildingException {
        return this.build(request, result, new LinkedHashSet<String>());
    }

    private ModelBuildingResult build(ModelBuildingRequest request, ModelBuildingResult result, Collection<String> imports) throws ModelBuildingException {
        Model resultModel = result.getEffectiveModel();
        DefaultModelProblemCollector problems = new DefaultModelProblemCollector(result);
        problems.setSource(resultModel);
        problems.setRootModel(resultModel);
        this.modelPathTranslator.alignToBaseDirectory(resultModel, resultModel.getProjectDirectory(), request);
        this.pluginManagementInjector.injectManagement(resultModel, request, problems);
        this.fireEvent(resultModel, request, problems, ModelBuildingEventCatapult.BUILD_EXTENSIONS_ASSEMBLED);
        if (request.isProcessPlugins()) {
            if (this.lifecycleBindingsInjector == null) {
                throw new IllegalStateException("lifecycle bindings injector is missing");
            }
            this.lifecycleBindingsInjector.injectLifecycleBindings(resultModel, request, problems);
        }
        this.importDependencyManagement(resultModel, request, problems, imports);
        this.dependencyManagementInjector.injectManagement(resultModel, request, problems);
        this.modelNormalizer.injectDefaultValues(resultModel, request, problems);
        if (request.isProcessPlugins()) {
            this.reportConfigurationExpander.expandPluginConfiguration(resultModel, request, problems);
            this.reportingConverter.convertReporting(resultModel, request, problems);
            this.pluginConfigurationExpander.expandPluginConfiguration(resultModel, request, problems);
        }
        this.modelValidator.validateEffectiveModel(resultModel, request, problems);
        if (this.hasModelErrors(problems)) {
            throw problems.newModelBuildingException();
        }
        return result;
    }

    private Model readModel(ModelSource modelSource, File pomFile, ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        Model model;
        if (modelSource == null) {
            if (pomFile != null) {
                modelSource = new FileModelSource(pomFile);
            } else {
                throw new IllegalArgumentException("neither model source nor input file are specified");
            }
        }
        problems.setSource(modelSource.getLocation());
        try {
            boolean strict = request.getValidationLevel() >= 20;
            InputSource source = request.isLocationTracking() ? new InputSource() : null;
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("org.apache.maven.model.io.isStrict", strict);
            options.put("org.apache.maven.model.io.inputSource", source);
            options.put("org.apache.maven.model.building.source", modelSource);
            try {
                model = this.modelProcessor.read(modelSource.getInputStream(), options);
            }
            catch (ModelParseException e) {
                if (!strict) {
                    throw e;
                }
                options.put("org.apache.maven.model.io.isStrict", Boolean.FALSE);
                try {
                    model = this.modelProcessor.read(modelSource.getInputStream(), options);
                }
                catch (ModelParseException ne) {
                    throw e;
                }
                if (pomFile != null) {
                    problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.V20).setMessage("Malformed POM " + modelSource.getLocation() + ": " + e.getMessage()).setException(e));
                }
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.WARNING, ModelProblem.Version.V20).setMessage("Malformed POM " + modelSource.getLocation() + ": " + e.getMessage()).setException(e));
            }
            if (source != null) {
                source.setModelId(ModelProblemUtils.toId(model));
                source.setLocation(modelSource.getLocation());
            }
        }
        catch (ModelParseException e) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage("Non-parseable POM " + modelSource.getLocation() + ": " + e.getMessage()).setException(e));
            throw problems.newModelBuildingException();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.length() <= 0) {
                msg = e.getClass().getName().endsWith("MalformedInputException") ? "Some input bytes do not match the file encoding." : e.getClass().getSimpleName();
            }
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage("Non-readable POM " + modelSource.getLocation() + ": " + msg).setException(e));
            throw problems.newModelBuildingException();
        }
        model.setPomFile(pomFile);
        problems.setSource(model);
        this.modelValidator.validateRawModel(model, request, problems);
        if (this.hasFatalErrors(problems)) {
            throw problems.newModelBuildingException();
        }
        return model;
    }

    private DefaultProfileActivationContext getProfileActivationContext(ModelBuildingRequest request) {
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setActiveProfileIds(request.getActiveProfileIds());
        context.setInactiveProfileIds(request.getInactiveProfileIds());
        context.setSystemProperties(request.getSystemProperties());
        context.setUserProperties(request.getUserProperties());
        context.setProjectDirectory(request.getPomFile() != null ? request.getPomFile().getParentFile() : null);
        return context;
    }

    private void configureResolver(ModelResolver modelResolver, Model model, DefaultModelProblemCollector problems) {
        this.configureResolver(modelResolver, model, problems, false);
    }

    private void configureResolver(ModelResolver modelResolver, Model model, DefaultModelProblemCollector problems, boolean resetRepositories) {
        if (modelResolver == null) {
            return;
        }
        problems.setSource(model);
        List repositories = model.getRepositories();
        if (resetRepositories) {
            modelResolver.resetRepositories();
        }
        for (Repository repository : repositories) {
            try {
                modelResolver.addRepository(repository);
            }
            catch (InvalidRepositoryException e) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Invalid repository " + repository.getId() + ": " + e.getMessage()).setLocation(repository.getLocation((Object)"")).setException(e));
            }
        }
    }

    private void checkPluginVersions(List<ModelData> lineage, ModelBuildingRequest request, ModelProblemCollector problems) {
        if (request.getValidationLevel() < 20) {
            return;
        }
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        HashMap<String, String> versions = new HashMap<String, String>();
        HashMap<String, String> managedVersions = new HashMap<String, String>();
        for (int i = lineage.size() - 1; i >= 0; --i) {
            Model model = lineage.get(i).getModel();
            Build build = model.getBuild();
            if (build == null) continue;
            for (Plugin plugin : build.getPlugins()) {
                String key = plugin.getKey();
                if (versions.get(key) != null) continue;
                versions.put(key, plugin.getVersion());
                plugins.put(key, plugin);
            }
            PluginManagement mngt = build.getPluginManagement();
            if (mngt == null) continue;
            for (Plugin plugin : mngt.getPlugins()) {
                String key = plugin.getKey();
                if (managedVersions.get(key) != null) continue;
                managedVersions.put(key, plugin.getVersion());
            }
        }
        for (String key : versions.keySet()) {
            if (versions.get(key) != null || managedVersions.get(key) != null) continue;
            InputLocation location = ((Plugin)plugins.get(key)).getLocation((Object)"");
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.WARNING, ModelProblem.Version.V20).setMessage("'build.plugins.plugin.version' for " + key + " is missing.").setLocation(location));
        }
    }

    private void assembleInheritance(List<ModelData> lineage, ModelBuildingRequest request, ModelProblemCollector problems) {
        for (int i = lineage.size() - 2; i >= 0; --i) {
            Model parent = lineage.get(i + 1).getModel();
            Model child = lineage.get(i).getModel();
            this.inheritanceAssembler.assembleModelInheritance(child, parent, request, problems);
        }
    }

    private Map<String, Activation> getProfileActivations(Model model, boolean clone) {
        HashMap<String, Activation> activations = new HashMap<String, Activation>();
        for (Profile profile : model.getProfiles()) {
            Activation activation = profile.getActivation();
            if (activation == null) continue;
            if (clone) {
                activation = activation.clone();
            }
            activations.put(profile.getId(), activation);
        }
        return activations;
    }

    private void injectProfileActivations(Model model, Map<String, Activation> activations) {
        for (Profile profile : model.getProfiles()) {
            Activation activation = profile.getActivation();
            if (activation == null) continue;
            profile.setActivation(activations.get(profile.getId()));
        }
    }

    private Model interpolateModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Map<String, Activation> originalActivations = this.getProfileActivations(model, true);
        Model result = this.modelInterpolator.interpolateModel(model, model.getProjectDirectory(), request, problems);
        result.setPomFile(model.getPomFile());
        this.injectProfileActivations(model, originalActivations);
        return result;
    }

    private ModelData readParent(Model childModel, ModelSource childSource, ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        ModelData parentData;
        Parent parent = childModel.getParent();
        if (parent != null) {
            String groupId = parent.getGroupId();
            String artifactId = parent.getArtifactId();
            String version = parent.getVersion();
            parentData = this.getCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.RAW);
            if (parentData == null) {
                parentData = this.readParentLocally(childModel, childSource, request, problems);
                if (parentData == null) {
                    parentData = this.readParentExternally(childModel, request, problems);
                }
                this.putCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.RAW, parentData);
            } else {
                ModelSource expectedParentSource;
                File pomFile = parentData.getModel().getPomFile();
                if (pomFile != null && (expectedParentSource = this.getParentPomFile(childModel, childSource)) instanceof ModelSource2 && !pomFile.toURI().equals(((ModelSource2)expectedParentSource).getLocationURI())) {
                    parentData = this.readParentExternally(childModel, request, problems);
                }
            }
            Model parentModel = parentData.getModel();
            if (!"pom".equals(parentModel.getPackaging())) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Invalid packaging for parent POM " + ModelProblemUtils.toSourceHint(parentModel) + ", must be \"pom\" but is \"" + parentModel.getPackaging() + "\"").setLocation(parentModel.getLocation((Object)"packaging")));
            }
        } else {
            parentData = null;
        }
        return parentData;
    }

    private ModelData readParentLocally(Model childModel, ModelSource childSource, ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        Model candidateModel;
        String groupId;
        ModelSource candidateSource = this.getParentPomFile(childModel, childSource);
        if (candidateSource == null) {
            return null;
        }
        File pomFile = null;
        if (candidateSource instanceof FileModelSource) {
            pomFile = ((FileModelSource)candidateSource).getPomFile();
        }
        if ((groupId = (candidateModel = this.readModel(candidateSource, pomFile, request, problems)).getGroupId()) == null && candidateModel.getParent() != null) {
            groupId = candidateModel.getParent().getGroupId();
        }
        String artifactId = candidateModel.getArtifactId();
        String version = candidateModel.getVersion();
        if (version == null && candidateModel.getParent() != null) {
            version = candidateModel.getParent().getVersion();
        }
        Parent parent = childModel.getParent();
        if (groupId == null || !groupId.equals(parent.getGroupId()) || artifactId == null || !artifactId.equals(parent.getArtifactId())) {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("'parent.relativePath'");
            if (childModel != problems.getRootModel()) {
                buffer.append(" of POM ").append(ModelProblemUtils.toSourceHint(childModel));
            }
            buffer.append(" points at ").append(groupId).append(":").append(artifactId);
            buffer.append(" instead of ").append(parent.getGroupId()).append(":").append(parent.getArtifactId());
            buffer.append(", please verify your project structure");
            problems.setSource(childModel);
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.WARNING, ModelProblem.Version.BASE).setMessage(buffer.toString()).setLocation(parent.getLocation((Object)"")));
            return null;
        }
        if (version == null || !version.equals(parent.getVersion())) {
            return null;
        }
        ModelData parentData = new ModelData(candidateSource, candidateModel, groupId, artifactId, version);
        return parentData;
    }

    private ModelSource getParentPomFile(Model childModel, ModelSource source) {
        if (!(source instanceof ModelSource2)) {
            return null;
        }
        String parentPath = childModel.getParent().getRelativePath();
        if (parentPath == null || parentPath.length() <= 0) {
            return null;
        }
        return ((ModelSource2)source).getRelatedSource(parentPath);
    }

    private ModelData readParentExternally(Model childModel, ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        ModelSource modelSource;
        problems.setSource(childModel);
        Parent parent = childModel.getParent().clone();
        String groupId = parent.getGroupId();
        String artifactId = parent.getArtifactId();
        String version = parent.getVersion();
        ModelResolver modelResolver = request.getModelResolver();
        if (modelResolver == null) {
            throw new IllegalArgumentException("no model resolver provided, cannot resolve parent POM " + ModelProblemUtils.toId(groupId, artifactId, version) + " for POM " + ModelProblemUtils.toSourceHint(childModel));
        }
        try {
            modelSource = modelResolver.resolveModel(parent);
        }
        catch (UnresolvableModelException e) {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("Non-resolvable parent POM");
            if (!this.containsCoordinates(e.getMessage(), groupId, artifactId, version)) {
                buffer.append(" ").append(ModelProblemUtils.toId(groupId, artifactId, version));
            }
            if (childModel != problems.getRootModel()) {
                buffer.append(" for ").append(ModelProblemUtils.toId(childModel));
            }
            buffer.append(": ").append(e.getMessage());
            if (childModel.getProjectDirectory() != null) {
                if (parent.getRelativePath() == null || parent.getRelativePath().length() <= 0) {
                    buffer.append(" and 'parent.relativePath' points at no local POM");
                } else {
                    buffer.append(" and 'parent.relativePath' points at wrong local POM");
                }
            }
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage(buffer.toString()).setLocation(parent.getLocation((Object)"")).setException(e));
            throw problems.newModelBuildingException();
        }
        ModelBuildingRequest lenientRequest = request;
        if (request.getValidationLevel() > 20) {
            lenientRequest = new FilterModelBuildingRequest(request){

                @Override
                public int getValidationLevel() {
                    return 20;
                }
            };
        }
        Model parentModel = this.readModel(modelSource, null, lenientRequest, problems);
        if (!parent.getVersion().equals(version)) {
            if (childModel.getVersion() == null) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.V31).setMessage("Version must be a constant").setLocation(childModel.getLocation((Object)"")));
            } else if (childModel.getVersion().indexOf("${") > -1) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.V31).setMessage("Version must be a constant").setLocation(childModel.getLocation((Object)"version")));
            }
        }
        ModelData parentData = new ModelData(modelSource, parentModel, parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        return parentData;
    }

    private Model getSuperModel() {
        return this.superPomProvider.getSuperModel("4.0.0").clone();
    }

    private void importDependencyManagement(Model model, ModelBuildingRequest request, DefaultModelProblemCollector problems, Collection<String> importIds) {
        DependencyManagement depMngt = model.getDependencyManagement();
        if (depMngt == null) {
            return;
        }
        String importing = model.getGroupId() + ':' + model.getArtifactId() + ':' + model.getVersion();
        importIds.add(importing);
        ModelResolver modelResolver = request.getModelResolver();
        ModelBuildingRequest importRequest = null;
        ArrayList<DependencyManagement> importMngts = null;
        Iterator it = depMngt.getDependencies().iterator();
        while (it.hasNext()) {
            Dependency dependency = (Dependency)it.next();
            if (!"pom".equals(dependency.getType()) || !"import".equals(dependency.getScope())) continue;
            it.remove();
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            String version = dependency.getVersion();
            if (groupId == null || groupId.length() <= 0) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("'dependencyManagement.dependencies.dependency.groupId' for " + dependency.getManagementKey() + " is missing.").setLocation(dependency.getLocation((Object)"")));
                continue;
            }
            if (artifactId == null || artifactId.length() <= 0) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("'dependencyManagement.dependencies.dependency.artifactId' for " + dependency.getManagementKey() + " is missing.").setLocation(dependency.getLocation((Object)"")));
                continue;
            }
            if (version == null || version.length() <= 0) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("'dependencyManagement.dependencies.dependency.version' for " + dependency.getManagementKey() + " is missing.").setLocation(dependency.getLocation((Object)"")));
                continue;
            }
            String imported = groupId + ':' + artifactId + ':' + version;
            if (importIds.contains(imported)) {
                String message = "The dependencies of type=pom and with scope=import form a cycle: ";
                for (String modelId : importIds) {
                    message = message + modelId + " -> ";
                }
                message = message + imported;
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage(message));
                continue;
            }
            DependencyManagement importMngt = this.getCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.IMPORT);
            if (importMngt == null) {
                ModelBuildingResult importResult;
                ModelSource importSource;
                if (modelResolver == null) {
                    throw new IllegalArgumentException("no model resolver provided, cannot resolve import POM " + ModelProblemUtils.toId(groupId, artifactId, version) + " for POM " + ModelProblemUtils.toSourceHint(model));
                }
                try {
                    importSource = modelResolver.resolveModel(groupId, artifactId, version);
                }
                catch (UnresolvableModelException e) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Non-resolvable import POM");
                    if (!this.containsCoordinates(e.getMessage(), groupId, artifactId, version)) {
                        buffer.append(" ").append(ModelProblemUtils.toId(groupId, artifactId, version));
                    }
                    buffer.append(": ").append(e.getMessage());
                    problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage(buffer.toString()).setLocation(dependency.getLocation((Object)"")).setException(e));
                    continue;
                }
                if (importRequest == null) {
                    importRequest = new DefaultModelBuildingRequest();
                    importRequest.setValidationLevel(0);
                    importRequest.setModelCache(request.getModelCache());
                    importRequest.setSystemProperties(request.getSystemProperties());
                    importRequest.setUserProperties(request.getUserProperties());
                    importRequest.setLocationTracking(request.isLocationTracking());
                }
                importRequest.setModelSource(importSource);
                importRequest.setModelResolver(modelResolver.newCopy());
                try {
                    importResult = this.build(importRequest);
                }
                catch (ModelBuildingException e) {
                    problems.addAll(e.getProblems());
                    continue;
                }
                problems.addAll(importResult.getProblems());
                Model importModel = importResult.getEffectiveModel();
                importMngt = importModel.getDependencyManagement();
                if (importMngt == null) {
                    importMngt = new DependencyManagement();
                }
                this.putCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.IMPORT, importMngt);
            }
            if (importMngts == null) {
                importMngts = new ArrayList<DependencyManagement>();
            }
            importMngts.add(importMngt);
        }
        importIds.remove(importing);
        this.dependencyManagementImporter.importManagement(model, importMngts, request, problems);
    }

    private <T> void putCache(ModelCache modelCache, String groupId, String artifactId, String version, ModelCacheTag<T> tag, T data) {
        if (modelCache != null) {
            modelCache.put(groupId, artifactId, version, tag.getName(), tag.intoCache(data));
        }
    }

    private <T> T getCache(ModelCache modelCache, String groupId, String artifactId, String version, ModelCacheTag<T> tag) {
        Object data;
        if (modelCache != null && (data = modelCache.get(groupId, artifactId, version, tag.getName())) != null) {
            return tag.fromCache(tag.getType().cast(data));
        }
        return null;
    }

    private void fireEvent(Model model, ModelBuildingRequest request, ModelProblemCollector problems, ModelBuildingEventCatapult catapult) throws ModelBuildingException {
        ModelBuildingListener listener = request.getModelBuildingListener();
        if (listener != null) {
            DefaultModelBuildingEvent event = new DefaultModelBuildingEvent(model, request, problems);
            catapult.fire(listener, event);
        }
    }

    private boolean containsCoordinates(String message, String groupId, String artifactId, String version) {
        return !(message == null || groupId != null && !message.contains(groupId) || artifactId != null && !message.contains(artifactId) || version != null && !message.contains(version));
    }

    protected boolean hasModelErrors(ModelProblemCollectorExt problems) {
        if (problems instanceof DefaultModelProblemCollector) {
            return ((DefaultModelProblemCollector)problems).hasErrors();
        }
        throw new IllegalStateException();
    }

    protected boolean hasFatalErrors(ModelProblemCollectorExt problems) {
        if (problems instanceof DefaultModelProblemCollector) {
            return ((DefaultModelProblemCollector)problems).hasFatalErrors();
        }
        throw new IllegalStateException();
    }
}

