/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.util.function.Supplier;
import org.apache.maven.building.Source;
import org.apache.maven.model.building.ModelCacheTag;

public interface ModelCache {
    default public void put(Source path, String tag, Object data) {
    }

    default public Object get(Source path, String tag) {
        return null;
    }

    public void put(String var1, String var2, String var3, String var4, Object var5);

    public Object get(String var1, String var2, String var3, String var4);

    default public <T> void put(Source path, ModelCacheTag<T> tag, T data) {
        this.put(path, tag.getName(), tag.intoCache(data));
    }

    default public <T> T get(Source path, ModelCacheTag<T> tag) {
        Object obj = this.get(path, tag.getName());
        return obj != null ? (T)tag.fromCache(tag.getType().cast(obj)) : null;
    }

    default public <T> void put(String groupId, String artifactId, String version, ModelCacheTag<T> tag, T data) {
        this.put(groupId, artifactId, version, tag.getName(), tag.intoCache(data));
    }

    default public <T> T get(String groupId, String artifactId, String version, ModelCacheTag<T> tag) {
        Object obj = this.get(groupId, artifactId, version, tag.getName());
        return obj != null ? (T)tag.fromCache(tag.getType().cast(obj)) : null;
    }

    default public <T> T computeIfAbsent(String groupId, String artifactId, String version, ModelCacheTag<T> tag, Supplier<Supplier<T>> data) {
        Object obj = this.computeIfAbsent(groupId, artifactId, version, tag.getName(), data);
        return obj != null ? (T)tag.fromCache(tag.getType().cast(obj)) : null;
    }

    default public <T> T computeIfAbsent(Source path, ModelCacheTag<T> tag, Supplier<Supplier<T>> data) {
        Object obj = this.computeIfAbsent(path, tag.getName(), data);
        return obj != null ? (T)tag.fromCache(tag.getType().cast(obj)) : null;
    }

    public Object computeIfAbsent(String var1, String var2, String var3, String var4, Supplier<Supplier<?>> var5);

    public Object computeIfAbsent(Source var1, String var2, Supplier<Supplier<?>> var3);
}

