/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.resolution;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.UnresolvableModelException;

public interface ModelResolver {
    public ModelSource resolveModel(String var1, String var2, String var3) throws UnresolvableModelException;

    public ModelSource resolveModel(Parent var1) throws UnresolvableModelException;

    public ModelSource resolveModel(Dependency var1) throws UnresolvableModelException;

    public void addRepository(Repository var1) throws InvalidRepositoryException;

    public void addRepository(Repository var1, boolean var2) throws InvalidRepositoryException;

    public ModelResolver newCopy();

    default public ModelSource resolveModel(org.apache.maven.api.model.Parent parent, AtomicReference<org.apache.maven.api.model.Parent> modified) throws UnresolvableModelException {
        Parent p = new Parent(parent);
        ModelSource result = this.resolveModel(p);
        if (p.getDelegate() != parent) {
            modified.set(p.getDelegate());
        }
        return result;
    }

    default public ModelSource resolveModel(org.apache.maven.api.model.Dependency dependency, AtomicReference<org.apache.maven.api.model.Dependency> modified) throws UnresolvableModelException {
        Dependency d = new Dependency(dependency);
        ModelSource result = this.resolveModel(d);
        if (d.getDelegate() != dependency) {
            modified.set(d.getDelegate());
        }
        return result;
    }

    default public void addRepository(org.apache.maven.api.model.Repository repository) throws InvalidRepositoryException {
        this.addRepository(new Repository(repository));
    }

    default public void addRepository(org.apache.maven.api.model.Repository repository, boolean replace) throws InvalidRepositoryException {
        this.addRepository(new Repository(repository), replace);
    }
}

