/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.CiManagement;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DeploymentRepository;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.Extension;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.IssueManagement;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Organization;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.model.ReportPlugin;
import org.apache.maven.api.model.ReportSet;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryBase;
import org.apache.maven.api.model.Scm;
import org.apache.maven.api.model.Site;
import org.apache.maven.model.Model;
import org.apache.maven.model.v4.MavenMerger;

public class MavenModelMerger
extends MavenMerger {
    public static final String CHILD_PATH_ADJUSTMENT = "child-path-adjustment";
    public static final String ARTIFACT_ID = "artifact-id";

    public MavenModelMerger() {
        super(false);
    }

    public void merge(Model target, Model source, boolean sourceDominant, Map<?, ?> hints) {
        Objects.requireNonNull(target, "target cannot be null");
        if (source == null) {
            return;
        }
        target.update((Object)this.merge(target.getDelegate(), source.getDelegate(), sourceDominant, hints));
    }

    public org.apache.maven.api.model.Model merge(org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<?, ?> hints) {
        return super.merge(target, source, sourceDominant, hints);
    }

    protected org.apache.maven.api.model.Model mergeModel(org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
        context.put(ARTIFACT_ID, target.getArtifactId());
        return super.mergeModel(target, source, sourceDominant, context);
    }

    protected void mergeModel_Name(Model.Builder builder, org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getName();
        if (src != null && sourceDominant) {
            builder.name(src);
            builder.location((Object)"name", source.getLocation((Object)"name"));
        }
    }

    protected void mergeModel_Url(Model.Builder builder, org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        if (src != null) {
            if (sourceDominant) {
                builder.url(src);
                builder.location((Object)"url", source.getLocation((Object)"url"));
            } else if (target.getUrl() == null) {
                builder.url(this.extrapolateChildUrl(src, source.isChildProjectUrlInheritAppendPath(), context));
                builder.location((Object)"url", source.getLocation((Object)"url"));
            }
        }
    }

    protected void mergeModel_Organization(Model.Builder builder, org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
        Organization tgt;
        Organization src = source.getOrganization();
        if (src != null && (tgt = target.getOrganization()) == null) {
            builder.organization(src);
            builder.location((Object)"organisation", source.getLocation((Object)"organisation"));
        }
    }

    protected void mergeModel_IssueManagement(Model.Builder builder, org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
        IssueManagement tgt;
        IssueManagement src = source.getIssueManagement();
        if (src != null && (tgt = target.getIssueManagement()) == null) {
            builder.issueManagement(src);
            builder.location((Object)"issueManagement", source.getLocation((Object)"issueManagement"));
        }
    }

    protected void mergeModel_CiManagement(Model.Builder builder, org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
        CiManagement tgt;
        CiManagement src = source.getCiManagement();
        if (src != null && (tgt = target.getCiManagement()) == null) {
            builder.ciManagement(src);
            builder.location((Object)"ciManagement", source.getLocation((Object)"ciManagement"));
        }
    }

    protected void mergeModel_ModelVersion(Model.Builder builder, org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
    }

    protected void mergeModel_ArtifactId(Model.Builder builder, org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
    }

    protected void mergeModel_Profiles(Model.Builder builder, org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
    }

    protected void mergeModel_Prerequisites(Model.Builder builder, org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
    }

    protected void mergeModel_Licenses(Model.Builder builder, org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
        builder.licenses((Collection)(target.getLicenses().isEmpty() ? source.getLicenses() : target.getLicenses()));
    }

    protected void mergeModel_Developers(Model.Builder builder, org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
        builder.developers((Collection)(target.getDevelopers().isEmpty() ? source.getDevelopers() : target.getDevelopers()));
    }

    protected void mergeModel_Contributors(Model.Builder builder, org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
        builder.contributors((Collection)(target.getContributors().isEmpty() ? source.getContributors() : target.getContributors()));
    }

    protected void mergeModel_MailingLists(Model.Builder builder, org.apache.maven.api.model.Model target, org.apache.maven.api.model.Model source, boolean sourceDominant, Map<Object, Object> context) {
        if (target.getMailingLists().isEmpty()) {
            builder.mailingLists((Collection)source.getMailingLists());
        }
    }

    protected void mergeModelBase_Modules(ModelBase.Builder builder, ModelBase target, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        List src = source.getModules();
        if (!src.isEmpty() && sourceDominant) {
            int i;
            ArrayList<Integer> indices = new ArrayList<Integer>();
            List tgt = target.getModules();
            LinkedHashSet excludes = new LinkedHashSet(tgt);
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src.size());
            merged.addAll(tgt);
            int n = tgt.size();
            for (i = 0; i < n; ++i) {
                indices.add(i);
            }
            n = src.size();
            for (i = 0; i < n; ++i) {
                String s = (String)src.get(i);
                if (excludes.contains(s)) continue;
                merged.add(s);
                indices.add(~i);
            }
            builder.modules(merged);
            builder.location((Object)"modules", InputLocation.merge((InputLocation)target.getLocation((Object)"modules"), (InputLocation)source.getLocation((Object)"modules"), indices));
        }
    }

    protected void mergeModelBase_Repositories(ModelBase.Builder builder, ModelBase target, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        List src = source.getRepositories();
        if (!src.isEmpty()) {
            Object key;
            List recessive;
            List dominant;
            List tgt = target.getRepositories();
            LinkedHashMap<Object, Repository> merged = new LinkedHashMap<Object, Repository>((src.size() + tgt.size()) * 2);
            if (sourceDominant) {
                dominant = src;
                recessive = tgt;
            } else {
                dominant = tgt;
                recessive = src;
            }
            for (Repository element : dominant) {
                key = this.getRepositoryKey().apply((Object)element);
                merged.put(key, element);
            }
            for (Repository element : recessive) {
                key = this.getRepositoryKey().apply((Object)element);
                if (merged.containsKey(key)) continue;
                merged.put(key, element);
            }
            builder.repositories(merged.values());
        }
    }

    protected void mergeModelBase_PluginRepositories(ModelBase.Builder builder, ModelBase target, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        List src = source.getPluginRepositories();
        if (!src.isEmpty()) {
            Object key;
            List recessive;
            List dominant;
            List tgt = target.getPluginRepositories();
            LinkedHashMap<Object, Repository> merged = new LinkedHashMap<Object, Repository>((src.size() + tgt.size()) * 2);
            if (sourceDominant) {
                dominant = src;
                recessive = tgt;
            } else {
                dominant = tgt;
                recessive = src;
            }
            for (Repository element : dominant) {
                key = this.getRepositoryKey().apply((Object)element);
                merged.put(key, element);
            }
            for (Repository element : recessive) {
                key = this.getRepositoryKey().apply((Object)element);
                if (merged.containsKey(key)) continue;
                merged.put(key, element);
            }
            builder.pluginRepositories(merged.values());
        }
    }

    protected void mergeBuildBase_Filters(BuildBase.Builder builder, BuildBase target, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        List src = source.getFilters();
        if (!src.isEmpty()) {
            List tgt = target.getFilters();
            LinkedHashSet excludes = new LinkedHashSet(tgt);
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src.size());
            merged.addAll(tgt);
            for (String s : src) {
                if (excludes.contains(s)) continue;
                merged.add(s);
            }
            builder.filters(merged);
        }
    }

    protected void mergeBuildBase_Resources(BuildBase.Builder builder, BuildBase target, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant || target.getResources().isEmpty()) {
            super.mergeBuildBase_Resources(builder, target, source, sourceDominant, context);
        }
    }

    protected void mergeBuildBase_TestResources(BuildBase.Builder builder, BuildBase target, BuildBase source, boolean sourceDominant, Map<Object, Object> context) {
        if (sourceDominant || target.getTestResources().isEmpty()) {
            super.mergeBuildBase_TestResources(builder, target, source, sourceDominant, context);
        }
    }

    protected void mergeDistributionManagement_Relocation(DistributionManagement.Builder builder, DistributionManagement target, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
    }

    protected void mergeDistributionManagement_Repository(DistributionManagement.Builder builder, DistributionManagement target, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        DeploymentRepository src = source.getRepository();
        if (src != null) {
            DeploymentRepository tgt = target.getRepository();
            if (sourceDominant || tgt == null) {
                tgt = DeploymentRepository.newInstance((boolean)false);
                builder.repository(this.mergeDeploymentRepository(tgt, src, sourceDominant, context));
            }
        }
    }

    protected void mergeDistributionManagement_SnapshotRepository(DistributionManagement.Builder builder, DistributionManagement target, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        DeploymentRepository src = source.getSnapshotRepository();
        if (src != null) {
            DeploymentRepository tgt = target.getSnapshotRepository();
            if (sourceDominant || tgt == null) {
                tgt = DeploymentRepository.newInstance((boolean)false);
                builder.snapshotRepository(this.mergeDeploymentRepository(tgt, src, sourceDominant, context));
            }
        }
    }

    protected void mergeDistributionManagement_Site(DistributionManagement.Builder builder, DistributionManagement target, DistributionManagement source, boolean sourceDominant, Map<Object, Object> context) {
        Site src = source.getSite();
        if (src != null) {
            Site tgt = target.getSite();
            if (tgt == null) {
                tgt = Site.newBuilder((boolean)false).build();
            }
            Site.Builder sbuilder = Site.newBuilder((Site)tgt);
            if (sourceDominant || tgt == null || this.isSiteEmpty(tgt)) {
                this.mergeSite(sbuilder, tgt, src, sourceDominant, context);
            }
            super.mergeSite_ChildSiteUrlInheritAppendPath(sbuilder, tgt, src, sourceDominant, context);
            builder.site(sbuilder.build());
        }
    }

    protected void mergeSite_ChildSiteUrlInheritAppendPath(Site.Builder builder, Site target, Site source, boolean sourceDominant, Map<Object, Object> context) {
    }

    protected boolean isSiteEmpty(Site site) {
        return !(site.getId() != null && !site.getId().isEmpty() || site.getName() != null && !site.getName().isEmpty() || site.getUrl() != null && !site.getUrl().isEmpty());
    }

    protected void mergeSite_Url(Site.Builder builder, Site target, Site source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        if (src != null) {
            if (sourceDominant) {
                builder.url(src);
                builder.location((Object)"url", source.getLocation((Object)"url"));
            } else if (target.getUrl() == null) {
                builder.url(this.extrapolateChildUrl(src, source.isChildSiteUrlInheritAppendPath(), context));
                builder.location((Object)"url", source.getLocation((Object)"url"));
            }
        }
    }

    protected void mergeScm_Url(Scm.Builder builder, Scm target, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getUrl();
        if (src != null) {
            if (sourceDominant) {
                builder.url(src);
                builder.location((Object)"url", source.getLocation((Object)"url"));
            } else if (target.getUrl() == null) {
                builder.url(this.extrapolateChildUrl(src, source.isChildScmUrlInheritAppendPath(), context));
                builder.location((Object)"url", source.getLocation((Object)"url"));
            }
        }
    }

    protected void mergeScm_Connection(Scm.Builder builder, Scm target, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getConnection();
        if (src != null) {
            if (sourceDominant) {
                builder.connection(src);
                builder.location((Object)"connection", source.getLocation((Object)"connection"));
            } else if (target.getConnection() == null) {
                builder.connection(this.extrapolateChildUrl(src, source.isChildScmConnectionInheritAppendPath(), context));
                builder.location((Object)"connection", source.getLocation((Object)"connection"));
            }
        }
    }

    protected void mergeScm_DeveloperConnection(Scm.Builder builder, Scm target, Scm source, boolean sourceDominant, Map<Object, Object> context) {
        String src = source.getDeveloperConnection();
        if (src != null) {
            if (sourceDominant) {
                builder.developerConnection(src);
                builder.location((Object)"developerConnection", source.getLocation((Object)"developerConnection"));
            } else if (target.getDeveloperConnection() == null) {
                String e = this.extrapolateChildUrl(src, source.isChildScmDeveloperConnectionInheritAppendPath(), context);
                builder.developerConnection(e);
                builder.location((Object)"developerConnection", source.getLocation((Object)"developerConnection"));
            }
        }
    }

    protected void mergePlugin_Executions(Plugin.Builder builder, Plugin target, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
        List src = source.getExecutions();
        if (!src.isEmpty()) {
            Object key;
            List tgt = target.getExecutions();
            LinkedHashMap<Object, PluginExecution> merged = new LinkedHashMap<Object, PluginExecution>((src.size() + tgt.size()) * 2);
            for (PluginExecution element : src) {
                if (!sourceDominant && !(element.getInherited() != null ? element.isInherited() : source.isInherited())) continue;
                key = this.getPluginExecutionKey().apply((Object)element);
                merged.put(key, element);
            }
            for (PluginExecution element : tgt) {
                key = this.getPluginExecutionKey().apply((Object)element);
                PluginExecution existing = (PluginExecution)merged.get(key);
                if (existing != null) {
                    element = this.mergePluginExecution(element, existing, sourceDominant, context);
                }
                merged.put(key, element);
            }
            builder.executions(merged.values());
        }
    }

    protected void mergePluginExecution_Goals(PluginExecution.Builder builder, PluginExecution target, PluginExecution source, boolean sourceDominant, Map<Object, Object> context) {
        List src = source.getGoals();
        if (!src.isEmpty()) {
            List tgt = target.getGoals();
            LinkedHashSet excludes = new LinkedHashSet(tgt);
            ArrayList<String> merged = new ArrayList<String>(tgt.size() + src.size());
            merged.addAll(tgt);
            for (String s : src) {
                if (excludes.contains(s)) continue;
                merged.add(s);
            }
            builder.goals(merged);
        }
    }

    protected void mergeReportPlugin_ReportSets(ReportPlugin.Builder builder, ReportPlugin target, ReportPlugin source, boolean sourceDominant, Map<Object, Object> context) {
        List src = source.getReportSets();
        if (!src.isEmpty()) {
            Object key;
            List tgt = target.getReportSets();
            LinkedHashMap<Object, ReportSet> merged = new LinkedHashMap<Object, ReportSet>((src.size() + tgt.size()) * 2);
            for (ReportSet rset : src) {
                if (!sourceDominant && !(rset.getInherited() != null ? rset.isInherited() : source.isInherited())) continue;
                key = this.getReportSetKey().apply((Object)rset);
                merged.put(key, rset);
            }
            for (ReportSet element : tgt) {
                key = this.getReportSetKey().apply((Object)element);
                ReportSet existing = (ReportSet)merged.get(key);
                if (existing != null) {
                    this.mergeReportSet(element, existing, sourceDominant, context);
                }
                merged.put(key, element);
            }
            builder.reportSets(merged.values());
        }
    }

    protected MavenMerger.KeyComputer<Dependency> getDependencyKey() {
        return Dependency::getManagementKey;
    }

    protected MavenMerger.KeyComputer<Plugin> getPluginKey() {
        return Plugin::getKey;
    }

    protected MavenMerger.KeyComputer<PluginExecution> getPluginExecutionKey() {
        return PluginExecution::getId;
    }

    protected MavenMerger.KeyComputer<ReportPlugin> getReportPluginKey() {
        return ReportPlugin::getKey;
    }

    protected MavenMerger.KeyComputer<ReportSet> getReportSetKey() {
        return ReportSet::getId;
    }

    protected MavenMerger.KeyComputer<RepositoryBase> getRepositoryBaseKey() {
        return RepositoryBase::getId;
    }

    protected MavenMerger.KeyComputer<Extension> getExtensionKey() {
        return e -> e.getGroupId() + ":" + e.getArtifactId();
    }

    protected MavenMerger.KeyComputer<Exclusion> getExclusionKey() {
        return e -> e.getGroupId() + ":" + e.getArtifactId();
    }

    protected String extrapolateChildUrl(String parentUrl, boolean appendPath, Map<Object, Object> context) {
        return parentUrl;
    }
}

