/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.interpolation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.interpolation.BuildTimestampValueSource;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.interpolation.PathTranslatingPostProcessor;
import org.apache.maven.model.interpolation.UrlNormalizingPostProcessor;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.UrlNormalizer;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.ValueSource;

public abstract class AbstractStringBasedModelInterpolator
implements ModelInterpolator {
    private static final List<String> PROJECT_PREFIXES = Collections.singletonList("project.");
    private static final Collection<String> TRANSLATED_PATH_EXPRESSIONS;
    private final PathTranslator pathTranslator;
    private final UrlNormalizer urlNormalizer;

    @Inject
    public AbstractStringBasedModelInterpolator(PathTranslator pathTranslator, UrlNormalizer urlNormalizer) {
        this.pathTranslator = pathTranslator;
        this.urlNormalizer = urlNormalizer;
    }

    @Override
    public Model interpolateModel(Model model, File projectDir, ModelBuildingRequest request, ModelProblemCollector problems) {
        return new Model(this.interpolateModel(model.getDelegate(), projectDir, request, problems));
    }

    protected List<ValueSource> createValueSources(org.apache.maven.api.model.Model model, final File projectDir, final ModelBuildingRequest config) {
        Map modelProperties = model.getProperties();
        PrefixedObjectValueSource projectPrefixValueSource = new PrefixedObjectValueSource(PROJECT_PREFIXES, (Object)model, false);
        ArrayList<ValueSource> valueSources = new ArrayList<ValueSource>(8);
        if (projectDir != null) {
            PrefixedValueSourceWrapper basedirValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

                public Object getValue(String expression) {
                    if ("basedir".equals(expression)) {
                        return projectDir.getAbsolutePath();
                    }
                    return null;
                }
            }, PROJECT_PREFIXES, true);
            valueSources.add((ValueSource)basedirValueSource);
            PrefixedValueSourceWrapper baseUriValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

                public Object getValue(String expression) {
                    if ("baseUri".equals(expression)) {
                        return projectDir.getAbsoluteFile().toPath().toUri().toASCIIString();
                    }
                    return null;
                }
            }, PROJECT_PREFIXES, false);
            valueSources.add((ValueSource)baseUriValueSource);
            valueSources.add((ValueSource)new BuildTimestampValueSource(config.getBuildStartTime(), modelProperties));
        }
        valueSources.add((ValueSource)projectPrefixValueSource);
        valueSources.add((ValueSource)new MapBasedValueSource((Map)config.getUserProperties()));
        valueSources.add((ValueSource)new MapBasedValueSource(modelProperties));
        valueSources.add((ValueSource)new MapBasedValueSource((Map)config.getSystemProperties()));
        valueSources.add((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                return config.getSystemProperties().getProperty("env." + expression);
            }
        });
        return valueSources;
    }

    protected List<? extends InterpolationPostProcessor> createPostProcessors(org.apache.maven.api.model.Model model, File projectDir, ModelBuildingRequest config) {
        ArrayList<Object> processors = new ArrayList<Object>(2);
        if (projectDir != null) {
            processors.add(new PathTranslatingPostProcessor(PROJECT_PREFIXES, TRANSLATED_PATH_EXPRESSIONS, projectDir, this.pathTranslator));
        }
        processors.add(new UrlNormalizingPostProcessor(this.urlNormalizer));
        return processors;
    }

    protected RecursionInterceptor createRecursionInterceptor() {
        return new PrefixAwareRecursionInterceptor(PROJECT_PREFIXES);
    }

    static {
        HashSet<String> translatedPrefixes = new HashSet<String>();
        translatedPrefixes.add("build.directory");
        translatedPrefixes.add("build.outputDirectory");
        translatedPrefixes.add("build.testOutputDirectory");
        translatedPrefixes.add("build.sourceDirectory");
        translatedPrefixes.add("build.testSourceDirectory");
        translatedPrefixes.add("build.scriptSourceDirectory");
        translatedPrefixes.add("reporting.outputDirectory");
        TRANSLATED_PATH_EXPRESSIONS = translatedPrefixes;
    }
}

