/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.building.Source;
import org.apache.maven.feature.Features;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuildingEvent;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.DefaultModelBuildingResult;
import org.apache.maven.model.building.DefaultModelProblemCollector;
import org.apache.maven.model.building.DefaultTransformerContext;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.FileToRawModelMerger;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingEventCatapult;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingListener;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.building.ModelCacheTag;
import org.apache.maven.model.building.ModelData;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorExt;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.building.Result;
import org.apache.maven.model.building.TransformerContext;
import org.apache.maven.model.building.TransformerContextBuilder;
import org.apache.maven.model.composition.DependencyManagementImporter;
import org.apache.maven.model.inheritance.InheritanceAssembler;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.interpolation.ModelVersionProcessor;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.management.DependencyManagementInjector;
import org.apache.maven.model.management.PluginManagementInjector;
import org.apache.maven.model.normalization.ModelNormalizer;
import org.apache.maven.model.path.ModelPathTranslator;
import org.apache.maven.model.path.ModelUrlNormalizer;
import org.apache.maven.model.path.ProfileActivationFilePathInterpolator;
import org.apache.maven.model.plugin.LifecycleBindingsInjector;
import org.apache.maven.model.plugin.PluginConfigurationExpander;
import org.apache.maven.model.plugin.ReportConfigurationExpander;
import org.apache.maven.model.plugin.ReportingConverter;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileInjector;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.model.resolution.WorkspaceModelResolver;
import org.apache.maven.model.superpom.SuperPomProvider;
import org.apache.maven.model.v4.MavenMerger;
import org.apache.maven.model.validation.ModelValidator;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.eclipse.sisu.Nullable;

@Named
@Singleton
public class DefaultModelBuilder
implements ModelBuilder {
    private final MavenMerger modelMerger = new FileToRawModelMerger();
    private final ModelProcessor modelProcessor;
    private final ModelValidator modelValidator;
    private final ModelNormalizer modelNormalizer;
    private final ModelInterpolator modelInterpolator;
    private final ModelPathTranslator modelPathTranslator;
    private final ModelUrlNormalizer modelUrlNormalizer;
    private final SuperPomProvider superPomProvider;
    private final InheritanceAssembler inheritanceAssembler;
    private final ProfileSelector profileSelector;
    private final ProfileInjector profileInjector;
    private final PluginManagementInjector pluginManagementInjector;
    private final DependencyManagementInjector dependencyManagementInjector;
    private final DependencyManagementImporter dependencyManagementImporter;
    private final LifecycleBindingsInjector lifecycleBindingsInjector;
    private final PluginConfigurationExpander pluginConfigurationExpander;
    private final ReportConfigurationExpander reportConfigurationExpander;
    private final ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator;
    private final ModelVersionProcessor versionProcessor;

    @Inject
    public DefaultModelBuilder(ModelProcessor modelProcessor, ModelValidator modelValidator, ModelNormalizer modelNormalizer, ModelInterpolator modelInterpolator, ModelPathTranslator modelPathTranslator, ModelUrlNormalizer modelUrlNormalizer, SuperPomProvider superPomProvider, InheritanceAssembler inheritanceAssembler, ProfileSelector profileSelector, ProfileInjector profileInjector, PluginManagementInjector pluginManagementInjector, DependencyManagementInjector dependencyManagementInjector, DependencyManagementImporter dependencyManagementImporter, @Nullable LifecycleBindingsInjector lifecycleBindingsInjector, PluginConfigurationExpander pluginConfigurationExpander, ReportConfigurationExpander reportConfigurationExpander, ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator, ModelVersionProcessor versionProcessor) {
        this.modelProcessor = modelProcessor;
        this.modelValidator = modelValidator;
        this.modelNormalizer = modelNormalizer;
        this.modelInterpolator = modelInterpolator;
        this.modelPathTranslator = modelPathTranslator;
        this.modelUrlNormalizer = modelUrlNormalizer;
        this.superPomProvider = superPomProvider;
        this.inheritanceAssembler = inheritanceAssembler;
        this.profileSelector = profileSelector;
        this.profileInjector = profileInjector;
        this.pluginManagementInjector = pluginManagementInjector;
        this.dependencyManagementInjector = dependencyManagementInjector;
        this.dependencyManagementImporter = dependencyManagementImporter;
        this.lifecycleBindingsInjector = lifecycleBindingsInjector;
        this.pluginConfigurationExpander = pluginConfigurationExpander;
        this.reportConfigurationExpander = reportConfigurationExpander;
        this.profileActivationFilePathInterpolator = profileActivationFilePathInterpolator;
        this.versionProcessor = versionProcessor;
    }

    @Deprecated
    public DefaultModelBuilder setModelProcessor(ModelProcessor modelProcessor) {
        return new DefaultModelBuilder(modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setModelValidator(ModelValidator modelValidator) {
        return new DefaultModelBuilder(this.modelProcessor, modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setModelNormalizer(ModelNormalizer modelNormalizer) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setModelInterpolator(ModelInterpolator modelInterpolator) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setModelPathTranslator(ModelPathTranslator modelPathTranslator) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setModelUrlNormalizer(ModelUrlNormalizer modelUrlNormalizer) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setSuperPomProvider(SuperPomProvider superPomProvider) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setInheritanceAssembler(InheritanceAssembler inheritanceAssembler) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setProfileSelector(ProfileSelector profileSelector) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setProfileInjector(ProfileInjector profileInjector) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setPluginManagementInjector(PluginManagementInjector pluginManagementInjector) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setDependencyManagementInjector(DependencyManagementInjector dependencyManagementInjector) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setDependencyManagementImporter(DependencyManagementImporter dependencyManagementImporter) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setLifecycleBindingsInjector(LifecycleBindingsInjector lifecycleBindingsInjector) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setPluginConfigurationExpander(PluginConfigurationExpander pluginConfigurationExpander) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, pluginConfigurationExpander, this.reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setReportConfigurationExpander(ReportConfigurationExpander reportConfigurationExpander) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, reportConfigurationExpander, this.profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setProfileActivationFilePathInterpolator(ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator) {
        return new DefaultModelBuilder(this.modelProcessor, this.modelValidator, this.modelNormalizer, this.modelInterpolator, this.modelPathTranslator, this.modelUrlNormalizer, this.superPomProvider, this.inheritanceAssembler, this.profileSelector, this.profileInjector, this.pluginManagementInjector, this.dependencyManagementInjector, this.dependencyManagementImporter, this.lifecycleBindingsInjector, this.pluginConfigurationExpander, this.reportConfigurationExpander, profileActivationFilePathInterpolator, this.versionProcessor);
    }

    @Deprecated
    public DefaultModelBuilder setReportingConverter(ReportingConverter reportingConverter) {
        return this;
    }

    @Override
    public DefaultTransformerContextBuilder newTransformerContextBuilder() {
        return new DefaultTransformerContextBuilder();
    }

    @Override
    public ModelBuildingResult build(ModelBuildingRequest request) throws ModelBuildingException {
        return this.build(request, new LinkedHashSet<String>());
    }

    protected ModelBuildingResult build(ModelBuildingRequest request, Collection<String> importIds) throws ModelBuildingException {
        DefaultModelBuildingResult result = new DefaultModelBuildingResult();
        DefaultModelProblemCollector problems = new DefaultModelProblemCollector(result);
        Model fileModel = this.readFileModel(request, problems);
        request.setFileModel(fileModel);
        result.setFileModel(fileModel);
        this.activateFileModel(request, result, problems);
        if (!request.isTwoPhaseBuilding()) {
            return this.build(request, result, importIds);
        }
        if (this.hasModelErrors(problems)) {
            throw problems.newModelBuildingException();
        }
        return result;
    }

    private void activateFileModel(ModelBuildingRequest request, DefaultModelBuildingResult result, DefaultModelProblemCollector problems) throws ModelBuildingException {
        Model inputModel = request.getFileModel();
        problems.setRootModel(inputModel);
        DefaultProfileActivationContext profileActivationContext = this.getProfileActivationContext(request);
        problems.setSource("(external profiles)");
        List<Profile> activeExternalProfiles = this.profileSelector.getActiveProfiles(request.getProfiles(), profileActivationContext, problems);
        result.setActiveExternalProfiles(activeExternalProfiles);
        if (!activeExternalProfiles.isEmpty()) {
            Properties profileProps = new Properties();
            for (Profile profile : activeExternalProfiles) {
                profileProps.putAll((Map<?, ?>)profile.getProperties());
            }
            profileProps.putAll(profileActivationContext.getUserProperties());
            profileActivationContext.setUserProperties(profileProps);
        }
        profileActivationContext.setProjectProperties(inputModel.getProperties());
        problems.setSource(inputModel);
        List<Profile> activePomProfiles = this.profileSelector.getActiveProfiles(inputModel.getProfiles(), profileActivationContext, problems);
        problems.setSource(inputModel);
        inputModel.update((Object)this.modelNormalizer.mergeDuplicates(inputModel.getDelegate(), request, (ModelProblemCollector)problems));
        Map<String, Activation> interpolatedActivations = this.getProfileActivations(inputModel, false);
        this.injectProfileActivations(inputModel, interpolatedActivations);
        for (Profile activeProfile : activePomProfiles) {
            this.profileInjector.injectProfile(inputModel, activeProfile, request, problems);
        }
        for (Profile activeProfile : activeExternalProfiles) {
            this.profileInjector.injectProfile(inputModel, activeProfile, request, problems);
        }
    }

    private Model readEffectiveModel(ModelBuildingRequest request, DefaultModelBuildingResult result, DefaultModelProblemCollector problems) throws ModelBuildingException {
        Model inputModel = this.readRawModel(request, problems);
        problems.setRootModel(inputModel);
        ModelData resultData = new ModelData(request.getModelSource(), inputModel);
        ModelData superData = new ModelData(null, this.getSuperModel());
        DefaultProfileActivationContext profileActivationContext = this.getProfileActivationContext(request);
        List<Profile> activeExternalProfiles = result.getActiveExternalProfiles();
        if (!activeExternalProfiles.isEmpty()) {
            Properties profileProps = new Properties();
            for (Profile profile : activeExternalProfiles) {
                profileProps.putAll((Map<?, ?>)profile.getProperties());
            }
            profileProps.putAll(profileActivationContext.getUserProperties());
            profileActivationContext.setUserProperties(profileProps);
        }
        LinkedHashSet<String> parentIds = new LinkedHashSet<String>();
        ArrayList<Model> lineage = new ArrayList<Model>();
        ModelData currentData = resultData;
        while (true) {
            String modelId = currentData.getId();
            result.addModelId(modelId);
            Model rawModel = currentData.getModel();
            result.setRawModel(modelId, rawModel);
            profileActivationContext.setProjectProperties(rawModel.getProperties());
            problems.setSource(rawModel);
            List<Profile> activePomProfiles = this.profileSelector.getActiveProfiles(rawModel.getProfiles(), profileActivationContext, problems);
            result.setActivePomProfiles(modelId, activePomProfiles);
            Model tmpModel = rawModel.clone();
            problems.setSource(tmpModel);
            tmpModel = new Model(this.modelNormalizer.mergeDuplicates(tmpModel.getDelegate(), request, (ModelProblemCollector)problems));
            profileActivationContext.setProjectProperties(tmpModel.getProperties());
            Map<String, Activation> interpolatedActivations = this.getInterpolatedActivations(rawModel, profileActivationContext, problems);
            this.injectProfileActivations(tmpModel, interpolatedActivations);
            for (Profile activeProfile : result.getActivePomProfiles(modelId)) {
                this.profileInjector.injectProfile(tmpModel, activeProfile, request, problems);
            }
            if (currentData == resultData) {
                for (Profile activeProfile : activeExternalProfiles) {
                    this.profileInjector.injectProfile(tmpModel, activeProfile, request, problems);
                }
                result.setEffectiveModel(tmpModel);
            }
            lineage.add(tmpModel);
            if (currentData == superData) break;
            this.configureResolver(request.getModelResolver(), tmpModel, problems);
            ModelData parentData = this.readParent(currentData.getModel(), currentData.getSource(), request, result, problems);
            if (parentData == null) {
                currentData = superData;
                continue;
            }
            if (!parentIds.add(parentData.getId())) {
                StringBuilder message = new StringBuilder("The parents form a cycle: ");
                for (String parentId : parentIds) {
                    message.append(parentId).append(" -> ");
                }
                message.append(parentData.getId());
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage(message.toString()));
                throw problems.newModelBuildingException();
            }
            currentData = parentData;
        }
        problems.setSource(result.getRawModel());
        this.checkPluginVersions(lineage, request, problems);
        Model resultModel = this.assembleInheritance(lineage, request, problems);
        problems.setSource(resultModel);
        problems.setRootModel(resultModel);
        resultModel = this.interpolateModel(resultModel, request, problems);
        this.modelUrlNormalizer.normalize(resultModel, request);
        result.setEffectiveModel(resultModel);
        this.configureResolver(request.getModelResolver(), resultModel, problems, true);
        return resultModel;
    }

    private Map<String, Activation> getInterpolatedActivations(Model rawModel, DefaultProfileActivationContext context, DefaultModelProblemCollector problems) {
        Map<String, Activation> interpolatedActivations = this.getProfileActivations(rawModel, true);
        for (Activation activation : interpolatedActivations.values()) {
            if (activation.getFile() == null) continue;
            this.replaceWithInterpolatedValue(activation.getFile(), context, problems);
        }
        return interpolatedActivations;
    }

    private void replaceWithInterpolatedValue(ActivationFile activationFile, ProfileActivationContext context, DefaultModelProblemCollector problems) {
        try {
            if (DefaultModelBuilder.isNotEmpty(activationFile.getExists())) {
                String path = activationFile.getExists();
                String absolutePath = this.profileActivationFilePathInterpolator.interpolate(path, context);
                activationFile.setExists(absolutePath);
            } else if (DefaultModelBuilder.isNotEmpty(activationFile.getMissing())) {
                String path = activationFile.getMissing();
                String absolutePath = this.profileActivationFilePathInterpolator.interpolate(path, context);
                activationFile.setMissing(absolutePath);
            }
        }
        catch (InterpolationException e) {
            String path = DefaultModelBuilder.isNotEmpty(activationFile.getExists()) ? activationFile.getExists() : activationFile.getMissing();
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Failed to interpolate file location " + path + ": " + e.getMessage()).setLocation(activationFile.getLocation((Object)(DefaultModelBuilder.isNotEmpty(activationFile.getExists()) ? "exists" : "missing"))).setException((Exception)((Object)e)));
        }
    }

    private static boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty();
    }

    @Override
    public ModelBuildingResult build(ModelBuildingRequest request, ModelBuildingResult result) throws ModelBuildingException {
        return this.build(request, result, new LinkedHashSet<String>());
    }

    private ModelBuildingResult build(ModelBuildingRequest request, ModelBuildingResult phaseOneResult, Collection<String> imports) throws ModelBuildingException {
        DefaultModelBuildingResult result = this.asDefaultModelBuildingResult(phaseOneResult);
        DefaultModelProblemCollector problems = new DefaultModelProblemCollector(result);
        Model resultModel = this.readEffectiveModel(request, result, problems);
        problems.setSource(resultModel);
        problems.setRootModel(resultModel);
        this.modelPathTranslator.alignToBaseDirectory(resultModel, resultModel.getProjectDirectory(), request);
        this.pluginManagementInjector.injectManagement(resultModel, request, problems);
        this.fireEvent(resultModel, request, problems, ModelBuildingEventCatapult.BUILD_EXTENSIONS_ASSEMBLED);
        if (request.isProcessPlugins()) {
            if (this.lifecycleBindingsInjector == null) {
                throw new IllegalStateException("lifecycle bindings injector is missing");
            }
            this.lifecycleBindingsInjector.injectLifecycleBindings(resultModel, request, problems);
        }
        this.importDependencyManagement(resultModel, request, problems, imports);
        this.dependencyManagementInjector.injectManagement(resultModel, request, problems);
        resultModel.update((Object)this.modelNormalizer.injectDefaultValues(resultModel.getDelegate(), request, (ModelProblemCollector)problems));
        if (request.isProcessPlugins()) {
            this.reportConfigurationExpander.expandPluginConfiguration(resultModel, request, problems);
            this.pluginConfigurationExpander.expandPluginConfiguration(resultModel, request, problems);
        }
        this.modelValidator.validateEffectiveModel(resultModel, request, problems);
        if (this.hasModelErrors(problems)) {
            throw problems.newModelBuildingException();
        }
        return result;
    }

    private DefaultModelBuildingResult asDefaultModelBuildingResult(ModelBuildingResult phaseOneResult) {
        if (phaseOneResult instanceof DefaultModelBuildingResult) {
            return (DefaultModelBuildingResult)phaseOneResult;
        }
        return new DefaultModelBuildingResult(phaseOneResult);
    }

    @Override
    public Result<? extends Model> buildRawModel(File pomFile, int validationLevel, boolean locationTracking) {
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest().setValidationLevel(validationLevel).setLocationTracking(locationTracking).setModelSource(new FileModelSource(pomFile));
        DefaultModelProblemCollector collector = new DefaultModelProblemCollector(new DefaultModelBuildingResult());
        try {
            return Result.newResult(this.readFileModel(request, collector), collector.getProblems());
        }
        catch (ModelBuildingException e) {
            return Result.error(collector.getProblems());
        }
    }

    private Model readFileModel(ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        ModelSource modelSource = request.getModelSource();
        org.apache.maven.api.model.Model model = DefaultModelBuilder.fromCache(request.getModelCache(), modelSource, ModelCacheTag.FILE);
        if (model == null) {
            model = this.doReadFileModel(modelSource, request, problems);
            this.intoCache(request.getModelCache(), modelSource, ModelCacheTag.FILE, model);
        }
        if (modelSource instanceof FileModelSource && request.getTransformerContextBuilder() instanceof DefaultTransformerContextBuilder) {
            DefaultTransformerContextBuilder contextBuilder = (DefaultTransformerContextBuilder)request.getTransformerContextBuilder();
            contextBuilder.putSource(this.getGroupId(model), model.getArtifactId(), modelSource);
        }
        return new Model(model);
    }

    private org.apache.maven.api.model.Model doReadFileModel(ModelSource modelSource, ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        org.apache.maven.api.model.Model model;
        block15: {
            problems.setSource(modelSource.getLocation());
            try {
                org.apache.maven.api.model.InputSource source;
                boolean strict = request.getValidationLevel() >= 20;
                HashMap<String, Object> options = new HashMap<String, Object>(3);
                options.put("org.apache.maven.model.io.isStrict", strict);
                options.put("org.apache.maven.model.building.source", modelSource);
                if (request.isLocationTracking()) {
                    source = new org.apache.maven.api.model.InputSource(null, modelSource.getLocation());
                    options.put("org.apache.maven.model.io.inputSource", new InputSource(source));
                } else {
                    source = null;
                }
                try {
                    model = this.modelProcessor.read(modelSource.getInputStream(), options).getDelegate();
                }
                catch (ModelParseException e) {
                    if (!strict) {
                        throw e;
                    }
                    options.put("org.apache.maven.model.io.isStrict", Boolean.FALSE);
                    try {
                        model = this.modelProcessor.read(modelSource.getInputStream(), options).getDelegate();
                    }
                    catch (ModelParseException ne) {
                        throw e;
                    }
                    ModelProblem.Severity severity = modelSource instanceof FileModelSource ? ModelProblem.Severity.ERROR : ModelProblem.Severity.WARNING;
                    problems.add(new ModelProblemCollectorRequest(severity, ModelProblem.Version.V20).setMessage("Malformed POM " + modelSource.getLocation() + ": " + e.getMessage()).setException(e));
                }
                if (source == null) break block15;
                try {
                    org.apache.maven.api.model.InputSource v4src = model.getLocation((Object)"").getSource();
                    Field field = org.apache.maven.api.model.InputSource.class.getDeclaredField("modelId");
                    field.setAccessible(true);
                    field.set(v4src, ModelProblemUtils.toId(model));
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Unable to set modelId on InputSource", t);
                }
            }
            catch (ModelParseException e) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage("Non-parseable POM " + modelSource.getLocation() + ": " + e.getMessage()).setException(e));
                throw problems.newModelBuildingException();
            }
            catch (IOException e) {
                String msg = e.getMessage();
                if (msg == null || msg.length() <= 0) {
                    msg = e.getClass().getName().endsWith("MalformedInputException") ? "Some input bytes do not match the file encoding." : e.getClass().getSimpleName();
                }
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage("Non-readable POM " + modelSource.getLocation() + ": " + msg).setException(e));
                throw problems.newModelBuildingException();
            }
        }
        if (modelSource instanceof FileModelSource) {
            model = model.withPomFile(((FileModelSource)modelSource).getFile().toPath());
        }
        Model retModel = new Model(model);
        problems.setSource(retModel);
        this.modelValidator.validateFileModel(retModel, request, problems);
        if (this.hasFatalErrors(problems)) {
            throw problems.newModelBuildingException();
        }
        return model;
    }

    private Model readRawModel(ModelBuildingRequest request, DefaultModelProblemCollector problems) throws ModelBuildingException {
        Model rawModel;
        ModelSource modelSource = request.getModelSource();
        ModelData cachedData = DefaultModelBuilder.fromCache(request.getModelCache(), modelSource, ModelCacheTag.RAW);
        if (cachedData != null) {
            return cachedData.getModel();
        }
        if (Features.buildConsumer(request.getUserProperties()).isActive() && modelSource instanceof FileModelSource) {
            rawModel = this.readFileModel(request, problems);
            File pomFile = ((FileModelSource)modelSource).getFile();
            TransformerContext context = null;
            if (request.getTransformerContextBuilder() != null) {
                context = request.getTransformerContextBuilder().initialize(request, problems);
            }
            try {
                Model transformedFileModel = this.modelProcessor.read(pomFile, Collections.singletonMap("transformerContext", context));
                rawModel = new Model(this.modelMerger.merge(rawModel.getDelegate(), transformedFileModel.getDelegate(), false, null));
            }
            catch (IOException e) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.V40).setException(e));
            }
        } else {
            rawModel = request.getFileModel() == null ? this.readFileModel(request, problems) : request.getFileModel().clone();
        }
        this.modelValidator.validateRawModel(rawModel, request, problems);
        if (this.hasFatalErrors(problems)) {
            throw problems.newModelBuildingException();
        }
        String groupId = this.getGroupId(rawModel);
        String artifactId = rawModel.getArtifactId();
        String version = this.getVersion(rawModel);
        ModelData modelData = new ModelData(modelSource, rawModel, groupId, artifactId, version);
        this.intoCache(request.getModelCache(), modelSource, ModelCacheTag.RAW, modelData);
        return rawModel;
    }

    private String getGroupId(Model model) {
        return this.getGroupId(model.getDelegate());
    }

    private String getGroupId(org.apache.maven.api.model.Model model) {
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        return groupId;
    }

    private String getVersion(Model model) {
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return version;
    }

    private DefaultProfileActivationContext getProfileActivationContext(ModelBuildingRequest request) {
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setActiveProfileIds(request.getActiveProfileIds());
        context.setInactiveProfileIds(request.getInactiveProfileIds());
        context.setSystemProperties(request.getSystemProperties());
        Properties userProperties = request.getUserProperties();
        if (!userProperties.containsKey("packaging")) {
            userProperties.put("packaging", request.getFileModel().getPackaging());
        }
        context.setUserProperties(userProperties);
        context.setProjectDirectory(request.getPomFile() != null ? request.getPomFile().getParentFile() : null);
        return context;
    }

    private void configureResolver(ModelResolver modelResolver, Model model, DefaultModelProblemCollector problems) {
        this.configureResolver(modelResolver, model, problems, false);
    }

    private void configureResolver(ModelResolver modelResolver, Model model, DefaultModelProblemCollector problems, boolean replaceRepositories) {
        if (modelResolver == null) {
            return;
        }
        problems.setSource(model);
        List repositories = model.getRepositories();
        for (Repository repository : repositories) {
            try {
                modelResolver.addRepository(repository, replaceRepositories);
            }
            catch (InvalidRepositoryException e) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Invalid repository " + repository.getId() + ": " + e.getMessage()).setLocation(repository.getLocation((Object)"")).setException(e));
            }
        }
    }

    private void checkPluginVersions(List<Model> lineage, ModelBuildingRequest request, ModelProblemCollector problems) {
        if (request.getValidationLevel() < 20) {
            return;
        }
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        HashMap<String, String> versions = new HashMap<String, String>();
        HashMap<String, String> managedVersions = new HashMap<String, String>();
        for (int i = lineage.size() - 1; i >= 0; --i) {
            Model model = lineage.get(i);
            Build build = model.getBuild();
            if (build == null) continue;
            for (Plugin plugin : build.getPlugins()) {
                String key = plugin.getKey();
                if (versions.get(key) != null) continue;
                versions.put(key, plugin.getVersion());
                plugins.put(key, plugin);
            }
            PluginManagement mgmt = build.getPluginManagement();
            if (mgmt == null) continue;
            for (Plugin plugin : mgmt.getPlugins()) {
                String key = plugin.getKey();
                managedVersions.computeIfAbsent(key, k -> plugin.getVersion());
            }
        }
        for (String key : versions.keySet()) {
            if (versions.get(key) != null || managedVersions.get(key) != null) continue;
            InputLocation location = ((Plugin)plugins.get(key)).getLocation((Object)"");
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.WARNING, ModelProblem.Version.V20).setMessage("'build.plugins.plugin.version' for " + key + " is missing.").setLocation(location));
        }
    }

    private Model assembleInheritance(List<Model> lineage, ModelBuildingRequest request, ModelProblemCollector problems) {
        org.apache.maven.api.model.Model parent = lineage.get(lineage.size() - 1).getDelegate();
        for (int i = lineage.size() - 2; i >= 0; --i) {
            Model child = lineage.get(i);
            parent = this.inheritanceAssembler.assembleModelInheritance(child.getDelegate(), parent, request, problems);
        }
        return new Model(parent);
    }

    private Map<String, Activation> getProfileActivations(Model model, boolean clone) {
        HashMap<String, Activation> activations = new HashMap<String, Activation>();
        for (Profile profile : model.getProfiles()) {
            Activation activation = profile.getActivation();
            if (activation == null) continue;
            if (clone) {
                activation = activation.clone();
            }
            activations.put(profile.getId(), activation);
        }
        return activations;
    }

    private void injectProfileActivations(Model model, Map<String, Activation> activations) {
        for (Profile profile : model.getProfiles()) {
            Activation activation = profile.getActivation();
            if (activation == null) continue;
            profile.setActivation(activations.get(profile.getId()));
        }
    }

    private Model interpolateModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Map<String, Activation> originalActivations = this.getProfileActivations(model, true);
        Model interpolatedModel = new Model(this.modelInterpolator.interpolateModel(model.getDelegate(), model.getProjectDirectory(), request, problems));
        if (interpolatedModel.getParent() != null) {
            StringSearchInterpolator ssi = new StringSearchInterpolator();
            ssi.addValueSource((ValueSource)new MapBasedValueSource((Map)request.getUserProperties()));
            ssi.addValueSource((ValueSource)new MapBasedValueSource((Map)model.getProperties()));
            ssi.addValueSource((ValueSource)new MapBasedValueSource((Map)request.getSystemProperties()));
            try {
                String interpolated = ssi.interpolate(interpolatedModel.getParent().getVersion());
                interpolatedModel.getParent().setVersion(interpolated);
            }
            catch (Exception e) {
                ModelProblemCollectorRequest mpcr = new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Failed to interpolate field: " + interpolatedModel.getParent().getVersion() + " on class: ").setException(e);
                problems.add(mpcr);
            }
        }
        interpolatedModel.setPomFile(model.getPomFile());
        this.injectProfileActivations(model, originalActivations);
        return interpolatedModel;
    }

    private ModelData readParent(Model childModel, Source childSource, ModelBuildingRequest request, ModelBuildingResult result, DefaultModelProblemCollector problems) throws ModelBuildingException {
        ModelData parentData = null;
        Parent parent = childModel.getParent();
        if (parent != null) {
            Model parentModel;
            parentData = this.readParentLocally(childModel, childSource, request, result, problems);
            if (parentData == null) {
                parentData = this.readParentExternally(childModel, request, result, problems);
            }
            if (!"pom".equals((parentModel = parentData.getModel()).getPackaging())) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Invalid packaging for parent POM " + ModelProblemUtils.toSourceHint(parentModel) + ", must be \"pom\" but is \"" + parentModel.getPackaging() + "\"").setLocation(parentModel.getLocation((Object)"packaging")));
            }
        }
        return parentData;
    }

    private ModelData readParentLocally(Model childModel, Source childSource, ModelBuildingRequest request, ModelBuildingResult result, DefaultModelProblemCollector problems) throws ModelBuildingException {
        Model candidateModel;
        ModelSource candidateSource;
        Parent parent = childModel.getParent();
        WorkspaceModelResolver resolver = request.getWorkspaceModelResolver();
        if (resolver == null) {
            candidateSource = this.getParentPomFile(childModel, childSource);
            if (candidateSource == null) {
                return null;
            }
            DefaultModelBuildingRequest candidateBuildRequest = new DefaultModelBuildingRequest(request).setModelSource(candidateSource);
            candidateModel = this.readRawModel(candidateBuildRequest, problems);
        } else {
            try {
                candidateModel = resolver.resolveRawModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            catch (UnresolvableModelException e) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage(e.getMessage()).setLocation(parent.getLocation((Object)"")).setException(e));
                throw problems.newModelBuildingException();
            }
            if (candidateModel == null) {
                return null;
            }
            candidateSource = new FileModelSource(candidateModel.getPomFile());
        }
        String groupId = this.getGroupId(candidateModel);
        String artifactId = candidateModel.getArtifactId();
        if (groupId == null || !groupId.equals(parent.getGroupId()) || artifactId == null || !artifactId.equals(parent.getArtifactId())) {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("'parent.relativePath'");
            if (childModel != problems.getRootModel()) {
                buffer.append(" of POM ").append(ModelProblemUtils.toSourceHint(childModel));
            }
            buffer.append(" points at ").append(groupId).append(':').append(artifactId);
            buffer.append(" instead of ").append(parent.getGroupId()).append(':');
            buffer.append(parent.getArtifactId()).append(", please verify your project structure");
            problems.setSource(childModel);
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.WARNING, ModelProblem.Version.BASE).setMessage(buffer.toString()).setLocation(parent.getLocation((Object)"")));
            return null;
        }
        String version = this.getVersion(candidateModel);
        if (version != null && parent.getVersion() != null && !version.equals(parent.getVersion())) {
            try {
                VersionRange parentRange = VersionRange.createFromVersionSpec((String)parent.getVersion());
                if (!parentRange.hasRestrictions()) {
                    return null;
                }
                if (!parentRange.containsVersion((ArtifactVersion)new DefaultArtifactVersion(version))) {
                    return null;
                }
                String rawChildModelVersion = childModel.getVersion();
                if (rawChildModelVersion == null) {
                    problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.V31).setMessage("Version must be a constant").setLocation(childModel.getLocation((Object)"")));
                } else if (this.rawChildVersionReferencesParent(rawChildModelVersion)) {
                    problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.V31).setMessage("Version must be a constant").setLocation(childModel.getLocation((Object)"version")));
                }
            }
            catch (InvalidVersionSpecificationException e) {
                return null;
            }
        }
        return new ModelData(candidateSource, candidateModel, groupId, artifactId, version);
    }

    private boolean rawChildVersionReferencesParent(String rawChildModelVersion) {
        return rawChildModelVersion.equals("${pom.version}") || rawChildModelVersion.equals("${project.version}") || rawChildModelVersion.equals("${pom.parent.version}") || rawChildModelVersion.equals("${project.parent.version}");
    }

    private ModelSource getParentPomFile(Model childModel, Source source) {
        if (!(source instanceof ModelSource2)) {
            return null;
        }
        String parentPath = childModel.getParent().getRelativePath();
        if (parentPath == null || parentPath.length() <= 0) {
            return null;
        }
        return ((ModelSource2)source).getRelatedSource(parentPath);
    }

    private ModelData readParentExternally(Model childModel, ModelBuildingRequest request, ModelBuildingResult result, DefaultModelProblemCollector problems) throws ModelBuildingException {
        ModelSource modelSource;
        problems.setSource(childModel);
        Parent parent = childModel.getParent();
        String groupId = parent.getGroupId();
        String artifactId = parent.getArtifactId();
        String version = parent.getVersion();
        ModelResolver modelResolver = request.getModelResolver();
        Objects.requireNonNull(modelResolver, String.format("request.modelResolver cannot be null (parent POM %s and POM %s)", ModelProblemUtils.toId(groupId, artifactId, version), ModelProblemUtils.toSourceHint(childModel)));
        try {
            modelSource = modelResolver.resolveModel(parent);
        }
        catch (UnresolvableModelException e) {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("Non-resolvable parent POM");
            if (!this.containsCoordinates(e.getMessage(), groupId, artifactId, version)) {
                buffer.append(' ').append(ModelProblemUtils.toId(groupId, artifactId, version));
            }
            if (childModel != problems.getRootModel()) {
                buffer.append(" for ").append(ModelProblemUtils.toId(childModel));
            }
            buffer.append(": ").append(e.getMessage());
            if (childModel.getProjectDirectory() != null) {
                if (parent.getRelativePath() == null || parent.getRelativePath().length() <= 0) {
                    buffer.append(" and 'parent.relativePath' points at no local POM");
                } else {
                    buffer.append(" and 'parent.relativePath' points at wrong local POM");
                }
            }
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage(buffer.toString()).setLocation(parent.getLocation((Object)"")).setException(e));
            throw problems.newModelBuildingException();
        }
        int validationLevel = Math.min(request.getValidationLevel(), 20);
        ModelBuildingRequest lenientRequest = new DefaultModelBuildingRequest(request).setValidationLevel(validationLevel).setFileModel(null).setModelSource(modelSource);
        Model parentModel = this.readRawModel(lenientRequest, problems);
        if (!parent.getVersion().equals(version)) {
            String rawChildModelVersion = childModel.getVersion();
            if (rawChildModelVersion == null) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.V31).setMessage("Version must be a constant").setLocation(childModel.getLocation((Object)"")));
            } else if (this.rawChildVersionReferencesParent(rawChildModelVersion)) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.V31).setMessage("Version must be a constant").setLocation(childModel.getLocation((Object)"version")));
            }
        }
        return new ModelData(modelSource, parentModel, parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    private Model getSuperModel() {
        return new Model(this.superPomProvider.getSuperModel("4.0.0"));
    }

    private void importDependencyManagement(Model model, ModelBuildingRequest request, DefaultModelProblemCollector problems, Collection<String> importIds) {
        DependencyManagement depMgmt = model.getDependencyManagement();
        if (depMgmt == null) {
            return;
        }
        String importing = model.getGroupId() + ':' + model.getArtifactId() + ':' + model.getVersion();
        importIds.add(importing);
        ArrayList<org.apache.maven.api.model.DependencyManagement> importMgmts = null;
        Iterator it = depMgmt.getDependencies().iterator();
        while (it.hasNext()) {
            Dependency dependency = (Dependency)it.next();
            if (!"pom".equals(dependency.getType()) || !"import".equals(dependency.getScope())) continue;
            it.remove();
            DependencyManagement importMgmt = this.loadDependencyManagement(model, request, problems, dependency, importIds);
            if (importMgmt == null) continue;
            if (importMgmts == null) {
                importMgmts = new ArrayList<org.apache.maven.api.model.DependencyManagement>();
            }
            importMgmts.add(importMgmt.getDelegate());
        }
        importIds.remove(importing);
        model.update((Object)this.dependencyManagementImporter.importManagement(model.getDelegate(), importMgmts, request, problems));
    }

    private DependencyManagement loadDependencyManagement(Model model, ModelBuildingRequest request, DefaultModelProblemCollector problems, Dependency dependency, Collection<String> importIds) {
        DependencyManagement importMgmtV3;
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        String version = dependency.getVersion();
        if (groupId == null || groupId.length() <= 0) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("'dependencyManagement.dependencies.dependency.groupId' for " + dependency.getManagementKey() + " is missing.").setLocation(dependency.getLocation((Object)"")));
            return null;
        }
        if (artifactId == null || artifactId.length() <= 0) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("'dependencyManagement.dependencies.dependency.artifactId' for " + dependency.getManagementKey() + " is missing.").setLocation(dependency.getLocation((Object)"")));
            return null;
        }
        if (version == null || version.length() <= 0) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("'dependencyManagement.dependencies.dependency.version' for " + dependency.getManagementKey() + " is missing.").setLocation(dependency.getLocation((Object)"")));
            return null;
        }
        String imported = groupId + ':' + artifactId + ':' + version;
        if (importIds.contains(imported)) {
            StringBuilder message = new StringBuilder("The dependencies of type=pom and with scope=import form a cycle: ");
            for (String modelId : importIds) {
                message.append(modelId).append(" -> ");
            }
            message.append(imported);
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage(message.toString()));
            return null;
        }
        org.apache.maven.api.model.DependencyManagement importMgmt = DefaultModelBuilder.fromCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.IMPORT);
        if (importMgmt == null && (importMgmtV3 = this.doLoadDependencyManagement(model, request, problems, dependency, groupId, artifactId, version, importIds)) != null) {
            importMgmt = importMgmtV3.getDelegate();
            this.intoCache(request.getModelCache(), groupId, artifactId, version, ModelCacheTag.IMPORT, importMgmt);
        }
        return importMgmt != null ? new DependencyManagement(importMgmt) : null;
    }

    private DependencyManagement doLoadDependencyManagement(Model model, ModelBuildingRequest request, DefaultModelProblemCollector problems, Dependency dependency, String groupId, String artifactId, String version, Collection<String> importIds) {
        DependencyManagement importMgmt;
        WorkspaceModelResolver workspaceResolver = request.getWorkspaceModelResolver();
        ModelResolver modelResolver = request.getModelResolver();
        if (workspaceResolver == null && modelResolver == null) {
            throw new NullPointerException(String.format("request.workspaceModelResolver and request.modelResolver cannot be null (parent POM %s and POM %s)", ModelProblemUtils.toId(groupId, artifactId, version), ModelProblemUtils.toSourceHint(model)));
        }
        Model importModel = null;
        if (workspaceResolver != null) {
            try {
                importModel = workspaceResolver.resolveEffectiveModel(groupId, artifactId, version);
            }
            catch (UnresolvableModelException e) {
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.FATAL, ModelProblem.Version.BASE).setMessage(e.getMessage()).setException(e));
                return null;
            }
        }
        if (importModel == null) {
            ModelBuildingResult importResult;
            ModelSource importSource;
            try {
                importSource = modelResolver.resolveModel(dependency);
            }
            catch (UnresolvableModelException e) {
                StringBuilder buffer = new StringBuilder(256);
                buffer.append("Non-resolvable import POM");
                if (!this.containsCoordinates(e.getMessage(), groupId, artifactId, version)) {
                    buffer.append(' ').append(ModelProblemUtils.toId(groupId, artifactId, version));
                }
                buffer.append(": ").append(e.getMessage());
                problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage(buffer.toString()).setLocation(dependency.getLocation((Object)"")).setException(e));
                return null;
            }
            try {
                DefaultModelBuildingRequest importRequest = new DefaultModelBuildingRequest();
                importRequest.setValidationLevel(0);
                importRequest.setModelCache(request.getModelCache());
                importRequest.setSystemProperties(request.getSystemProperties());
                importRequest.setUserProperties(request.getUserProperties());
                importRequest.setLocationTracking(request.isLocationTracking());
                importRequest.setModelSource(importSource);
                importRequest.setModelResolver(modelResolver.newCopy());
                importResult = this.build((ModelBuildingRequest)importRequest, importIds);
            }
            catch (ModelBuildingException e) {
                problems.addAll(e.getProblems());
                return null;
            }
            problems.addAll(importResult.getProblems());
            importModel = importResult.getEffectiveModel();
        }
        if ((importMgmt = importModel.getDependencyManagement()) == null) {
            importMgmt = new DependencyManagement();
        }
        return importMgmt;
    }

    private <T> void intoCache(ModelCache modelCache, String groupId, String artifactId, String version, ModelCacheTag<T> tag, T data) {
        if (modelCache != null) {
            modelCache.put(groupId, artifactId, version, tag, data);
        }
    }

    private <T> void intoCache(ModelCache modelCache, Source source, ModelCacheTag<T> tag, T data) {
        if (modelCache != null) {
            modelCache.put(source, tag, data);
        }
    }

    private static <T> T fromCache(ModelCache modelCache, String groupId, String artifactId, String version, ModelCacheTag<T> tag) {
        if (modelCache != null) {
            return modelCache.get(groupId, artifactId, version, tag);
        }
        return null;
    }

    private static <T> T fromCache(ModelCache modelCache, Source source, ModelCacheTag<T> tag) {
        if (modelCache != null) {
            return modelCache.get(source, tag);
        }
        return null;
    }

    private void fireEvent(Model model, ModelBuildingRequest request, ModelProblemCollector problems, ModelBuildingEventCatapult catapult) throws ModelBuildingException {
        ModelBuildingListener listener = request.getModelBuildingListener();
        if (listener != null) {
            DefaultModelBuildingEvent event = new DefaultModelBuildingEvent(model, request, problems);
            catapult.fire(listener, event);
        }
    }

    private boolean containsCoordinates(String message, String groupId, String artifactId, String version) {
        return !(message == null || groupId != null && !message.contains(groupId) || artifactId != null && !message.contains(artifactId) || version != null && !message.contains(version));
    }

    protected boolean hasModelErrors(ModelProblemCollectorExt problems) {
        if (problems instanceof DefaultModelProblemCollector) {
            return ((DefaultModelProblemCollector)problems).hasErrors();
        }
        throw new IllegalStateException();
    }

    protected boolean hasFatalErrors(ModelProblemCollectorExt problems) {
        if (problems instanceof DefaultModelProblemCollector) {
            return ((DefaultModelProblemCollector)problems).hasFatalErrors();
        }
        throw new IllegalStateException();
    }

    private class DefaultTransformerContextBuilder
    implements TransformerContextBuilder {
        private final DefaultTransformerContext context = new DefaultTransformerContext();
        private final Map<DefaultTransformerContext.GAKey, Set<Source>> mappedSources = new ConcurrentHashMap<DefaultTransformerContext.GAKey, Set<Source>>(64);

        private DefaultTransformerContextBuilder() {
        }

        @Override
        public TransformerContext initialize(final ModelBuildingRequest request, ModelProblemCollector collector) {
            final DefaultModelProblemCollector problems = (DefaultModelProblemCollector)collector;
            return new TransformerContext(){

                @Override
                public String getUserProperty(String key) {
                    return ((DefaultTransformerContextBuilder)DefaultTransformerContextBuilder.this).context.userProperties.computeIfAbsent(key, k -> request.getUserProperties().getProperty(key));
                }

                @Override
                public Model getRawModel(String gId, String aId) {
                    return ((DefaultTransformerContextBuilder)DefaultTransformerContextBuilder.this).context.modelByGA.computeIfAbsent(new DefaultTransformerContext.GAKey(gId, aId), k -> new DefaultTransformerContext.Holder()).computeIfAbsent(() -> this.findRawModel(gId, aId));
                }

                @Override
                public Model getRawModel(Path path) {
                    return ((DefaultTransformerContextBuilder)DefaultTransformerContextBuilder.this).context.modelByPath.computeIfAbsent(path, k -> new DefaultTransformerContext.Holder()).computeIfAbsent(() -> this.findRawModel(path));
                }

                private Model findRawModel(String groupId, String artifactId) {
                    Source source = DefaultTransformerContextBuilder.this.getSource(groupId, artifactId);
                    if (source != null) {
                        try {
                            DefaultModelBuildingRequest gaBuildingRequest = new DefaultModelBuildingRequest(request).setModelSource((ModelSource)source);
                            Model model = DefaultModelBuilder.this.readRawModel(gaBuildingRequest, problems);
                            if (source instanceof FileModelSource) {
                                Path path = ((FileModelSource)source).getFile().toPath();
                                ((DefaultTransformerContextBuilder)DefaultTransformerContextBuilder.this).context.modelByPath.computeIfAbsent(path, k -> new DefaultTransformerContext.Holder()).computeIfAbsent(() -> model);
                            }
                            return model;
                        }
                        catch (ModelBuildingException modelBuildingException) {
                            // empty catch block
                        }
                    }
                    return null;
                }

                private Model findRawModel(Path p) {
                    if (!Files.isRegularFile(p, new LinkOption[0])) {
                        throw new IllegalArgumentException("Not a regular file: " + p);
                    }
                    DefaultModelBuildingRequest req = new DefaultModelBuildingRequest(request).setPomFile(p.toFile()).setModelSource(new FileModelSource(p.toFile()));
                    try {
                        Model model = DefaultModelBuilder.this.readRawModel(req, problems);
                        DefaultTransformerContext.GAKey key = new DefaultTransformerContext.GAKey(DefaultModelBuilder.this.getGroupId(model), model.getArtifactId());
                        ((DefaultTransformerContextBuilder)DefaultTransformerContextBuilder.this).context.modelByGA.computeIfAbsent(key, k -> new DefaultTransformerContext.Holder()).computeIfAbsent(() -> model);
                        return model;
                    }
                    catch (ModelBuildingException modelBuildingException) {
                        return null;
                    }
                }
            };
        }

        @Override
        public TransformerContext build() {
            return this.context;
        }

        public Source getSource(String groupId, String artifactId) {
            Set<Source> sources = this.mappedSources.get(new DefaultTransformerContext.GAKey(groupId, artifactId));
            if (sources == null) {
                return null;
            }
            return sources.stream().reduce((a, b) -> {
                throw new IllegalStateException(String.format("No unique Source for %s:%s: %s and %s", groupId, artifactId, a.getLocation(), b.getLocation()));
            }).orElse(null);
        }

        public void putSource(String groupId, String artifactId, Source source) {
            this.mappedSources.computeIfAbsent(new DefaultTransformerContext.GAKey(groupId, artifactId), k -> new HashSet()).add(source);
        }
    }
}

