/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.File;
import java.util.Objects;
import org.apache.maven.building.FileSource;
import org.apache.maven.model.building.ModelSource;

public class ArtifactModelSource
extends FileSource
implements ModelSource {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final int hashCode;

    public ArtifactModelSource(File file, String groupId, String artifactId, String version) {
        super(file);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.hashCode = Objects.hash(groupId, artifactId, version);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!ArtifactModelSource.class.equals(obj.getClass())) {
            return false;
        }
        ArtifactModelSource other = (ArtifactModelSource)obj;
        return Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.groupId, other.groupId) && Objects.equals(this.version, other.version);
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }
}

