/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class Graph {
    final Map<String, Vertex> vertices = new LinkedHashMap<String, Vertex>();

    Graph() {
    }

    public Vertex getVertex(String id) {
        return this.vertices.get(id);
    }

    public Collection<Vertex> getVertices() {
        return this.vertices.values();
    }

    Vertex addVertex(String label) {
        return this.vertices.computeIfAbsent(label, Vertex::new);
    }

    void addEdge(Vertex from, Vertex to) throws CycleDetectedException {
        from.children.add(to);
        to.parents.add(from);
        List<String> cycle = this.findCycle(to);
        if (cycle != null) {
            this.removeEdge(from, to);
            throw new CycleDetectedException("Edge between '" + from.label + "' and '" + to.label + "' introduces to cycle in the graph", cycle);
        }
    }

    void removeEdge(Vertex from, Vertex to) {
        from.children.remove(to);
        to.parents.remove(from);
    }

    List<String> visitAll() {
        return Graph.visitAll(this.vertices.values(), new HashMap<Vertex, DfsState>(), new ArrayList<String>());
    }

    List<String> findCycle(Vertex vertex) {
        return Graph.visitCycle(Collections.singleton(vertex), new HashMap<Vertex, DfsState>(), new LinkedList<String>());
    }

    private static List<String> visitAll(Collection<Vertex> children, Map<Vertex, DfsState> stateMap, List<String> list) {
        for (Vertex v : children) {
            DfsState state = stateMap.putIfAbsent(v, DfsState.VISITING);
            if (state != null) continue;
            Graph.visitAll(v.children, stateMap, list);
            stateMap.put(v, DfsState.VISITED);
            list.add(v.label);
        }
        return list;
    }

    private static List<String> visitCycle(Collection<Vertex> children, Map<Vertex, DfsState> stateMap, LinkedList<String> cycle) {
        for (Vertex v : children) {
            DfsState state = stateMap.putIfAbsent(v, DfsState.VISITING);
            if (state == null) {
                cycle.addLast(v.label);
                List<String> ret = Graph.visitCycle(v.children, stateMap, cycle);
                if (ret != null) {
                    return ret;
                }
                cycle.removeLast();
                stateMap.put(v, DfsState.VISITED);
                continue;
            }
            if (state != DfsState.VISITING) continue;
            int pos = cycle.lastIndexOf(v.label);
            List<String> ret = cycle.subList(pos, cycle.size());
            ret.add(v.label);
            return ret;
        }
        return null;
    }

    static class Vertex {
        final String label;
        final List<Vertex> children = new ArrayList<Vertex>();
        final List<Vertex> parents = new ArrayList<Vertex>();

        Vertex(String label) {
            this.label = label;
        }

        String getLabel() {
            return this.label;
        }

        List<Vertex> getChildren() {
            return this.children;
        }

        List<Vertex> getParents() {
            return this.parents;
        }
    }

    public static class CycleDetectedException
    extends Exception {
        private final List<String> cycle;

        CycleDetectedException(String message, List<String> cycle) {
            super(message);
            this.cycle = cycle;
        }

        public List<String> getCycle() {
            return this.cycle;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " " + String.join((CharSequence)" --> ", this.cycle);
        }
    }

    private static enum DfsState {
        VISITING,
        VISITED;

    }
}

