/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.profile.activation;

import java.util.Locale;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.utils.Os;

@Named(value="os")
@Singleton
public class OperatingSystemProfileActivator
implements ProfileActivator {
    private static final String REGEX_PREFIX = "regex:";

    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationOS os = activation.getOs();
        if (os == null) {
            return false;
        }
        boolean active = this.ensureAtLeastOneNonNull(os);
        String actualOsName = context.getSystemProperties().get("os.name").toLowerCase(Locale.ENGLISH);
        String actualOsArch = context.getSystemProperties().get("os.arch").toLowerCase(Locale.ENGLISH);
        String actualOsVersion = context.getSystemProperties().get("os.version").toLowerCase(Locale.ENGLISH);
        if (active && os.getFamily() != null) {
            active = this.determineFamilyMatch(os.getFamily(), actualOsName);
        }
        if (active && os.getName() != null) {
            active = this.determineNameMatch(os.getName(), actualOsName);
        }
        if (active && os.getArch() != null) {
            active = this.determineArchMatch(os.getArch(), actualOsArch);
        }
        if (active && os.getVersion() != null) {
            active = this.determineVersionMatch(os.getVersion(), actualOsVersion);
        }
        return active;
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationOS os = activation.getOs();
        return os != null;
    }

    private boolean ensureAtLeastOneNonNull(ActivationOS os) {
        return os.getArch() != null || os.getFamily() != null || os.getName() != null || os.getVersion() != null;
    }

    private boolean determineVersionMatch(String expectedVersion, String actualVersion) {
        boolean result;
        String test = expectedVersion;
        boolean reverse = false;
        if (test.startsWith(REGEX_PREFIX)) {
            result = actualVersion.matches(test.substring(REGEX_PREFIX.length()));
        } else {
            if (test.startsWith("!")) {
                reverse = true;
                test = test.substring(1);
            }
            result = actualVersion.equals(test);
        }
        return reverse != result;
    }

    private boolean determineArchMatch(String expectedArch, String actualArch) {
        boolean result;
        String test = expectedArch;
        boolean reverse = false;
        if (test.startsWith("!")) {
            reverse = true;
            test = test.substring(1);
        }
        return reverse != (result = actualArch.equals(test));
    }

    private boolean determineNameMatch(String expectedName, String actualName) {
        boolean result;
        String test = expectedName;
        boolean reverse = false;
        if (test.startsWith("!")) {
            reverse = true;
            test = test.substring(1);
        }
        return reverse != (result = actualName.equals(test));
    }

    private boolean determineFamilyMatch(String family, String actualName) {
        boolean result;
        String test = family;
        boolean reverse = false;
        if (test.startsWith("!")) {
            reverse = true;
            test = test.substring(1);
        }
        return reverse != (result = Os.isFamily(test, actualName));
    }
}

