/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.transform;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.model.transform.pull.BufferingParser;
import org.apache.maven.model.transform.pull.NodeBufferingParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

public class RelativePathXMLFilter
extends NodeBufferingParser {
    private static final Pattern S_FILTER = Pattern.compile("\\s+");

    public RelativePathXMLFilter(XmlPullParser xmlPullParser) {
        super(xmlPullParser, "parent");
    }

    @Override
    protected void process(List<BufferingParser.Event> buffer) {
        boolean skip = false;
        BufferingParser.Event prev = null;
        for (BufferingParser.Event event : buffer) {
            if (event.event == 2 && "relativePath".equals(event.name)) {
                skip = true;
                if (prev != null && prev.event == 4 && S_FILTER.matcher(prev.text).matches()) {
                    prev = null;
                }
                event = null;
            } else if (event.event == 3 && "relativePath".equals(event.name)) {
                skip = false;
                event = null;
            } else if (skip) {
                event = null;
            }
            if (prev != null) {
                this.pushEvent(prev);
            }
            prev = event;
        }
        this.pushEvent(prev);
    }
}

