/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class Dependency.
 * 
 * @version $Revision$ $Date$
 */
public class Dependency implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field type
     */
    private String type = "jar";

    /**
     * Field classifier
     */
    private String classifier;

    /**
     * Field scope
     */
    private String scope;

    /**
     * Field systemPath
     */
    private String systemPath;

    /**
     * Field exclusions
     */
    private java.util.List exclusions;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclusion
     * 
     * @param exclusion
     */
    public void addExclusion(Exclusion exclusion)
    {
        getExclusions().add( exclusion );
    } //-- void addExclusion(Exclusion) 

    /**
     * Method getArtifactId
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Method getClassifier
     */
    public String getClassifier()
    {
        return this.classifier;
    } //-- String getClassifier() 

    /**
     * Method getExclusions
     */
    public java.util.List getExclusions()
    {
        if ( this.exclusions == null )
        {
            this.exclusions = new java.util.ArrayList();
        }
        
        return this.exclusions;
    } //-- java.util.List getExclusions() 

    /**
     * Method getGroupId
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Method getScope
     */
    public String getScope()
    {
        return this.scope;
    } //-- String getScope() 

    /**
     * Method getSystemPath
     */
    public String getSystemPath()
    {
        return this.systemPath;
    } //-- String getSystemPath() 

    /**
     * Method getType
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Method getVersion
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Method removeExclusion
     * 
     * @param exclusion
     */
    public void removeExclusion(Exclusion exclusion)
    {
        getExclusions().remove( exclusion );
    } //-- void removeExclusion(Exclusion) 

    /**
     * Method setArtifactId
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Method setClassifier
     * 
     * @param classifier
     */
    public void setClassifier(String classifier)
    {
        this.classifier = classifier;
    } //-- void setClassifier(String) 

    /**
     * Method setExclusions
     * 
     * @param exclusions
     */
    public void setExclusions(java.util.List exclusions)
    {
        this.exclusions = exclusions;
    } //-- void setExclusions(java.util.List) 

    /**
     * Method setGroupId
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Method setScope
     * 
     * @param scope
     */
    public void setScope(String scope)
    {
        this.scope = scope;
    } //-- void setScope(String) 

    /**
     * Method setSystemPath
     * 
     * @param systemPath
     */
    public void setSystemPath(String systemPath)
    {
        this.systemPath = systemPath;
    } //-- void setSystemPath(String) 

    /**
     * Method setType
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 

    /**
     * Method setVersion
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


            public String toString()
            {
                return "Dependency {groupId=" + groupId + ", artifactId=" + artifactId + ", version=" + version + ", type=" + type + "}";
            }
          
            public String getManagementKey()
            {
                return groupId + ":" + artifactId + ":" + type + (classifier != null ? ":" + classifier : "");
            }
          }
