/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.Properties;

/**
 * Class Notifier.
 * 
 * @version $Revision$ $Date$
 */
public class Notifier implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field type
     */
    private String type = "mail";

    /**
     * Field sendOnError
     */
    private boolean sendOnError = true;

    /**
     * Field sendOnFailure
     */
    private boolean sendOnFailure = true;

    /**
     * Field sendOnSuccess
     */
    private boolean sendOnSuccess = true;

    /**
     * Field sendOnWarning
     */
    private boolean sendOnWarning = true;

    /**
     * Field address
     */
    private String address;

    /**
     * Field configuration
     */
    private java.util.Properties configuration;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addConfiguration
     * 
     * @param key
     * @param value
     */
    public void addConfiguration(String key, String value)
    {
        getConfiguration().put( key, value );
    } //-- void addConfiguration(String, String) 

    /**
     * Method getAddress
     */
    public String getAddress()
    {
        return this.address;
    } //-- String getAddress() 

    /**
     * Method getConfiguration
     */
    public java.util.Properties getConfiguration()
    {
        if ( this.configuration == null )
        {
            this.configuration = new java.util.Properties();
        }
        
        return this.configuration;
    } //-- java.util.Properties getConfiguration() 

    /**
     * Method getType
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Method isSendOnError
     */
    public boolean isSendOnError()
    {
        return this.sendOnError;
    } //-- boolean isSendOnError() 

    /**
     * Method isSendOnFailure
     */
    public boolean isSendOnFailure()
    {
        return this.sendOnFailure;
    } //-- boolean isSendOnFailure() 

    /**
     * Method isSendOnSuccess
     */
    public boolean isSendOnSuccess()
    {
        return this.sendOnSuccess;
    } //-- boolean isSendOnSuccess() 

    /**
     * Method isSendOnWarning
     */
    public boolean isSendOnWarning()
    {
        return this.sendOnWarning;
    } //-- boolean isSendOnWarning() 

    /**
     * Method setAddress
     * 
     * @param address
     */
    public void setAddress(String address)
    {
        this.address = address;
    } //-- void setAddress(String) 

    /**
     * Method setConfiguration
     * 
     * @param configuration
     */
    public void setConfiguration(java.util.Properties configuration)
    {
        this.configuration = configuration;
    } //-- void setConfiguration(java.util.Properties) 

    /**
     * Method setSendOnError
     * 
     * @param sendOnError
     */
    public void setSendOnError(boolean sendOnError)
    {
        this.sendOnError = sendOnError;
    } //-- void setSendOnError(boolean) 

    /**
     * Method setSendOnFailure
     * 
     * @param sendOnFailure
     */
    public void setSendOnFailure(boolean sendOnFailure)
    {
        this.sendOnFailure = sendOnFailure;
    } //-- void setSendOnFailure(boolean) 

    /**
     * Method setSendOnSuccess
     * 
     * @param sendOnSuccess
     */
    public void setSendOnSuccess(boolean sendOnSuccess)
    {
        this.sendOnSuccess = sendOnSuccess;
    } //-- void setSendOnSuccess(boolean) 

    /**
     * Method setSendOnWarning
     * 
     * @param sendOnWarning
     */
    public void setSendOnWarning(boolean sendOnWarning)
    {
        this.sendOnWarning = sendOnWarning;
    } //-- void setSendOnWarning(boolean) 

    /**
     * Method setType
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 

}
