/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class Reporting.
 * 
 * @version $Revision$ $Date$
 */
public class Reporting implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field outputDirectory
     */
    private String outputDirectory;

    /**
     * Field plugins
     */
    private java.util.List plugins;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPlugin
     * 
     * @param reportPlugin
     */
    public void addPlugin(ReportPlugin reportPlugin)
    {
        getPlugins().add( reportPlugin );
    } //-- void addPlugin(ReportPlugin) 

    /**
     * Method getOutputDirectory
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory() 

    /**
     * Method getPlugins
     */
    public java.util.List getPlugins()
    {
        if ( this.plugins == null )
        {
            this.plugins = new java.util.ArrayList();
        }
        
        return this.plugins;
    } //-- java.util.List getPlugins() 

    /**
     * Method removePlugin
     * 
     * @param reportPlugin
     */
    public void removePlugin(ReportPlugin reportPlugin)
    {
        getPlugins().remove( reportPlugin );
    } //-- void removePlugin(ReportPlugin) 

    /**
     * Method setOutputDirectory
     * 
     * @param outputDirectory
     */
    public void setOutputDirectory(String outputDirectory)
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory(String) 

    /**
     * Method setPlugins
     * 
     * @param plugins
     */
    public void setPlugins(java.util.List plugins)
    {
        this.plugins = plugins;
    } //-- void setPlugins(java.util.List) 


    java.util.Map reportPluginMap;
    
    public void flushReportPluginMap()
    {
        this.reportPluginMap = null;
    }

    public java.util.Map getReportPluginsAsMap()
    {
        if ( reportPluginMap == null )
        {
            reportPluginMap = new java.util.HashMap();
            if ( getPlugins() != null )
            {
                for ( java.util.Iterator it = getPlugins().iterator(); it.hasNext(); )
                {
                    ReportPlugin reportPlugin = (ReportPlugin) it.next();
                    reportPluginMap.put( reportPlugin.getKey(), reportPlugin );
                }
            }
        }
        return reportPluginMap;
    }
          }
