/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io.xpp3;

import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenXpp3Reader {
    private boolean addDefaultEntities = true;

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    public boolean getBooleanValue(String s) {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    public char getCharacterValue(String s) {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    public Date getDateValue(String s) {
        if (s != null) {
            DateFormat dateParser = DateFormat.getDateTimeInstance(0, 0);
            return dateParser.parse(s, new ParsePosition(0));
        }
        return null;
    }

    public double getDoubleValue(String s) {
        if (s != null) {
            return Double.valueOf(s);
        }
        return 0.0;
    }

    public float getFloatValue(String s) {
        if (s != null) {
            return Float.valueOf(s).floatValue();
        }
        return 0.0f;
    }

    public int getIntegerValue(String s) {
        if (s != null) {
            return Integer.valueOf(s);
        }
        return 0;
    }

    public long getLongValue(String s) {
        if (s != null) {
            return Long.valueOf(s);
        }
        return 0L;
    }

    public String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s == null) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    public short getShortValue(String s) {
        if (s != null) {
            return Short.valueOf(s);
        }
        return 0;
    }

    public String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private Activation parseActivation(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Activation activation = new Activation();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("activeByDefault")) {
                activation.setActiveByDefault(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                continue;
            }
            if (parser.getName().equals("jdk")) {
                activation.setJdk(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("os")) {
                activation.setOs(this.parseActivationOS("os", parser));
                continue;
            }
            if (parser.getName().equals("property")) {
                activation.setProperty(this.parseActivationProperty("property", parser));
                continue;
            }
            if (parser.getName().equals("file")) {
                activation.setFile(this.parseActivationFile("file", parser));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return activation;
    }

    private ActivationFile parseActivationFile(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        ActivationFile activationFile = new ActivationFile();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("missing")) {
                activationFile.setMissing(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("exists")) {
                activationFile.setExists(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return activationFile;
    }

    private ActivationOS parseActivationOS(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        ActivationOS activationOS = new ActivationOS();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("name")) {
                activationOS.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("family")) {
                activationOS.setFamily(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("arch")) {
                activationOS.setArch(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                activationOS.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return activationOS;
    }

    private ActivationProperty parseActivationProperty(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        ActivationProperty activationProperty = new ActivationProperty();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("name")) {
                activationProperty.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("value")) {
                activationProperty.setValue(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return activationProperty;
    }

    private Build parseBuild(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Build build = new Build();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("sourceDirectory")) {
                build.setSourceDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("scriptSourceDirectory")) {
                build.setScriptSourceDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("testSourceDirectory")) {
                build.setTestSourceDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("outputDirectory")) {
                build.setOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("testOutputDirectory")) {
                build.setTestOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("extensions")) {
                ArrayList<Extension> extensions = new ArrayList<Extension>();
                build.setExtensions(extensions);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("extension")) {
                        extensions.add(this.parseExtension("extension", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("defaultGoal")) {
                build.setDefaultGoal(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("resources")) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                build.setResources(resources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("resource")) {
                        resources.add(this.parseResource("resource", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("testResources")) {
                ArrayList<Resource> testResources = new ArrayList<Resource>();
                build.setTestResources(testResources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("testResource")) {
                        testResources.add(this.parseResource("testResource", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("directory")) {
                build.setDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("finalName")) {
                build.setFinalName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("filters")) {
                ArrayList<String> filters = new ArrayList<String>();
                build.setFilters(filters);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("filter")) {
                        filters.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("pluginManagement")) {
                build.setPluginManagement(this.parsePluginManagement("pluginManagement", parser));
                continue;
            }
            if (parser.getName().equals("plugins")) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                build.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return build;
    }

    private BuildBase parseBuildBase(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        BuildBase buildBase = new BuildBase();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("defaultGoal")) {
                buildBase.setDefaultGoal(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("resources")) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                buildBase.setResources(resources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("resource")) {
                        resources.add(this.parseResource("resource", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("testResources")) {
                ArrayList<Resource> testResources = new ArrayList<Resource>();
                buildBase.setTestResources(testResources);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("testResource")) {
                        testResources.add(this.parseResource("testResource", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("directory")) {
                buildBase.setDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("finalName")) {
                buildBase.setFinalName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("filters")) {
                ArrayList<String> filters = new ArrayList<String>();
                buildBase.setFilters(filters);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("filter")) {
                        filters.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("pluginManagement")) {
                buildBase.setPluginManagement(this.parsePluginManagement("pluginManagement", parser));
                continue;
            }
            if (parser.getName().equals("plugins")) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                buildBase.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return buildBase;
    }

    private CiManagement parseCiManagement(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        CiManagement ciManagement = new CiManagement();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("system")) {
                ciManagement.setSystem(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                ciManagement.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("notifiers")) {
                ArrayList<Notifier> notifiers = new ArrayList<Notifier>();
                ciManagement.setNotifiers(notifiers);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("notifier")) {
                        notifiers.add(this.parseNotifier("notifier", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return ciManagement;
    }

    private ConfigurationContainer parseConfigurationContainer(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        ConfigurationContainer configurationContainer = new ConfigurationContainer();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("inherited")) {
                configurationContainer.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("configuration")) {
                configurationContainer.setConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return configurationContainer;
    }

    private Contributor parseContributor(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Contributor contributor = new Contributor();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("name")) {
                contributor.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("email")) {
                contributor.setEmail(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                contributor.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("organization")) {
                contributor.setOrganization(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("organizationUrl")) {
                contributor.setOrganizationUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("roles")) {
                ArrayList<String> roles = new ArrayList<String>();
                contributor.setRoles(roles);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("role")) {
                        roles.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("timezone")) {
                contributor.setTimezone(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("properties")) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    contributor.addProperty(key, value);
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return contributor;
    }

    private Dependency parseDependency(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Dependency dependency = new Dependency();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("groupId")) {
                dependency.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("artifactId")) {
                dependency.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                dependency.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("type")) {
                dependency.setType(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("classifier")) {
                dependency.setClassifier(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("scope")) {
                dependency.setScope(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("systemPath")) {
                dependency.setSystemPath(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("exclusions")) {
                ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
                dependency.setExclusions(exclusions);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclusion")) {
                        exclusions.add(this.parseExclusion("exclusion", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("optional")) {
                dependency.setOptional(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return dependency;
    }

    private DependencyManagement parseDependencyManagement(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        DependencyManagement dependencyManagement = new DependencyManagement();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("dependencies")) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                dependencyManagement.setDependencies(dependencies);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependency")) {
                        dependencies.add(this.parseDependency("dependency", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return dependencyManagement;
    }

    private DeploymentRepository parseDeploymentRepository(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        DeploymentRepository deploymentRepository = new DeploymentRepository();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("uniqueVersion")) {
                deploymentRepository.setUniqueVersion(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                continue;
            }
            if (parser.getName().equals("id")) {
                deploymentRepository.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("name")) {
                deploymentRepository.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                deploymentRepository.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("layout")) {
                deploymentRepository.setLayout(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return deploymentRepository;
    }

    private Developer parseDeveloper(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Developer developer = new Developer();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("id")) {
                developer.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("name")) {
                developer.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("email")) {
                developer.setEmail(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                developer.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("organization")) {
                developer.setOrganization(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("organizationUrl")) {
                developer.setOrganizationUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("roles")) {
                ArrayList<String> roles = new ArrayList<String>();
                developer.setRoles(roles);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("role")) {
                        roles.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("timezone")) {
                developer.setTimezone(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("properties")) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    developer.addProperty(key, value);
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return developer;
    }

    private DistributionManagement parseDistributionManagement(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        DistributionManagement distributionManagement = new DistributionManagement();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("repository")) {
                distributionManagement.setRepository(this.parseDeploymentRepository("repository", parser));
                continue;
            }
            if (parser.getName().equals("snapshotRepository")) {
                distributionManagement.setSnapshotRepository(this.parseDeploymentRepository("snapshotRepository", parser));
                continue;
            }
            if (parser.getName().equals("site")) {
                distributionManagement.setSite(this.parseSite("site", parser));
                continue;
            }
            if (parser.getName().equals("downloadUrl")) {
                distributionManagement.setDownloadUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("relocation")) {
                distributionManagement.setRelocation(this.parseRelocation("relocation", parser));
                continue;
            }
            if (parser.getName().equals("status")) {
                distributionManagement.setStatus(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return distributionManagement;
    }

    private Exclusion parseExclusion(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Exclusion exclusion = new Exclusion();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("artifactId")) {
                exclusion.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("groupId")) {
                exclusion.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return exclusion;
    }

    private Extension parseExtension(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Extension extension = new Extension();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("groupId")) {
                extension.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("artifactId")) {
                extension.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                extension.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return extension;
    }

    private FileSet parseFileSet(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        FileSet fileSet = new FileSet();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("directory")) {
                fileSet.setDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("includes")) {
                ArrayList<String> includes = new ArrayList<String>();
                fileSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("excludes")) {
                ArrayList<String> excludes = new ArrayList<String>();
                fileSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return fileSet;
    }

    private IssueManagement parseIssueManagement(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        IssueManagement issueManagement = new IssueManagement();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("system")) {
                issueManagement.setSystem(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                issueManagement.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return issueManagement;
    }

    private License parseLicense(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        License license = new License();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("name")) {
                license.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                license.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("distribution")) {
                license.setDistribution(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("comments")) {
                license.setComments(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return license;
    }

    private MailingList parseMailingList(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        MailingList mailingList = new MailingList();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("name")) {
                mailingList.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("subscribe")) {
                mailingList.setSubscribe(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("unsubscribe")) {
                mailingList.setUnsubscribe(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("post")) {
                mailingList.setPost(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("archive")) {
                mailingList.setArchive(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("otherArchives")) {
                ArrayList<String> otherArchives = new ArrayList<String>();
                mailingList.setOtherArchives(otherArchives);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("otherArchive")) {
                        otherArchives.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return mailingList;
    }

    private Model parseModel(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Model model = new Model();
        int eventType = parser.getEventType();
        boolean foundRoot = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals(tagName)) {
                    foundRoot = true;
                } else if (parser.getName().equals("parent")) {
                    model.setParent(this.parseParent("parent", parser));
                } else if (parser.getName().equals("modelVersion")) {
                    model.setModelVersion(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("groupId")) {
                    model.setGroupId(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("artifactId")) {
                    model.setArtifactId(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("packaging")) {
                    model.setPackaging(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("name")) {
                    model.setName(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("version")) {
                    model.setVersion(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("description")) {
                    model.setDescription(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("url")) {
                    model.setUrl(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("prerequisites")) {
                    model.setPrerequisites(this.parsePrerequisites("prerequisites", parser));
                } else if (parser.getName().equals("issueManagement")) {
                    model.setIssueManagement(this.parseIssueManagement("issueManagement", parser));
                } else if (parser.getName().equals("ciManagement")) {
                    model.setCiManagement(this.parseCiManagement("ciManagement", parser));
                } else if (parser.getName().equals("inceptionYear")) {
                    model.setInceptionYear(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("mailingLists")) {
                    ArrayList<MailingList> mailingLists = new ArrayList<MailingList>();
                    model.setMailingLists(mailingLists);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("mailingList")) {
                            mailingLists.add(this.parseMailingList("mailingList", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("developers")) {
                    ArrayList<Developer> developers = new ArrayList<Developer>();
                    model.setDevelopers(developers);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("developer")) {
                            developers.add(this.parseDeveloper("developer", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("contributors")) {
                    ArrayList<Contributor> contributors = new ArrayList<Contributor>();
                    model.setContributors(contributors);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("contributor")) {
                            contributors.add(this.parseContributor("contributor", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("licenses")) {
                    ArrayList<License> licenses = new ArrayList<License>();
                    model.setLicenses(licenses);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("license")) {
                            licenses.add(this.parseLicense("license", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("scm")) {
                    model.setScm(this.parseScm("scm", parser));
                } else if (parser.getName().equals("organization")) {
                    model.setOrganization(this.parseOrganization("organization", parser));
                } else if (parser.getName().equals("build")) {
                    model.setBuild(this.parseBuild("build", parser));
                } else if (parser.getName().equals("profiles")) {
                    ArrayList<Profile> profiles = new ArrayList<Profile>();
                    model.setProfiles(profiles);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("profile")) {
                            profiles.add(this.parseProfile("profile", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("modules")) {
                    ArrayList<String> modules = new ArrayList<String>();
                    model.setModules(modules);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("module")) {
                            modules.add(this.getTrimmedValue(parser.nextText()));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("repositories")) {
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    model.setRepositories(repositories);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("repository")) {
                            repositories.add(this.parseRepository("repository", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("pluginRepositories")) {
                    ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                    model.setPluginRepositories(pluginRepositories);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("pluginRepository")) {
                            pluginRepositories.add(this.parseRepository("pluginRepository", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("dependencies")) {
                    ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                    model.setDependencies(dependencies);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("dependency")) {
                            dependencies.add(this.parseDependency("dependency", parser));
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("reports")) {
                    model.setReports(Xpp3DomBuilder.build((XmlPullParser)parser));
                } else if (parser.getName().equals("reporting")) {
                    model.setReporting(this.parseReporting("reporting", parser));
                } else if (parser.getName().equals("dependencyManagement")) {
                    model.setDependencyManagement(this.parseDependencyManagement("dependencyManagement", parser));
                } else if (parser.getName().equals("distributionManagement")) {
                    model.setDistributionManagement(this.parseDistributionManagement("distributionManagement", parser));
                } else if (parser.getName().equals("properties")) {
                    while (parser.nextTag() == 2) {
                        String key = parser.getName();
                        String value = parser.nextText().trim();
                        model.addProperty(key, value);
                    }
                } else if (foundRoot) {
                    throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
                }
            }
            eventType = parser.next();
        }
        return model;
    }

    private ModelBase parseModelBase(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        ModelBase modelBase = new ModelBase();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("modules")) {
                ArrayList<String> modules = new ArrayList<String>();
                modelBase.setModules(modules);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("module")) {
                        modules.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("repositories")) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                modelBase.setRepositories(repositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("repository")) {
                        repositories.add(this.parseRepository("repository", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("pluginRepositories")) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                modelBase.setPluginRepositories(pluginRepositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("pluginRepository")) {
                        pluginRepositories.add(this.parseRepository("pluginRepository", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("dependencies")) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                modelBase.setDependencies(dependencies);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependency")) {
                        dependencies.add(this.parseDependency("dependency", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("reports")) {
                modelBase.setReports(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (parser.getName().equals("reporting")) {
                modelBase.setReporting(this.parseReporting("reporting", parser));
                continue;
            }
            if (parser.getName().equals("dependencyManagement")) {
                modelBase.setDependencyManagement(this.parseDependencyManagement("dependencyManagement", parser));
                continue;
            }
            if (parser.getName().equals("distributionManagement")) {
                modelBase.setDistributionManagement(this.parseDistributionManagement("distributionManagement", parser));
                continue;
            }
            if (parser.getName().equals("properties")) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    modelBase.addProperty(key, value);
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return modelBase;
    }

    private Notifier parseNotifier(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Notifier notifier = new Notifier();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("type")) {
                notifier.setType(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("sendOnError")) {
                notifier.setSendOnError(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                continue;
            }
            if (parser.getName().equals("sendOnFailure")) {
                notifier.setSendOnFailure(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                continue;
            }
            if (parser.getName().equals("sendOnSuccess")) {
                notifier.setSendOnSuccess(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                continue;
            }
            if (parser.getName().equals("sendOnWarning")) {
                notifier.setSendOnWarning(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                continue;
            }
            if (parser.getName().equals("address")) {
                notifier.setAddress(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("configuration")) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    notifier.addConfiguration(key, value);
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return notifier;
    }

    private Organization parseOrganization(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Organization organization = new Organization();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("name")) {
                organization.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                organization.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return organization;
    }

    private Parent parseParent(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Parent parent = new Parent();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("artifactId")) {
                parent.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("groupId")) {
                parent.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                parent.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("relativePath")) {
                parent.setRelativePath(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return parent;
    }

    private PatternSet parsePatternSet(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        PatternSet patternSet = new PatternSet();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("includes")) {
                ArrayList<String> includes = new ArrayList<String>();
                patternSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("excludes")) {
                ArrayList<String> excludes = new ArrayList<String>();
                patternSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return patternSet;
    }

    private Plugin parsePlugin(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Plugin plugin = new Plugin();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("groupId")) {
                plugin.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("artifactId")) {
                plugin.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                plugin.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("extensions")) {
                plugin.setExtensions(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                continue;
            }
            if (parser.getName().equals("executions")) {
                ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
                plugin.setExecutions(executions);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("execution")) {
                        executions.add(this.parsePluginExecution("execution", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("dependencies")) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                plugin.setDependencies(dependencies);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependency")) {
                        dependencies.add(this.parseDependency("dependency", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("goals")) {
                plugin.setGoals(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (parser.getName().equals("inherited")) {
                plugin.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("configuration")) {
                plugin.setConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return plugin;
    }

    private PluginConfiguration parsePluginConfiguration(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("pluginManagement")) {
                pluginConfiguration.setPluginManagement(this.parsePluginManagement("pluginManagement", parser));
                continue;
            }
            if (parser.getName().equals("plugins")) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginConfiguration.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return pluginConfiguration;
    }

    private PluginContainer parsePluginContainer(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        PluginContainer pluginContainer = new PluginContainer();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("plugins")) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginContainer.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return pluginContainer;
    }

    private PluginExecution parsePluginExecution(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        PluginExecution pluginExecution = new PluginExecution();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("id")) {
                pluginExecution.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("phase")) {
                pluginExecution.setPhase(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("goals")) {
                ArrayList<String> goals = new ArrayList<String>();
                pluginExecution.setGoals(goals);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("goal")) {
                        goals.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("inherited")) {
                pluginExecution.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("configuration")) {
                pluginExecution.setConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return pluginExecution;
    }

    private PluginManagement parsePluginManagement(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        PluginManagement pluginManagement = new PluginManagement();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("plugins")) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginManagement.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parsePlugin("plugin", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return pluginManagement;
    }

    private Prerequisites parsePrerequisites(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Prerequisites prerequisites = new Prerequisites();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("maven")) {
                prerequisites.setMaven(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return prerequisites;
    }

    private Profile parseProfile(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Profile profile = new Profile();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("id")) {
                profile.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("activation")) {
                profile.setActivation(this.parseActivation("activation", parser));
                continue;
            }
            if (parser.getName().equals("build")) {
                profile.setBuild(this.parseBuildBase("build", parser));
                continue;
            }
            if (parser.getName().equals("modules")) {
                ArrayList<String> modules = new ArrayList<String>();
                profile.setModules(modules);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("module")) {
                        modules.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("repositories")) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                profile.setRepositories(repositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("repository")) {
                        repositories.add(this.parseRepository("repository", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("pluginRepositories")) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                profile.setPluginRepositories(pluginRepositories);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("pluginRepository")) {
                        pluginRepositories.add(this.parseRepository("pluginRepository", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("dependencies")) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                profile.setDependencies(dependencies);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("dependency")) {
                        dependencies.add(this.parseDependency("dependency", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("reports")) {
                profile.setReports(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (parser.getName().equals("reporting")) {
                profile.setReporting(this.parseReporting("reporting", parser));
                continue;
            }
            if (parser.getName().equals("dependencyManagement")) {
                profile.setDependencyManagement(this.parseDependencyManagement("dependencyManagement", parser));
                continue;
            }
            if (parser.getName().equals("distributionManagement")) {
                profile.setDistributionManagement(this.parseDistributionManagement("distributionManagement", parser));
                continue;
            }
            if (parser.getName().equals("properties")) {
                while (parser.nextTag() == 2) {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    profile.addProperty(key, value);
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return profile;
    }

    private Relocation parseRelocation(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Relocation relocation = new Relocation();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("groupId")) {
                relocation.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("artifactId")) {
                relocation.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                relocation.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("message")) {
                relocation.setMessage(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return relocation;
    }

    private ReportPlugin parseReportPlugin(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        ReportPlugin reportPlugin = new ReportPlugin();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("groupId")) {
                reportPlugin.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("artifactId")) {
                reportPlugin.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                reportPlugin.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("inherited")) {
                reportPlugin.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("configuration")) {
                reportPlugin.setConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (parser.getName().equals("reportSets")) {
                ArrayList<ReportSet> reportSets = new ArrayList<ReportSet>();
                reportPlugin.setReportSets(reportSets);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("reportSet")) {
                        reportSets.add(this.parseReportSet("reportSet", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return reportPlugin;
    }

    private ReportSet parseReportSet(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        ReportSet reportSet = new ReportSet();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("id")) {
                reportSet.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("configuration")) {
                reportSet.setConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (parser.getName().equals("inherited")) {
                reportSet.setInherited(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("reports")) {
                ArrayList<String> reports = new ArrayList<String>();
                reportSet.setReports(reports);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("report")) {
                        reports.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return reportSet;
    }

    private Reporting parseReporting(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Reporting reporting = new Reporting();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("excludeDefaults")) {
                reporting.setExcludeDefaults(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                continue;
            }
            if (parser.getName().equals("outputDirectory")) {
                reporting.setOutputDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("plugins")) {
                ArrayList<ReportPlugin> plugins = new ArrayList<ReportPlugin>();
                reporting.setPlugins(plugins);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("plugin")) {
                        plugins.add(this.parseReportPlugin("plugin", parser));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return reporting;
    }

    private Repository parseRepository(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Repository repository = new Repository();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("releases")) {
                repository.setReleases(this.parseRepositoryPolicy("releases", parser));
                continue;
            }
            if (parser.getName().equals("snapshots")) {
                repository.setSnapshots(this.parseRepositoryPolicy("snapshots", parser));
                continue;
            }
            if (parser.getName().equals("id")) {
                repository.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("name")) {
                repository.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                repository.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("layout")) {
                repository.setLayout(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return repository;
    }

    private RepositoryBase parseRepositoryBase(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        RepositoryBase repositoryBase = new RepositoryBase();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("id")) {
                repositoryBase.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("name")) {
                repositoryBase.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                repositoryBase.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("layout")) {
                repositoryBase.setLayout(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return repositoryBase;
    }

    private RepositoryPolicy parseRepositoryPolicy(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        RepositoryPolicy repositoryPolicy = new RepositoryPolicy();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("enabled")) {
                repositoryPolicy.setEnabled(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                continue;
            }
            if (parser.getName().equals("updatePolicy")) {
                repositoryPolicy.setUpdatePolicy(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("checksumPolicy")) {
                repositoryPolicy.setChecksumPolicy(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return repositoryPolicy;
    }

    private Resource parseResource(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Resource resource = new Resource();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("targetPath")) {
                resource.setTargetPath(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("filtering")) {
                resource.setFiltering(this.getBooleanValue(this.getTrimmedValue(parser.nextText())));
                continue;
            }
            if (parser.getName().equals("directory")) {
                resource.setDirectory(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("includes")) {
                ArrayList<String> includes = new ArrayList<String>();
                resource.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        includes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("excludes")) {
                ArrayList<String> excludes = new ArrayList<String>();
                resource.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(parser.nextText()));
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return resource;
    }

    private Scm parseScm(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Scm scm = new Scm();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("connection")) {
                scm.setConnection(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("developerConnection")) {
                scm.setDeveloperConnection(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("tag")) {
                scm.setTag(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                scm.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return scm;
    }

    private Site parseSite(String tagName, XmlPullParser parser) throws IOException, XmlPullParserException {
        Site site = new Site();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals(tagName)) continue;
            if (parser.getName().equals("id")) {
                site.setId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("name")) {
                site.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("url")) {
                site.setUrl(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        return site;
    }

    public Model read(Reader reader) throws IOException, XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setInput(reader);
        if (this.addDefaultEntities) {
            parser.defineEntityReplacementText("nbsp", "\u00a0");
            parser.defineEntityReplacementText("iexcl", "\u00a1");
            parser.defineEntityReplacementText("cent", "\u00a2");
            parser.defineEntityReplacementText("pound", "\u00a3");
            parser.defineEntityReplacementText("curren", "\u00a4");
            parser.defineEntityReplacementText("yen", "\u00a5");
            parser.defineEntityReplacementText("brvbar", "\u00a6");
            parser.defineEntityReplacementText("sect", "\u00a7");
            parser.defineEntityReplacementText("uml", "\u00a8");
            parser.defineEntityReplacementText("copy", "\u00a9");
            parser.defineEntityReplacementText("ordf", "\u00aa");
            parser.defineEntityReplacementText("laquo", "\u00ab");
            parser.defineEntityReplacementText("not", "\u00ac");
            parser.defineEntityReplacementText("shy", "\u00ad");
            parser.defineEntityReplacementText("reg", "\u00ae");
            parser.defineEntityReplacementText("macr", "\u00af");
            parser.defineEntityReplacementText("deg", "\u00b0");
            parser.defineEntityReplacementText("plusmn", "\u00b1");
            parser.defineEntityReplacementText("sup2", "\u00b2");
            parser.defineEntityReplacementText("sup3", "\u00b3");
            parser.defineEntityReplacementText("acute", "\u00b4");
            parser.defineEntityReplacementText("micro", "\u00b5");
            parser.defineEntityReplacementText("para", "\u00b6");
            parser.defineEntityReplacementText("middot", "\u00b7");
            parser.defineEntityReplacementText("cedil", "\u00b8");
            parser.defineEntityReplacementText("sup1", "\u00b9");
            parser.defineEntityReplacementText("ordm", "\u00ba");
            parser.defineEntityReplacementText("raquo", "\u00bb");
            parser.defineEntityReplacementText("frac14", "\u00bc");
            parser.defineEntityReplacementText("frac12", "\u00bd");
            parser.defineEntityReplacementText("frac34", "\u00be");
            parser.defineEntityReplacementText("iquest", "\u00bf");
            parser.defineEntityReplacementText("Agrave", "\u00c0");
            parser.defineEntityReplacementText("Aacute", "\u00c1");
            parser.defineEntityReplacementText("Acirc", "\u00c2");
            parser.defineEntityReplacementText("Atilde", "\u00c3");
            parser.defineEntityReplacementText("Auml", "\u00c4");
            parser.defineEntityReplacementText("Aring", "\u00c5");
            parser.defineEntityReplacementText("AElig", "\u00c6");
            parser.defineEntityReplacementText("Ccedil", "\u00c7");
            parser.defineEntityReplacementText("Egrave", "\u00c8");
            parser.defineEntityReplacementText("Eacute", "\u00c9");
            parser.defineEntityReplacementText("Ecirc", "\u00ca");
            parser.defineEntityReplacementText("Euml", "\u00cb");
            parser.defineEntityReplacementText("Igrave", "\u00cc");
            parser.defineEntityReplacementText("Iacute", "\u00cd");
            parser.defineEntityReplacementText("Icirc", "\u00ce");
            parser.defineEntityReplacementText("Iuml", "\u00cf");
            parser.defineEntityReplacementText("ETH", "\u00d0");
            parser.defineEntityReplacementText("Ntilde", "\u00d1");
            parser.defineEntityReplacementText("Ograve", "\u00d2");
            parser.defineEntityReplacementText("Oacute", "\u00d3");
            parser.defineEntityReplacementText("Ocirc", "\u00d4");
            parser.defineEntityReplacementText("Otilde", "\u00d5");
            parser.defineEntityReplacementText("Ouml", "\u00d6");
            parser.defineEntityReplacementText("times", "\u00d7");
            parser.defineEntityReplacementText("Oslash", "\u00d8");
            parser.defineEntityReplacementText("Ugrave", "\u00d9");
            parser.defineEntityReplacementText("Uacute", "\u00da");
            parser.defineEntityReplacementText("Ucirc", "\u00db");
            parser.defineEntityReplacementText("Uuml", "\u00dc");
            parser.defineEntityReplacementText("Yacute", "\u00dd");
            parser.defineEntityReplacementText("THORN", "\u00de");
            parser.defineEntityReplacementText("szlig", "\u00df");
            parser.defineEntityReplacementText("agrave", "\u00e0");
            parser.defineEntityReplacementText("aacute", "\u00e1");
            parser.defineEntityReplacementText("acirc", "\u00e2");
            parser.defineEntityReplacementText("atilde", "\u00e3");
            parser.defineEntityReplacementText("auml", "\u00e4");
            parser.defineEntityReplacementText("aring", "\u00e5");
            parser.defineEntityReplacementText("aelig", "\u00e6");
            parser.defineEntityReplacementText("ccedil", "\u00e7");
            parser.defineEntityReplacementText("egrave", "\u00e8");
            parser.defineEntityReplacementText("eacute", "\u00e9");
            parser.defineEntityReplacementText("ecirc", "\u00ea");
            parser.defineEntityReplacementText("euml", "\u00eb");
            parser.defineEntityReplacementText("igrave", "\u00ec");
            parser.defineEntityReplacementText("iacute", "\u00ed");
            parser.defineEntityReplacementText("icirc", "\u00ee");
            parser.defineEntityReplacementText("iuml", "\u00ef");
            parser.defineEntityReplacementText("eth", "\u00f0");
            parser.defineEntityReplacementText("ntilde", "\u00f1");
            parser.defineEntityReplacementText("ograve", "\u00f2");
            parser.defineEntityReplacementText("oacute", "\u00f3");
            parser.defineEntityReplacementText("ocirc", "\u00f4");
            parser.defineEntityReplacementText("otilde", "\u00f5");
            parser.defineEntityReplacementText("ouml", "\u00f6");
            parser.defineEntityReplacementText("divide", "\u00f7");
            parser.defineEntityReplacementText("oslash", "\u00f8");
            parser.defineEntityReplacementText("ugrave", "\u00f9");
            parser.defineEntityReplacementText("uacute", "\u00fa");
            parser.defineEntityReplacementText("ucirc", "\u00fb");
            parser.defineEntityReplacementText("uuml", "\u00fc");
            parser.defineEntityReplacementText("yacute", "\u00fd");
            parser.defineEntityReplacementText("thorn", "\u00fe");
            parser.defineEntityReplacementText("yuml", "\u00ff");
            parser.defineEntityReplacementText("OElig", "\u0152");
            parser.defineEntityReplacementText("oelig", "\u0153");
            parser.defineEntityReplacementText("Scaron", "\u0160");
            parser.defineEntityReplacementText("scaron", "\u0161");
            parser.defineEntityReplacementText("Yuml", "\u0178");
            parser.defineEntityReplacementText("circ", "\u02c6");
            parser.defineEntityReplacementText("tilde", "\u02dc");
            parser.defineEntityReplacementText("ensp", "\u2002");
            parser.defineEntityReplacementText("emsp", "\u2003");
            parser.defineEntityReplacementText("thinsp", "\u2009");
            parser.defineEntityReplacementText("zwnj", "\u200c");
            parser.defineEntityReplacementText("zwj", "\u200d");
            parser.defineEntityReplacementText("lrm", "\u200e");
            parser.defineEntityReplacementText("rlm", "\u200f");
            parser.defineEntityReplacementText("ndash", "\u2013");
            parser.defineEntityReplacementText("mdash", "\u2014");
            parser.defineEntityReplacementText("lsquo", "\u2018");
            parser.defineEntityReplacementText("rsquo", "\u2019");
            parser.defineEntityReplacementText("sbquo", "\u201a");
            parser.defineEntityReplacementText("ldquo", "\u201c");
            parser.defineEntityReplacementText("rdquo", "\u201d");
            parser.defineEntityReplacementText("bdquo", "\u201e");
            parser.defineEntityReplacementText("dagger", "\u2020");
            parser.defineEntityReplacementText("Dagger", "\u2021");
            parser.defineEntityReplacementText("permil", "\u2030");
            parser.defineEntityReplacementText("lsaquo", "\u2039");
            parser.defineEntityReplacementText("rsaquo", "\u203a");
            parser.defineEntityReplacementText("euro", "\u20ac");
            parser.defineEntityReplacementText("fnof", "\u0192");
            parser.defineEntityReplacementText("Alpha", "\u0391");
            parser.defineEntityReplacementText("Beta", "\u0392");
            parser.defineEntityReplacementText("Gamma", "\u0393");
            parser.defineEntityReplacementText("Delta", "\u0394");
            parser.defineEntityReplacementText("Epsilon", "\u0395");
            parser.defineEntityReplacementText("Zeta", "\u0396");
            parser.defineEntityReplacementText("Eta", "\u0397");
            parser.defineEntityReplacementText("Theta", "\u0398");
            parser.defineEntityReplacementText("Iota", "\u0399");
            parser.defineEntityReplacementText("Kappa", "\u039a");
            parser.defineEntityReplacementText("Lambda", "\u039b");
            parser.defineEntityReplacementText("Mu", "\u039c");
            parser.defineEntityReplacementText("Nu", "\u039d");
            parser.defineEntityReplacementText("Xi", "\u039e");
            parser.defineEntityReplacementText("Omicron", "\u039f");
            parser.defineEntityReplacementText("Pi", "\u03a0");
            parser.defineEntityReplacementText("Rho", "\u03a1");
            parser.defineEntityReplacementText("Sigma", "\u03a3");
            parser.defineEntityReplacementText("Tau", "\u03a4");
            parser.defineEntityReplacementText("Upsilon", "\u03a5");
            parser.defineEntityReplacementText("Phi", "\u03a6");
            parser.defineEntityReplacementText("Chi", "\u03a7");
            parser.defineEntityReplacementText("Psi", "\u03a8");
            parser.defineEntityReplacementText("Omega", "\u03a9");
            parser.defineEntityReplacementText("alpha", "\u03b1");
            parser.defineEntityReplacementText("beta", "\u03b2");
            parser.defineEntityReplacementText("gamma", "\u03b3");
            parser.defineEntityReplacementText("delta", "\u03b4");
            parser.defineEntityReplacementText("epsilon", "\u03b5");
            parser.defineEntityReplacementText("zeta", "\u03b6");
            parser.defineEntityReplacementText("eta", "\u03b7");
            parser.defineEntityReplacementText("theta", "\u03b8");
            parser.defineEntityReplacementText("iota", "\u03b9");
            parser.defineEntityReplacementText("kappa", "\u03ba");
            parser.defineEntityReplacementText("lambda", "\u03bb");
            parser.defineEntityReplacementText("mu", "\u03bc");
            parser.defineEntityReplacementText("nu", "\u03bd");
            parser.defineEntityReplacementText("xi", "\u03be");
            parser.defineEntityReplacementText("omicron", "\u03bf");
            parser.defineEntityReplacementText("pi", "\u03c0");
            parser.defineEntityReplacementText("rho", "\u03c1");
            parser.defineEntityReplacementText("sigmaf", "\u03c2");
            parser.defineEntityReplacementText("sigma", "\u03c3");
            parser.defineEntityReplacementText("tau", "\u03c4");
            parser.defineEntityReplacementText("upsilon", "\u03c5");
            parser.defineEntityReplacementText("phi", "\u03c6");
            parser.defineEntityReplacementText("chi", "\u03c7");
            parser.defineEntityReplacementText("psi", "\u03c8");
            parser.defineEntityReplacementText("omega", "\u03c9");
            parser.defineEntityReplacementText("thetasym", "\u03d1");
            parser.defineEntityReplacementText("upsih", "\u03d2");
            parser.defineEntityReplacementText("piv", "\u03d6");
            parser.defineEntityReplacementText("bull", "\u2022");
            parser.defineEntityReplacementText("hellip", "\u2026");
            parser.defineEntityReplacementText("prime", "\u2032");
            parser.defineEntityReplacementText("Prime", "\u2033");
            parser.defineEntityReplacementText("oline", "\u203e");
            parser.defineEntityReplacementText("frasl", "\u2044");
            parser.defineEntityReplacementText("weierp", "\u2118");
            parser.defineEntityReplacementText("image", "\u2111");
            parser.defineEntityReplacementText("real", "\u211c");
            parser.defineEntityReplacementText("trade", "\u2122");
            parser.defineEntityReplacementText("alefsym", "\u2135");
            parser.defineEntityReplacementText("larr", "\u2190");
            parser.defineEntityReplacementText("uarr", "\u2191");
            parser.defineEntityReplacementText("rarr", "\u2192");
            parser.defineEntityReplacementText("darr", "\u2193");
            parser.defineEntityReplacementText("harr", "\u2194");
            parser.defineEntityReplacementText("crarr", "\u21b5");
            parser.defineEntityReplacementText("lArr", "\u21d0");
            parser.defineEntityReplacementText("uArr", "\u21d1");
            parser.defineEntityReplacementText("rArr", "\u21d2");
            parser.defineEntityReplacementText("dArr", "\u21d3");
            parser.defineEntityReplacementText("hArr", "\u21d4");
            parser.defineEntityReplacementText("forall", "\u2200");
            parser.defineEntityReplacementText("part", "\u2202");
            parser.defineEntityReplacementText("exist", "\u2203");
            parser.defineEntityReplacementText("empty", "\u2205");
            parser.defineEntityReplacementText("nabla", "\u2207");
            parser.defineEntityReplacementText("isin", "\u2208");
            parser.defineEntityReplacementText("notin", "\u2209");
            parser.defineEntityReplacementText("ni", "\u220b");
            parser.defineEntityReplacementText("prod", "\u220f");
            parser.defineEntityReplacementText("sum", "\u2211");
            parser.defineEntityReplacementText("minus", "\u2212");
            parser.defineEntityReplacementText("lowast", "\u2217");
            parser.defineEntityReplacementText("radic", "\u221a");
            parser.defineEntityReplacementText("prop", "\u221d");
            parser.defineEntityReplacementText("infin", "\u221e");
            parser.defineEntityReplacementText("ang", "\u2220");
            parser.defineEntityReplacementText("and", "\u2227");
            parser.defineEntityReplacementText("or", "\u2228");
            parser.defineEntityReplacementText("cap", "\u2229");
            parser.defineEntityReplacementText("cup", "\u222a");
            parser.defineEntityReplacementText("int", "\u222b");
            parser.defineEntityReplacementText("there4", "\u2234");
            parser.defineEntityReplacementText("sim", "\u223c");
            parser.defineEntityReplacementText("cong", "\u2245");
            parser.defineEntityReplacementText("asymp", "\u2248");
            parser.defineEntityReplacementText("ne", "\u2260");
            parser.defineEntityReplacementText("equiv", "\u2261");
            parser.defineEntityReplacementText("le", "\u2264");
            parser.defineEntityReplacementText("ge", "\u2265");
            parser.defineEntityReplacementText("sub", "\u2282");
            parser.defineEntityReplacementText("sup", "\u2283");
            parser.defineEntityReplacementText("nsub", "\u2284");
            parser.defineEntityReplacementText("sube", "\u2286");
            parser.defineEntityReplacementText("supe", "\u2287");
            parser.defineEntityReplacementText("oplus", "\u2295");
            parser.defineEntityReplacementText("otimes", "\u2297");
            parser.defineEntityReplacementText("perp", "\u22a5");
            parser.defineEntityReplacementText("sdot", "\u22c5");
            parser.defineEntityReplacementText("lceil", "\u2308");
            parser.defineEntityReplacementText("rceil", "\u2309");
            parser.defineEntityReplacementText("lfloor", "\u230a");
            parser.defineEntityReplacementText("rfloor", "\u230b");
            parser.defineEntityReplacementText("lang", "\u2329");
            parser.defineEntityReplacementText("rang", "\u232a");
            parser.defineEntityReplacementText("loz", "\u25ca");
            parser.defineEntityReplacementText("spades", "\u2660");
            parser.defineEntityReplacementText("clubs", "\u2663");
            parser.defineEntityReplacementText("hearts", "\u2665");
            parser.defineEntityReplacementText("diams", "\u2666");
        }
        return this.parseModel("project", (XmlPullParser)parser);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

