/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         
 *         The <code>&lt;project&gt;</code> element is the root of
 * the descriptor.
 *         The following table lists all of the possible child
 * elements.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Model extends ModelBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field parent
     */
    private Parent parent;

    /**
     * Field modelVersion
     */
    private String modelVersion;

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field packaging
     */
    private String packaging = "jar";

    /**
     * Field name
     */
    private String name;

    /**
     * Field version
     */
    private String version;

    /**
     * Field description
     */
    private String description;

    /**
     * Field url
     */
    private String url;

    /**
     * Field prerequisites
     */
    private Prerequisites prerequisites;

    /**
     * Field issueManagement
     */
    private IssueManagement issueManagement;

    /**
     * Field ciManagement
     */
    private CiManagement ciManagement;

    /**
     * Field inceptionYear
     */
    private String inceptionYear;

    /**
     * Field mailingLists
     */
    private java.util.List mailingLists;

    /**
     * Field developers
     */
    private java.util.List developers;

    /**
     * Field contributors
     */
    private java.util.List contributors;

    /**
     * Field licenses
     */
    private java.util.List licenses;

    /**
     * Field scm
     */
    private Scm scm;

    /**
     * Field organization
     */
    private Organization organization;

    /**
     * Field build
     */
    private Build build;

    /**
     * Field profiles
     */
    private java.util.List profiles;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addContributor
     * 
     * @param contributor
     */
    public void addContributor(Contributor contributor)
    {
        getContributors().add( contributor );
    } //-- void addContributor(Contributor) 

    /**
     * Method addDeveloper
     * 
     * @param developer
     */
    public void addDeveloper(Developer developer)
    {
        getDevelopers().add( developer );
    } //-- void addDeveloper(Developer) 

    /**
     * Method addLicense
     * 
     * @param license
     */
    public void addLicense(License license)
    {
        getLicenses().add( license );
    } //-- void addLicense(License) 

    /**
     * Method addMailingList
     * 
     * @param mailingList
     */
    public void addMailingList(MailingList mailingList)
    {
        getMailingLists().add( mailingList );
    } //-- void addMailingList(MailingList) 

    /**
     * Method addProfile
     * 
     * @param profile
     */
    public void addProfile(Profile profile)
    {
        getProfiles().add( profile );
    } //-- void addProfile(Profile) 

    /**
     * Get 
     *             
     *             The identifier for this artifact that is unique
     * within the group
     *             given by the group ID.
     *             An artifact is something that is either produced
     * or used by a project.
     *             Examples of artifacts produced by Maven for a
     * project include: JARs,
     *             source and binary distributions, and WARs.
     *             
     *           
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get 
     *             
     *             Information required to build the project.
     *             
     *           
     */
    public Build getBuild()
    {
        return this.build;
    } //-- Build getBuild() 

    /**
     * Get 
     *             
     *             The project's continuous integration
     * information.
     *             
     *           
     */
    public CiManagement getCiManagement()
    {
        return this.ciManagement;
    } //-- CiManagement getCiManagement() 

    /**
     * Method getContributors
     */
    public java.util.List getContributors()
    {
        if ( this.contributors == null )
        {
            this.contributors = new java.util.ArrayList();
        }
        
        return this.contributors;
    } //-- java.util.List getContributors() 

    /**
     * Get 
     *             
     *             A detailed description of the project, used by
     * Maven whenever it needs
     *             to describe the project, such as on the web
     * site. While this element
     *             can be specified as CDATA to enable the use of
     * HTML tags within the
     *             description, it is discouraged to allow plain
     * text representation.
     *             If you need to modify the index page of the
     * generated web site, you are
     *             able to specify your own instead of adjusting
     * this text.
     *             
     *           
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Method getDevelopers
     */
    public java.util.List getDevelopers()
    {
        if ( this.developers == null )
        {
            this.developers = new java.util.ArrayList();
        }
        
        return this.developers;
    } //-- java.util.List getDevelopers() 

    /**
     * Get 
     *             
     *             A universally unique identifier for a project.
     * It is normal to
     *             use a fully-qualified package name to
     * distinguish it from other
     *             projects with a similar name (eg.
     * <code>org.apache.maven</code>).
     *             
     *           
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get 
     *             
     *             The year of the project's inception, specified
     * with 4 digits.
     *             This value is used when generating copyright
     * notices as well as being informational.
     *             
     *           
     */
    public String getInceptionYear()
    {
        return this.inceptionYear;
    } //-- String getInceptionYear() 

    /**
     * Get 
     *             
     *             The project's issue management system
     * information.
     *             
     *           
     */
    public IssueManagement getIssueManagement()
    {
        return this.issueManagement;
    } //-- IssueManagement getIssueManagement() 

    /**
     * Method getLicenses
     */
    public java.util.List getLicenses()
    {
        if ( this.licenses == null )
        {
            this.licenses = new java.util.ArrayList();
        }
        
        return this.licenses;
    } //-- java.util.List getLicenses() 

    /**
     * Method getMailingLists
     */
    public java.util.List getMailingLists()
    {
        if ( this.mailingLists == null )
        {
            this.mailingLists = new java.util.ArrayList();
        }
        
        return this.mailingLists;
    } //-- java.util.List getMailingLists() 

    /**
     * Get 
     *             
     *             Declares to which version of project descriptor
     * this POM conforms.
     *             
     *           
     */
    public String getModelVersion()
    {
        return this.modelVersion;
    } //-- String getModelVersion() 

    /**
     * Get 
     *             
     *             The full name of the project.
     *             
     *           
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get 
     *             
     *             This element describes various attributes of the
     * organization to
     *             which the project belongs.  These attributes are
     * utilized when
     *             documentation is created (for copyright notices
     * and links).
     *             
     *           
     */
    public Organization getOrganization()
    {
        return this.organization;
    } //-- Organization getOrganization() 

    /**
     * Get 
     *             
     *             The type of artifact this project produces, for
     * example <code>jar</code>
     *               <code>war</code>
     *               <code>ear</code>
     *               <code>pom</code>.
     *             Plugins can create their own packaging, and
     *             therefore their own packaging types,
     *             so this list does not contain all possible
     * types.
     *             
     *           
     */
    public String getPackaging()
    {
        return this.packaging;
    } //-- String getPackaging() 

    /**
     * Get 
     *             
     *             The location of the parent project, if one
     * exists. Values from the
     *             parent project will be the default for this
     * project if they are
     *             left unspecified. The location is given as a
     * group ID, artifact ID
     *             and version.
     *             
     *           
     */
    public Parent getParent()
    {
        return this.parent;
    } //-- Parent getParent() 

    /**
     * Get 
     *             Describes the prerequisites in the build
     * environment for
     *             this project.
     *           
     */
    public Prerequisites getPrerequisites()
    {
        return this.prerequisites;
    } //-- Prerequisites getPrerequisites() 

    /**
     * Method getProfiles
     */
    public java.util.List getProfiles()
    {
        if ( this.profiles == null )
        {
            this.profiles = new java.util.ArrayList();
        }
        
        return this.profiles;
    } //-- java.util.List getProfiles() 

    /**
     * Get 
     *             
     *             Specification for the SCM used by the project,
     * such as CVS, Subversion, etc.
     *             
     *           
     */
    public Scm getScm()
    {
        return this.scm;
    } //-- Scm getScm() 

    /**
     * Get 
     *             
     *             The URL to the project's homepage.
     *             
     *           
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Get 
     *             
     *             The current version of the artifact produced by
     * this project.
     *             
     *           
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Method removeContributor
     * 
     * @param contributor
     */
    public void removeContributor(Contributor contributor)
    {
        getContributors().remove( contributor );
    } //-- void removeContributor(Contributor) 

    /**
     * Method removeDeveloper
     * 
     * @param developer
     */
    public void removeDeveloper(Developer developer)
    {
        getDevelopers().remove( developer );
    } //-- void removeDeveloper(Developer) 

    /**
     * Method removeLicense
     * 
     * @param license
     */
    public void removeLicense(License license)
    {
        getLicenses().remove( license );
    } //-- void removeLicense(License) 

    /**
     * Method removeMailingList
     * 
     * @param mailingList
     */
    public void removeMailingList(MailingList mailingList)
    {
        getMailingLists().remove( mailingList );
    } //-- void removeMailingList(MailingList) 

    /**
     * Method removeProfile
     * 
     * @param profile
     */
    public void removeProfile(Profile profile)
    {
        getProfiles().remove( profile );
    } //-- void removeProfile(Profile) 

    /**
     * Set 
     *             
     *             The identifier for this artifact that is unique
     * within the group
     *             given by the group ID.
     *             An artifact is something that is either produced
     * or used by a project.
     *             Examples of artifacts produced by Maven for a
     * project include: JARs,
     *             source and binary distributions, and WARs.
     *             
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set 
     *             
     *             Information required to build the project.
     *             
     *           
     * 
     * @param build
     */
    public void setBuild(Build build)
    {
        this.build = build;
    } //-- void setBuild(Build) 

    /**
     * Set 
     *             
     *             The project's continuous integration
     * information.
     *             
     *           
     * 
     * @param ciManagement
     */
    public void setCiManagement(CiManagement ciManagement)
    {
        this.ciManagement = ciManagement;
    } //-- void setCiManagement(CiManagement) 

    /**
     * Set 
     *             
     *             Describes the contributors to a project that are
     * not yet committers.
     *             
     *           
     * 
     * @param contributors
     */
    public void setContributors(java.util.List contributors)
    {
        this.contributors = contributors;
    } //-- void setContributors(java.util.List) 

    /**
     * Set 
     *             
     *             A detailed description of the project, used by
     * Maven whenever it needs
     *             to describe the project, such as on the web
     * site. While this element
     *             can be specified as CDATA to enable the use of
     * HTML tags within the
     *             description, it is discouraged to allow plain
     * text representation.
     *             If you need to modify the index page of the
     * generated web site, you are
     *             able to specify your own instead of adjusting
     * this text.
     *             
     *           
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set 
     *             
     *             Describes the committers of a project.
     *             
     *           
     * 
     * @param developers
     */
    public void setDevelopers(java.util.List developers)
    {
        this.developers = developers;
    } //-- void setDevelopers(java.util.List) 

    /**
     * Set 
     *             
     *             A universally unique identifier for a project.
     * It is normal to
     *             use a fully-qualified package name to
     * distinguish it from other
     *             projects with a similar name (eg.
     * <code>org.apache.maven</code>).
     *             
     *           
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set 
     *             
     *             The year of the project's inception, specified
     * with 4 digits.
     *             This value is used when generating copyright
     * notices as well as being informational.
     *             
     *           
     * 
     * @param inceptionYear
     */
    public void setInceptionYear(String inceptionYear)
    {
        this.inceptionYear = inceptionYear;
    } //-- void setInceptionYear(String) 

    /**
     * Set 
     *             
     *             The project's issue management system
     * information.
     *             
     *           
     * 
     * @param issueManagement
     */
    public void setIssueManagement(IssueManagement issueManagement)
    {
        this.issueManagement = issueManagement;
    } //-- void setIssueManagement(IssueManagement) 

    /**
     * Set 
     *             
     *             This element describes all of the licenses for
     * this project.
     *             Each license is described by a
     * <code>license</code> element, which
     *             is then described by additional elements.
     *             Projects should only list the license(s) that
     * applies to the project
     *             and not the licenses that apply to dependencies.
     *             If multiple licenses are listed, it is assumed
     * that the user can select
     *             any of them, not that they must accept all.
     *             
     *           
     * 
     * @param licenses
     */
    public void setLicenses(java.util.List licenses)
    {
        this.licenses = licenses;
    } //-- void setLicenses(java.util.List) 

    /**
     * Set 
     *             
     *             Contains information about a project's mailing
     * lists.
     *             
     *           
     * 
     * @param mailingLists
     */
    public void setMailingLists(java.util.List mailingLists)
    {
        this.mailingLists = mailingLists;
    } //-- void setMailingLists(java.util.List) 

    /**
     * Set 
     *             
     *             Declares to which version of project descriptor
     * this POM conforms.
     *             
     *           
     * 
     * @param modelVersion
     */
    public void setModelVersion(String modelVersion)
    {
        this.modelVersion = modelVersion;
    } //-- void setModelVersion(String) 

    /**
     * Set 
     *             
     *             The full name of the project.
     *             
     *           
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set 
     *             
     *             This element describes various attributes of the
     * organization to
     *             which the project belongs.  These attributes are
     * utilized when
     *             documentation is created (for copyright notices
     * and links).
     *             
     *           
     * 
     * @param organization
     */
    public void setOrganization(Organization organization)
    {
        this.organization = organization;
    } //-- void setOrganization(Organization) 

    /**
     * Set 
     *             
     *             The type of artifact this project produces, for
     * example <code>jar</code>
     *               <code>war</code>
     *               <code>ear</code>
     *               <code>pom</code>.
     *             Plugins can create their own packaging, and
     *             therefore their own packaging types,
     *             so this list does not contain all possible
     * types.
     *             
     *           
     * 
     * @param packaging
     */
    public void setPackaging(String packaging)
    {
        this.packaging = packaging;
    } //-- void setPackaging(String) 

    /**
     * Set 
     *             
     *             The location of the parent project, if one
     * exists. Values from the
     *             parent project will be the default for this
     * project if they are
     *             left unspecified. The location is given as a
     * group ID, artifact ID
     *             and version.
     *             
     *           
     * 
     * @param parent
     */
    public void setParent(Parent parent)
    {
        this.parent = parent;
    } //-- void setParent(Parent) 

    /**
     * Set 
     *             Describes the prerequisites in the build
     * environment for
     *             this project.
     *           
     * 
     * @param prerequisites
     */
    public void setPrerequisites(Prerequisites prerequisites)
    {
        this.prerequisites = prerequisites;
    } //-- void setPrerequisites(Prerequisites) 

    /**
     * Set 
     *             
     *             A listing of project-local build profiles which
     * will modify
     *             the build process when activated.
     *             
     *           
     * 
     * @param profiles
     */
    public void setProfiles(java.util.List profiles)
    {
        this.profiles = profiles;
    } //-- void setProfiles(java.util.List) 

    /**
     * Set 
     *             
     *             Specification for the SCM used by the project,
     * such as CVS, Subversion, etc.
     *             
     *           
     * 
     * @param scm
     */
    public void setScm(Scm scm)
    {
        this.scm = scm;
    } //-- void setScm(Scm) 

    /**
     * Set 
     *             
     *             The URL to the project's homepage.
     *             
     *           
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 

    /**
     * Set 
     *             
     *             The current version of the artifact produced by
     * this project.
     *             
     *           
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


            
    /**
     * @return the model id as <code>groupId:artifactId:packaging:version</code>
     */
    public String getId()
    {
        StringBuffer id = new StringBuffer();

        id.append( getGroupId() );
        id.append( ":" );
        id.append( getArtifactId() );
        id.append( ":" );
        id.append( getPackaging() );
        id.append( ":" );
        id.append( getVersion() );

        return id.toString();
    }
            
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
