/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBase
implements Serializable,
Cloneable {
    private List<String> modules;
    private DistributionManagement distributionManagement;
    private Properties properties;
    private DependencyManagement dependencyManagement;
    private List<Dependency> dependencies;
    private List<Repository> repositories;
    private List<Repository> pluginRepositories;
    private Object reports;
    private Reporting reporting;

    public void addDependency(Dependency dependency) {
        this.getDependencies().add(dependency);
    }

    public void addModule(String string) {
        this.getModules().add(string);
    }

    public void addPluginRepository(Repository repository) {
        this.getPluginRepositories().add(repository);
    }

    public void addProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    public void addRepository(Repository repository) {
        this.getRepositories().add(repository);
    }

    public ModelBase clone() {
        try {
            ModelBase copy = (ModelBase)super.clone();
            if (this.modules != null) {
                copy.modules = new ArrayList<String>();
                copy.modules.addAll(this.modules);
            }
            if (this.distributionManagement != null) {
                copy.distributionManagement = this.distributionManagement.clone();
            }
            if (this.properties != null) {
                copy.properties = (Properties)this.properties.clone();
            }
            if (this.dependencyManagement != null) {
                copy.dependencyManagement = this.dependencyManagement.clone();
            }
            if (this.dependencies != null) {
                copy.dependencies = new ArrayList<Dependency>();
                for (Dependency dependency : this.dependencies) {
                    copy.dependencies.add(dependency.clone());
                }
            }
            if (this.repositories != null) {
                copy.repositories = new ArrayList<Repository>();
                for (Repository repository : this.repositories) {
                    copy.repositories.add(repository.clone());
                }
            }
            if (this.pluginRepositories != null) {
                copy.pluginRepositories = new ArrayList<Repository>();
                for (Repository repository : this.pluginRepositories) {
                    copy.pluginRepositories.add(repository.clone());
                }
            }
            if (this.reports != null) {
                copy.reports = new Xpp3Dom((Xpp3Dom)this.reports);
            }
            if (this.reporting != null) {
                copy.reporting = this.reporting.clone();
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public List<Dependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Dependency>();
        }
        return this.dependencies;
    }

    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    public DistributionManagement getDistributionManagement() {
        return this.distributionManagement;
    }

    public List<String> getModules() {
        if (this.modules == null) {
            this.modules = new ArrayList<String>();
        }
        return this.modules;
    }

    public List<Repository> getPluginRepositories() {
        if (this.pluginRepositories == null) {
            this.pluginRepositories = new ArrayList<Repository>();
        }
        return this.pluginRepositories;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public Reporting getReporting() {
        return this.reporting;
    }

    public Object getReports() {
        return this.reports;
    }

    public List<Repository> getRepositories() {
        if (this.repositories == null) {
            this.repositories = new ArrayList<Repository>();
        }
        return this.repositories;
    }

    public void removeDependency(Dependency dependency) {
        this.getDependencies().remove(dependency);
    }

    public void removeModule(String string) {
        this.getModules().remove(string);
    }

    public void removePluginRepository(Repository repository) {
        this.getPluginRepositories().remove(repository);
    }

    public void removeRepository(Repository repository) {
        this.getRepositories().remove(repository);
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void setDependencyManagement(DependencyManagement dependencyManagement) {
        this.dependencyManagement = dependencyManagement;
    }

    public void setDistributionManagement(DistributionManagement distributionManagement) {
        this.distributionManagement = distributionManagement;
    }

    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    public void setPluginRepositories(List<Repository> pluginRepositories) {
        this.pluginRepositories = pluginRepositories;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setReporting(Reporting reporting) {
        this.reporting = reporting;
    }

    public void setReports(Object reports) {
        this.reports = reports;
    }

    public void setRepositories(List<Repository> repositories) {
        this.repositories = repositories;
    }
}

