/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.4.0,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.model;

/**
 * 
 *         
 *         Base class for the <code>Model</code> and the
 * <code>Profile</code> objects.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class ModelBase
    implements java.io.Serializable, java.lang.Cloneable, org.apache.maven.model.InputLocationTracker
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field modules.
     */
    private java.util.List<String> modules;

    /**
     * Distribution information for a project that enables
     * deployment of the site
     *             and artifacts to remote web servers and
     * repositories respectively.
     */
    private DistributionManagement distributionManagement;

    /**
     * Field properties.
     */
    private java.util.Properties properties;

    /**
     * Default dependency information for projects that inherit
     * from this one. The
     *             dependencies in this section are not immediately
     * resolved. Instead, when a POM derived
     *             from this one declares a dependency described by
     * a matching groupId and artifactId, the
     *             version and other values from this section are
     * used for that dependency if they were not
     *             already specified.
     */
    private DependencyManagement dependencyManagement;

    /**
     * Field dependencies.
     */
    private java.util.List<Dependency> dependencies;

    /**
     * Field repositories.
     */
    private java.util.List<Repository> repositories;

    /**
     * Field pluginRepositories.
     */
    private java.util.List<Repository> pluginRepositories;

    /**
     * 
     *             
     *             <b>Deprecated</b>. Now ignored by Maven.
     *             
     *           
     */
    private Object reports;

    /**
     * 
     *             
     *             This element includes the specification of
     * report plugins to use
     *             to generate the reports on the Maven-generated
     * site.
     *             These reports will be run when a user executes
     * <code>mvn site</code>.
     *             All of the reports will be included in the
     * navigation bar for browsing.
     *             
     *           
     */
    private Reporting reporting;

    /**
     * Field locations.
     */
    private java.util.Map<Object, InputLocation> locations;

    /**
     * Field location.
     */
    private InputLocation location;

    /**
     * Field modulesLocation.
     */
    private InputLocation modulesLocation;

    /**
     * Field distributionManagementLocation.
     */
    private InputLocation distributionManagementLocation;

    /**
     * Field propertiesLocation.
     */
    private InputLocation propertiesLocation;

    /**
     * Field dependencyManagementLocation.
     */
    private InputLocation dependencyManagementLocation;

    /**
     * Field dependenciesLocation.
     */
    private InputLocation dependenciesLocation;

    /**
     * Field repositoriesLocation.
     */
    private InputLocation repositoriesLocation;

    /**
     * Field pluginRepositoriesLocation.
     */
    private InputLocation pluginRepositoriesLocation;

    /**
     * Field reportsLocation.
     */
    private InputLocation reportsLocation;

    /**
     * Field reportingLocation.
     */
    private InputLocation reportingLocation;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addDependency.
     * 
     * @param dependency a dependency object.
     */
    public void addDependency( Dependency dependency )
    {
        getDependencies().add( dependency );
    } //-- void addDependency( Dependency )

    /**
     * Method addModule.
     * 
     * @param string a string object.
     */
    public void addModule( String string )
    {
        getModules().add( string );
    } //-- void addModule( String )

    /**
     * Method addPluginRepository.
     * 
     * @param repository a repository object.
     */
    public void addPluginRepository( Repository repository )
    {
        getPluginRepositories().add( repository );
    } //-- void addPluginRepository( Repository )

    /**
     * Method addProperty.
     * 
     * @param key a key object.
     * @param value a value object.
     */
    public void addProperty( String key, String value )
    {
        getProperties().put( key, value );
    } //-- void addProperty( String, String )

    /**
     * Method addRepository.
     * 
     * @param repository a repository object.
     */
    public void addRepository( Repository repository )
    {
        getRepositories().add( repository );
    } //-- void addRepository( Repository )

    /**
     * Method clone.
     * 
     * @return ModelBase
     */
    public ModelBase clone()
    {
        try
        {
            ModelBase copy = (ModelBase) super.clone();

            if ( this.modules != null )
            {
                copy.modules = new java.util.ArrayList<String>();
                copy.modules.addAll( this.modules );
            }

            if ( this.distributionManagement != null )
            {
                copy.distributionManagement = (DistributionManagement) this.distributionManagement.clone();
            }

            if ( this.properties != null )
            {
                copy.properties = (java.util.Properties) this.properties.clone();
            }

            if ( this.dependencyManagement != null )
            {
                copy.dependencyManagement = (DependencyManagement) this.dependencyManagement.clone();
            }

            if ( this.dependencies != null )
            {
                copy.dependencies = new java.util.ArrayList<Dependency>();
                for ( Dependency item : this.dependencies )
                {
                    copy.dependencies.add( ( (Dependency) item).clone() );
                }
            }

            if ( this.repositories != null )
            {
                copy.repositories = new java.util.ArrayList<Repository>();
                for ( Repository item : this.repositories )
                {
                    copy.repositories.add( ( (Repository) item).clone() );
                }
            }

            if ( this.pluginRepositories != null )
            {
                copy.pluginRepositories = new java.util.ArrayList<Repository>();
                for ( Repository item : this.pluginRepositories )
                {
                    copy.pluginRepositories.add( ( (Repository) item).clone() );
                }
            }

            if ( this.reports != null )
            {
                copy.reports = new org.codehaus.plexus.util.xml.Xpp3Dom( (org.codehaus.plexus.util.xml.Xpp3Dom) this.reports );
            }

            if ( this.reporting != null )
            {
                copy.reporting = (Reporting) this.reporting.clone();
            }

            if ( copy.locations != null )
            {
                copy.locations = new java.util.LinkedHashMap( copy.locations );
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- ModelBase clone()

    /**
     * Method getDependencies.
     * 
     * @return List
     */
    public java.util.List<Dependency> getDependencies()
    {
        if ( this.dependencies == null )
        {
            this.dependencies = new java.util.ArrayList<Dependency>();
        }

        return this.dependencies;
    } //-- java.util.List<Dependency> getDependencies()

    /**
     * Get default dependency information for projects that inherit
     * from this one. The
     *             dependencies in this section are not immediately
     * resolved. Instead, when a POM derived
     *             from this one declares a dependency described by
     * a matching groupId and artifactId, the
     *             version and other values from this section are
     * used for that dependency if they were not
     *             already specified.
     * 
     * @return DependencyManagement
     */
    public DependencyManagement getDependencyManagement()
    {
        return this.dependencyManagement;
    } //-- DependencyManagement getDependencyManagement()

    /**
     * Get distribution information for a project that enables
     * deployment of the site
     *             and artifacts to remote web servers and
     * repositories respectively.
     * 
     * @return DistributionManagement
     */
    public DistributionManagement getDistributionManagement()
    {
        return this.distributionManagement;
    } //-- DistributionManagement getDistributionManagement()

    /**
     * 
     * 
     * @param key a key object.
     * @return InputLocation
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "" :
                {
                    return this.location;
                }
                case "modules" :
                {
                    return modulesLocation;
                }
                case "distributionManagement" :
                {
                    return distributionManagementLocation;
                }
                case "properties" :
                {
                    return propertiesLocation;
                }
                case "dependencyManagement" :
                {
                    return dependencyManagementLocation;
                }
                case "dependencies" :
                {
                    return dependenciesLocation;
                }
                case "repositories" :
                {
                    return repositoriesLocation;
                }
                case "pluginRepositories" :
                {
                    return pluginRepositoriesLocation;
                }
                case "reports" :
                {
                    return reportsLocation;
                }
                case "reporting" :
                {
                    return reportingLocation;
                }
                default :
                {
                    return getOtherLocation( key );
                }
                }
            }
            else
            {
                return getOtherLocation( key );
            }
    } //-- InputLocation getLocation( Object )

    /**
     * Method getModules.
     * 
     * @return List
     */
    public java.util.List<String> getModules()
    {
        if ( this.modules == null )
        {
            this.modules = new java.util.ArrayList<String>();
        }

        return this.modules;
    } //-- java.util.List<String> getModules()

    /**
     * 
     * 
     * @param key a key object.
     * @param location a location object.
     */
    public void setLocation( Object key, InputLocation location )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "" :
                {
                    this.location = location;
                    return;
                }
                case "modules" :
                {
                    modulesLocation = location;
                    return;
                }
                case "distributionManagement" :
                {
                    distributionManagementLocation = location;
                    return;
                }
                case "properties" :
                {
                    propertiesLocation = location;
                    return;
                }
                case "dependencyManagement" :
                {
                    dependencyManagementLocation = location;
                    return;
                }
                case "dependencies" :
                {
                    dependenciesLocation = location;
                    return;
                }
                case "repositories" :
                {
                    repositoriesLocation = location;
                    return;
                }
                case "pluginRepositories" :
                {
                    pluginRepositoriesLocation = location;
                    return;
                }
                case "reports" :
                {
                    reportsLocation = location;
                    return;
                }
                case "reporting" :
                {
                    reportingLocation = location;
                    return;
                }
                default :
                {
                    setOtherLocation( key, location );
                    return;
                }
            }
        }
        else
        {
            setOtherLocation( key, location );
        }
    } //-- void setLocation( Object, InputLocation )

    /**
     * 
     * 
     * @param key a key object.
     * @param location a location object.
     */
    public void setOtherLocation( Object key, InputLocation location )
    {
        if ( location != null )
        {
            if ( this.locations == null )
            {
                this.locations = new java.util.LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put( key, location );
        }
    } //-- void setOtherLocation( Object, InputLocation )

    /**
     * 
     * 
     * @param key a key object.
     * @return InputLocation
     */
    private InputLocation getOtherLocation( Object key )
    {
        return ( locations != null ) ? locations.get( key ) : null;
    } //-- InputLocation getOtherLocation( Object )

    /**
     * Method getPluginRepositories.
     * 
     * @return List
     */
    public java.util.List<Repository> getPluginRepositories()
    {
        if ( this.pluginRepositories == null )
        {
            this.pluginRepositories = new java.util.ArrayList<Repository>();
        }

        return this.pluginRepositories;
    } //-- java.util.List<Repository> getPluginRepositories()

    /**
     * Method getProperties.
     * 
     * @return Properties
     */
    public java.util.Properties getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.Properties();
        }

        return this.properties;
    } //-- java.util.Properties getProperties()

    /**
     * Get this element includes the specification of report
     * plugins to use
     *             to generate the reports on the Maven-generated
     * site.
     *             These reports will be run when a user executes
     * <code>mvn site</code>.
     *             All of the reports will be included in the
     * navigation bar for browsing.
     * 
     * @return Reporting
     */
    public Reporting getReporting()
    {
        return this.reporting;
    } //-- Reporting getReporting()

    /**
     * Get <b>Deprecated</b>. Now ignored by Maven.
     * 
     * @return Object
     */
    public Object getReports()
    {
        return this.reports;
    } //-- Object getReports()

    /**
     * Method getRepositories.
     * 
     * @return List
     */
    public java.util.List<Repository> getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList<Repository>();
        }

        return this.repositories;
    } //-- java.util.List<Repository> getRepositories()

    /**
     * Method removeDependency.
     * 
     * @param dependency a dependency object.
     */
    public void removeDependency( Dependency dependency )
    {
        getDependencies().remove( dependency );
    } //-- void removeDependency( Dependency )

    /**
     * Method removeModule.
     * 
     * @param string a string object.
     */
    public void removeModule( String string )
    {
        getModules().remove( string );
    } //-- void removeModule( String )

    /**
     * Method removePluginRepository.
     * 
     * @param repository a repository object.
     */
    public void removePluginRepository( Repository repository )
    {
        getPluginRepositories().remove( repository );
    } //-- void removePluginRepository( Repository )

    /**
     * Method removeRepository.
     * 
     * @param repository a repository object.
     */
    public void removeRepository( Repository repository )
    {
        getRepositories().remove( repository );
    } //-- void removeRepository( Repository )

    /**
     * Set this element describes all of the dependencies
     * associated with a
     *             project.
     *             These dependencies are used to construct a
     * classpath for your
     *             project during the build process. They are
     * automatically downloaded from the
     *             repositories defined in this project.
     *             See <a
     * href="https://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     *             dependency mechanism</a> for more information.
     * 
     * @param dependencies a dependencies object.
     */
    public void setDependencies( java.util.List<Dependency> dependencies )
    {
        this.dependencies = dependencies;
    } //-- void setDependencies( java.util.List )

    /**
     * Set default dependency information for projects that inherit
     * from this one. The
     *             dependencies in this section are not immediately
     * resolved. Instead, when a POM derived
     *             from this one declares a dependency described by
     * a matching groupId and artifactId, the
     *             version and other values from this section are
     * used for that dependency if they were not
     *             already specified.
     * 
     * @param dependencyManagement a dependencyManagement object.
     */
    public void setDependencyManagement( DependencyManagement dependencyManagement )
    {
        this.dependencyManagement = dependencyManagement;
    } //-- void setDependencyManagement( DependencyManagement )

    /**
     * Set distribution information for a project that enables
     * deployment of the site
     *             and artifacts to remote web servers and
     * repositories respectively.
     * 
     * @param distributionManagement a distributionManagement object
     */
    public void setDistributionManagement( DistributionManagement distributionManagement )
    {
        this.distributionManagement = distributionManagement;
    } //-- void setDistributionManagement( DistributionManagement )

    /**
     * Set the modules (sometimes called subprojects) to build as a
     * part of this
     *             project. Each module listed is a relative path
     * to the directory containing the module.
     *             To be consistent with the way default urls are
     * calculated from parent, it is recommended
     *             to have module names match artifact ids.
     * 
     * @param modules a modules object.
     */
    public void setModules( java.util.List<String> modules )
    {
        this.modules = modules;
    } //-- void setModules( java.util.List )

    /**
     * Set the lists of the remote repositories for discovering
     * plugins for builds and
     *             reports.
     * 
     * @param pluginRepositories a pluginRepositories object.
     */
    public void setPluginRepositories( java.util.List<Repository> pluginRepositories )
    {
        this.pluginRepositories = pluginRepositories;
    } //-- void setPluginRepositories( java.util.List )

    /**
     * Set properties that can be used throughout the POM as a
     * substitution, and
     *             are used as filters in resources if enabled.
     *             The format is
     * <code>&lt;name&gt;value&lt;/name&gt;</code>.
     * 
     * @param properties a properties object.
     */
    public void setProperties( java.util.Properties properties )
    {
        this.properties = properties;
    } //-- void setProperties( java.util.Properties )

    /**
     * Set this element includes the specification of report
     * plugins to use
     *             to generate the reports on the Maven-generated
     * site.
     *             These reports will be run when a user executes
     * <code>mvn site</code>.
     *             All of the reports will be included in the
     * navigation bar for browsing.
     * 
     * @param reporting a reporting object.
     */
    public void setReporting( Reporting reporting )
    {
        this.reporting = reporting;
    } //-- void setReporting( Reporting )

    /**
     * Set <b>Deprecated</b>. Now ignored by Maven.
     * 
     * @param reports a reports object.
     */
    public void setReports( Object reports )
    {
        this.reports = reports;
    } //-- void setReports( Object )

    /**
     * Set the lists of the remote repositories for discovering
     * dependencies and
     *             extensions.
     * 
     * @param repositories a repositories object.
     */
    public void setRepositories( java.util.List<Repository> repositories )
    {
        this.repositories = repositories;
    } //-- void setRepositories( java.util.List )

}
