/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.4.0,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.model;

/**
 * Describes where an artifact has moved to. If any of the values
 * are omitted, it is
 *         assumed to be the same as it was before.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Relocation
    implements java.io.Serializable, java.lang.Cloneable, org.apache.maven.model.InputLocationTracker
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The group ID the artifact has moved to.
     */
    private String groupId;

    /**
     * The new artifact ID of the artifact.
     */
    private String artifactId;

    /**
     * The new version of the artifact.
     */
    private String version;

    /**
     * An additional message to show the user about the move, such
     * as the reason.
     */
    private String message;

    /**
     * Field locations.
     */
    private java.util.Map<Object, InputLocation> locations;

    /**
     * Field location.
     */
    private InputLocation location;

    /**
     * Field groupIdLocation.
     */
    private InputLocation groupIdLocation;

    /**
     * Field artifactIdLocation.
     */
    private InputLocation artifactIdLocation;

    /**
     * Field versionLocation.
     */
    private InputLocation versionLocation;

    /**
     * Field messageLocation.
     */
    private InputLocation messageLocation;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method clone.
     * 
     * @return Relocation
     */
    public Relocation clone()
    {
        try
        {
            Relocation copy = (Relocation) super.clone();

            if ( copy.locations != null )
            {
                copy.locations = new java.util.LinkedHashMap( copy.locations );
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- Relocation clone()

    /**
     * Get the new artifact ID of the artifact.
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId()

    /**
     * Get the group ID the artifact has moved to.
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId()

    /**
     * 
     * 
     * @param key a key object.
     * @return InputLocation
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "" :
                {
                    return this.location;
                }
                case "groupId" :
                {
                    return groupIdLocation;
                }
                case "artifactId" :
                {
                    return artifactIdLocation;
                }
                case "version" :
                {
                    return versionLocation;
                }
                case "message" :
                {
                    return messageLocation;
                }
                default :
                {
                    return getOtherLocation( key );
                }
                }
            }
            else
            {
                return getOtherLocation( key );
            }
    } //-- InputLocation getLocation( Object )

    /**
     * Get an additional message to show the user about the move,
     * such as the reason.
     * 
     * @return String
     */
    public String getMessage()
    {
        return this.message;
    } //-- String getMessage()

    /**
     * 
     * 
     * @param key a key object.
     * @param location a location object.
     */
    public void setLocation( Object key, InputLocation location )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "" :
                {
                    this.location = location;
                    return;
                }
                case "groupId" :
                {
                    groupIdLocation = location;
                    return;
                }
                case "artifactId" :
                {
                    artifactIdLocation = location;
                    return;
                }
                case "version" :
                {
                    versionLocation = location;
                    return;
                }
                case "message" :
                {
                    messageLocation = location;
                    return;
                }
                default :
                {
                    setOtherLocation( key, location );
                    return;
                }
            }
        }
        else
        {
            setOtherLocation( key, location );
        }
    } //-- void setLocation( Object, InputLocation )

    /**
     * 
     * 
     * @param key a key object.
     * @param location a location object.
     */
    public void setOtherLocation( Object key, InputLocation location )
    {
        if ( location != null )
        {
            if ( this.locations == null )
            {
                this.locations = new java.util.LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put( key, location );
        }
    } //-- void setOtherLocation( Object, InputLocation )

    /**
     * 
     * 
     * @param key a key object.
     * @return InputLocation
     */
    private InputLocation getOtherLocation( Object key )
    {
        return ( locations != null ) ? locations.get( key ) : null;
    } //-- InputLocation getOtherLocation( Object )

    /**
     * Get the new version of the artifact.
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion()

    /**
     * Set the new artifact ID of the artifact.
     * 
     * @param artifactId a artifactId object.
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String )

    /**
     * Set the group ID the artifact has moved to.
     * 
     * @param groupId a groupId object.
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String )

    /**
     * Set an additional message to show the user about the move,
     * such as the reason.
     * 
     * @param message a message object.
     */
    public void setMessage( String message )
    {
        this.message = message;
    } //-- void setMessage( String )

    /**
     * Set the new version of the artifact.
     * 
     * @param version a version object.
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String )

}
