/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.4.0,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.model;

/**
 * Contains the information needed for deploying websites.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Site
    implements java.io.Serializable, java.lang.Cloneable, org.apache.maven.model.InputLocationTracker
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             
     *             A unique identifier for a deployment location.
     * This is used to match the
     *             site to configuration in the
     * <code>settings.xml</code> file, for example.
     *             
     *           
     */
    private String id;

    /**
     * Human readable name of the deployment location.
     */
    private String name;

    /**
     * 
     *             
     *             The url of the location where website is
     * deployed, in the form <code>protocol://hostname/path</code>.
     *             <br><b>Default value is</b>: parent value [+
     * path adjustment] + (artifactId or project.directory
     * property), or just parent value if
     *             site's
     * <code>child.site.url.inherit.append.path="false"</code>
     *             
     *           
     */
    private String url;

    /**
     * 
     *             
     *             When children inherit from distribution
     * management site url, append path or not? Note: While the
     * type
     *             of this field is <code>String</code> for
     * technical reasons, the semantic type is actually
     *             <code>Boolean</code>
     *             <br><b>Default value is</b>: <code>true</code>
     *             <br><b>Since</b>: Maven 3.6.1
     *             
     *           .
     */
    private String childSiteUrlInheritAppendPath;

    /**
     * Field locations.
     */
    private java.util.Map<Object, InputLocation> locations;

    /**
     * Field location.
     */
    private InputLocation location;

    /**
     * Field idLocation.
     */
    private InputLocation idLocation;

    /**
     * Field nameLocation.
     */
    private InputLocation nameLocation;

    /**
     * Field urlLocation.
     */
    private InputLocation urlLocation;

    /**
     * Field childSiteUrlInheritAppendPathLocation.
     */
    private InputLocation childSiteUrlInheritAppendPathLocation;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method clone.
     * 
     * @return Site
     */
    public Site clone()
    {
        try
        {
            Site copy = (Site) super.clone();

            if ( copy.locations != null )
            {
                copy.locations = new java.util.LinkedHashMap( copy.locations );
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- Site clone()

    /**
     * Get when children inherit from distribution management site
     * url, append path or not? Note: While the type
     *             of this field is <code>String</code> for
     * technical reasons, the semantic type is actually
     *             <code>Boolean</code>
     *             <br><b>Default value is</b>: <code>true</code>
     *             <br><b>Since</b>: Maven 3.6.1.
     * 
     * @return String
     */
    public String getChildSiteUrlInheritAppendPath()
    {
        return this.childSiteUrlInheritAppendPath;
    } //-- String getChildSiteUrlInheritAppendPath()

    /**
     * Get a unique identifier for a deployment location. This is
     * used to match the
     *             site to configuration in the
     * <code>settings.xml</code> file, for example.
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId()

    /**
     * 
     * 
     * @param key a key object.
     * @return InputLocation
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "" :
                {
                    return this.location;
                }
                case "id" :
                {
                    return idLocation;
                }
                case "name" :
                {
                    return nameLocation;
                }
                case "url" :
                {
                    return urlLocation;
                }
                case "childSiteUrlInheritAppendPath" :
                {
                    return childSiteUrlInheritAppendPathLocation;
                }
                default :
                {
                    return getOtherLocation( key );
                }
                }
            }
            else
            {
                return getOtherLocation( key );
            }
    } //-- InputLocation getLocation( Object )

    /**
     * Get human readable name of the deployment location.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * 
     * 
     * @param key a key object.
     * @param location a location object.
     */
    public void setLocation( Object key, InputLocation location )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "" :
                {
                    this.location = location;
                    return;
                }
                case "id" :
                {
                    idLocation = location;
                    return;
                }
                case "name" :
                {
                    nameLocation = location;
                    return;
                }
                case "url" :
                {
                    urlLocation = location;
                    return;
                }
                case "childSiteUrlInheritAppendPath" :
                {
                    childSiteUrlInheritAppendPathLocation = location;
                    return;
                }
                default :
                {
                    setOtherLocation( key, location );
                    return;
                }
            }
        }
        else
        {
            setOtherLocation( key, location );
        }
    } //-- void setLocation( Object, InputLocation )

    /**
     * 
     * 
     * @param key a key object.
     * @param location a location object.
     */
    public void setOtherLocation( Object key, InputLocation location )
    {
        if ( location != null )
        {
            if ( this.locations == null )
            {
                this.locations = new java.util.LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put( key, location );
        }
    } //-- void setOtherLocation( Object, InputLocation )

    /**
     * 
     * 
     * @param key a key object.
     * @return InputLocation
     */
    private InputLocation getOtherLocation( Object key )
    {
        return ( locations != null ) ? locations.get( key ) : null;
    } //-- InputLocation getOtherLocation( Object )

    /**
     * Get the url of the location where website is deployed, in
     * the form <code>protocol://hostname/path</code>.
     *             <br><b>Default value is</b>: parent value [+
     * path adjustment] + (artifactId or project.directory
     * property), or just parent value if
     *             site's
     * <code>child.site.url.inherit.append.path="false"</code>
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Set when children inherit from distribution management site
     * url, append path or not? Note: While the type
     *             of this field is <code>String</code> for
     * technical reasons, the semantic type is actually
     *             <code>Boolean</code>
     *             <br><b>Default value is</b>: <code>true</code>
     *             <br><b>Since</b>: Maven 3.6.1.
     * 
     * @param childSiteUrlInheritAppendPath a
     * childSiteUrlInheritAppendPath object.
     */
    public void setChildSiteUrlInheritAppendPath( String childSiteUrlInheritAppendPath )
    {
        this.childSiteUrlInheritAppendPath = childSiteUrlInheritAppendPath;
    } //-- void setChildSiteUrlInheritAppendPath( String )

    /**
     * Set a unique identifier for a deployment location. This is
     * used to match the
     *             site to configuration in the
     * <code>settings.xml</code> file, for example.
     * 
     * @param id a id object.
     */
    public void setId( String id )
    {
        this.id = id;
    } //-- void setId( String )

    /**
     * Set human readable name of the deployment location.
     * 
     * @param name a name object.
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set the url of the location where website is deployed, in
     * the form <code>protocol://hostname/path</code>.
     *             <br><b>Default value is</b>: parent value [+
     * path adjustment] + (artifactId or project.directory
     * property), or just parent value if
     *             site's
     * <code>child.site.url.inherit.append.path="false"</code>
     * 
     * @param url a url object.
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )

    
            

    public boolean isChildSiteUrlInheritAppendPath()
    {
        return ( childSiteUrlInheritAppendPath != null ) ? Boolean.parseBoolean( childSiteUrlInheritAppendPath ) : true;
    }

    public void setChildSiteUrlInheritAppendPath( boolean childSiteUrlInheritAppendPath )
    {
        this.childSiteUrlInheritAppendPath = String.valueOf( childSiteUrlInheritAppendPath );
    }

            
          
}
