/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.model.BaseObject;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Extension;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.WrapperList;

@Generated
public class Build
extends BuildBase
implements Serializable,
Cloneable {
    public Build() {
        this(org.apache.maven.api.model.Build.newInstance());
    }

    public Build(org.apache.maven.api.model.Build delegate) {
        this(delegate, (BaseObject)null);
    }

    public Build(org.apache.maven.api.model.Build delegate, BaseObject parent) {
        super((org.apache.maven.api.model.BuildBase)delegate, parent);
    }

    @Override
    public Build clone() {
        return new Build(this.getDelegate());
    }

    public org.apache.maven.api.model.Build getDelegate() {
        return (org.apache.maven.api.model.Build)super.getDelegate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Build)) {
            return false;
        }
        Build that = (Build)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public String getSourceDirectory() {
        return this.getDelegate().getSourceDirectory();
    }

    public void setSourceDirectory(String sourceDirectory) {
        if (!Objects.equals(sourceDirectory, this.getSourceDirectory())) {
            this.update(this.getDelegate().withSourceDirectory(sourceDirectory));
        }
    }

    public String getScriptSourceDirectory() {
        return this.getDelegate().getScriptSourceDirectory();
    }

    public void setScriptSourceDirectory(String scriptSourceDirectory) {
        if (!Objects.equals(scriptSourceDirectory, this.getScriptSourceDirectory())) {
            this.update(this.getDelegate().withScriptSourceDirectory(scriptSourceDirectory));
        }
    }

    public String getTestSourceDirectory() {
        return this.getDelegate().getTestSourceDirectory();
    }

    public void setTestSourceDirectory(String testSourceDirectory) {
        if (!Objects.equals(testSourceDirectory, this.getTestSourceDirectory())) {
            this.update(this.getDelegate().withTestSourceDirectory(testSourceDirectory));
        }
    }

    public String getOutputDirectory() {
        return this.getDelegate().getOutputDirectory();
    }

    public void setOutputDirectory(String outputDirectory) {
        if (!Objects.equals(outputDirectory, this.getOutputDirectory())) {
            this.update(this.getDelegate().withOutputDirectory(outputDirectory));
        }
    }

    public String getTestOutputDirectory() {
        return this.getDelegate().getTestOutputDirectory();
    }

    public void setTestOutputDirectory(String testOutputDirectory) {
        if (!Objects.equals(testOutputDirectory, this.getTestOutputDirectory())) {
            this.update(this.getDelegate().withTestOutputDirectory(testOutputDirectory));
        }
    }

    @Nonnull
    public List<Extension> getExtensions() {
        return new WrapperList<Extension, org.apache.maven.api.model.Extension>(() -> this.getDelegate().getExtensions(), l -> this.update(this.getDelegate().withExtensions((Collection)l)), d -> new Extension((org.apache.maven.api.model.Extension)d, (BaseObject)this), Extension::getDelegate);
    }

    public void setExtensions(List<Extension> extensions) {
        if (extensions == null) {
            extensions = Collections.emptyList();
        }
        if (!Objects.equals(extensions, this.getExtensions())) {
            this.update(this.getDelegate().withExtensions((Collection)extensions.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            extensions.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addExtension(Extension extension) {
        this.update(this.getDelegate().withExtensions((Collection)Stream.concat(this.getDelegate().getExtensions().stream(), Stream.of(extension.getDelegate())).collect(Collectors.toList())));
        extension.childrenTracking = this::replace;
    }

    public void removeExtension(Extension extension) {
        this.update(this.getDelegate().withExtensions((Collection)this.getDelegate().getExtensions().stream().filter(e -> !Objects.equals(e, extension)).collect(Collectors.toList())));
        extension.childrenTracking = null;
    }

    @Override
    public InputLocation getLocation(Object key) {
        org.apache.maven.api.model.InputLocation loc = this.getDelegate().getLocation(key);
        return loc != null ? new InputLocation(loc) : null;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        this.update(org.apache.maven.api.model.Build.newBuilder((org.apache.maven.api.model.Build)this.getDelegate(), (boolean)true).location(key, location.toApiLocation()).build());
    }

    @Override
    protected boolean replace(Object oldDelegate, Object newDelegate) {
        if (super.replace(oldDelegate, newDelegate)) {
            return true;
        }
        if (this.getDelegate().getExtensions().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getExtensions());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.model.Extension)newDelegate : d);
            this.update(this.getDelegate().withExtensions(list));
            return true;
        }
        return false;
    }

    public static List<org.apache.maven.api.model.Build> buildToApiV4(List<Build> list) {
        return list != null ? new WrapperList<org.apache.maven.api.model.Build, Build>(list, Build::getDelegate, Build::new) : null;
    }

    public static List<Build> buildToApiV3(List<org.apache.maven.api.model.Build> list) {
        return list != null ? new WrapperList<Build, org.apache.maven.api.model.Build>(list, Build::new, Build::getDelegate) : null;
    }

    @Override
    public String toString() {
        return "Build {" + super.toString() + "}";
    }
}

