/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.v4;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationFile;
import org.apache.maven.api.model.ActivationOS;
import org.apache.maven.api.model.ActivationProperty;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.CiManagement;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.Contributor;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.DeploymentRepository;
import org.apache.maven.api.model.Developer;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.Extension;
import org.apache.maven.api.model.FileSet;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputSource;
import org.apache.maven.api.model.IssueManagement;
import org.apache.maven.api.model.License;
import org.apache.maven.api.model.MailingList;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Notifier;
import org.apache.maven.api.model.Organization;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.PatternSet;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginConfiguration;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.Prerequisites;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Relocation;
import org.apache.maven.api.model.ReportPlugin;
import org.apache.maven.api.model.ReportSet;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryBase;
import org.apache.maven.api.model.RepositoryPolicy;
import org.apache.maven.api.model.Resource;
import org.apache.maven.api.model.Scm;
import org.apache.maven.api.model.Site;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeBuilder;

@Generated
public class MavenStaxReader {
    private static final Map<String, String> DEFAULT_ENTITIES;
    private boolean addDefaultEntities = true;
    private boolean addLocationInformation = true;
    private final ContentTransformer contentTransformer;

    public MavenStaxReader() {
        this((s, f) -> s);
    }

    public MavenStaxReader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public boolean getAddLocationInformation() {
        return this.addLocationInformation;
    }

    public void setAddLocationInformation(boolean addLocationInformation) {
        this.addLocationInformation = addLocationInformation;
    }

    public Model read(Reader reader) throws XMLStreamException {
        return this.read(reader, true, null);
    }

    public Model read(Reader reader, boolean strict, InputSource source) throws XMLStreamException {
        WstxInputFactory factory = new WstxInputFactory();
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        StreamSource streamSource = new StreamSource(reader, source != null ? source.getLocation() : null);
        XMLStreamReader parser = factory.createXMLStreamReader(streamSource);
        return this.read(parser, strict, source);
    }

    public Model read(InputStream in) throws XMLStreamException {
        return this.read(in, true, null);
    }

    public Model read(InputStream in, boolean strict, InputSource source) throws XMLStreamException {
        WstxInputFactory factory = new WstxInputFactory();
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        StreamSource streamSource = new StreamSource(in, source != null ? source.getLocation() : null);
        XMLStreamReader parser = factory.createXMLStreamReader(streamSource);
        return this.read(parser, strict, source);
    }

    public Model read(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        Model model = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 8) {
            if (eventType == 1) {
                if (strict && !"project".equals(parser.getLocalName())) {
                    throw new XMLStreamException("Expected root element 'project' but found '" + String.valueOf(parser.getName()) + "'", parser.getLocation(), null);
                }
                if (parsed) {
                    throw new XMLStreamException("Duplicated tag: 'project'", parser.getLocation(), null);
                }
                model = this.parseModel(parser, strict, source);
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return model;
        }
        throw new XMLStreamException("Expected root element 'project' but found no element at all: invalid XML document", parser.getLocation(), null);
    }

    private Model parseModel(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Model.Builder model = Model.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            model.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns) || "xmlns".equals(name)) continue;
            if ("child.project.url.inherit.append.path".equals(name)) {
                if (this.addLocationInformation) {
                    model.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                }
                model.childProjectUrlInheritAppendPath(this.interpolatedTrimmed(value, "child.project.url.inherit.append.path"));
                continue;
            }
            if ("root".equals(name)) {
                if (this.addLocationInformation) {
                    model.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                }
                model.root(this.getBooleanValue(this.interpolatedTrimmed(value, "root"), "root", parser, false));
                continue;
            }
            if ("preserve.model.version".equals(name)) {
                if (this.addLocationInformation) {
                    model.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                }
                model.preserveModelVersion(this.getBooleanValue(this.interpolatedTrimmed(value, "preserve.model.version"), "preserve.model.version", parser, false));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Object, InputLocation> locations = null;
            switch (childName) {
                case "modelVersion": {
                    model.modelVersion(this.interpolatedTrimmed(this.nextText(parser, strict), "modelVersion"));
                    break;
                }
                case "parent": {
                    model.parent(this.parseParent(parser, strict, source));
                    break;
                }
                case "groupId": {
                    model.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    model.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    model.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "packaging": {
                    model.packaging(this.interpolatedTrimmed(this.nextText(parser, strict), "packaging"));
                    break;
                }
                case "name": {
                    model.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "description": {
                    model.description(this.interpolatedTrimmed(this.nextText(parser, strict), "description"));
                    break;
                }
                case "url": {
                    model.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "inceptionYear": {
                    model.inceptionYear(this.interpolatedTrimmed(this.nextText(parser, strict), "inceptionYear"));
                    break;
                }
                case "organization": {
                    model.organization(this.parseOrganization(parser, strict, source));
                    break;
                }
                case "licenses": {
                    ArrayList<License> licenses = new ArrayList<License>();
                    while (parser.nextTag() == 1) {
                        if ("license".equals(parser.getLocalName())) {
                            licenses.add(this.parseLicense(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.licenses(licenses);
                    break;
                }
                case "developers": {
                    ArrayList<Developer> developers = new ArrayList<Developer>();
                    while (parser.nextTag() == 1) {
                        if ("developer".equals(parser.getLocalName())) {
                            developers.add(this.parseDeveloper(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.developers(developers);
                    break;
                }
                case "contributors": {
                    ArrayList<Contributor> contributors = new ArrayList<Contributor>();
                    while (parser.nextTag() == 1) {
                        if ("contributor".equals(parser.getLocalName())) {
                            contributors.add(this.parseContributor(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.contributors(contributors);
                    break;
                }
                case "mailingLists": {
                    ArrayList<MailingList> mailingLists = new ArrayList<MailingList>();
                    while (parser.nextTag() == 1) {
                        if ("mailingList".equals(parser.getLocalName())) {
                            mailingLists.add(this.parseMailingList(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.mailingLists(mailingLists);
                    break;
                }
                case "prerequisites": {
                    model.prerequisites(this.parsePrerequisites(parser, strict, source));
                    break;
                }
                case "modules": {
                    ArrayList<String> modules = new ArrayList<String>();
                    locations = new HashMap<Object, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("module".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            modules.add(this.interpolatedTrimmed(this.nextText(parser, strict), "modules"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.modules(modules);
                    break;
                }
                case "scm": {
                    model.scm(this.parseScm(parser, strict, source));
                    break;
                }
                case "issueManagement": {
                    model.issueManagement(this.parseIssueManagement(parser, strict, source));
                    break;
                }
                case "ciManagement": {
                    model.ciManagement(this.parseCiManagement(parser, strict, source));
                    break;
                }
                case "distributionManagement": {
                    model.distributionManagement(this.parseDistributionManagement(parser, strict, source));
                    break;
                }
                case "properties": {
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        String key = parser.getLocalName();
                        String value = this.nextText(parser, strict).trim();
                        if (this.addLocationInformation) {
                            locations.put(key, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                        }
                        properties.put(key, value);
                    }
                    model.properties(properties);
                    break;
                }
                case "dependencyManagement": {
                    model.dependencyManagement(this.parseDependencyManagement(parser, strict, source));
                    break;
                }
                case "dependencies": {
                    ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                    while (parser.nextTag() == 1) {
                        if ("dependency".equals(parser.getLocalName())) {
                            dependencies.add(this.parseDependency(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.dependencies(dependencies);
                    break;
                }
                case "repositories": {
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("repository".equals(parser.getLocalName())) {
                            repositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.repositories(repositories);
                    break;
                }
                case "pluginRepositories": {
                    ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("pluginRepository".equals(parser.getLocalName())) {
                            pluginRepositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.pluginRepositories(pluginRepositories);
                    break;
                }
                case "build": {
                    model.build(this.parseBuild(parser, strict, source));
                    break;
                }
                case "reporting": {
                    model.reporting(this.parseReporting(parser, strict, source));
                    break;
                }
                case "profiles": {
                    ArrayList<Profile> profiles = new ArrayList<Profile>();
                    while (parser.nextTag() == 1) {
                        if ("profile".equals(parser.getLocalName())) {
                            profiles.add(this.parseProfile(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    model.profiles(profiles);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            model.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        model.namespaceUri(parser.getNamespaceURI());
        model.modelEncoding(parser.getEncoding());
        return model.build();
    }

    private ModelBase parseModelBase(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ModelBase.Builder modelBase = ModelBase.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            modelBase.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Object, InputLocation> locations = null;
            switch (childName) {
                case "modules": {
                    ArrayList<String> modules = new ArrayList<String>();
                    locations = new HashMap<Object, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("module".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            modules.add(this.interpolatedTrimmed(this.nextText(parser, strict), "modules"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    modelBase.modules(modules);
                    break;
                }
                case "distributionManagement": {
                    modelBase.distributionManagement(this.parseDistributionManagement(parser, strict, source));
                    break;
                }
                case "properties": {
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        String key = parser.getLocalName();
                        String value = this.nextText(parser, strict).trim();
                        if (this.addLocationInformation) {
                            locations.put(key, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                        }
                        properties.put(key, value);
                    }
                    modelBase.properties(properties);
                    break;
                }
                case "dependencyManagement": {
                    modelBase.dependencyManagement(this.parseDependencyManagement(parser, strict, source));
                    break;
                }
                case "dependencies": {
                    ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                    while (parser.nextTag() == 1) {
                        if ("dependency".equals(parser.getLocalName())) {
                            dependencies.add(this.parseDependency(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    modelBase.dependencies(dependencies);
                    break;
                }
                case "repositories": {
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("repository".equals(parser.getLocalName())) {
                            repositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    modelBase.repositories(repositories);
                    break;
                }
                case "pluginRepositories": {
                    ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("pluginRepository".equals(parser.getLocalName())) {
                            pluginRepositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    modelBase.pluginRepositories(pluginRepositories);
                    break;
                }
                case "reporting": {
                    modelBase.reporting(this.parseReporting(parser, strict, source));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            modelBase.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return modelBase.build();
    }

    private PluginContainer parsePluginContainer(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        PluginContainer.Builder pluginContainer = PluginContainer.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            pluginContainer.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "plugins": {
                    ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                    while (parser.nextTag() == 1) {
                        if ("plugin".equals(parser.getLocalName())) {
                            plugins.add(this.parsePlugin(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    pluginContainer.plugins(plugins);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            pluginContainer.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return pluginContainer.build();
    }

    private PluginConfiguration parsePluginConfiguration(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        PluginConfiguration.Builder pluginConfiguration = PluginConfiguration.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            pluginConfiguration.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "pluginManagement": {
                    pluginConfiguration.pluginManagement(this.parsePluginManagement(parser, strict, source));
                    break;
                }
                case "plugins": {
                    ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                    while (parser.nextTag() == 1) {
                        if ("plugin".equals(parser.getLocalName())) {
                            plugins.add(this.parsePlugin(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    pluginConfiguration.plugins(plugins);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            pluginConfiguration.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return pluginConfiguration.build();
    }

    private BuildBase parseBuildBase(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        BuildBase.Builder buildBase = BuildBase.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            buildBase.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "defaultGoal": {
                    buildBase.defaultGoal(this.interpolatedTrimmed(this.nextText(parser, strict), "defaultGoal"));
                    break;
                }
                case "resources": {
                    ArrayList<Resource> resources = new ArrayList<Resource>();
                    while (parser.nextTag() == 1) {
                        if ("resource".equals(parser.getLocalName())) {
                            resources.add(this.parseResource(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    buildBase.resources(resources);
                    break;
                }
                case "testResources": {
                    ArrayList<Resource> testResources = new ArrayList<Resource>();
                    while (parser.nextTag() == 1) {
                        if ("testResource".equals(parser.getLocalName())) {
                            testResources.add(this.parseResource(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    buildBase.testResources(testResources);
                    break;
                }
                case "directory": {
                    buildBase.directory(this.interpolatedTrimmed(this.nextText(parser, strict), "directory"));
                    break;
                }
                case "finalName": {
                    buildBase.finalName(this.interpolatedTrimmed(this.nextText(parser, strict), "finalName"));
                    break;
                }
                case "filters": {
                    ArrayList<String> filters = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("filter".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            filters.add(this.interpolatedTrimmed(this.nextText(parser, strict), "filters"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    buildBase.filters(filters);
                    break;
                }
                case "pluginManagement": {
                    buildBase.pluginManagement(this.parsePluginManagement(parser, strict, source));
                    break;
                }
                case "plugins": {
                    ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                    while (parser.nextTag() == 1) {
                        if ("plugin".equals(parser.getLocalName())) {
                            plugins.add(this.parsePlugin(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    buildBase.plugins(plugins);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            buildBase.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return buildBase.build();
    }

    private Build parseBuild(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Build.Builder build = Build.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            build.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "sourceDirectory": {
                    build.sourceDirectory(this.interpolatedTrimmed(this.nextText(parser, strict), "sourceDirectory"));
                    break;
                }
                case "scriptSourceDirectory": {
                    build.scriptSourceDirectory(this.interpolatedTrimmed(this.nextText(parser, strict), "scriptSourceDirectory"));
                    break;
                }
                case "testSourceDirectory": {
                    build.testSourceDirectory(this.interpolatedTrimmed(this.nextText(parser, strict), "testSourceDirectory"));
                    break;
                }
                case "outputDirectory": {
                    build.outputDirectory(this.interpolatedTrimmed(this.nextText(parser, strict), "outputDirectory"));
                    break;
                }
                case "testOutputDirectory": {
                    build.testOutputDirectory(this.interpolatedTrimmed(this.nextText(parser, strict), "testOutputDirectory"));
                    break;
                }
                case "extensions": {
                    ArrayList<Extension> extensions = new ArrayList<Extension>();
                    while (parser.nextTag() == 1) {
                        if ("extension".equals(parser.getLocalName())) {
                            extensions.add(this.parseExtension(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    build.extensions(extensions);
                    break;
                }
                case "defaultGoal": {
                    build.defaultGoal(this.interpolatedTrimmed(this.nextText(parser, strict), "defaultGoal"));
                    break;
                }
                case "resources": {
                    ArrayList<Resource> resources = new ArrayList<Resource>();
                    while (parser.nextTag() == 1) {
                        if ("resource".equals(parser.getLocalName())) {
                            resources.add(this.parseResource(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    build.resources(resources);
                    break;
                }
                case "testResources": {
                    ArrayList<Resource> testResources = new ArrayList<Resource>();
                    while (parser.nextTag() == 1) {
                        if ("testResource".equals(parser.getLocalName())) {
                            testResources.add(this.parseResource(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    build.testResources(testResources);
                    break;
                }
                case "directory": {
                    build.directory(this.interpolatedTrimmed(this.nextText(parser, strict), "directory"));
                    break;
                }
                case "finalName": {
                    build.finalName(this.interpolatedTrimmed(this.nextText(parser, strict), "finalName"));
                    break;
                }
                case "filters": {
                    ArrayList<String> filters = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("filter".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            filters.add(this.interpolatedTrimmed(this.nextText(parser, strict), "filters"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    build.filters(filters);
                    break;
                }
                case "pluginManagement": {
                    build.pluginManagement(this.parsePluginManagement(parser, strict, source));
                    break;
                }
                case "plugins": {
                    ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                    while (parser.nextTag() == 1) {
                        if ("plugin".equals(parser.getLocalName())) {
                            plugins.add(this.parsePlugin(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    build.plugins(plugins);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            build.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return build.build();
    }

    private CiManagement parseCiManagement(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        CiManagement.Builder ciManagement = CiManagement.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            ciManagement.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "system": {
                    ciManagement.system(this.interpolatedTrimmed(this.nextText(parser, strict), "system"));
                    break;
                }
                case "url": {
                    ciManagement.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "notifiers": {
                    ArrayList<Notifier> notifiers = new ArrayList<Notifier>();
                    while (parser.nextTag() == 1) {
                        if ("notifier".equals(parser.getLocalName())) {
                            notifiers.add(this.parseNotifier(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    ciManagement.notifiers(notifiers);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            ciManagement.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return ciManagement.build();
    }

    private Notifier parseNotifier(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Notifier.Builder notifier = Notifier.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            notifier.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<String, InputLocation> locations = null;
            switch (childName) {
                case "type": {
                    notifier.type(this.interpolatedTrimmed(this.nextText(parser, strict), "type"));
                    break;
                }
                case "sendOnError": {
                    notifier.sendOnError(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "sendOnError"), "sendOnError", parser, true));
                    break;
                }
                case "sendOnFailure": {
                    notifier.sendOnFailure(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "sendOnFailure"), "sendOnFailure", parser, true));
                    break;
                }
                case "sendOnSuccess": {
                    notifier.sendOnSuccess(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "sendOnSuccess"), "sendOnSuccess", parser, true));
                    break;
                }
                case "sendOnWarning": {
                    notifier.sendOnWarning(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "sendOnWarning"), "sendOnWarning", parser, true));
                    break;
                }
                case "address": {
                    notifier.address(this.interpolatedTrimmed(this.nextText(parser, strict), "address"));
                    break;
                }
                case "configuration": {
                    LinkedHashMap<String, String> configuration = new LinkedHashMap<String, String>();
                    locations = new HashMap<String, InputLocation>();
                    while (parser.nextTag() == 1) {
                        String key = parser.getLocalName();
                        String value = this.nextText(parser, strict).trim();
                        if (this.addLocationInformation) {
                            locations.put(key, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                        }
                        configuration.put(key, value);
                    }
                    notifier.configuration(configuration);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            notifier.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return notifier.build();
    }

    private Contributor parseContributor(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Contributor.Builder contributor = Contributor.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            contributor.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Object, InputLocation> locations = null;
            switch (childName) {
                case "name": {
                    contributor.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "email": {
                    contributor.email(this.interpolatedTrimmed(this.nextText(parser, strict), "email"));
                    break;
                }
                case "url": {
                    contributor.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "organization": {
                    contributor.organization(this.interpolatedTrimmed(this.nextText(parser, strict), "organization"));
                    break;
                }
                case "organizationUrl": {
                    contributor.organizationUrl(this.interpolatedTrimmed(this.nextText(parser, strict), "organizationUrl"));
                    break;
                }
                case "roles": {
                    ArrayList<String> roles = new ArrayList<String>();
                    locations = new HashMap<Object, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("role".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            roles.add(this.interpolatedTrimmed(this.nextText(parser, strict), "roles"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    contributor.roles(roles);
                    break;
                }
                case "timezone": {
                    contributor.timezone(this.interpolatedTrimmed(this.nextText(parser, strict), "timezone"));
                    break;
                }
                case "properties": {
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        String key = parser.getLocalName();
                        String value = this.nextText(parser, strict).trim();
                        if (this.addLocationInformation) {
                            locations.put(key, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                        }
                        properties.put(key, value);
                    }
                    contributor.properties(properties);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            contributor.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return contributor.build();
    }

    private Dependency parseDependency(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Dependency.Builder dependency = Dependency.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            dependency.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    dependency.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    dependency.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    dependency.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "type": {
                    dependency.type(this.interpolatedTrimmed(this.nextText(parser, strict), "type"));
                    break;
                }
                case "classifier": {
                    dependency.classifier(this.interpolatedTrimmed(this.nextText(parser, strict), "classifier"));
                    break;
                }
                case "scope": {
                    dependency.scope(this.interpolatedTrimmed(this.nextText(parser, strict), "scope"));
                    break;
                }
                case "systemPath": {
                    dependency.systemPath(this.interpolatedTrimmed(this.nextText(parser, strict), "systemPath"));
                    break;
                }
                case "exclusions": {
                    ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
                    while (parser.nextTag() == 1) {
                        if ("exclusion".equals(parser.getLocalName())) {
                            exclusions.add(this.parseExclusion(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    dependency.exclusions(exclusions);
                    break;
                }
                case "optional": {
                    dependency.optional(this.interpolatedTrimmed(this.nextText(parser, strict), "optional"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            dependency.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return dependency.build();
    }

    private Developer parseDeveloper(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Developer.Builder developer = Developer.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            developer.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Object, InputLocation> locations = null;
            switch (childName) {
                case "id": {
                    developer.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "name": {
                    developer.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "email": {
                    developer.email(this.interpolatedTrimmed(this.nextText(parser, strict), "email"));
                    break;
                }
                case "url": {
                    developer.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "organization": {
                    developer.organization(this.interpolatedTrimmed(this.nextText(parser, strict), "organization"));
                    break;
                }
                case "organizationUrl": {
                    developer.organizationUrl(this.interpolatedTrimmed(this.nextText(parser, strict), "organizationUrl"));
                    break;
                }
                case "roles": {
                    ArrayList<String> roles = new ArrayList<String>();
                    locations = new HashMap<Object, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("role".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            roles.add(this.interpolatedTrimmed(this.nextText(parser, strict), "roles"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    developer.roles(roles);
                    break;
                }
                case "timezone": {
                    developer.timezone(this.interpolatedTrimmed(this.nextText(parser, strict), "timezone"));
                    break;
                }
                case "properties": {
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        String key = parser.getLocalName();
                        String value = this.nextText(parser, strict).trim();
                        if (this.addLocationInformation) {
                            locations.put(key, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                        }
                        properties.put(key, value);
                    }
                    developer.properties(properties);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            developer.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return developer.build();
    }

    private Exclusion parseExclusion(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Exclusion.Builder exclusion = Exclusion.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            exclusion.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    exclusion.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    exclusion.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            exclusion.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return exclusion.build();
    }

    private IssueManagement parseIssueManagement(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        IssueManagement.Builder issueManagement = IssueManagement.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            issueManagement.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "system": {
                    issueManagement.system(this.interpolatedTrimmed(this.nextText(parser, strict), "system"));
                    break;
                }
                case "url": {
                    issueManagement.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            issueManagement.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return issueManagement.build();
    }

    private DistributionManagement parseDistributionManagement(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        DistributionManagement.Builder distributionManagement = DistributionManagement.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            distributionManagement.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "repository": {
                    distributionManagement.repository(this.parseDeploymentRepository(parser, strict, source));
                    break;
                }
                case "snapshotRepository": {
                    distributionManagement.snapshotRepository(this.parseDeploymentRepository(parser, strict, source));
                    break;
                }
                case "site": {
                    distributionManagement.site(this.parseSite(parser, strict, source));
                    break;
                }
                case "downloadUrl": {
                    distributionManagement.downloadUrl(this.interpolatedTrimmed(this.nextText(parser, strict), "downloadUrl"));
                    break;
                }
                case "relocation": {
                    distributionManagement.relocation(this.parseRelocation(parser, strict, source));
                    break;
                }
                case "status": {
                    distributionManagement.status(this.interpolatedTrimmed(this.nextText(parser, strict), "status"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            distributionManagement.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return distributionManagement.build();
    }

    private License parseLicense(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        License.Builder license = License.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            license.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "name": {
                    license.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    license.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "distribution": {
                    license.distribution(this.interpolatedTrimmed(this.nextText(parser, strict), "distribution"));
                    break;
                }
                case "comments": {
                    license.comments(this.interpolatedTrimmed(this.nextText(parser, strict), "comments"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            license.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return license.build();
    }

    private MailingList parseMailingList(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        MailingList.Builder mailingList = MailingList.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            mailingList.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "name": {
                    mailingList.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "subscribe": {
                    mailingList.subscribe(this.interpolatedTrimmed(this.nextText(parser, strict), "subscribe"));
                    break;
                }
                case "unsubscribe": {
                    mailingList.unsubscribe(this.interpolatedTrimmed(this.nextText(parser, strict), "unsubscribe"));
                    break;
                }
                case "post": {
                    mailingList.post(this.interpolatedTrimmed(this.nextText(parser, strict), "post"));
                    break;
                }
                case "archive": {
                    mailingList.archive(this.interpolatedTrimmed(this.nextText(parser, strict), "archive"));
                    break;
                }
                case "otherArchives": {
                    ArrayList<String> otherArchives = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("otherArchive".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            otherArchives.add(this.interpolatedTrimmed(this.nextText(parser, strict), "otherArchives"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    mailingList.otherArchives(otherArchives);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            mailingList.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return mailingList.build();
    }

    private Organization parseOrganization(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Organization.Builder organization = Organization.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            organization.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "name": {
                    organization.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    organization.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            organization.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return organization.build();
    }

    private PatternSet parsePatternSet(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        PatternSet.Builder patternSet = PatternSet.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            patternSet.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "includes": {
                    ArrayList<String> includes = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("include".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            includes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "includes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    patternSet.includes(includes);
                    break;
                }
                case "excludes": {
                    ArrayList<String> excludes = new ArrayList<String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        if ("exclude".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            excludes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "excludes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    patternSet.excludes(excludes);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            patternSet.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return patternSet.build();
    }

    private Parent parseParent(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Parent.Builder parent = Parent.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            parent.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    parent.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    parent.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    parent.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "relativePath": {
                    parent.relativePath(this.interpolatedTrimmed(this.nextText(parser, strict), "relativePath"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            parent.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return parent.build();
    }

    private Scm parseScm(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Scm.Builder scm = Scm.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            scm.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            if ("child.scm.connection.inherit.append.path".equals(name)) {
                if (this.addLocationInformation) {
                    scm.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                }
                scm.childScmConnectionInheritAppendPath(this.interpolatedTrimmed(value, "child.scm.connection.inherit.append.path"));
                continue;
            }
            if ("child.scm.developerConnection.inherit.append.path".equals(name)) {
                if (this.addLocationInformation) {
                    scm.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                }
                scm.childScmDeveloperConnectionInheritAppendPath(this.interpolatedTrimmed(value, "child.scm.developerConnection.inherit.append.path"));
                continue;
            }
            if ("child.scm.url.inherit.append.path".equals(name)) {
                if (this.addLocationInformation) {
                    scm.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                }
                scm.childScmUrlInheritAppendPath(this.interpolatedTrimmed(value, "child.scm.url.inherit.append.path"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "connection": {
                    scm.connection(this.interpolatedTrimmed(this.nextText(parser, strict), "connection"));
                    break;
                }
                case "developerConnection": {
                    scm.developerConnection(this.interpolatedTrimmed(this.nextText(parser, strict), "developerConnection"));
                    break;
                }
                case "tag": {
                    scm.tag(this.interpolatedTrimmed(this.nextText(parser, strict), "tag"));
                    break;
                }
                case "url": {
                    scm.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            scm.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return scm.build();
    }

    private FileSet parseFileSet(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        FileSet.Builder fileSet = FileSet.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            fileSet.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "directory": {
                    fileSet.directory(this.interpolatedTrimmed(this.nextText(parser, strict), "directory"));
                    break;
                }
                case "includes": {
                    ArrayList<String> includes = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("include".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            includes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "includes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    fileSet.includes(includes);
                    break;
                }
                case "excludes": {
                    ArrayList<String> excludes = new ArrayList<String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        if ("exclude".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            excludes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "excludes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    fileSet.excludes(excludes);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            fileSet.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return fileSet.build();
    }

    private Resource parseResource(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Resource.Builder resource = Resource.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            resource.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "targetPath": {
                    resource.targetPath(this.interpolatedTrimmed(this.nextText(parser, strict), "targetPath"));
                    break;
                }
                case "filtering": {
                    resource.filtering(this.interpolatedTrimmed(this.nextText(parser, strict), "filtering"));
                    break;
                }
                case "directory": {
                    resource.directory(this.interpolatedTrimmed(this.nextText(parser, strict), "directory"));
                    break;
                }
                case "includes": {
                    ArrayList<String> includes = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("include".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            includes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "includes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    resource.includes(includes);
                    break;
                }
                case "excludes": {
                    ArrayList<String> excludes = new ArrayList<String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        if ("exclude".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            excludes.add(this.interpolatedTrimmed(this.nextText(parser, strict), "excludes"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    resource.excludes(excludes);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            resource.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return resource.build();
    }

    private RepositoryBase parseRepositoryBase(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        RepositoryBase.Builder repositoryBase = RepositoryBase.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            repositoryBase.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "id": {
                    repositoryBase.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "name": {
                    repositoryBase.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    repositoryBase.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "layout": {
                    repositoryBase.layout(this.interpolatedTrimmed(this.nextText(parser, strict), "layout"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            repositoryBase.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return repositoryBase.build();
    }

    private Repository parseRepository(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Repository.Builder repository = Repository.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            repository.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "releases": {
                    repository.releases(this.parseRepositoryPolicy(parser, strict, source));
                    break;
                }
                case "snapshots": {
                    repository.snapshots(this.parseRepositoryPolicy(parser, strict, source));
                    break;
                }
                case "id": {
                    repository.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "name": {
                    repository.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    repository.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "layout": {
                    repository.layout(this.interpolatedTrimmed(this.nextText(parser, strict), "layout"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            repository.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return repository.build();
    }

    private DeploymentRepository parseDeploymentRepository(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        DeploymentRepository.Builder deploymentRepository = DeploymentRepository.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            deploymentRepository.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "uniqueVersion": {
                    deploymentRepository.uniqueVersion(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "uniqueVersion"), "uniqueVersion", parser, true));
                    break;
                }
                case "releases": {
                    deploymentRepository.releases(this.parseRepositoryPolicy(parser, strict, source));
                    break;
                }
                case "snapshots": {
                    deploymentRepository.snapshots(this.parseRepositoryPolicy(parser, strict, source));
                    break;
                }
                case "id": {
                    deploymentRepository.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "name": {
                    deploymentRepository.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    deploymentRepository.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                case "layout": {
                    deploymentRepository.layout(this.interpolatedTrimmed(this.nextText(parser, strict), "layout"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            deploymentRepository.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return deploymentRepository.build();
    }

    private RepositoryPolicy parseRepositoryPolicy(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        RepositoryPolicy.Builder repositoryPolicy = RepositoryPolicy.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            repositoryPolicy.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "enabled": {
                    repositoryPolicy.enabled(this.interpolatedTrimmed(this.nextText(parser, strict), "enabled"));
                    break;
                }
                case "updatePolicy": {
                    repositoryPolicy.updatePolicy(this.interpolatedTrimmed(this.nextText(parser, strict), "updatePolicy"));
                    break;
                }
                case "checksumPolicy": {
                    repositoryPolicy.checksumPolicy(this.interpolatedTrimmed(this.nextText(parser, strict), "checksumPolicy"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            repositoryPolicy.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return repositoryPolicy.build();
    }

    private Site parseSite(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Site.Builder site = Site.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            site.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            if ("child.site.url.inherit.append.path".equals(name)) {
                if (this.addLocationInformation) {
                    site.location((Object)name, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                }
                site.childSiteUrlInheritAppendPath(this.interpolatedTrimmed(value, "child.site.url.inherit.append.path"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "id": {
                    site.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "name": {
                    site.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "url": {
                    site.url(this.interpolatedTrimmed(this.nextText(parser, strict), "url"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            site.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return site.build();
    }

    private ConfigurationContainer parseConfigurationContainer(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ConfigurationContainer.Builder configurationContainer = ConfigurationContainer.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            configurationContainer.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "inherited": {
                    configurationContainer.inherited(this.interpolatedTrimmed(this.nextText(parser, strict), "inherited"));
                    break;
                }
                case "configuration": {
                    configurationContainer.configuration(this.buildXmlNode(parser, source));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            configurationContainer.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return configurationContainer.build();
    }

    private Plugin parsePlugin(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Plugin.Builder plugin = Plugin.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            plugin.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    plugin.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    plugin.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    plugin.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "extensions": {
                    plugin.extensions(this.interpolatedTrimmed(this.nextText(parser, strict), "extensions"));
                    break;
                }
                case "executions": {
                    ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
                    while (parser.nextTag() == 1) {
                        if ("execution".equals(parser.getLocalName())) {
                            executions.add(this.parsePluginExecution(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    plugin.executions(executions);
                    break;
                }
                case "dependencies": {
                    ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                    while (parser.nextTag() == 1) {
                        if ("dependency".equals(parser.getLocalName())) {
                            dependencies.add(this.parseDependency(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    plugin.dependencies(dependencies);
                    break;
                }
                case "inherited": {
                    plugin.inherited(this.interpolatedTrimmed(this.nextText(parser, strict), "inherited"));
                    break;
                }
                case "configuration": {
                    plugin.configuration(this.buildXmlNode(parser, source));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            plugin.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return plugin.build();
    }

    private PluginExecution parsePluginExecution(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        PluginExecution.Builder pluginExecution = PluginExecution.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            pluginExecution.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "id": {
                    pluginExecution.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "phase": {
                    pluginExecution.phase(this.interpolatedTrimmed(this.nextText(parser, strict), "phase"));
                    break;
                }
                case "priority": {
                    pluginExecution.priority(this.getIntegerValue(this.interpolatedTrimmed(this.nextText(parser, strict), "priority"), "priority", parser, strict, 0));
                    break;
                }
                case "goals": {
                    ArrayList<String> goals = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("goal".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            goals.add(this.interpolatedTrimmed(this.nextText(parser, strict), "goals"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    pluginExecution.goals(goals);
                    break;
                }
                case "inherited": {
                    pluginExecution.inherited(this.interpolatedTrimmed(this.nextText(parser, strict), "inherited"));
                    break;
                }
                case "configuration": {
                    pluginExecution.configuration(this.buildXmlNode(parser, source));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            pluginExecution.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return pluginExecution.build();
    }

    private DependencyManagement parseDependencyManagement(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        DependencyManagement.Builder dependencyManagement = DependencyManagement.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            dependencyManagement.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "dependencies": {
                    ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                    while (parser.nextTag() == 1) {
                        if ("dependency".equals(parser.getLocalName())) {
                            dependencies.add(this.parseDependency(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    dependencyManagement.dependencies(dependencies);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            dependencyManagement.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return dependencyManagement.build();
    }

    private PluginManagement parsePluginManagement(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        PluginManagement.Builder pluginManagement = PluginManagement.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            pluginManagement.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "plugins": {
                    ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                    while (parser.nextTag() == 1) {
                        if ("plugin".equals(parser.getLocalName())) {
                            plugins.add(this.parsePlugin(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    pluginManagement.plugins(plugins);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            pluginManagement.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return pluginManagement.build();
    }

    private Reporting parseReporting(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Reporting.Builder reporting = Reporting.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            reporting.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "excludeDefaults": {
                    reporting.excludeDefaults(this.interpolatedTrimmed(this.nextText(parser, strict), "excludeDefaults"));
                    break;
                }
                case "outputDirectory": {
                    reporting.outputDirectory(this.interpolatedTrimmed(this.nextText(parser, strict), "outputDirectory"));
                    break;
                }
                case "plugins": {
                    ArrayList<ReportPlugin> plugins = new ArrayList<ReportPlugin>();
                    while (parser.nextTag() == 1) {
                        if ("plugin".equals(parser.getLocalName())) {
                            plugins.add(this.parseReportPlugin(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    reporting.plugins(plugins);
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            reporting.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return reporting.build();
    }

    private Profile parseProfile(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Profile.Builder profile = Profile.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            profile.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Object, InputLocation> locations = null;
            switch (childName) {
                case "id": {
                    profile.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "activation": {
                    profile.activation(this.parseActivation(parser, strict, source));
                    break;
                }
                case "build": {
                    profile.build(this.parseBuildBase(parser, strict, source));
                    break;
                }
                case "modules": {
                    ArrayList<String> modules = new ArrayList<String>();
                    locations = new HashMap<Object, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("module".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            modules.add(this.interpolatedTrimmed(this.nextText(parser, strict), "modules"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.modules(modules);
                    break;
                }
                case "distributionManagement": {
                    profile.distributionManagement(this.parseDistributionManagement(parser, strict, source));
                    break;
                }
                case "properties": {
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    locations = new HashMap();
                    while (parser.nextTag() == 1) {
                        String key = parser.getLocalName();
                        String value = this.nextText(parser, strict).trim();
                        if (this.addLocationInformation) {
                            locations.put(key, new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                        }
                        properties.put(key, value);
                    }
                    profile.properties(properties);
                    break;
                }
                case "dependencyManagement": {
                    profile.dependencyManagement(this.parseDependencyManagement(parser, strict, source));
                    break;
                }
                case "dependencies": {
                    ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                    while (parser.nextTag() == 1) {
                        if ("dependency".equals(parser.getLocalName())) {
                            dependencies.add(this.parseDependency(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.dependencies(dependencies);
                    break;
                }
                case "repositories": {
                    ArrayList<Repository> repositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("repository".equals(parser.getLocalName())) {
                            repositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.repositories(repositories);
                    break;
                }
                case "pluginRepositories": {
                    ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                    while (parser.nextTag() == 1) {
                        if ("pluginRepository".equals(parser.getLocalName())) {
                            pluginRepositories.add(this.parseRepository(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    profile.pluginRepositories(pluginRepositories);
                    break;
                }
                case "reporting": {
                    profile.reporting(this.parseReporting(parser, strict, source));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            profile.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return profile.build();
    }

    private Activation parseActivation(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Activation.Builder activation = Activation.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            activation.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "activeByDefault": {
                    activation.activeByDefault(this.getBooleanValue(this.interpolatedTrimmed(this.nextText(parser, strict), "activeByDefault"), "activeByDefault", parser, false));
                    break;
                }
                case "jdk": {
                    activation.jdk(this.interpolatedTrimmed(this.nextText(parser, strict), "jdk"));
                    break;
                }
                case "os": {
                    activation.os(this.parseActivationOS(parser, strict, source));
                    break;
                }
                case "property": {
                    activation.property(this.parseActivationProperty(parser, strict, source));
                    break;
                }
                case "file": {
                    activation.file(this.parseActivationFile(parser, strict, source));
                    break;
                }
                case "packaging": {
                    activation.packaging(this.interpolatedTrimmed(this.nextText(parser, strict), "packaging"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            activation.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return activation.build();
    }

    private ActivationProperty parseActivationProperty(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ActivationProperty.Builder activationProperty = ActivationProperty.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            activationProperty.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "name": {
                    activationProperty.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "value": {
                    activationProperty.value(this.interpolatedTrimmed(this.nextText(parser, strict), "value"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            activationProperty.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return activationProperty.build();
    }

    private ActivationOS parseActivationOS(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ActivationOS.Builder activationOS = ActivationOS.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            activationOS.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "name": {
                    activationOS.name(this.interpolatedTrimmed(this.nextText(parser, strict), "name"));
                    break;
                }
                case "family": {
                    activationOS.family(this.interpolatedTrimmed(this.nextText(parser, strict), "family"));
                    break;
                }
                case "arch": {
                    activationOS.arch(this.interpolatedTrimmed(this.nextText(parser, strict), "arch"));
                    break;
                }
                case "version": {
                    activationOS.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            activationOS.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return activationOS.build();
    }

    private ActivationFile parseActivationFile(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ActivationFile.Builder activationFile = ActivationFile.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            activationFile.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "missing": {
                    activationFile.missing(this.interpolatedTrimmed(this.nextText(parser, strict), "missing"));
                    break;
                }
                case "exists": {
                    activationFile.exists(this.interpolatedTrimmed(this.nextText(parser, strict), "exists"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            activationFile.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return activationFile.build();
    }

    private ReportPlugin parseReportPlugin(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ReportPlugin.Builder reportPlugin = ReportPlugin.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            reportPlugin.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    reportPlugin.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    reportPlugin.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    reportPlugin.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "reportSets": {
                    ArrayList<ReportSet> reportSets = new ArrayList<ReportSet>();
                    while (parser.nextTag() == 1) {
                        if ("reportSet".equals(parser.getLocalName())) {
                            reportSets.add(this.parseReportSet(parser, strict, source));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    reportPlugin.reportSets(reportSets);
                    break;
                }
                case "inherited": {
                    reportPlugin.inherited(this.interpolatedTrimmed(this.nextText(parser, strict), "inherited"));
                    break;
                }
                case "configuration": {
                    reportPlugin.configuration(this.buildXmlNode(parser, source));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            reportPlugin.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return reportPlugin.build();
    }

    private ReportSet parseReportSet(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        ReportSet.Builder reportSet = ReportSet.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            reportSet.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            HashMap<Integer, InputLocation> locations = null;
            switch (childName) {
                case "id": {
                    reportSet.id(this.interpolatedTrimmed(this.nextText(parser, strict), "id"));
                    break;
                }
                case "reports": {
                    ArrayList<String> reports = new ArrayList<String>();
                    locations = new HashMap<Integer, InputLocation>();
                    while (parser.nextTag() == 1) {
                        if ("report".equals(parser.getLocalName())) {
                            if (this.addLocationInformation) {
                                locations.put(locations.size(), new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
                            }
                            reports.add(this.interpolatedTrimmed(this.nextText(parser, strict), "reports"));
                            continue;
                        }
                        this.checkUnknownElement(parser, strict);
                    }
                    reportSet.reports(reports);
                    break;
                }
                case "inherited": {
                    reportSet.inherited(this.interpolatedTrimmed(this.nextText(parser, strict), "inherited"));
                    break;
                }
                case "configuration": {
                    reportSet.configuration(this.buildXmlNode(parser, source));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            reportSet.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return reportSet.build();
    }

    private Prerequisites parsePrerequisites(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Prerequisites.Builder prerequisites = Prerequisites.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            prerequisites.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "maven": {
                    prerequisites.maven(this.interpolatedTrimmed(this.nextText(parser, strict), "maven"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            prerequisites.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return prerequisites.build();
    }

    private Relocation parseRelocation(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Relocation.Builder relocation = Relocation.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            relocation.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    relocation.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    relocation.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    relocation.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "message": {
                    relocation.message(this.interpolatedTrimmed(this.nextText(parser, strict), "message"));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            relocation.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return relocation.build();
    }

    private Extension parseExtension(XMLStreamReader parser, boolean strict, InputSource source) throws XMLStreamException {
        String tagName = parser.getLocalName();
        Extension.Builder extension = Extension.newBuilder((boolean)true);
        if (this.addLocationInformation) {
            extension.location((Object)"", new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source));
        }
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeLocalName(i);
            String ns = parser.getAttributeNamespace(i);
            String value = parser.getAttributeValue(i);
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 1) {
            String childName = this.checkDuplicate(parser.getLocalName(), parser, parsed);
            int line = this.addLocationInformation ? parser.getLocation().getLineNumber() : -1;
            int column = this.addLocationInformation ? parser.getLocation().getColumnNumber() : -1;
            Map locations = null;
            switch (childName) {
                case "groupId": {
                    extension.groupId(this.interpolatedTrimmed(this.nextText(parser, strict), "groupId"));
                    break;
                }
                case "artifactId": {
                    extension.artifactId(this.interpolatedTrimmed(this.nextText(parser, strict), "artifactId"));
                    break;
                }
                case "version": {
                    extension.version(this.interpolatedTrimmed(this.nextText(parser, strict), "version"));
                    break;
                }
                case "configuration": {
                    extension.configuration(this.buildXmlNode(parser, source));
                    break;
                }
                default: {
                    this.checkUnknownElement(parser, strict);
                }
            }
            if (!this.addLocationInformation) continue;
            extension.location((Object)childName, new InputLocation(line, column, source, locations));
        }
        return extension.build();
    }

    private String checkDuplicate(String tagName, XMLStreamReader parser, Set<String> parsed) throws XMLStreamException {
        switch (tagName) {
            case "organisation": {
                tagName = "organization";
                break;
            }
            case "organisationUrl": {
                tagName = "organizationUrl";
            }
        }
        if (!parsed.add(tagName)) {
            throw new XMLStreamException("Duplicated tag: '" + tagName + "'", parser.getLocation(), null);
        }
        return tagName;
    }

    private void checkUnknownAttribute(XMLStreamReader parser, String attribute, String tagName, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser.getLocation(), null);
        }
    }

    private void checkUnknownElement(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unrecognised tag: '" + String.valueOf(parser.getName()) + "'", parser.getLocation(), null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = this.nextTag(parser);
            if (eventType == 1) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 2) continue;
            --unrecognizedTagCount;
        }
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XMLStreamReader parser) throws XMLStreamException {
        block4: while (true) {
            int next = parser.next();
            switch (next) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 12: {
                    continue block4;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
        }
    }

    private String nextText(XMLStreamReader parser, boolean strict) throws XMLStreamException {
        int eventType = parser.getEventType();
        if (eventType != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", parser.getLocation(), null);
        }
        eventType = parser.next();
        StringBuilder result = new StringBuilder();
        while (true) {
            if (eventType == 4 || eventType == 12) {
                result.append(parser.getText());
            } else if (eventType == 9) {
                String val = null;
                if (strict) {
                    throw new XMLStreamException("Entities are not supported in strict mode", parser.getLocation(), null);
                }
                if (this.addDefaultEntities) {
                    val = DEFAULT_ENTITIES.get(parser.getLocalName());
                }
                if (val != null) {
                    result.append(val);
                } else {
                    result.append("&").append(parser.getLocalName()).append(";");
                }
            } else if (eventType != 5) break;
            eventType = parser.next();
        }
        if (eventType != 2) {
            throw new XMLStreamException("TEXT must be immediately followed by END_ELEMENT and not " + eventType, parser.getLocation(), null);
        }
        return result.toString();
    }

    private XmlNode buildXmlNode(XMLStreamReader parser, InputSource source) throws XMLStreamException {
        return XmlNodeBuilder.build((XMLStreamReader)parser, this.addLocationInformation ? p -> new InputLocation(parser.getLocation().getLineNumber(), parser.getLocation().getColumnNumber(), source) : null);
    }

    private boolean getBooleanValue(String s, String attribute, XMLStreamReader parser, boolean defaultValue) throws XMLStreamException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        return defaultValue;
    }

    private int getIntegerValue(String s, String attribute, XMLStreamReader parser, boolean strict, int defaultValue) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer", parser.getLocation(), nfe);
                }
            }
        }
        return defaultValue;
    }

    static {
        HashMap<String, String> entities = new HashMap<String, String>();
        entities.put("nbsp", "\u00a0");
        entities.put("iexcl", "\u00a1");
        entities.put("cent", "\u00a2");
        entities.put("pound", "\u00a3");
        entities.put("curren", "\u00a4");
        entities.put("yen", "\u00a5");
        entities.put("brvbar", "\u00a6");
        entities.put("sect", "\u00a7");
        entities.put("uml", "\u00a8");
        entities.put("copy", "\u00a9");
        entities.put("ordf", "\u00aa");
        entities.put("laquo", "\u00ab");
        entities.put("not", "\u00ac");
        entities.put("shy", "\u00ad");
        entities.put("reg", "\u00ae");
        entities.put("macr", "\u00af");
        entities.put("deg", "\u00b0");
        entities.put("plusmn", "\u00b1");
        entities.put("sup2", "\u00b2");
        entities.put("sup3", "\u00b3");
        entities.put("acute", "\u00b4");
        entities.put("micro", "\u00b5");
        entities.put("para", "\u00b6");
        entities.put("middot", "\u00b7");
        entities.put("cedil", "\u00b8");
        entities.put("sup1", "\u00b9");
        entities.put("ordm", "\u00ba");
        entities.put("raquo", "\u00bb");
        entities.put("frac14", "\u00bc");
        entities.put("frac12", "\u00bd");
        entities.put("frac34", "\u00be");
        entities.put("iquest", "\u00bf");
        entities.put("Agrave", "\u00c0");
        entities.put("Aacute", "\u00c1");
        entities.put("Acirc", "\u00c2");
        entities.put("Atilde", "\u00c3");
        entities.put("Auml", "\u00c4");
        entities.put("Aring", "\u00c5");
        entities.put("AElig", "\u00c6");
        entities.put("Ccedil", "\u00c7");
        entities.put("Egrave", "\u00c8");
        entities.put("Eacute", "\u00c9");
        entities.put("Ecirc", "\u00ca");
        entities.put("Euml", "\u00cb");
        entities.put("Igrave", "\u00cc");
        entities.put("Iacute", "\u00cd");
        entities.put("Icirc", "\u00ce");
        entities.put("Iuml", "\u00cf");
        entities.put("ETH", "\u00d0");
        entities.put("Ntilde", "\u00d1");
        entities.put("Ograve", "\u00d2");
        entities.put("Oacute", "\u00d3");
        entities.put("Ocirc", "\u00d4");
        entities.put("Otilde", "\u00d5");
        entities.put("Ouml", "\u00d6");
        entities.put("times", "\u00d7");
        entities.put("Oslash", "\u00d8");
        entities.put("Ugrave", "\u00d9");
        entities.put("Uacute", "\u00da");
        entities.put("Ucirc", "\u00db");
        entities.put("Uuml", "\u00dc");
        entities.put("Yacute", "\u00dd");
        entities.put("THORN", "\u00de");
        entities.put("szlig", "\u00df");
        entities.put("agrave", "\u00e0");
        entities.put("aacute", "\u00e1");
        entities.put("acirc", "\u00e2");
        entities.put("atilde", "\u00e3");
        entities.put("auml", "\u00e4");
        entities.put("aring", "\u00e5");
        entities.put("aelig", "\u00e6");
        entities.put("ccedil", "\u00e7");
        entities.put("egrave", "\u00e8");
        entities.put("eacute", "\u00e9");
        entities.put("ecirc", "\u00ea");
        entities.put("euml", "\u00eb");
        entities.put("igrave", "\u00ec");
        entities.put("iacute", "\u00ed");
        entities.put("icirc", "\u00ee");
        entities.put("iuml", "\u00ef");
        entities.put("eth", "\u00f0");
        entities.put("ntilde", "\u00f1");
        entities.put("ograve", "\u00f2");
        entities.put("oacute", "\u00f3");
        entities.put("ocirc", "\u00f4");
        entities.put("otilde", "\u00f5");
        entities.put("ouml", "\u00f6");
        entities.put("divide", "\u00f7");
        entities.put("oslash", "\u00f8");
        entities.put("ugrave", "\u00f9");
        entities.put("uacute", "\u00fa");
        entities.put("ucirc", "\u00fb");
        entities.put("uuml", "\u00fc");
        entities.put("yacute", "\u00fd");
        entities.put("thorn", "\u00fe");
        entities.put("yuml", "\u00ff");
        entities.put("OElig", "\u0152");
        entities.put("oelig", "\u0153");
        entities.put("Scaron", "\u0160");
        entities.put("scaron", "\u0161");
        entities.put("Yuml", "\u0178");
        entities.put("circ", "\u02c6");
        entities.put("tilde", "\u02dc");
        entities.put("ensp", "\u2002");
        entities.put("emsp", "\u2003");
        entities.put("thinsp", "\u2009");
        entities.put("zwnj", "\u200c");
        entities.put("zwj", "\u200d");
        entities.put("lrm", "\u200e");
        entities.put("rlm", "\u200f");
        entities.put("ndash", "\u2013");
        entities.put("mdash", "\u2014");
        entities.put("lsquo", "\u2018");
        entities.put("rsquo", "\u2019");
        entities.put("sbquo", "\u201a");
        entities.put("ldquo", "\u201c");
        entities.put("rdquo", "\u201d");
        entities.put("bdquo", "\u201e");
        entities.put("dagger", "\u2020");
        entities.put("Dagger", "\u2021");
        entities.put("permil", "\u2030");
        entities.put("lsaquo", "\u2039");
        entities.put("rsaquo", "\u203a");
        entities.put("euro", "\u20ac");
        entities.put("fnof", "\u0192");
        entities.put("Alpha", "\u0391");
        entities.put("Beta", "\u0392");
        entities.put("Gamma", "\u0393");
        entities.put("Delta", "\u0394");
        entities.put("Epsilon", "\u0395");
        entities.put("Zeta", "\u0396");
        entities.put("Eta", "\u0397");
        entities.put("Theta", "\u0398");
        entities.put("Iota", "\u0399");
        entities.put("Kappa", "\u039a");
        entities.put("Lambda", "\u039b");
        entities.put("Mu", "\u039c");
        entities.put("Nu", "\u039d");
        entities.put("Xi", "\u039e");
        entities.put("Omicron", "\u039f");
        entities.put("Pi", "\u03a0");
        entities.put("Rho", "\u03a1");
        entities.put("Sigma", "\u03a3");
        entities.put("Tau", "\u03a4");
        entities.put("Upsilon", "\u03a5");
        entities.put("Phi", "\u03a6");
        entities.put("Chi", "\u03a7");
        entities.put("Psi", "\u03a8");
        entities.put("Omega", "\u03a9");
        entities.put("alpha", "\u03b1");
        entities.put("beta", "\u03b2");
        entities.put("gamma", "\u03b3");
        entities.put("delta", "\u03b4");
        entities.put("epsilon", "\u03b5");
        entities.put("zeta", "\u03b6");
        entities.put("eta", "\u03b7");
        entities.put("theta", "\u03b8");
        entities.put("iota", "\u03b9");
        entities.put("kappa", "\u03ba");
        entities.put("lambda", "\u03bb");
        entities.put("mu", "\u03bc");
        entities.put("nu", "\u03bd");
        entities.put("xi", "\u03be");
        entities.put("omicron", "\u03bf");
        entities.put("pi", "\u03c0");
        entities.put("rho", "\u03c1");
        entities.put("sigmaf", "\u03c2");
        entities.put("sigma", "\u03c3");
        entities.put("tau", "\u03c4");
        entities.put("upsilon", "\u03c5");
        entities.put("phi", "\u03c6");
        entities.put("chi", "\u03c7");
        entities.put("psi", "\u03c8");
        entities.put("omega", "\u03c9");
        entities.put("thetasym", "\u03d1");
        entities.put("upsih", "\u03d2");
        entities.put("piv", "\u03d6");
        entities.put("bull", "\u2022");
        entities.put("hellip", "\u2026");
        entities.put("prime", "\u2032");
        entities.put("Prime", "\u2033");
        entities.put("oline", "\u203e");
        entities.put("frasl", "\u2044");
        entities.put("weierp", "\u2118");
        entities.put("image", "\u2111");
        entities.put("real", "\u211c");
        entities.put("trade", "\u2122");
        entities.put("alefsym", "\u2135");
        entities.put("larr", "\u2190");
        entities.put("uarr", "\u2191");
        entities.put("rarr", "\u2192");
        entities.put("darr", "\u2193");
        entities.put("harr", "\u2194");
        entities.put("crarr", "\u21b5");
        entities.put("lArr", "\u21d0");
        entities.put("uArr", "\u21d1");
        entities.put("rArr", "\u21d2");
        entities.put("dArr", "\u21d3");
        entities.put("hArr", "\u21d4");
        entities.put("forall", "\u2200");
        entities.put("part", "\u2202");
        entities.put("exist", "\u2203");
        entities.put("empty", "\u2205");
        entities.put("nabla", "\u2207");
        entities.put("isin", "\u2208");
        entities.put("notin", "\u2209");
        entities.put("ni", "\u220b");
        entities.put("prod", "\u220f");
        entities.put("sum", "\u2211");
        entities.put("minus", "\u2212");
        entities.put("lowast", "\u2217");
        entities.put("radic", "\u221a");
        entities.put("prop", "\u221d");
        entities.put("infin", "\u221e");
        entities.put("ang", "\u2220");
        entities.put("and", "\u2227");
        entities.put("or", "\u2228");
        entities.put("cap", "\u2229");
        entities.put("cup", "\u222a");
        entities.put("int", "\u222b");
        entities.put("there4", "\u2234");
        entities.put("sim", "\u223c");
        entities.put("cong", "\u2245");
        entities.put("asymp", "\u2248");
        entities.put("ne", "\u2260");
        entities.put("equiv", "\u2261");
        entities.put("le", "\u2264");
        entities.put("ge", "\u2265");
        entities.put("sub", "\u2282");
        entities.put("sup", "\u2283");
        entities.put("nsub", "\u2284");
        entities.put("sube", "\u2286");
        entities.put("supe", "\u2287");
        entities.put("oplus", "\u2295");
        entities.put("otimes", "\u2297");
        entities.put("perp", "\u22a5");
        entities.put("sdot", "\u22c5");
        entities.put("lceil", "\u2308");
        entities.put("rceil", "\u2309");
        entities.put("lfloor", "\u230a");
        entities.put("rfloor", "\u230b");
        entities.put("lang", "\u2329");
        entities.put("rang", "\u232a");
        entities.put("loz", "\u25ca");
        entities.put("spades", "\u2660");
        entities.put("clubs", "\u2663");
        entities.put("hearts", "\u2665");
        entities.put("diams", "\u2666");
        DEFAULT_ENTITIES = Collections.unmodifiableMap(entities);
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

