/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.model.BaseObject;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.WrapperList;

@Generated
public class ReportPlugin
extends ConfigurationContainer
implements Serializable,
Cloneable {
    private Map<String, ReportSet> reportSetMap = null;

    public ReportPlugin() {
        this(org.apache.maven.api.model.ReportPlugin.newInstance());
    }

    public ReportPlugin(org.apache.maven.api.model.ReportPlugin delegate) {
        this(delegate, (BaseObject)null);
    }

    public ReportPlugin(org.apache.maven.api.model.ReportPlugin delegate, BaseObject parent) {
        super((org.apache.maven.api.model.ConfigurationContainer)delegate, parent);
    }

    @Override
    public ReportPlugin clone() {
        return new ReportPlugin(this.getDelegate());
    }

    public org.apache.maven.api.model.ReportPlugin getDelegate() {
        return (org.apache.maven.api.model.ReportPlugin)super.getDelegate();
    }

    public String getGroupId() {
        return this.getDelegate().getGroupId();
    }

    public void setGroupId(String groupId) {
        if (!Objects.equals(groupId, this.getDelegate().getGroupId())) {
            this.update(this.getDelegate().withGroupId(groupId));
        }
    }

    public String getArtifactId() {
        return this.getDelegate().getArtifactId();
    }

    public void setArtifactId(String artifactId) {
        if (!Objects.equals(artifactId, this.getDelegate().getArtifactId())) {
            this.update(this.getDelegate().withArtifactId(artifactId));
        }
    }

    public String getVersion() {
        return this.getDelegate().getVersion();
    }

    public void setVersion(String version) {
        if (!Objects.equals(version, this.getDelegate().getVersion())) {
            this.update(this.getDelegate().withVersion(version));
        }
    }

    @Nonnull
    public List<ReportSet> getReportSets() {
        return new WrapperList<ReportSet, org.apache.maven.api.model.ReportSet>(() -> this.getDelegate().getReportSets(), l -> this.update(this.getDelegate().withReportSets((Collection)l)), d -> new ReportSet((org.apache.maven.api.model.ReportSet)d, (BaseObject)this), ReportSet::getDelegate);
    }

    public void setReportSets(List<ReportSet> reportSets) {
        if (!Objects.equals(reportSets, this.getDelegate().getReportSets())) {
            this.update(this.getDelegate().withReportSets((Collection)reportSets.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            reportSets.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addReportSet(ReportSet reportSet) {
        this.update(this.getDelegate().withReportSets((Collection)Stream.concat(this.getDelegate().getReportSets().stream(), Stream.of(reportSet.getDelegate())).collect(Collectors.toList())));
        reportSet.childrenTracking = this::replace;
    }

    public void removeReportSet(ReportSet reportSet) {
        this.update(this.getDelegate().withReportSets((Collection)this.getDelegate().getReportSets().stream().filter(e -> !Objects.equals(e, reportSet)).collect(Collectors.toList())));
        reportSet.childrenTracking = null;
    }

    @Override
    public InputLocation getLocation(Object key) {
        org.apache.maven.api.model.InputLocation loc = this.getDelegate().getLocation(key);
        return loc != null ? new InputLocation(loc) : null;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        this.update(org.apache.maven.api.model.ReportPlugin.newBuilder((org.apache.maven.api.model.ReportPlugin)this.getDelegate(), (boolean)true).location(key, location.toApiLocation()).build());
    }

    @Override
    protected boolean replace(Object oldDelegate, Object newDelegate) {
        if (super.replace(oldDelegate, newDelegate)) {
            return true;
        }
        if (this.getDelegate().getReportSets().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getReportSets());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.model.ReportSet)newDelegate : d);
            this.update(this.getDelegate().withReportSets(list));
            return true;
        }
        return false;
    }

    public static List<org.apache.maven.api.model.ReportPlugin> reportPluginToApiV4(List<ReportPlugin> list) {
        return list != null ? new WrapperList<org.apache.maven.api.model.ReportPlugin, ReportPlugin>(list, ReportPlugin::getDelegate, ReportPlugin::new) : null;
    }

    public static List<ReportPlugin> reportPluginToApiV3(List<org.apache.maven.api.model.ReportPlugin> list) {
        return list != null ? new WrapperList<ReportPlugin, org.apache.maven.api.model.ReportPlugin>(list, ReportPlugin::new, ReportPlugin::getDelegate) : null;
    }

    public void flushReportSetMap() {
        this.reportSetMap = null;
    }

    public Map<String, ReportSet> getReportSetsAsMap() {
        if (this.reportSetMap == null) {
            this.reportSetMap = new LinkedHashMap<String, ReportSet>();
            if (this.getReportSets() != null) {
                for (ReportSet reportSet : this.getReportSets()) {
                    this.reportSetMap.put(reportSet.getId(), reportSet);
                }
            }
        }
        return this.reportSetMap;
    }

    public String getKey() {
        return ReportPlugin.constructKey(this.getGroupId(), this.getArtifactId());
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }
}

