// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.plugin.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.Dom;

/**
 * A set of goals to execute.
 */
@Generated @ThreadSafe @Immutable
public class Execution
    implements Serializable
{
    /**
     * Configuration to pass to the goals.
     */
    final Dom configuration;
    /**
     * The goals to execute.
     */
    final List<String> goals;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Execution(
        Dom configuration,
        Collection<String> goals
    )
    {
        this.configuration = configuration;
        this.goals = ImmutableCollections.copy( goals );
    }

    /**
     * Configuration to pass to the goals.
     */
    public Dom getConfiguration()
    {
        return this.configuration;
    }

    /**
     * The goals to execute.
     */
    @Nonnull
    public List<String> getGoals()
    {
        return this.goals;
    }

    /**
     * Creates a new builder with this object as the basis.
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /** Creates a new Execution instance using the specified configuration. */
    @Nonnull
    public Execution withConfiguration( Dom configuration )
    {
        return with().configuration( configuration ).build();
    }
    /** Creates a new Execution instance using the specified goals. */
    @Nonnull
    public Execution withGoals( Collection<String> goals )
    {
        return with().goals( goals ).build();
    }

    /**
     * Creates a new Execution instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     */
    @Nonnull
    public static Execution newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new Execution instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     */
    @Nonnull
    public static Execution newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new Execution builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new Execution builder instance using default values or not.
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new Execution builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     */
    @Nonnull
    public static Builder newBuilder( Execution from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new Execution builder instance using the specified object as a basis.
     */
    @Nonnull
    public static Builder newBuilder( Execution from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Execution instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Execution base;
        Dom configuration;
        Collection<String> goals;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( Execution base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.configuration = base.configuration;
                this.goals = base.goals;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder configuration( Dom configuration )
        {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder goals( Collection<String> goals )
        {
            this.goals = goals;
            return this;
        }


        @Nonnull
        public Execution build()
        {
            if ( base != null
                    && ( configuration == null || configuration == base.configuration )
                    && ( goals == null || goals == base.goals )
            )
            {
                return base;
            }
            return new Execution(
                configuration != null ? configuration : ( base != null ? base.configuration : null ),
                goals != null ? goals : ( base != null ? base.goals : null )
            );
        }
    }

}
