/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.lifecycle;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.plugin.lifecycle.ImmutableCollections;
import org.apache.maven.plugin.lifecycle.Phase;

@Generated
@ThreadSafe
@Immutable
public class Lifecycle
implements Serializable {
    final String id;
    final List<Phase> phases;

    Lifecycle(String id, Collection<Phase> phases) {
        this.id = id;
        this.phases = ImmutableCollections.copy(phases);
    }

    public String getId() {
        return this.id;
    }

    @Nonnull
    public List<Phase> getPhases() {
        return this.phases;
    }

    @Nonnull
    public Builder with() {
        return Lifecycle.newBuilder(this);
    }

    @Nonnull
    public Lifecycle withId(String id) {
        return this.with().id(id).build();
    }

    @Nonnull
    public Lifecycle withPhases(Collection<Phase> phases) {
        return this.with().phases(phases).build();
    }

    @Nonnull
    public static Lifecycle newInstance() {
        return Lifecycle.newInstance(true);
    }

    @Nonnull
    public static Lifecycle newInstance(boolean withDefaults) {
        return Lifecycle.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Lifecycle.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Lifecycle from) {
        return Lifecycle.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Lifecycle from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Lifecycle base;
        String id;
        Collection<Phase> phases;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Lifecycle base, boolean forceCopy) {
            if (forceCopy) {
                this.id = base.id;
                this.phases = base.phases;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder phases(Collection<Phase> phases) {
            this.phases = phases;
            return this;
        }

        @Nonnull
        public Lifecycle build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.phases != null && this.phases != this.base.phases)) {
                return this.base;
            }
            return new Lifecycle(this.id != null ? this.id : (this.base != null ? this.base.id : null), this.phases != null ? this.phases : (this.base != null ? this.base.phases : null));
        }
    }
}

