/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.descriptor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeBuilder;
import org.apache.maven.internal.xml.XmlPlexusConfiguration;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PluginDescriptorBuilder {
    public PluginDescriptor build(Reader reader) throws PlexusConfigurationException {
        return this.build(reader, null);
    }

    public PluginDescriptor build(Reader reader, String source) throws PlexusConfigurationException {
        return this.build(source, this.buildConfiguration(reader));
    }

    public PluginDescriptor build(InputStream input, String source) throws PlexusConfigurationException {
        return this.build(source, this.buildConfiguration(input));
    }

    private PluginDescriptor build(String source, PlexusConfiguration c) throws PlexusConfigurationException {
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setSource(source);
        pluginDescriptor.setGroupId(this.extractGroupId(c));
        pluginDescriptor.setArtifactId(this.extractArtifactId(c));
        pluginDescriptor.setVersion(this.extractVersion(c));
        pluginDescriptor.setGoalPrefix(this.extractGoalPrefix(c));
        pluginDescriptor.setName(this.extractName(c));
        pluginDescriptor.setDescription(this.extractDescription(c));
        pluginDescriptor.setIsolatedRealm(this.extractIsolatedRealm(c));
        pluginDescriptor.setInheritedByDefault(this.extractInheritedByDefault(c));
        pluginDescriptor.setRequiredJavaVersion(this.extractRequiredJavaVersion(c).orElse(null));
        pluginDescriptor.setRequiredMavenVersion(this.extractRequiredMavenVersion(c).orElse(null));
        pluginDescriptor.addMojos(this.extractMojos(c, pluginDescriptor));
        pluginDescriptor.setDependencies(this.extractComponentDependencies(c));
        return pluginDescriptor;
    }

    private String extractGroupId(PlexusConfiguration c) {
        return c.getChild("groupId").getValue();
    }

    private String extractArtifactId(PlexusConfiguration c) {
        return c.getChild("artifactId").getValue();
    }

    private String extractVersion(PlexusConfiguration c) {
        return c.getChild("version").getValue();
    }

    private String extractGoalPrefix(PlexusConfiguration c) {
        return c.getChild("goalPrefix").getValue();
    }

    private String extractName(PlexusConfiguration c) {
        return c.getChild("name").getValue();
    }

    private String extractDescription(PlexusConfiguration c) {
        return c.getChild("description").getValue();
    }

    private List<MojoDescriptor> extractMojos(PlexusConfiguration c, PluginDescriptor pluginDescriptor) throws PlexusConfigurationException {
        PlexusConfiguration[] mojoConfigurations;
        ArrayList<MojoDescriptor> mojos = new ArrayList<MojoDescriptor>();
        for (PlexusConfiguration component : mojoConfigurations = c.getChild("mojos").getChildren("mojo")) {
            mojos.add(this.buildComponentDescriptor(component, pluginDescriptor));
        }
        return mojos;
    }

    private boolean extractInheritedByDefault(PlexusConfiguration c) {
        String inheritedByDefault = c.getChild("inheritedByDefault").getValue();
        if (inheritedByDefault != null) {
            return Boolean.parseBoolean(inheritedByDefault);
        }
        return false;
    }

    private boolean extractIsolatedRealm(PlexusConfiguration c) {
        String isolatedRealm = c.getChild("isolatedRealm").getValue();
        if (isolatedRealm != null) {
            return Boolean.parseBoolean(isolatedRealm);
        }
        return false;
    }

    private Optional<String> extractRequiredJavaVersion(PlexusConfiguration c) {
        return Optional.ofNullable(c.getChild("requiredJavaVersion")).map(PlexusConfiguration::getValue);
    }

    private Optional<String> extractRequiredMavenVersion(PlexusConfiguration c) {
        return Optional.ofNullable(c.getChild("requiredMavenVersion")).map(PlexusConfiguration::getValue);
    }

    private List<ComponentDependency> extractComponentDependencies(PlexusConfiguration c) {
        PlexusConfiguration[] dependencyConfigurations = c.getChild("dependencies").getChildren("dependency");
        ArrayList<ComponentDependency> dependencies = new ArrayList<ComponentDependency>();
        for (PlexusConfiguration d : dependencyConfigurations) {
            dependencies.add(this.extractComponentDependency(d));
        }
        return dependencies;
    }

    private ComponentDependency extractComponentDependency(PlexusConfiguration d) {
        ComponentDependency cd = new ComponentDependency();
        cd.setArtifactId(this.extractArtifactId(d));
        cd.setGroupId(this.extractGroupId(d));
        cd.setType(d.getChild("type").getValue());
        cd.setVersion(this.extractVersion(d));
        return cd;
    }

    public MojoDescriptor buildComponentDescriptor(PlexusConfiguration c, PluginDescriptor pluginDescriptor) throws PlexusConfigurationException {
        PlexusConfiguration[] requirements;
        String v4Api;
        String threadSafe;
        String inheritedByDefault;
        String requiresOnline;
        String aggregator;
        String requiresReports;
        String requiresProject;
        String directInvocationOnly;
        PlexusConfiguration dependencyCollection;
        String executeLifecycle;
        String executeMojo;
        String executePhase;
        String phase;
        PlexusConfiguration deprecated;
        String since;
        PlexusConfiguration composerConfig;
        PlexusConfiguration configuratorConfig;
        MojoDescriptor mojo = new MojoDescriptor();
        mojo.setPluginDescriptor(pluginDescriptor);
        mojo.setGoal(c.getChild("goal").getValue());
        mojo.setImplementation(c.getChild("implementation").getValue());
        PlexusConfiguration langConfig = c.getChild("language");
        if (langConfig != null) {
            mojo.setLanguage(langConfig.getValue());
        }
        if ((configuratorConfig = c.getChild("configurator")) != null) {
            mojo.setComponentConfigurator(configuratorConfig.getValue());
        }
        if ((composerConfig = c.getChild("composer")) != null) {
            mojo.setComponentComposer(composerConfig.getValue());
        }
        if ((since = c.getChild("since").getValue()) != null) {
            mojo.setSince(since);
        }
        if ((deprecated = c.getChild("deprecated", false)) != null) {
            mojo.setDeprecated(deprecated.getValue());
        }
        if ((phase = c.getChild("phase").getValue()) != null) {
            mojo.setPhase(phase);
        }
        if ((executePhase = c.getChild("executePhase").getValue()) != null) {
            mojo.setExecutePhase(executePhase);
        }
        if ((executeMojo = c.getChild("executeGoal").getValue()) != null) {
            mojo.setExecuteGoal(executeMojo);
        }
        if ((executeLifecycle = c.getChild("executeLifecycle").getValue()) != null) {
            mojo.setExecuteLifecycle(executeLifecycle);
        }
        mojo.setInstantiationStrategy(c.getChild("instantiationStrategy").getValue());
        mojo.setDescription(this.extractDescription(c));
        PlexusConfiguration dependencyResolution = c.getChild("requiresDependencyResolution", false);
        if (dependencyResolution != null) {
            mojo.setDependencyResolutionRequired(dependencyResolution.getValue());
        }
        if ((dependencyCollection = c.getChild("requiresDependencyCollection", false)) != null) {
            mojo.setDependencyCollectionRequired(dependencyCollection.getValue());
        }
        if ((directInvocationOnly = c.getChild("requiresDirectInvocation").getValue()) != null) {
            mojo.setDirectInvocationOnly(Boolean.parseBoolean(directInvocationOnly));
        }
        if ((requiresProject = c.getChild("requiresProject").getValue()) != null) {
            mojo.setProjectRequired(Boolean.parseBoolean(requiresProject));
        }
        if ((requiresReports = c.getChild("requiresReports").getValue()) != null) {
            mojo.setRequiresReports(Boolean.parseBoolean(requiresReports));
        }
        if ((aggregator = c.getChild("aggregator").getValue()) != null) {
            mojo.setAggregator(Boolean.parseBoolean(aggregator));
        }
        if ((requiresOnline = c.getChild("requiresOnline").getValue()) != null) {
            mojo.setOnlineRequired(Boolean.parseBoolean(requiresOnline));
        }
        if ((inheritedByDefault = c.getChild("inheritedByDefault").getValue()) != null) {
            mojo.setInheritedByDefault(Boolean.parseBoolean(inheritedByDefault));
        }
        if ((threadSafe = c.getChild("threadSafe").getValue()) != null) {
            mojo.setThreadSafe(Boolean.parseBoolean(threadSafe));
        }
        if ((v4Api = c.getChild("v4Api").getValue()) != null) {
            mojo.setV4Api(Boolean.parseBoolean(v4Api));
        }
        PlexusConfiguration mojoConfig = c.getChild("configuration");
        mojo.setMojoConfiguration(mojoConfig);
        PlexusConfiguration[] parameterConfigurations = c.getChild("parameters").getChildren("parameter");
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (PlexusConfiguration d : parameterConfigurations) {
            Parameter parameter = new Parameter();
            parameter.setName(this.extractName(d));
            parameter.setAlias(d.getChild("alias").getValue());
            parameter.setType(d.getChild("type").getValue());
            String required = d.getChild("required").getValue();
            parameter.setRequired(Boolean.parseBoolean(required));
            PlexusConfiguration editableConfig = d.getChild("editable");
            if (editableConfig != null) {
                String editable = d.getChild("editable").getValue();
                parameter.setEditable(editable == null || Boolean.parseBoolean(editable));
            }
            parameter.setDescription(this.extractDescription(d));
            parameter.setDeprecated(d.getChild("deprecated").getValue());
            parameter.setImplementation(d.getChild("implementation").getValue());
            parameter.setSince(d.getChild("since").getValue());
            PlexusConfiguration paramConfig = mojoConfig.getChild(parameter.getName(), false);
            if (paramConfig != null) {
                parameter.setExpression(paramConfig.getValue(null));
                parameter.setDefaultValue(paramConfig.getAttribute("default-value"));
            }
            parameters.add(parameter);
        }
        mojo.setParameters(parameters);
        for (PlexusConfiguration requirement : requirements = c.getChild("requirements").getChildren("requirement")) {
            ComponentRequirement cr = new ComponentRequirement();
            cr.setRole(requirement.getChild("role").getValue());
            cr.setRoleHint(requirement.getChild("role-hint").getValue());
            cr.setFieldName(requirement.getChild("field-name").getValue());
            mojo.addRequirement(cr);
        }
        return mojo;
    }

    public PlexusConfiguration buildConfiguration(Reader configuration) throws PlexusConfigurationException {
        try {
            return XmlPlexusConfiguration.toPlexusConfiguration((XmlNode)XmlNodeBuilder.build((Reader)configuration));
        }
        catch (IOException | XmlPullParserException e) {
            throw new PlexusConfigurationException(e.getMessage(), e);
        }
    }

    public PlexusConfiguration buildConfiguration(InputStream configuration) throws PlexusConfigurationException {
        try {
            return XmlPlexusConfiguration.toPlexusConfiguration((XmlNode)XmlNodeBuilder.build((InputStream)configuration, null));
        }
        catch (IOException | XmlPullParserException e) {
            throw new PlexusConfigurationException(e.getMessage(), e);
        }
    }
}

