/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.descriptor;

import java.util.List;
import org.apache.maven.plugin.descriptor.DuplicateMojoDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;

public class PluginDescriptor
extends ComponentSetDescriptor {
    private String groupId;
    private String artifactId;
    private String version;
    private List dependencies;
    private boolean isolatedRealm;
    private String goalPrefix;
    private String source;

    public List getMojos() {
        return this.getComponents();
    }

    public void addMojo(MojoDescriptor mojoDescriptor) throws DuplicateMojoDescriptorException {
        List mojos = this.getComponents();
        if (mojos != null && mojos.contains(mojoDescriptor)) {
            int indexOf = mojos.indexOf(mojoDescriptor);
            MojoDescriptor existing = (MojoDescriptor)mojos.get(indexOf);
            throw new DuplicateMojoDescriptorException(this.getGoalPrefix(), mojoDescriptor.getGoal(), existing.getImplementation(), mojoDescriptor.getImplementation());
        }
        this.addComponentDescriptor(mojoDescriptor);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public boolean isIsolatedRealm() {
        return this.isolatedRealm;
    }

    public static String constructPluginKey(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }

    public String getId() {
        String id = PluginDescriptor.constructPluginKey(this.groupId, this.artifactId, this.version);
        if (this.groupId == null || this.artifactId == null || this.version == null) {
            throw new IllegalStateException("Plugin descriptor ID incomplete: " + id + " in " + this.getSource());
        }
        return id;
    }

    public static String getDefaultPluginArtifactId(String id) {
        return "maven-" + id + "-plugin";
    }

    public static String getDefaultPluginGroupId() {
        return "org.apache.maven.plugins";
    }

    public static String getGoalPrefixFromArtifactId(String artifactId) {
        if ("maven-plugin-plugin".equals(artifactId)) {
            return "plugin";
        }
        return artifactId.replaceAll("-?maven-?", "").replaceAll("-?plugin-?", "");
    }

    public String getGoalPrefix() {
        return this.goalPrefix;
    }

    public void setGoalPrefix(String goalPrefix) {
        this.goalPrefix = goalPrefix;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }
}

