/*
 * $Id$
 */

package org.apache.maven.profiles;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;

/**
 * Class Repository.
 * 
 * @version $Revision$ $Date$
 */
public class Repository implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field name
     */
    private String name;

    /**
     * Field url
     */
    private String url;

    /**
     * Field snapshotPolicy
     */
    private String snapshotPolicy = "daily";

    /**
     * Field layout
     */
    private String layout = "default";

    /**
     * Field checksumPolicy
     */
    private String checksumPolicy = "warn";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method getChecksumPolicy
     */
    public String getChecksumPolicy()
    {
        return this.checksumPolicy;
    } //-- String getChecksumPolicy() 

    /**
     * Method getId
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method getLayout
     */
    public String getLayout()
    {
        return this.layout;
    } //-- String getLayout() 

    /**
     * Method getName
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Method getSnapshotPolicy
     */
    public String getSnapshotPolicy()
    {
        return this.snapshotPolicy;
    } //-- String getSnapshotPolicy() 

    /**
     * Method getUrl
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Method setChecksumPolicy
     * 
     * @param checksumPolicy
     */
    public void setChecksumPolicy(String checksumPolicy)
    {
        this.checksumPolicy = checksumPolicy;
    } //-- void setChecksumPolicy(String) 

    /**
     * Method setId
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Method setLayout
     * 
     * @param layout
     */
    public void setLayout(String layout)
    {
        this.layout = layout;
    } //-- void setLayout(String) 

    /**
     * Method setName
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Method setSnapshotPolicy
     * 
     * @param snapshotPolicy
     */
    public void setSnapshotPolicy(String snapshotPolicy)
    {
        this.snapshotPolicy = snapshotPolicy;
    } //-- void setSnapshotPolicy(String) 

    /**
     * Method setUrl
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 


            public boolean equals( Object obj )
            {
                Repository other =  ( Repository ) obj;

                boolean retValue = false;

                if ( id != null )
                {
                    retValue = id.equals( other.id );
                }

                return retValue;
            }
          }
