/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.inheritance.ModelInheritanceAssembler;
import org.apache.maven.project.injection.ModelDefaultsInjector;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultMavenProjectBuilder
extends AbstractLogEnabled
implements MavenProjectBuilder,
Initializable,
Contextualizable {
    private PlexusContainer container;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ModelInheritanceAssembler modelInheritanceAssembler;
    private ModelValidator validator;
    private MavenXpp3Reader modelReader;
    private PathTranslator pathTranslator;
    private ModelDefaultsInjector modelDefaultsInjector;
    private ModelInterpolator modelInterpolator;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private final Map modelCache = new HashMap();
    public static final String MAVEN_MODEL_VERSION = "4.0.0";
    static /* synthetic */ Class class$org$apache$maven$project$DefaultMavenProjectBuilder;

    public void initialize() {
        this.modelReader = new MavenXpp3Reader();
    }

    public MavenProject buildWithDependencies(File projectDescriptor, ArtifactRepository localRepository, ArtifactMetadataSource artifactMetadataSource) throws ProjectBuildingException, ArtifactResolutionException {
        MavenProject project = this.buildFromSourceFile(projectDescriptor, localRepository);
        ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(project.getArtifacts(), project.getRemoteArtifactRepositories(), localRepository, artifactMetadataSource);
        project.addArtifacts(result.getArtifacts().values(), this.artifactFactory);
        return project;
    }

    public MavenProject build(File projectDescriptor, ArtifactRepository localRepository) throws ProjectBuildingException, ArtifactResolutionException {
        return this.buildFromSourceFile(projectDescriptor, localRepository);
    }

    private MavenProject buildFromSourceFile(File projectDescriptor, ArtifactRepository localRepository) throws ProjectBuildingException, ArtifactResolutionException {
        Model model = this.readModel(projectDescriptor);
        this.modelCache.put(DefaultMavenProjectBuilder.createCacheKey(model.getGroupId(), model.getArtifactId(), model.getVersion()), model);
        MavenProject project = this.build(projectDescriptor.getAbsolutePath(), model, localRepository);
        this.pathTranslator.alignToBaseDirectory(project.getModel(), projectDescriptor);
        Build build = project.getBuild();
        project.addCompileSourceRoot(build.getSourceDirectory());
        project.addScriptSourceRoot(build.getScriptSourceDirectory());
        project.addTestCompileSourceRoot(build.getTestSourceDirectory());
        project.setFile(projectDescriptor);
        return project;
    }

    public MavenProject buildFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository) throws ProjectBuildingException, ArtifactResolutionException {
        Model model = this.findModelFromRepository(artifact, remoteArtifactRepositories, localRepository);
        return this.build("Artifact [" + artifact.getId() + "]", model, localRepository);
    }

    private Model findModelFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository) throws ProjectBuildingException, ArtifactResolutionException {
        Model model = this.getCachedModel(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        if (model == null) {
            this.artifactResolver.resolve(artifact, remoteArtifactRepositories, localRepository);
            File file = artifact.getFile();
            model = this.readModel(file);
        }
        String downloadUrl = null;
        if (model.getDistributionManagement() != null) {
            downloadUrl = model.getDistributionManagement().getDownloadUrl();
        }
        if (downloadUrl != null) {
            artifact.setDownloadUrl(downloadUrl);
        } else {
            artifact.setDownloadUrl(model.getUrl());
        }
        return model;
    }

    private MavenProject build(String pomLocation, Model model, ArtifactRepository localRepository) throws ProjectBuildingException, ArtifactResolutionException {
        Model superModel = this.getSuperModel();
        LinkedList lineage = new LinkedList();
        List aggregatedRemoteWagonRepositories = this.buildArtifactRepositories(superModel.getRepositories());
        MavenProject project = this.assembleLineage(model, lineage, aggregatedRemoteWagonRepositories, localRepository);
        Model previous = superModel;
        Iterator i = lineage.iterator();
        while (i.hasNext()) {
            Model current = ((MavenProject)i.next()).getModel();
            this.modelInheritanceAssembler.assembleModelInheritance(current, previous);
            previous = current;
        }
        try {
            project = this.processProjectLogic(pomLocation, project, aggregatedRemoteWagonRepositories);
        }
        catch (ModelInterpolationException e) {
            throw new ProjectBuildingException("Error building project from '" + pomLocation + "': " + model.getId(), e);
        }
        return project;
    }

    private MavenProject processProjectLogic(String pomLocation, MavenProject project, List remoteRepositories) throws ProjectBuildingException, ModelInterpolationException {
        Model model = project.getModel();
        String key = DefaultMavenProjectBuilder.createCacheKey(model.getGroupId(), model.getArtifactId(), model.getVersion());
        Model cachedModel = (Model)this.modelCache.get(key);
        if (cachedModel == null) {
            this.modelCache.put(key, model);
        }
        model = this.modelInterpolator.interpolate(model);
        this.modelDefaultsInjector.injectDefaults(model);
        MavenProject parentProject = project.getParent();
        project = new MavenProject(model);
        project.setPluginArtifactRepositories(this.buildArtifactRepositories(model.getPluginRepositories()));
        DistributionManagement dm = model.getDistributionManagement();
        if (dm != null) {
            project.setDistributionManagementArtifactRepository(this.buildArtifactRepository(dm.getRepository()));
        }
        project.setParent(parentProject);
        project.setRemoteArtifactRepositories(remoteRepositories);
        project.setArtifacts(this.createArtifacts(project.getDependencies()));
        ModelValidationResult validationResult = this.validator.validate(model);
        if (validationResult.getMessageCount() > 0) {
            throw new ProjectBuildingException("Failed to validate POM for '" + pomLocation + "'.\n\n  Reason(s):\n" + validationResult.render("  "));
        }
        return project;
    }

    private MavenProject assembleLineage(Model model, LinkedList lineage, List aggregatedRemoteWagonRepositories, ArtifactRepository localRepository) throws ProjectBuildingException, ArtifactResolutionException {
        aggregatedRemoteWagonRepositories.addAll(this.buildArtifactRepositories(model.getRepositories()));
        MavenProject project = new MavenProject(model);
        lineage.addFirst(project);
        Parent parentModel = model.getParent();
        if (parentModel != null) {
            if (StringUtils.isEmpty((String)parentModel.getGroupId())) {
                throw new ProjectBuildingException("Missing groupId element from parent element");
            }
            if (StringUtils.isEmpty((String)parentModel.getArtifactId())) {
                throw new ProjectBuildingException("Missing artifactId element from parent element");
            }
            if (StringUtils.isEmpty((String)parentModel.getVersion())) {
                throw new ProjectBuildingException("Missing version element from parent element");
            }
            Artifact artifact = this.artifactFactory.createArtifact(parentModel.getGroupId(), parentModel.getArtifactId(), parentModel.getVersion(), null, "pom", null);
            model = this.findModelFromRepository(artifact, aggregatedRemoteWagonRepositories, localRepository);
            MavenProject parent = this.assembleLineage(model, lineage, aggregatedRemoteWagonRepositories, localRepository);
            project.setParent(parent);
        }
        return project;
    }

    private List buildArtifactRepositories(List repositories) throws ProjectBuildingException {
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        Iterator i = repositories.iterator();
        while (i.hasNext()) {
            Repository mavenRepo = (Repository)i.next();
            ArtifactRepository artifactRepo = this.buildArtifactRepository(mavenRepo);
            if (repos.contains(artifactRepo)) continue;
            repos.add(artifactRepo);
        }
        return repos;
    }

    private ArtifactRepositoryLayout getRepositoryLayout(Repository mavenRepo) throws ProjectBuildingException {
        String layout = mavenRepo.getLayout();
        ArtifactRepositoryLayout repositoryLayout = null;
        try {
            repositoryLayout = (ArtifactRepositoryLayout)this.container.lookup(ArtifactRepositoryLayout.ROLE, layout);
        }
        catch (ComponentLookupException e) {
            throw new ProjectBuildingException("Cannot find layout implementation corresponding to: '" + layout + "' for remote repository with id: '" + mavenRepo.getId() + "'.", e);
        }
        return repositoryLayout;
    }

    private ArtifactRepository buildArtifactRepository(Repository repo) throws ProjectBuildingException {
        if (repo != null) {
            String id = repo.getId();
            String url = repo.getUrl();
            String snapshotPolicy = repo.getSnapshotPolicy();
            ArtifactRepositoryLayout layout = this.getRepositoryLayout(repo);
            return this.artifactRepositoryFactory.createArtifactRepository(id, url, layout, snapshotPolicy);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model readModel(File file) throws ProjectBuildingException {
        Model model;
        FileReader reader = null;
        try {
            Model model2;
            reader = new FileReader(file);
            model = model2 = this.modelReader.read((Reader)reader);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ProjectBuildingException("Could not find the model file '" + file.getAbsolutePath() + "'.", e);
                catch (IOException e2) {
                    throw new ProjectBuildingException("Failed to build model from file '" + file.getAbsolutePath() + "'.\nError: '" + e2.getLocalizedMessage() + "'", e2);
                }
                catch (XmlPullParserException e3) {
                    throw new ProjectBuildingException("Failed to parse model from file '" + file.getAbsolutePath() + "'.\nError: '" + e3.getLocalizedMessage() + "'", e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return model;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model readModel(URL url) throws ProjectBuildingException {
        Model model;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(url.openStream());
            model = this.modelReader.read((Reader)reader);
        }
        catch (IOException e) {
            try {
                throw new ProjectBuildingException("Failed build model from URL '" + url.toExternalForm() + "'\nError: '" + e.getLocalizedMessage() + "'", e);
                catch (XmlPullParserException e2) {
                    throw new ProjectBuildingException("Failed to parse model from URL '" + url.toExternalForm() + "'\nError: '" + e2.getLocalizedMessage() + "'", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return model;
    }

    private Model getCachedModel(String groupId, String artifactId, String version) {
        return (Model)this.modelCache.get(DefaultMavenProjectBuilder.createCacheKey(groupId, artifactId, version));
    }

    private static String createCacheKey(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }

    protected Set createArtifacts(List dependencies) {
        HashSet<Artifact> projectArtifacts = new HashSet<Artifact>();
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            Dependency d = (Dependency)i.next();
            Artifact artifact = this.artifactFactory.createArtifact(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getScope(), d.getType(), null);
            if (artifact == null) continue;
            projectArtifacts.add(artifact);
        }
        return projectArtifacts;
    }

    public MavenProject buildStandaloneSuperProject(ArtifactRepository localRepository) throws ProjectBuildingException {
        Model superModel = this.getSuperModel();
        superModel.setGroupId("org.apache.maven");
        superModel.setArtifactId("super-pom");
        superModel.setVersion("2.0");
        MavenProject project = new MavenProject(superModel);
        try {
            project.setFile(new File(".", "pom.xml"));
            List remoteRepositories = this.buildArtifactRepositories(superModel.getRepositories());
            project = this.processProjectLogic("<Super-POM>", project, remoteRepositories);
            return project;
        }
        catch (ModelInterpolationException e) {
            throw new ProjectBuildingException("Error building super-project", e);
        }
    }

    private Model getSuperModel() throws ProjectBuildingException {
        URL url = (class$org$apache$maven$project$DefaultMavenProjectBuilder == null ? (class$org$apache$maven$project$DefaultMavenProjectBuilder = DefaultMavenProjectBuilder.class$("org.apache.maven.project.DefaultMavenProjectBuilder")) : class$org$apache$maven$project$DefaultMavenProjectBuilder).getResource("pom-4.0.0.xml");
        return this.readModel(url);
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

