/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;

public class ProjectSorter {
    private ProjectSorter() {
    }

    public static List getSortedProjects(List projects) throws CycleDetectedException {
        String id;
        MavenProject project;
        DAG dag = new DAG();
        HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
        Iterator i = projects.iterator();
        while (i.hasNext()) {
            project = (MavenProject)i.next();
            id = ProjectSorter.getProjectId(project);
            dag.addVertex(id);
            projectMap.put(id, project);
        }
        i = projects.iterator();
        while (i.hasNext()) {
            String parentId;
            project = (MavenProject)i.next();
            id = ProjectSorter.getProjectId(project);
            Iterator j = project.getDependencies().iterator();
            while (j.hasNext()) {
                Dependency dependency = (Dependency)j.next();
                String dependencyId = ProjectSorter.getDependencyId(dependency);
                if (dag.getVertex(dependencyId) == null) continue;
                dag.addEdge(id, dependencyId);
            }
            MavenProject parent = project.getParent();
            if (parent == null || dag.getVertex(parentId = ProjectSorter.getProjectId(parent)) == null) continue;
            dag.addEdge(id, parentId);
        }
        ArrayList sortedProjects = new ArrayList();
        Iterator i2 = TopologicalSorter.sort((DAG)dag).iterator();
        while (i2.hasNext()) {
            id = (String)i2.next();
            sortedProjects.add(projectMap.get(id));
        }
        return sortedProjects;
    }

    private static String getDependencyId(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId();
    }

    private static String getProjectId(MavenProject project) {
        return project.getGroupId() + ":" + project.getArtifactId();
    }
}

