/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.factory.DefaultArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.wagon.util.IoUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenMetadataSource
implements ArtifactMetadataSource {
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactResolver artifactResolver;
    protected ArtifactFactory artifactFactory = new DefaultArtifactFactory();
    private MavenXpp3Reader reader = new MavenXpp3Reader();

    public MavenMetadataSource(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
        this.mavenProjectBuilder = null;
    }

    public MavenMetadataSource(ArtifactResolver artifactResolver, MavenProjectBuilder projectBuilder) {
        this.artifactResolver = artifactResolver;
        this.mavenProjectBuilder = projectBuilder;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set retrieve(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException, ArtifactResolutionException {
        Artifact pomArtifact = this.artifactFactory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), "pom");
        List dependencies = null;
        if (this.mavenProjectBuilder != null) {
            try {
                MavenProject p = this.mavenProjectBuilder.buildFromRepository(pomArtifact, remoteRepositories, localRepository);
                dependencies = p.getDependencies();
                artifact.setDownloadUrl(pomArtifact.getDownloadUrl());
                return this.createArtifacts(dependencies, artifact.getScope());
            }
            catch (ProjectBuildingException e) {
                throw new ArtifactMetadataRetrievalException("Unable to read the metadata file", (Throwable)e);
            }
        }
        this.artifactResolver.resolve(pomArtifact, remoteRepositories, localRepository);
        FileReader reader = null;
        try {
            File file = pomArtifact.getFile();
            reader = new FileReader(file);
            Model model = this.reader.read((Reader)reader);
            dependencies = model.getDependencies();
        }
        catch (FileNotFoundException e) {
            try {
                throw new ArtifactMetadataRetrievalException("Unable to find the metadata file", (Throwable)e);
                catch (IOException e2) {
                    throw new ArtifactMetadataRetrievalException("Unable to read the metadata file", (Throwable)e2);
                }
                catch (XmlPullParserException e3) {
                    throw new ArtifactMetadataRetrievalException("Unable to parse the metadata file", (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                IoUtils.close(reader);
                throw throwable;
            }
        }
        IoUtils.close((Reader)reader);
        return this.createArtifacts(dependencies, artifact.getScope());
    }

    protected Set createArtifacts(List dependencies, String inheritedScope) {
        HashSet<Artifact> projectArtifacts = new HashSet<Artifact>();
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            Dependency d = (Dependency)i.next();
            Artifact artifact = this.artifactFactory.createArtifact(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getScope(), d.getType(), inheritedScope);
            if (artifact == null) continue;
            projectArtifacts.add(artifact);
        }
        return projectArtifacts;
    }
}

