/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.inheritance;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Goal;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.apache.maven.project.inheritance.ModelInheritanceAssembler;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class DefaultModelInheritanceAssembler
implements ModelInheritanceAssembler {
    public void assembleModelInheritance(Model child, Model parent) {
        if (child.getGroupId() == null) {
            child.setGroupId(parent.getGroupId());
        }
        if (child.getVersion() == null) {
            child.setVersion(child.getParent().getVersion());
        }
        if (child.getInceptionYear() == null) {
            child.setInceptionYear(parent.getInceptionYear());
        }
        if (child.getUrl() == null) {
            if (parent.getUrl() != null && parent.getUrl().endsWith("/")) {
                child.setUrl(parent.getUrl() + child.getArtifactId() + "/");
            } else {
                child.setUrl(parent.getUrl());
            }
        }
        this.assembleDistributionInheritence(child, parent);
        if (child.getIssueManagement() == null) {
            child.setIssueManagement(parent.getIssueManagement());
        }
        if (child.getDescription() == null) {
            child.setDescription(parent.getDescription());
        }
        if (child.getOrganization() == null) {
            child.setOrganization(parent.getOrganization());
        }
        this.assembleScmInheritance(child, parent);
        if (child.getCiManagement() == null) {
            child.setCiManagement(parent.getCiManagement());
        }
        if (child.getDevelopers().size() == 0) {
            child.setDevelopers(parent.getDevelopers());
        }
        if (child.getContributors().size() == 0) {
            child.setContributors(parent.getContributors());
        }
        if (child.getMailingLists().size() == 0) {
            child.setMailingLists(parent.getMailingLists());
        }
        this.assembleBuildInheritance(child, parent);
        List dependencies = parent.getDependencies();
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            child.addDependency(dependency);
        }
        List parentRepositories = parent.getRepositories();
        List childRepositories = child.getRepositories();
        Iterator iterator2 = parentRepositories.iterator();
        while (iterator2.hasNext()) {
            Repository repository = (Repository)iterator2.next();
            if (childRepositories.contains(repository)) continue;
            child.addRepository(repository);
        }
        List parentPluginRepositories = parent.getPluginRepositories();
        List childPluginRepositories = child.getPluginRepositories();
        Iterator iterator3 = parentPluginRepositories.iterator();
        while (iterator3.hasNext()) {
            Repository repository = (Repository)iterator3.next();
            if (childPluginRepositories.contains(repository)) continue;
            child.addPluginRepository(repository);
        }
        if (child.getReports() != null && parent.getReports() != null) {
            if (child.getReports().getOutputDirectory() == null) {
                child.getReports().setOutputDirectory(parent.getReports().getOutputDirectory());
            }
            List parentReports = parent.getReports().getPlugins();
            List childReports = child.getReports().getPlugins();
            Iterator iterator4 = parentReports.iterator();
            while (iterator4.hasNext()) {
                Plugin plugin = (Plugin)iterator4.next();
                if (childReports.contains(plugin)) continue;
                child.getReports().addPlugin(plugin);
            }
        }
        this.assembleDependencyManagementInheritance(child, parent);
    }

    private void assemblePluginManagementInheritance(Build childBuild, Build parentBuild) {
        PluginManagement parentPluginMgmt = parentBuild.getPluginManagement();
        PluginManagement childPluginMgmt = childBuild.getPluginManagement();
        if (parentPluginMgmt != null) {
            if (childPluginMgmt == null) {
                childBuild.setPluginManagement(parentPluginMgmt);
            } else {
                Map mappedChildPlugins = childPluginMgmt.getPluginsAsMap();
                Iterator it = parentPluginMgmt.getPlugins().iterator();
                while (it.hasNext()) {
                    Plugin plugin = (Plugin)it.next();
                    if (!mappedChildPlugins.containsKey(plugin.getKey())) {
                        childPluginMgmt.addPlugin(plugin);
                        continue;
                    }
                    Plugin childPlugin = (Plugin)mappedChildPlugins.get(plugin.getKey());
                    if (childPlugin.getVersion() == null) {
                        childPlugin.setVersion(childPlugin.getVersion());
                    }
                    Map mappedChildGoals = childPlugin.getGoalsAsMap();
                    Iterator itGoals = plugin.getGoals().iterator();
                    while (itGoals.hasNext()) {
                        Goal parentGoal = (Goal)itGoals.next();
                        Goal childGoal = (Goal)mappedChildGoals.get(parentGoal.getId());
                        if (childGoal == null) {
                            childPlugin.addGoal(parentGoal);
                            continue;
                        }
                        Xpp3Dom childDom = (Xpp3Dom)childGoal.getConfiguration();
                        Xpp3Dom parentDom = (Xpp3Dom)parentGoal.getConfiguration();
                        childGoal.setConfiguration((Object)Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childDom, (Xpp3Dom)parentDom));
                    }
                    Xpp3Dom childConfig = (Xpp3Dom)childPlugin.getConfiguration();
                    Xpp3Dom parentConfig = (Xpp3Dom)plugin.getConfiguration();
                    childPlugin.setConfiguration((Object)Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childConfig, (Xpp3Dom)parentConfig));
                }
            }
        }
    }

    private void assembleDependencyManagementInheritance(Model child, Model parent) {
        DependencyManagement parentDepMgmt = parent.getDependencyManagement();
        DependencyManagement childDepMgmt = child.getDependencyManagement();
        if (parentDepMgmt != null) {
            if (childDepMgmt == null) {
                child.setDependencyManagement(parentDepMgmt);
            } else {
                Dependency dep;
                List childDeps = childDepMgmt.getDependencies();
                TreeMap<String, Dependency> mappedChildDeps = new TreeMap<String, Dependency>();
                Iterator it = childDeps.iterator();
                while (it.hasNext()) {
                    dep = (Dependency)it.next();
                    mappedChildDeps.put(dep.getManagementKey(), dep);
                }
                it = parentDepMgmt.getDependencies().iterator();
                while (it.hasNext()) {
                    dep = (Dependency)it.next();
                    if (mappedChildDeps.containsKey(dep.getManagementKey())) continue;
                    childDepMgmt.addDependency(dep);
                }
            }
        }
    }

    private void assembleBuildInheritance(Model child, Model parent) {
        Build childBuild = child.getBuild();
        Build parentBuild = parent.getBuild();
        if (parentBuild != null) {
            List resources;
            if (childBuild == null) {
                childBuild = new Build();
                child.setBuild(childBuild);
            }
            if (childBuild.getDirectory() == null) {
                childBuild.setDirectory(parentBuild.getDirectory());
            }
            if (childBuild.getSourceDirectory() == null) {
                childBuild.setSourceDirectory(parentBuild.getSourceDirectory());
            }
            if (childBuild.getScriptSourceDirectory() == null) {
                childBuild.setScriptSourceDirectory(parentBuild.getScriptSourceDirectory());
            }
            if (childBuild.getTestSourceDirectory() == null) {
                childBuild.setTestSourceDirectory(parentBuild.getTestSourceDirectory());
            }
            if (childBuild.getOutputDirectory() == null) {
                childBuild.setOutputDirectory(parentBuild.getOutputDirectory());
            }
            if (childBuild.getTestOutputDirectory() == null) {
                childBuild.setTestOutputDirectory(parentBuild.getTestOutputDirectory());
            }
            if (childBuild.getFinalName() == null) {
                childBuild.setFinalName(parentBuild.getFinalName());
            }
            if ((resources = childBuild.getResources()) == null || resources.isEmpty()) {
                childBuild.setResources(parentBuild.getResources());
            }
            if ((resources = childBuild.getTestResources()) == null || resources.isEmpty()) {
                childBuild.setTestResources(parentBuild.getTestResources());
            }
            this.assemblePluginManagementInheritance(childBuild, parentBuild);
        }
    }

    private void assembleScmInheritance(Model child, Model parent) {
        if (parent.getScm() != null) {
            Scm parentScm = parent.getScm();
            Scm childScm = child.getScm();
            if (childScm == null) {
                childScm = new Scm();
                child.setScm(childScm);
            }
            if (StringUtils.isEmpty((String)childScm.getConnection()) && !StringUtils.isEmpty((String)parentScm.getConnection())) {
                if (parentScm.getConnection().endsWith("/")) {
                    childScm.setConnection(parentScm.getConnection() + child.getArtifactId() + "/");
                } else {
                    childScm.setConnection(parentScm.getConnection());
                }
            }
            if (StringUtils.isEmpty((String)childScm.getDeveloperConnection()) && !StringUtils.isEmpty((String)parentScm.getDeveloperConnection())) {
                if (parentScm.getDeveloperConnection().endsWith("/")) {
                    childScm.setDeveloperConnection(parentScm.getDeveloperConnection() + child.getArtifactId() + "/");
                } else {
                    childScm.setDeveloperConnection(parentScm.getDeveloperConnection());
                }
            }
            if (StringUtils.isEmpty((String)childScm.getUrl()) && !StringUtils.isEmpty((String)parentScm.getUrl())) {
                if (parentScm.getUrl().endsWith("/")) {
                    childScm.setUrl(parentScm.getUrl() + child.getArtifactId() + "/");
                } else {
                    childScm.setUrl(parentScm.getUrl());
                }
            }
        }
    }

    private void assembleDistributionInheritence(Model child, Model parent) {
        if (parent.getDistributionManagement() != null) {
            DistributionManagement parentDistMgmt = parent.getDistributionManagement();
            DistributionManagement childDistMgmt = child.getDistributionManagement();
            if (childDistMgmt == null) {
                childDistMgmt = new DistributionManagement();
                child.setDistributionManagement(childDistMgmt);
            }
            if (childDistMgmt.getSite() == null && parentDistMgmt.getSite() != null) {
                Site site = new Site();
                childDistMgmt.setSite(site);
                site.setId(parentDistMgmt.getSite().getId());
                site.setName(parentDistMgmt.getSite().getName());
                site.setUrl(parentDistMgmt.getSite().getUrl());
                if (site.getUrl() != null && site.getUrl().endsWith("/")) {
                    site.setUrl(site.getUrl() + child.getArtifactId() + "/");
                }
            }
            if (childDistMgmt.getRepository() == null && parentDistMgmt.getRepository() != null) {
                Repository repository = new Repository();
                childDistMgmt.setRepository(repository);
                repository.setId(parentDistMgmt.getRepository().getId());
                repository.setName(parentDistMgmt.getRepository().getName());
                repository.setUrl(parentDistMgmt.getRepository().getUrl());
            }
        }
    }
}

