/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.injection;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Goal;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.project.injection.ModelDefaultsInjector;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class DefaultModelDefaultsInjector
implements ModelDefaultsInjector {
    public void injectDefaults(Model model) {
        this.injectDependencyDefaults(model.getDependencies(), model.getDependencyManagement());
        if (model.getBuild() != null) {
            this.injectPluginDefaults(model.getBuild().getPluginsAsMap(), model.getBuild().getPluginManagement());
        }
    }

    private void injectPluginDefaults(Map pluginMap, PluginManagement pluginManagement) {
        if (pluginManagement != null) {
            List managedPlugins = pluginManagement.getPlugins();
            Iterator it = managedPlugins.iterator();
            while (it.hasNext()) {
                Plugin def = (Plugin)it.next();
                Plugin plugin = (Plugin)pluginMap.get(def.getKey());
                if (plugin == null) continue;
                this.mergePluginWithDefaults(plugin, def);
            }
        }
    }

    public void mergePluginWithDefaults(Plugin plugin, Plugin def) {
        if (plugin.getVersion() == null && def.getVersion() != null) {
            plugin.setVersion(def.getVersion());
        }
        Map defaultGoals = def.getGoalsAsMap();
        List pluginGoals = plugin.getGoals();
        if (pluginGoals != null) {
            Iterator it = pluginGoals.iterator();
            while (it.hasNext()) {
                Goal pluginGoal = (Goal)it.next();
                Goal defaultGoal = (Goal)defaultGoals.get(pluginGoal.getId());
                if (defaultGoal == null) continue;
                Xpp3Dom pluginGoalConfig = (Xpp3Dom)pluginGoal.getConfiguration();
                Xpp3Dom defaultGoalConfig = (Xpp3Dom)defaultGoal.getConfiguration();
                pluginGoalConfig = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)pluginGoalConfig, (Xpp3Dom)defaultGoalConfig);
                pluginGoal.setConfiguration((Object)pluginGoalConfig);
            }
        }
        Xpp3Dom pluginConfiguration = (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom defaultConfiguration = (Xpp3Dom)def.getConfiguration();
        pluginConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)pluginConfiguration, (Xpp3Dom)defaultConfiguration);
        plugin.setConfiguration((Object)pluginConfiguration);
    }

    private void injectDependencyDefaults(List dependencies, DependencyManagement dependencyManagement) {
        if (dependencyManagement != null) {
            TreeMap<String, Dependency> depsMap = new TreeMap<String, Dependency>();
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                depsMap.put(dep.getManagementKey(), dep);
            }
            List managedDependencies = dependencyManagement.getDependencies();
            Iterator it2 = managedDependencies.iterator();
            while (it2.hasNext()) {
                Dependency def = (Dependency)it2.next();
                String key = def.getManagementKey();
                Dependency dep = (Dependency)depsMap.get(key);
                if (dep == null) continue;
                this.mergeDependencyWithDefaults(dep, def);
            }
        }
    }

    private void mergeDependencyWithDefaults(Dependency dep, Dependency def) {
        if (dep.getScope() == null && def.getScope() != null) {
            dep.setScope(def.getScope());
        }
        if (dep.getVersion() == null && def.getVersion() != null) {
            dep.setVersion(def.getVersion());
        }
    }
}

