/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;

public class MavenMetadataSource
implements ArtifactMetadataSource {
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private MavenXpp3Reader reader = new MavenXpp3Reader();

    public MavenMetadataSource(ArtifactResolver artifactResolver, MavenProjectBuilder projectBuilder, ArtifactFactory artifactFactory) {
        this.artifactResolver = artifactResolver;
        this.mavenProjectBuilder = projectBuilder;
        this.artifactFactory = artifactFactory;
    }

    public Set retrieve(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        Artifact pomArtifact = this.artifactFactory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), "pom");
        List dependencies = null;
        try {
            MavenProject p = this.mavenProjectBuilder.buildFromRepository(pomArtifact, remoteRepositories, localRepository);
            dependencies = p.getDependencies();
            artifact.setDownloadUrl(pomArtifact.getDownloadUrl());
        }
        catch (ProjectBuildingException e) {
            throw new ArtifactMetadataRetrievalException("Unable to read the metadata file", (Throwable)e);
        }
        return MavenMetadataSource.createArtifacts(this.artifactFactory, dependencies, artifact.getScope(), artifact.getDependencyFilter());
    }

    public static Set createArtifacts(ArtifactFactory artifactFactory, List dependencies, String inheritedScope, ArtifactFilter dependencyFilter) {
        HashSet<Artifact> projectArtifacts = new HashSet<Artifact>();
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            Dependency d = (Dependency)i.next();
            Artifact artifact = artifactFactory.createArtifact(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getScope(), d.getType(), inheritedScope);
            if (artifact == null || dependencyFilter != null && !dependencyFilter.include(artifact)) continue;
            if (d.getExclusions() != null && !d.getExclusions().isEmpty()) {
                ArrayList<String> exclusions = new ArrayList<String>();
                Iterator j = d.getExclusions().iterator();
                while (j.hasNext()) {
                    Exclusion e = (Exclusion)j.next();
                    exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
                }
                ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
                if (dependencyFilter != null) {
                    AndArtifactFilter filter = new AndArtifactFilter();
                    filter.add(dependencyFilter);
                    filter.add((ArtifactFilter)newFilter);
                    dependencyFilter = filter;
                } else {
                    dependencyFilter = newFilter;
                }
            }
            artifact.setDependencyFilter(dependencyFilter);
            projectArtifacts.add(artifact);
        }
        return projectArtifacts;
    }
}

