/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.inheritance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.apache.maven.project.ModelUtils;
import org.apache.maven.project.inheritance.ModelInheritanceAssembler;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class DefaultModelInheritanceAssembler
implements ModelInheritanceAssembler {
    public void assembleModelInheritance(Model child, Model parent) {
        if (parent == null) {
            return;
        }
        if (child.getGroupId() == null) {
            child.setGroupId(parent.getGroupId());
        }
        if (child.getVersion() == null && child.getParent() != null) {
            child.setVersion(child.getParent().getVersion());
        }
        if (child.getInceptionYear() == null) {
            child.setInceptionYear(parent.getInceptionYear());
        }
        if (child.getUrl() == null) {
            if (parent.getUrl() != null) {
                child.setUrl(DefaultModelInheritanceAssembler.appendPath(parent.getUrl(), child.getArtifactId()));
            } else {
                child.setUrl(parent.getUrl());
            }
        }
        this.assembleDistributionInheritence(child, parent);
        if (child.getIssueManagement() == null) {
            child.setIssueManagement(parent.getIssueManagement());
        }
        if (child.getDescription() == null) {
            child.setDescription(parent.getDescription());
        }
        if (child.getOrganization() == null) {
            child.setOrganization(parent.getOrganization());
        }
        this.assembleScmInheritance(child, parent);
        if (child.getCiManagement() == null) {
            child.setCiManagement(parent.getCiManagement());
        }
        if (child.getDevelopers().size() == 0) {
            child.setDevelopers(parent.getDevelopers());
        }
        if (child.getContributors().size() == 0) {
            child.setContributors(parent.getContributors());
        }
        if (child.getMailingLists().size() == 0) {
            child.setMailingLists(parent.getMailingLists());
        }
        this.assembleBuildInheritance(child, parent.getBuild());
        this.assembleModelBaseInheritance((ModelBase)child, (ModelBase)parent);
    }

    public void mergeProfileWithModel(Model model, Profile profile) {
        this.assembleModelBaseInheritance((ModelBase)model, (ModelBase)profile);
        this.assembleBuildBaseInheritance((BuildBase)model.getBuild(), profile.getBuild());
    }

    private void assembleModelBaseInheritance(ModelBase child, ModelBase parent) {
        List dependencies = parent.getDependencies();
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            child.addDependency(dependency);
        }
        List parentRepositories = parent.getRepositories();
        List childRepositories = child.getRepositories();
        Iterator iterator2 = parentRepositories.iterator();
        while (iterator2.hasNext()) {
            Repository repository = (Repository)iterator2.next();
            if (childRepositories.contains(repository)) continue;
            child.addRepository(repository);
        }
        List parentPluginRepositories = parent.getPluginRepositories();
        List childPluginRepositories = child.getPluginRepositories();
        Iterator iterator3 = parentPluginRepositories.iterator();
        while (iterator3.hasNext()) {
            Repository repository = (Repository)iterator3.next();
            if (childPluginRepositories.contains(repository)) continue;
            child.addPluginRepository(repository);
        }
        Reporting childReporting = child.getReporting();
        Reporting parentReporting = parent.getReporting();
        if (childReporting != null && parentReporting != null) {
            Iterator<Object> it;
            if (StringUtils.isEmpty((String)childReporting.getOutputDirectory())) {
                childReporting.setOutputDirectory(parentReporting.getOutputDirectory());
            }
            HashMap<String, Object> mergedReportPlugins = new HashMap<String, Object>();
            Map childReportersByKey = childReporting.getReportPluginsAsMap();
            List parentReportPlugins = parentReporting.getPlugins();
            if (parentReportPlugins != null) {
                it = parentReportPlugins.iterator();
                while (it.hasNext()) {
                    ReportPlugin parentReportPlugin = (ReportPlugin)it.next();
                    String inherited = parentReportPlugin.getInherited();
                    if (!StringUtils.isEmpty((String)inherited) && !Boolean.valueOf(inherited).booleanValue()) continue;
                    ReportPlugin childReportPlugin = (ReportPlugin)childReportersByKey.get(parentReportPlugin.getKey());
                    ReportPlugin mergedReportPlugin = parentReportPlugin;
                    if (childReportPlugin != null) {
                        mergedReportPlugin = childReportPlugin;
                        this.mergeReportPlugins(childReportPlugin, parentReportPlugin);
                    } else if (StringUtils.isEmpty((String)inherited)) {
                        mergedReportPlugin.unsetInheritanceApplied();
                    }
                    mergedReportPlugins.put(mergedReportPlugin.getKey(), mergedReportPlugin);
                }
            }
            it = childReportersByKey.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String key = (String)entry.getKey();
                if (mergedReportPlugins.containsKey(key)) continue;
                mergedReportPlugins.put(key, entry.getValue());
            }
            childReporting.setPlugins(new ArrayList(mergedReportPlugins.values()));
            childReporting.flushReportPluginMap();
        }
        this.assembleDependencyManagementInheritance(child, parent);
    }

    private void mergeReportPlugins(ReportPlugin dominant, ReportPlugin recessive) {
        if (StringUtils.isEmpty((String)dominant.getVersion())) {
            dominant.setVersion(recessive.getVersion());
        }
        Xpp3Dom dominantConfig = (Xpp3Dom)dominant.getConfiguration();
        Xpp3Dom recessiveConfig = (Xpp3Dom)recessive.getConfiguration();
        dominant.setConfiguration((Object)Xpp3Dom.mergeXpp3Dom((Xpp3Dom)dominantConfig, (Xpp3Dom)recessiveConfig));
        HashMap<String, Object> mergedReportSets = new HashMap<String, Object>();
        Map dominantReportSetsById = dominant.getReportSetsAsMap();
        Iterator it = recessive.getReportSets().iterator();
        while (it.hasNext()) {
            ReportSet recessiveReportSet = (ReportSet)it.next();
            String inherited = recessiveReportSet.getInherited();
            if (!StringUtils.isEmpty((String)inherited) && !Boolean.valueOf(inherited).booleanValue()) continue;
            ReportSet dominantReportSet = (ReportSet)dominantReportSetsById.get(recessiveReportSet.getId());
            ReportSet merged = recessiveReportSet;
            if (dominantReportSet != null) {
                List recessiveRSReports;
                merged = dominantReportSet;
                Xpp3Dom recessiveRSConfig = (Xpp3Dom)recessiveReportSet.getConfiguration();
                Xpp3Dom mergedRSConfig = (Xpp3Dom)merged.getConfiguration();
                merged.setConfiguration((Object)Xpp3Dom.mergeXpp3Dom((Xpp3Dom)mergedRSConfig, (Xpp3Dom)recessiveRSConfig));
                ArrayList<String> mergedReports = merged.getReports();
                if (mergedReports == null) {
                    mergedReports = new ArrayList<String>();
                    merged.setReports(mergedReports);
                }
                if ((recessiveRSReports = recessiveReportSet.getReports()) != null) {
                    Iterator reportIterator = recessiveRSReports.iterator();
                    while (reportIterator.hasNext()) {
                        String report = (String)reportIterator.next();
                        if (mergedReports.contains(report)) continue;
                        mergedReports.add(report);
                    }
                }
            } else if (StringUtils.isEmpty((String)inherited)) {
                merged.unsetInheritanceApplied();
            }
            mergedReportSets.put(merged.getId(), merged);
        }
        Iterator rsIterator = dominantReportSetsById.entrySet().iterator();
        while (rsIterator.hasNext()) {
            Map.Entry entry = rsIterator.next();
            String key = (String)entry.getKey();
            if (mergedReportSets.containsKey(key)) continue;
            mergedReportSets.put(key, entry.getValue());
        }
        dominant.setReportSets(new ArrayList(mergedReportSets.values()));
        dominant.flushReportSetMap();
    }

    private void assembleDependencyManagementInheritance(ModelBase child, ModelBase parent) {
        DependencyManagement parentDepMgmt = parent.getDependencyManagement();
        DependencyManagement childDepMgmt = child.getDependencyManagement();
        if (parentDepMgmt != null) {
            if (childDepMgmt == null) {
                child.setDependencyManagement(parentDepMgmt);
            } else {
                Dependency dep;
                List childDeps = childDepMgmt.getDependencies();
                TreeMap<String, Dependency> mappedChildDeps = new TreeMap<String, Dependency>();
                Iterator it = childDeps.iterator();
                while (it.hasNext()) {
                    dep = (Dependency)it.next();
                    mappedChildDeps.put(dep.getManagementKey(), dep);
                }
                it = parentDepMgmt.getDependencies().iterator();
                while (it.hasNext()) {
                    dep = (Dependency)it.next();
                    if (mappedChildDeps.containsKey(dep.getManagementKey())) continue;
                    childDepMgmt.addDependency(dep);
                }
            }
        }
    }

    private void assembleBuildInheritance(Model child, Build parentBuild) {
        if (parentBuild == null) {
            return;
        }
        Build childBuild = child.getBuild();
        if (parentBuild != null) {
            if (childBuild == null) {
                childBuild = new Build();
                child.setBuild(childBuild);
            }
            if (childBuild.getDirectory() == null) {
                childBuild.setDirectory(parentBuild.getDirectory());
            }
            if (childBuild.getSourceDirectory() == null) {
                childBuild.setSourceDirectory(parentBuild.getSourceDirectory());
            }
            if (childBuild.getScriptSourceDirectory() == null) {
                childBuild.setScriptSourceDirectory(parentBuild.getScriptSourceDirectory());
            }
            if (childBuild.getTestSourceDirectory() == null) {
                childBuild.setTestSourceDirectory(parentBuild.getTestSourceDirectory());
            }
            if (childBuild.getOutputDirectory() == null) {
                childBuild.setOutputDirectory(parentBuild.getOutputDirectory());
            }
            if (childBuild.getTestOutputDirectory() == null) {
                childBuild.setTestOutputDirectory(parentBuild.getTestOutputDirectory());
            }
            this.assembleBuildBaseInheritance((BuildBase)childBuild, (BuildBase)parentBuild);
        }
    }

    private void assembleBuildBaseInheritance(BuildBase childBuild, BuildBase parentBuild) {
        List resources;
        if (parentBuild == null) {
            return;
        }
        if (childBuild.getDefaultGoal() == null) {
            childBuild.setDefaultGoal(parentBuild.getDefaultGoal());
        }
        if (childBuild.getFinalName() == null) {
            childBuild.setFinalName(parentBuild.getFinalName());
        }
        if ((resources = childBuild.getResources()) == null || resources.isEmpty()) {
            childBuild.setResources(parentBuild.getResources());
        }
        if ((resources = childBuild.getTestResources()) == null || resources.isEmpty()) {
            childBuild.setTestResources(parentBuild.getTestResources());
        }
        ModelUtils.mergePluginLists((PluginContainer)childBuild, (PluginContainer)parentBuild, true);
        if (childBuild != null && parentBuild != null) {
            ModelUtils.mergePluginLists((PluginContainer)childBuild.getPluginManagement(), (PluginContainer)parentBuild.getPluginManagement(), false);
        }
    }

    private void assembleScmInheritance(Model child, Model parent) {
        if (parent.getScm() != null) {
            Scm parentScm = parent.getScm();
            Scm childScm = child.getScm();
            if (childScm == null) {
                childScm = new Scm();
                child.setScm(childScm);
            }
            if (StringUtils.isEmpty((String)childScm.getConnection()) && !StringUtils.isEmpty((String)parentScm.getConnection())) {
                childScm.setConnection(DefaultModelInheritanceAssembler.appendPath(parentScm.getConnection(), child.getArtifactId()));
            }
            if (StringUtils.isEmpty((String)childScm.getDeveloperConnection()) && !StringUtils.isEmpty((String)parentScm.getDeveloperConnection())) {
                childScm.setDeveloperConnection(DefaultModelInheritanceAssembler.appendPath(parentScm.getDeveloperConnection(), child.getArtifactId()));
            }
            if (StringUtils.isEmpty((String)childScm.getUrl()) && !StringUtils.isEmpty((String)parentScm.getUrl())) {
                childScm.setUrl(DefaultModelInheritanceAssembler.appendPath(parentScm.getUrl(), child.getArtifactId()));
            }
        }
    }

    private void assembleDistributionInheritence(Model child, Model parent) {
        if (parent.getDistributionManagement() != null) {
            DistributionManagement parentDistMgmt = parent.getDistributionManagement();
            DistributionManagement childDistMgmt = child.getDistributionManagement();
            if (childDistMgmt == null) {
                childDistMgmt = new DistributionManagement();
                child.setDistributionManagement(childDistMgmt);
            }
            if (childDistMgmt.getSite() == null && parentDistMgmt.getSite() != null) {
                Site site = new Site();
                childDistMgmt.setSite(site);
                site.setId(parentDistMgmt.getSite().getId());
                site.setName(parentDistMgmt.getSite().getName());
                site.setUrl(parentDistMgmt.getSite().getUrl());
                if (site.getUrl() != null) {
                    site.setUrl(DefaultModelInheritanceAssembler.appendPath(site.getUrl(), child.getArtifactId()));
                }
            }
            if (childDistMgmt.getRepository() == null && parentDistMgmt.getRepository() != null) {
                Repository repository = new Repository();
                childDistMgmt.setRepository(repository);
                repository.setId(parentDistMgmt.getRepository().getId());
                repository.setName(parentDistMgmt.getRepository().getName());
                repository.setUrl(parentDistMgmt.getRepository().getUrl());
            }
        }
    }

    private static String appendPath(String url, String path) {
        if (url.endsWith("/")) {
            return url + path;
        }
        return url + "/" + path;
    }
}

