/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.injection;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.project.ModelUtils;
import org.apache.maven.project.injection.ModelDefaultsInjector;

public class DefaultModelDefaultsInjector
implements ModelDefaultsInjector {
    public void injectDefaults(Model model) {
        this.injectDependencyDefaults(model.getDependencies(), model.getDependencyManagement());
        if (model.getBuild() != null) {
            ModelUtils.mergePluginLists((PluginContainer)model.getBuild(), (PluginContainer)model.getBuild().getPluginManagement(), false);
        }
    }

    public void mergePluginWithDefaults(Plugin plugin, Plugin def) {
        ModelUtils.mergePluginDefinitions(plugin, def, false);
    }

    private void injectDependencyDefaults(List dependencies, DependencyManagement dependencyManagement) {
        if (dependencyManagement != null) {
            TreeMap<String, Dependency> depsMap = new TreeMap<String, Dependency>();
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                depsMap.put(dep.getManagementKey(), dep);
            }
            List managedDependencies = dependencyManagement.getDependencies();
            Iterator it2 = managedDependencies.iterator();
            while (it2.hasNext()) {
                Dependency def = (Dependency)it2.next();
                String key = def.getManagementKey();
                Dependency dep = (Dependency)depsMap.get(key);
                if (dep == null) continue;
                this.mergeDependencyWithDefaults(dep, def);
            }
        }
    }

    private void mergeDependencyWithDefaults(Dependency dep, Dependency def) {
        if (dep.getScope() == null && def.getScope() != null) {
            dep.setScope(def.getScope());
        }
        if (dep.getVersion() == null && def.getVersion() != null) {
            dep.setVersion(def.getVersion());
        }
    }
}

