/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.validation;

import java.util.Iterator;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;

public class DefaultModelValidator
implements ModelValidator {
    public ModelValidationResult validate(Model model) {
        ModelValidationResult result = new ModelValidationResult();
        this.validateStringNotEmpty("modelVersion", result, model.getModelVersion());
        this.validateStringNotEmpty("groupId", result, model.getGroupId());
        this.validateStringNotEmpty("artifactId", result, model.getArtifactId());
        this.validateStringNotEmpty("packaging", result, model.getPackaging());
        this.validateStringNotEmpty("version", result, model.getVersion());
        Iterator it = model.getDependencies().iterator();
        while (it.hasNext()) {
            Dependency d = (Dependency)it.next();
            this.validateStringNotEmpty("dependencies.dependency.artifactId", result, d.getArtifactId());
            this.validateStringNotEmpty("dependencies.dependency.groupId", result, d.getGroupId());
            this.validateStringNotEmpty("dependencies.dependency.type", result, d.getType());
            this.validateStringNotEmpty("dependencies.dependency.version", result, d.getVersion());
        }
        return result;
    }

    private boolean validateStringNotEmpty(String fieldName, ModelValidationResult result, String string) {
        if (!this.validateNotNull(fieldName, result, string)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        result.addMessage("'" + fieldName + "' is empty.");
        return false;
    }

    private boolean validateNotNull(String fieldName, ModelValidationResult result, Object object) {
        if (object != null) {
            return true;
        }
        result.addMessage("'" + fieldName + "' is missing.");
        return false;
    }
}

