/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.maven.model.Goal;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.project.inheritance.DefaultModelInheritanceAssembler;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public final class ModelUtils {
    public static void mergePluginLists(PluginContainer childContainer, PluginContainer parentContainer, boolean handleAsInheritance) {
        if (childContainer == null || parentContainer == null) {
            return;
        }
        List parentPlugins = parentContainer.getPlugins();
        if (parentPlugins != null && !parentPlugins.isEmpty()) {
            TreeMap<String, Plugin> assembledPlugins = new TreeMap<String, Plugin>();
            Map childPlugins = childContainer.getPluginsAsMap();
            Iterator<Object> it = parentPlugins.iterator();
            while (it.hasNext()) {
                Plugin parentPlugin = (Plugin)it.next();
                String parentInherited = parentPlugin.getInherited();
                if (handleAsInheritance && parentInherited != null && !Boolean.valueOf(parentInherited).booleanValue()) continue;
                Plugin assembledPlugin = parentPlugin;
                Plugin childPlugin = (Plugin)childPlugins.get(parentPlugin.getKey());
                if (childPlugin != null) {
                    assembledPlugin = childPlugin;
                    ModelUtils.mergePluginDefinitions(childPlugin, parentPlugin, handleAsInheritance);
                }
                if (handleAsInheritance && parentInherited == null) {
                    assembledPlugin.unsetInheritanceApplied();
                }
                assembledPlugins.put(assembledPlugin.getKey(), assembledPlugin);
            }
            it = childPlugins.values().iterator();
            while (it.hasNext()) {
                Plugin childPlugin = (Plugin)it.next();
                if (assembledPlugins.containsKey(childPlugin.getKey())) continue;
                assembledPlugins.put(childPlugin.getKey(), childPlugin);
            }
            childContainer.setPlugins(new ArrayList(assembledPlugins.values()));
            childContainer.flushPluginMap();
        }
    }

    public static void mergeReportPluginLists(Reporting child, Reporting parent, boolean handleAsInheritance) {
        if (child == null || parent == null) {
            return;
        }
        List parentPlugins = parent.getPlugins();
        if (parentPlugins != null && !parentPlugins.isEmpty()) {
            TreeMap<String, ReportPlugin> assembledPlugins = new TreeMap<String, ReportPlugin>();
            Map childPlugins = child.getReportPluginsAsMap();
            Iterator<Object> it = parentPlugins.iterator();
            while (it.hasNext()) {
                ReportPlugin parentPlugin = (ReportPlugin)it.next();
                String parentInherited = parentPlugin.getInherited();
                if (handleAsInheritance && parentInherited != null && !Boolean.valueOf(parentInherited).booleanValue()) continue;
                ReportPlugin assembledPlugin = parentPlugin;
                ReportPlugin childPlugin = (ReportPlugin)childPlugins.get(parentPlugin.getKey());
                if (childPlugin != null) {
                    assembledPlugin = childPlugin;
                    ModelUtils.mergeReportPluginDefinitions(childPlugin, parentPlugin, handleAsInheritance);
                }
                if (handleAsInheritance && parentInherited == null) {
                    assembledPlugin.unsetInheritanceApplied();
                }
                assembledPlugins.put(assembledPlugin.getKey(), assembledPlugin);
            }
            it = childPlugins.values().iterator();
            while (it.hasNext()) {
                ReportPlugin childPlugin = (ReportPlugin)it.next();
                if (assembledPlugins.containsKey(childPlugin.getKey())) continue;
                assembledPlugins.put(childPlugin.getKey(), childPlugin);
            }
            child.setPlugins(new ArrayList(assembledPlugins.values()));
            child.flushReportPluginMap();
        }
    }

    public static void mergePluginDefinitions(Plugin child, Plugin parent, boolean handleAsInheritance) {
        if (child == null || parent == null) {
            return;
        }
        if (parent.isExtensions()) {
            child.setExtensions(true);
        }
        if (child.getVersion() == null && parent.getVersion() != null) {
            child.setVersion(parent.getVersion());
        }
        ModelUtils.mergeGoalContainerDefinitions(child, parent);
        String parentInherited = parent.getInherited();
        boolean parentIsInherited = parentInherited == null || Boolean.valueOf(parentInherited) != false;
        List parentExecutions = parent.getExecutions();
        if (parentExecutions != null && !parentExecutions.isEmpty()) {
            TreeMap<String, Object> assembledExecutions = new TreeMap<String, Object>();
            Map childExecutions = child.getExecutionsAsMap();
            Iterator<Object> it = parentExecutions.iterator();
            while (it.hasNext()) {
                PluginExecution parentExecution = (PluginExecution)it.next();
                if (handleAsInheritance && !parentIsInherited) continue;
                PluginExecution assembled = parentExecution;
                PluginExecution childExecution = (PluginExecution)childExecutions.get(parentExecution.getId());
                if (childExecution != null) {
                    ModelUtils.mergePluginExecutionDefinitions(childExecution, parentExecution);
                    assembled = childExecution;
                } else if (handleAsInheritance && parentInherited == null) {
                    parentExecution.unsetInheritanceApplied();
                }
                assembledExecutions.put(assembled.getId(), assembled);
            }
            it = childExecutions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String id = (String)entry.getKey();
                if (assembledExecutions.containsKey(id)) continue;
                assembledExecutions.put(id, entry.getValue());
            }
            child.setExecutions(new ArrayList(assembledExecutions.values()));
            child.flushExecutionMap();
        }
    }

    public static void mergeReportPluginDefinitions(ReportPlugin child, ReportPlugin parent, boolean handleAsInheritance) {
        String parentInherited;
        if (child == null || parent == null) {
            return;
        }
        if (child.getVersion() == null && parent.getVersion() != null) {
            child.setVersion(parent.getVersion());
        }
        boolean parentIsInherited = (parentInherited = parent.getInherited()) == null || Boolean.valueOf(parentInherited) != false;
        List parentReportSets = parent.getReportSets();
        if (parentReportSets != null && !parentReportSets.isEmpty()) {
            TreeMap<String, Object> assembledReportSets = new TreeMap<String, Object>();
            Map childReportSets = child.getReportSetsAsMap();
            Iterator<Object> it = parentReportSets.iterator();
            while (it.hasNext()) {
                ReportSet parentReportSet = (ReportSet)it.next();
                if (handleAsInheritance && !parentIsInherited) continue;
                ReportSet assembledReportSet = parentReportSet;
                ReportSet childReportSet = (ReportSet)childReportSets.get(parentReportSet.getId());
                if (childReportSet != null) {
                    ModelUtils.mergeReportSetDefinitions(childReportSet, parentReportSet);
                    assembledReportSet = childReportSet;
                } else if (handleAsInheritance && parentInherited == null) {
                    parentReportSet.unsetInheritanceApplied();
                }
                assembledReportSets.put(assembledReportSet.getId(), assembledReportSet);
            }
            it = childReportSets.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String id = (String)entry.getKey();
                if (assembledReportSets.containsKey(id)) continue;
                assembledReportSets.put(id, entry.getValue());
            }
            child.setReportSets(new ArrayList(assembledReportSets.values()));
            child.flushReportSetMap();
        }
    }

    private static void mergeGoalContainerDefinitions(Plugin child, Plugin parent) {
        List parentGoals = parent.getGoals();
        if (parentGoals != null && !parentGoals.isEmpty()) {
            TreeMap<String, Goal> assembledGoals = new TreeMap<String, Goal>();
            Map childGoals = child.getGoalsAsMap();
            if (childGoals != null) {
                Goal childGoal;
                Iterator<Object> it = parentGoals.iterator();
                while (it.hasNext()) {
                    Goal parentGoal;
                    Goal assembledGoal = parentGoal = (Goal)it.next();
                    childGoal = (Goal)childGoals.get(parentGoal.getId());
                    if (childGoal != null) {
                        Xpp3Dom childGoalConfig = (Xpp3Dom)childGoal.getConfiguration();
                        Xpp3Dom parentGoalConfig = (Xpp3Dom)parentGoal.getConfiguration();
                        childGoalConfig = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childGoalConfig, (Xpp3Dom)parentGoalConfig);
                        childGoal.setConfiguration((Object)childGoalConfig);
                        assembledGoal = childGoal;
                    }
                    assembledGoals.put(assembledGoal.getId(), assembledGoal);
                }
                it = childGoals.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    String key = (String)entry.getKey();
                    childGoal = (Goal)entry.getValue();
                    if (assembledGoals.containsKey(key)) continue;
                    assembledGoals.put(key, childGoal);
                }
                child.setGoals(new ArrayList(assembledGoals.values()));
                child.flushGoalMap();
            }
        }
        Xpp3Dom childConfiguration = (Xpp3Dom)child.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)parent.getConfiguration();
        childConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childConfiguration, (Xpp3Dom)parentConfiguration);
        child.setConfiguration((Object)childConfiguration);
    }

    private static void mergePluginExecutionDefinitions(PluginExecution child, PluginExecution parent) {
        if (child.getPhase() == null) {
            child.setPhase(parent.getPhase());
        }
        List parentGoals = parent.getGoals();
        List childGoals = child.getGoals();
        ArrayList<String> goals = new ArrayList<String>();
        if (childGoals != null && !childGoals.isEmpty()) {
            goals.addAll(childGoals);
        }
        if (parentGoals != null) {
            Iterator goalIterator = parentGoals.iterator();
            while (goalIterator.hasNext()) {
                String goal = (String)goalIterator.next();
                if (goals.contains(goal)) continue;
                goals.add(goal);
            }
        }
        child.setGoals(goals);
        Xpp3Dom childConfiguration = (Xpp3Dom)child.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)parent.getConfiguration();
        childConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childConfiguration, (Xpp3Dom)parentConfiguration);
        child.setConfiguration((Object)childConfiguration);
    }

    private static void mergeReportSetDefinitions(ReportSet child, ReportSet parent) {
        List parentReports = parent.getReports();
        List childReports = child.getReports();
        ArrayList<String> reports = new ArrayList<String>();
        if (childReports != null && !childReports.isEmpty()) {
            reports.addAll(childReports);
        }
        if (parentReports != null) {
            Iterator i = parentReports.iterator();
            while (i.hasNext()) {
                String report = (String)i.next();
                if (reports.contains(report)) continue;
                reports.add(report);
            }
        }
        child.setReports(reports);
        Xpp3Dom childConfiguration = (Xpp3Dom)child.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)parent.getConfiguration();
        childConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childConfiguration, (Xpp3Dom)parentConfiguration);
        child.setConfiguration((Object)childConfiguration);
    }

    static Model cloneModel(Model model) {
        Model newModel = new Model();
        DefaultModelInheritanceAssembler assembler = new DefaultModelInheritanceAssembler();
        newModel.setModelVersion(model.getModelVersion());
        newModel.setName(model.getName());
        newModel.setParent(ModelUtils.cloneParent(model.getParent()));
        newModel.setVersion(model.getVersion());
        newModel.setArtifactId(model.getArtifactId());
        newModel.setProperties(new Properties(model.getProperties()));
        newModel.setGroupId(model.getGroupId());
        newModel.setPackaging(model.getPackaging());
        newModel.setModules(ModelUtils.cloneModules(model.getModules()));
        assembler.copyModel(newModel, model);
        return newModel;
    }

    private static List cloneModules(List modules) {
        if (modules == null) {
            return modules;
        }
        return new ArrayList(modules);
    }

    private static Parent cloneParent(Parent parent) {
        if (parent == null) {
            return parent;
        }
        Parent newParent = new Parent();
        newParent.setArtifactId(parent.getArtifactId());
        newParent.setGroupId(parent.getGroupId());
        newParent.setRelativePath(parent.getRelativePath());
        newParent.setVersion(parent.getVersion());
        return newParent;
    }

    public static List mergeRepositoryLists(List dominant, List recessive) {
        Repository repository;
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        Iterator it = dominant.iterator();
        while (it.hasNext()) {
            repository = (Repository)it.next();
            repositories.add(repository);
        }
        it = recessive.iterator();
        while (it.hasNext()) {
            repository = (Repository)it.next();
            if (repositories.contains(repository)) continue;
            repositories.add(repository);
        }
        return repositories;
    }
}

