/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;

public class ProjectSorter {
    private ProjectSorter() {
    }

    public static List getSortedProjects(List projects) throws CycleDetectedException {
        String id;
        MavenProject project;
        DAG dag = new DAG();
        HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
        Iterator i = projects.iterator();
        while (i.hasNext()) {
            project = (MavenProject)i.next();
            id = ProjectSorter.getId(project.getGroupId(), project.getArtifactId());
            dag.addVertex(id);
            projectMap.put(id, project);
        }
        i = projects.iterator();
        while (i.hasNext()) {
            Iterator j;
            List reportPlugins;
            List buildPlugins;
            String parentId;
            project = (MavenProject)i.next();
            id = ProjectSorter.getId(project.getGroupId(), project.getArtifactId());
            Iterator j2 = project.getDependencies().iterator();
            while (j2.hasNext()) {
                Dependency dependency = (Dependency)j2.next();
                String dependencyId = ProjectSorter.getId(dependency.getGroupId(), dependency.getArtifactId());
                if (dag.getVertex(dependencyId) == null) continue;
                project.addProjectReference((MavenProject)projectMap.get(dependencyId));
                dag.addEdge(id, dependencyId);
            }
            MavenProject parent = project.getParent();
            if (parent != null && dag.getVertex(parentId = ProjectSorter.getId(parent.getGroupId(), parent.getArtifactId())) != null) {
                dag.addEdge(id, parentId);
            }
            if ((buildPlugins = project.getBuildPlugins()) != null) {
                Iterator j3 = buildPlugins.iterator();
                while (j3.hasNext()) {
                    Plugin plugin = (Plugin)j3.next();
                    String pluginId = ProjectSorter.getId(plugin.getGroupId(), plugin.getArtifactId());
                    if (dag.getVertex(pluginId) == null) continue;
                    dag.addEdge(id, pluginId);
                }
            }
            if ((reportPlugins = project.getReportPlugins()) != null) {
                j = reportPlugins.iterator();
                while (j.hasNext()) {
                    ReportPlugin plugin = (ReportPlugin)j.next();
                    String pluginId = ProjectSorter.getId(plugin.getGroupId(), plugin.getArtifactId());
                    if (dag.getVertex(pluginId) == null) continue;
                    dag.addEdge(id, pluginId);
                }
            }
            j = project.getBuildExtensions().iterator();
            while (j.hasNext()) {
                Extension extension = (Extension)j.next();
                String extensionId = ProjectSorter.getId(extension.getGroupId(), extension.getArtifactId());
                if (dag.getVertex(extensionId) == null) continue;
                dag.addEdge(id, extensionId);
            }
        }
        ArrayList sortedProjects = new ArrayList();
        Iterator i2 = TopologicalSorter.sort((DAG)dag).iterator();
        while (i2.hasNext()) {
            id = (String)i2.next();
            sortedProjects.add(projectMap.get(id));
        }
        return sortedProjects;
    }

    private static String getId(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }
}

