/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Relocation;
import org.apache.maven.project.InvalidModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.ActiveProjectArtifact;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenMetadataSource
extends AbstractLogEnabled
implements ArtifactMetadataSource {
    public static final String ROLE_HINT = "maven";
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactFactory artifactFactory;
    private RepositoryMetadataManager repositoryMetadataManager;
    private MavenProject superProject;

    public ResolutionGroup retrieve(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        Artifact pomArtifact;
        MavenProject project = null;
        boolean done = false;
        do {
            pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
            if ("system".equals(artifact.getScope())) {
                done = true;
                continue;
            }
            try {
                project = this.mavenProjectBuilder.buildFromRepository(pomArtifact, remoteRepositories, localRepository);
            }
            catch (InvalidModelException e) {
                this.getLogger().warn("POM for: '" + pomArtifact.getId() + "' does not appear to be valid. Its will be ignored for artifact resolution.");
                project = null;
            }
            catch (ProjectBuildingException e) {
                throw new ArtifactMetadataRetrievalException("Unable to read the metadata file", (Throwable)e);
            }
            if (project != null) {
                Relocation relocation = null;
                DistributionManagement distMgmt = project.getDistributionManagement();
                if (distMgmt != null) {
                    relocation = distMgmt.getRelocation();
                }
                if (relocation != null) {
                    if (relocation.getGroupId() != null) {
                        artifact.setGroupId(relocation.getGroupId());
                    }
                    if (relocation.getArtifactId() != null) {
                        artifact.setArtifactId(relocation.getArtifactId());
                    }
                    if (relocation.getVersion() != null) {
                        artifact.setVersion(relocation.getVersion());
                    }
                    String message = "\n  This artifact has been relocated to " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ".\n";
                    if (relocation.getMessage() != null) {
                        message = message + "  " + relocation.getMessage() + "\n";
                    }
                    this.getLogger().warn(message + "\n");
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        } while (!done);
        artifact.setDownloadUrl(pomArtifact.getDownloadUrl());
        try {
            ResolutionGroup result;
            if (project == null) {
                result = new ResolutionGroup(pomArtifact, Collections.EMPTY_SET, Collections.EMPTY_LIST);
            } else {
                Set artifacts = project.createArtifacts(this.artifactFactory, artifact.getScope(), artifact.getDependencyFilter());
                List repositories = this.aggregateRepositoryLists(remoteRepositories, project.getRemoteArtifactRepositories());
                result = new ResolutionGroup(pomArtifact, artifacts, repositories);
            }
            return result;
        }
        catch (InvalidVersionSpecificationException e) {
            throw new ArtifactMetadataRetrievalException("Unable to read the metadata file", (Throwable)e);
        }
        catch (ProjectBuildingException e) {
            throw new ArtifactMetadataRetrievalException("Unable to read the metadata file", (Throwable)e);
        }
    }

    private List aggregateRepositoryLists(List remoteRepositories, List remoteArtifactRepositories) throws ProjectBuildingException {
        if (this.superProject == null) {
            this.superProject = this.mavenProjectBuilder.buildStandaloneSuperProject(null);
        }
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        repositories.addAll(remoteRepositories);
        Iterator it = this.superProject.getRemoteArtifactRepositories().iterator();
        while (it.hasNext()) {
            ArtifactRepository superRepo = (ArtifactRepository)it.next();
            Iterator aggregatedIterator = repositories.iterator();
            while (aggregatedIterator.hasNext()) {
                ArtifactRepository repo = (ArtifactRepository)aggregatedIterator.next();
                if (!repo.getId().equals(superRepo.getId()) || !repo.getUrl().equals(superRepo.getUrl())) continue;
                aggregatedIterator.remove();
            }
        }
        it = remoteArtifactRepositories.iterator();
        while (it.hasNext()) {
            ArtifactRepository repository = (ArtifactRepository)it.next();
            if (repositories.contains(repository)) continue;
            repositories.add(repository);
        }
        return repositories;
    }

    public static Set createArtifacts(ArtifactFactory artifactFactory, List dependencies, String inheritedScope, ArtifactFilter dependencyFilter, Map projectReferences) throws InvalidVersionSpecificationException {
        HashSet<Artifact> projectArtifacts = new HashSet<Artifact>(dependencies.size());
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            String refId;
            MavenProject project;
            Dependency d = (Dependency)i.next();
            String scope = d.getScope();
            if (StringUtils.isEmpty((String)scope)) {
                scope = "compile";
                d.setScope(scope);
            }
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
            Artifact artifact = artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), scope, inheritedScope);
            if ("system".equals(scope)) {
                artifact.setFile(new File(d.getSystemPath()));
            }
            if (artifact == null || dependencyFilter != null && !dependencyFilter.include(artifact)) continue;
            if (d.getExclusions() != null && !d.getExclusions().isEmpty()) {
                ArrayList<String> exclusions = new ArrayList<String>();
                Iterator j = d.getExclusions().iterator();
                while (j.hasNext()) {
                    Exclusion e = (Exclusion)j.next();
                    exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
                }
                ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
                if (dependencyFilter != null) {
                    AndArtifactFilter filter = new AndArtifactFilter();
                    filter.add(dependencyFilter);
                    filter.add((ArtifactFilter)newFilter);
                    dependencyFilter = filter;
                } else {
                    dependencyFilter = newFilter;
                }
            }
            artifact.setDependencyFilter(dependencyFilter);
            if (projectReferences != null && (project = (MavenProject)projectReferences.get(refId = d.getGroupId() + ":" + d.getArtifactId())) != null && project.getArtifact() != null) {
                artifact = new ActiveProjectArtifact(project, artifact);
            }
            projectArtifacts.add(artifact);
        }
        return projectArtifacts;
    }

    public List retrieveAvailableVersions(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        ArrayList<DefaultArtifactVersion> versions;
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(artifact);
        this.repositoryMetadataManager.resolve((RepositoryMetadata)metadata, remoteRepositories, localRepository);
        Metadata repoMetadata = metadata.getMetadata();
        if (repoMetadata != null) {
            List metadataVersions = repoMetadata.getVersioning().getVersions();
            versions = new ArrayList<DefaultArtifactVersion>(metadataVersions.size());
            Iterator i = metadataVersions.iterator();
            while (i.hasNext()) {
                String version = (String)i.next();
                versions.add(new DefaultArtifactVersion(version));
            }
        } else {
            versions = Collections.EMPTY_LIST;
        }
        return versions;
    }

    private Metadata loadMetadata(ArtifactMetadata repoMetadata, ArtifactRepository remoteRepository, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        File metadataFile = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(repoMetadata, remoteRepository));
        Metadata metadata = null;
        if (metadataFile.exists()) {
            metadata = MavenMetadataSource.readMetadata(metadataFile);
        }
        return metadata;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Metadata readMetadata(File mappingFile) throws ArtifactMetadataRetrievalException {
        Metadata result;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(mappingFile);
            MetadataXpp3Reader mappingReader = new MetadataXpp3Reader();
            result = mappingReader.read((Reader)fileReader);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ArtifactMetadataRetrievalException("Cannot read version information from: " + mappingFile, (Throwable)e);
                catch (IOException e2) {
                    throw new ArtifactMetadataRetrievalException("Cannot read version information from: " + mappingFile, (Throwable)e2);
                }
                catch (XmlPullParserException e3) {
                    throw new ArtifactMetadataRetrievalException("Cannot parse version information from: " + mappingFile, (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(fileReader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)fileReader);
        return result;
    }
}

