/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactStatus;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.transform.ArtifactTransformationManager;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.MavenProfilesBuilder;
import org.apache.maven.profiles.Profile;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.ProfilesConversionUtils;
import org.apache.maven.profiles.ProfilesRoot;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.project.InvalidModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ModelUtils;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectUtils;
import org.apache.maven.project.inheritance.ModelInheritanceAssembler;
import org.apache.maven.project.injection.ModelDefaultsInjector;
import org.apache.maven.project.injection.ProfileInjector;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultMavenProjectBuilder
extends AbstractLogEnabled
implements MavenProjectBuilder,
Initializable,
Contextualizable {
    private PlexusContainer container;
    protected MavenProfilesBuilder profilesBuilder;
    protected ArtifactResolver artifactResolver;
    protected ArtifactMetadataSource artifactMetadataSource;
    private ArtifactFactory artifactFactory;
    private ModelInheritanceAssembler modelInheritanceAssembler;
    private ProfileInjector profileInjector;
    private ModelValidator validator;
    private MavenXpp3Reader modelReader;
    private PathTranslator pathTranslator;
    private ModelDefaultsInjector modelDefaultsInjector;
    private ModelInterpolator modelInterpolator;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactTransformationManager transformationManager;
    private WagonManager wagonManager;
    private final Map modelCache = new HashMap();
    public static final String MAVEN_MODEL_VERSION = "4.0.0";
    private Map projectCache = new HashMap();
    static /* synthetic */ Class class$org$apache$maven$project$DefaultMavenProjectBuilder;

    public void initialize() {
        this.modelReader = new MavenXpp3Reader();
    }

    public MavenProject buildWithDependencies(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException, ArtifactResolutionException {
        return this.buildWithDependencies(projectDescriptor, localRepository, profileManager, null);
    }

    public MavenProject buildWithDependencies(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager, TransferListener transferListener) throws ProjectBuildingException, ArtifactResolutionException {
        MavenProject project = this.buildFromSourceFile(projectDescriptor, localRepository, profileManager);
        Artifact projectArtifact = project.getArtifact();
        Map managedVersions = this.createManagedVersionMap(project.getDependencyManagement());
        this.ensureMetadataSourceIsInitialized();
        try {
            project.setDependencyArtifacts(project.createArtifacts(this.artifactFactory, null, null));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new ProjectBuildingException("Error in dependency version", e);
        }
        if (transferListener != null) {
            this.wagonManager.setDownloadMonitor(transferListener);
        }
        ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(project.getDependencyArtifacts(), projectArtifact, managedVersions, localRepository, project.getRemoteArtifactRepositories(), this.artifactMetadataSource);
        project.setArtifacts(result.getArtifacts());
        return project;
    }

    private void ensureMetadataSourceIsInitialized() throws ProjectBuildingException {
        if (this.artifactMetadataSource == null) {
            try {
                this.artifactMetadataSource = (ArtifactMetadataSource)this.container.lookup(ArtifactMetadataSource.ROLE);
            }
            catch (ComponentLookupException e) {
                throw new ProjectBuildingException("Cannot lookup metadata source for building the project.", e);
            }
        }
    }

    private Map createManagedVersionMap(DependencyManagement dependencyManagement) throws ProjectBuildingException {
        HashMap<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            Iterator i = dependencyManagement.getDependencies().iterator();
            while (i.hasNext()) {
                Dependency d = (Dependency)i.next();
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = this.artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException("Unable to parse dependency version", e);
                }
            }
        } else {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    public MavenProject build(File projectDescriptor, ArtifactRepository localRepository, List activeExternalProfiles) throws ProjectBuildingException {
        DefaultProfileManager profileManager = new DefaultProfileManager(this.container);
        if (activeExternalProfiles != null) {
            Iterator it = activeExternalProfiles.iterator();
            while (it.hasNext()) {
                org.apache.maven.model.Profile profile = (org.apache.maven.model.Profile)it.next();
                profileManager.explicitlyActivate(profile.getId());
                profileManager.addProfile(profile);
            }
        }
        return this.buildFromSourceFile(projectDescriptor, localRepository, profileManager);
    }

    public MavenProject build(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        return this.buildFromSourceFile(projectDescriptor, localRepository, profileManager);
    }

    private MavenProject buildFromSourceFile(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        Model model = this.readModel(projectDescriptor);
        MavenProject p = new MavenProject(model);
        p.setFile(projectDescriptor);
        this.modelCache.put(DefaultMavenProjectBuilder.createCacheKey(model.getGroupId(), model.getArtifactId(), model.getVersion()), p);
        MavenProject project = this.build(projectDescriptor.getAbsolutePath(), model, localRepository, this.buildArtifactRepositories(this.getSuperModel()), projectDescriptor.getAbsoluteFile().getParentFile(), profileManager);
        if (project.getDistributionManagement() != null && project.getDistributionManagement().getStatus() != null) {
            throw new ProjectBuildingException("Invalid project file: distribution status must not be specified for a project outside of the repository");
        }
        this.pathTranslator.alignToBaseDirectory(project.getModel(), projectDescriptor);
        Build build = project.getBuild();
        project.addCompileSourceRoot(build.getSourceDirectory());
        project.addScriptSourceRoot(build.getScriptSourceDirectory());
        project.addTestCompileSourceRoot(build.getTestSourceDirectory());
        project.setFile(projectDescriptor);
        return project;
    }

    public MavenProject buildFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository) throws ProjectBuildingException {
        String cacheKey = DefaultMavenProjectBuilder.createCacheKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        MavenProject project = (MavenProject)this.projectCache.get(cacheKey);
        if (project != null) {
            return project;
        }
        Model model = this.findModelFromRepository(artifact, remoteArtifactRepositories, localRepository);
        return this.build("Artifact [" + artifact.getId() + "]", model, localRepository, remoteArtifactRepositories, null, null);
    }

    private Model findModelFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository) throws ProjectBuildingException {
        Model model;
        block12: {
            Artifact projectArtifact;
            if ("pom".equals(artifact.getType())) {
                projectArtifact = artifact;
            } else {
                this.getLogger().warn("Attempting to build MavenProject instance for Artifact of type: " + artifact.getType() + "; constructing POM artifact instead.");
                projectArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
            }
            MavenProject project = this.getCachedProject(projectArtifact.getGroupId(), projectArtifact.getArtifactId(), projectArtifact.getVersion());
            if (project == null) {
                try {
                    this.artifactResolver.resolve(projectArtifact, remoteArtifactRepositories, localRepository);
                    File file = projectArtifact.getFile();
                    model = this.readModel(file);
                    String downloadUrl = null;
                    ArtifactStatus status = ArtifactStatus.NONE;
                    DistributionManagement distributionManagement = model.getDistributionManagement();
                    if (distributionManagement != null) {
                        downloadUrl = distributionManagement.getDownloadUrl();
                        status = ArtifactStatus.valueOf((String)distributionManagement.getStatus());
                    }
                    if (!projectArtifact.isSnapshot() && status.compareTo((Object)ArtifactStatus.DEPLOYED) < 0) {
                        ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy();
                        policy.setUpdatePolicy("never");
                        if (policy.checkOutOfDate(new Date(file.lastModified()))) {
                            this.getLogger().info(projectArtifact.getArtifactId() + ": updating metadata due to status of '" + status + "'");
                            try {
                                projectArtifact.setResolved(false);
                                this.artifactResolver.resolveAlways(projectArtifact, remoteArtifactRepositories, localRepository);
                            }
                            catch (ArtifactResolutionException e) {
                                this.getLogger().warn("Error updating POM - using existing version");
                                this.getLogger().debug("Cause", (Throwable)e);
                            }
                        }
                    }
                    if (downloadUrl != null) {
                        projectArtifact.setDownloadUrl(downloadUrl);
                        break block12;
                    }
                    projectArtifact.setDownloadUrl(model.getUrl());
                }
                catch (ArtifactResolutionException e) {
                    this.getLogger().warn("\n  ***** Using defaults for missing POM " + projectArtifact.getId() + " *****\n");
                    model = new Model();
                    model.setModelVersion(MAVEN_MODEL_VERSION);
                    model.setArtifactId(projectArtifact.getArtifactId());
                    model.setGroupId(projectArtifact.getGroupId());
                    model.setVersion(projectArtifact.getVersion());
                    model.setPackaging(projectArtifact.getType());
                    model.setDistributionManagement(new DistributionManagement());
                    model.getDistributionManagement().setStatus(ArtifactStatus.GENERATED.toString());
                }
            } else {
                model = project.getModel();
            }
        }
        return model;
    }

    private MavenProject build(String pomLocation, Model model, ArtifactRepository localRepository, List parentSearchRepositories, File projectDir, ProfileManager externalProfileManager) throws ProjectBuildingException {
        List activeExternalProfiles;
        Model superModel = this.getSuperModel();
        DefaultProfileManager superProjectProfileManager = new DefaultProfileManager(this.container);
        superProjectProfileManager.addProfiles(superModel.getProfiles());
        List activeProfiles = this.injectActiveProfiles(superProjectProfileManager, superModel);
        MavenProject superProject = new MavenProject(superModel);
        superProject.setActiveProfiles(activeProfiles);
        LinkedList lineage = new LinkedList();
        LinkedHashSet<ArtifactRepository> aggregatedRemoteWagonRepositories = new LinkedHashSet<ArtifactRepository>();
        try {
            activeExternalProfiles = externalProfileManager != null ? externalProfileManager.getActiveProfiles() : Collections.EMPTY_LIST;
        }
        catch (ProfileActivationException e) {
            throw new ProjectBuildingException("Failed to calculate active external profiles.", e);
        }
        Iterator i = activeExternalProfiles.iterator();
        while (i.hasNext()) {
            org.apache.maven.model.Profile externalProfile = (org.apache.maven.model.Profile)i.next();
            Iterator repoIterator = externalProfile.getRepositories().iterator();
            while (repoIterator.hasNext()) {
                Repository mavenRepo = (Repository)repoIterator.next();
                ArtifactRepository artifactRepo = ProjectUtils.buildArtifactRepository(mavenRepo, this.artifactRepositoryFactory, this.container);
                aggregatedRemoteWagonRepositories.add(artifactRepo);
            }
        }
        Model originalModel = ModelUtils.cloneModel(model);
        MavenProject project = this.assembleLineage(model, lineage, localRepository, projectDir, parentSearchRepositories, aggregatedRemoteWagonRepositories, externalProfileManager);
        project.setOriginalModel(originalModel);
        Model previous = superProject.getModel();
        Iterator i2 = lineage.iterator();
        while (i2.hasNext()) {
            MavenProject currentProject = (MavenProject)i2.next();
            Model current = currentProject.getModel();
            this.modelInheritanceAssembler.assembleModelInheritance(current, previous);
            previous = current;
        }
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>(aggregatedRemoteWagonRepositories);
        List superRepositories = this.buildArtifactRepositories(superModel);
        Iterator i3 = superRepositories.iterator();
        while (i3.hasNext()) {
            ArtifactRepository repository = (ArtifactRepository)i3.next();
            if (repositories.contains(repository)) continue;
            repositories.add(repository);
        }
        try {
            project = this.processProjectLogic(pomLocation, project, repositories, externalProfileManager, projectDir);
        }
        catch (ModelInterpolationException e) {
            throw new ProjectBuildingException("Error building project from '" + pomLocation + "': " + model.getId(), e);
        }
        this.projectCache.put(DefaultMavenProjectBuilder.createCacheKey(project.getGroupId(), project.getArtifactId(), project.getVersion()), project);
        return project;
    }

    private List buildArtifactRepositories(Model model) throws ProjectBuildingException {
        return ProjectUtils.buildArtifactRepositories(model.getRepositories(), this.artifactRepositoryFactory, this.container);
    }

    private MavenProject processProjectLogic(String pomLocation, MavenProject project, List remoteRepositories, ProfileManager profileMgr, File projectDir) throws ProjectBuildingException, ModelInterpolationException {
        ModelValidationResult validationResult;
        ArrayList activeProfiles;
        Model model = project.getModel();
        String key = DefaultMavenProjectBuilder.createCacheKey(model.getGroupId(), model.getArtifactId(), model.getVersion());
        if (!this.modelCache.containsKey(key)) {
            MavenProject p = new MavenProject(ModelUtils.cloneModel(model));
            p.setFile(project.getFile());
            this.modelCache.put(key, p);
        }
        if ((activeProfiles = project.getActiveProfiles()) == null) {
            activeProfiles = new ArrayList();
        }
        List injectedProfiles = this.injectActiveProfiles(profileMgr, model);
        activeProfiles.addAll(injectedProfiles);
        HashMap<Object, Object> context = new HashMap<Object, Object>(System.getProperties());
        if (projectDir != null) {
            context.put("basedir", projectDir.getAbsolutePath());
        }
        model = this.modelInterpolator.interpolate(model, context);
        this.modelDefaultsInjector.injectDefaults(model);
        MavenProject parentProject = project.getParent();
        Model originalModel = project.getOriginalModel();
        project = new MavenProject(model);
        project.setOriginalModel(originalModel);
        project.setActiveProfiles(activeProfiles);
        Artifact projectArtifact = this.artifactFactory.createBuildArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging());
        project.setArtifact(projectArtifact);
        project.setPluginArtifactRepositories(ProjectUtils.buildArtifactRepositories(model.getPluginRepositories(), this.artifactRepositoryFactory, this.container));
        DistributionManagement dm = model.getDistributionManagement();
        if (dm != null) {
            ArtifactRepository repo = ProjectUtils.buildArtifactRepositoryBase(dm.getRepository(), this.artifactRepositoryFactory, this.container);
            project.setReleaseArtifactRepository(repo);
            if (dm.getSnapshotRepository() != null) {
                repo = ProjectUtils.buildArtifactRepositoryBase(dm.getSnapshotRepository(), this.artifactRepositoryFactory, this.container);
                project.setSnapshotArtifactRepository(repo);
            }
        }
        project.setParent(parentProject);
        if (parentProject != null) {
            Artifact parentArtifact = this.artifactFactory.createParentArtifact(parentProject.getGroupId(), parentProject.getArtifactId(), parentProject.getVersion());
            project.setParentArtifact(parentArtifact);
        }
        if ((validationResult = this.validator.validate(model)).getMessageCount() > 0) {
            throw new ProjectBuildingException("Failed to validate POM for '" + pomLocation + "'.\n\n  Reason(s):\n" + validationResult.render("  "));
        }
        project.setRemoteArtifactRepositories(remoteRepositories);
        project.setPluginArtifacts(this.createPluginArtifacts(project.getBuildPlugins()));
        project.setReportArtifacts(this.createReportArtifacts(project.getReportPlugins()));
        project.setExtensionArtifacts(this.createExtensionArtifacts(project.getBuildExtensions()));
        return project;
    }

    private MavenProject assembleLineage(Model model, LinkedList lineage, ArtifactRepository localRepository, File projectDir, List parentSearchRepositories, Set aggregatedRemoteWagonRepositories, ProfileManager externalProfileManager) throws ProjectBuildingException {
        List activeProfiles;
        if (!model.getRepositories().isEmpty()) {
            List respositories = this.buildArtifactRepositories(model);
            Iterator it = respositories.iterator();
            while (it.hasNext()) {
                ArtifactRepository repository = (ArtifactRepository)it.next();
                if (aggregatedRemoteWagonRepositories.contains(repository)) continue;
                aggregatedRemoteWagonRepositories.add(repository);
            }
        }
        DefaultProfileManager profileManager = new DefaultProfileManager(this.container);
        if (externalProfileManager != null) {
            profileManager.explicitlyActivate(externalProfileManager.getExplicitlyActivatedIds());
            profileManager.explicitlyDeactivate(externalProfileManager.getExplicitlyDeactivatedIds());
        }
        try {
            profileManager.addProfiles(model.getProfiles());
            this.loadProjectExternalProfiles(profileManager, projectDir);
            activeProfiles = this.injectActiveProfiles(profileManager, model);
        }
        catch (ProfileActivationException e) {
            throw new ProjectBuildingException("Failed to activate local (project-level) build profiles.", e);
        }
        MavenProject project = new MavenProject(model);
        project.setActiveProfiles(activeProfiles);
        lineage.addFirst(project);
        Parent parentModel = model.getParent();
        if (parentModel != null) {
            if (StringUtils.isEmpty((String)parentModel.getGroupId())) {
                throw new ProjectBuildingException("Missing groupId element from parent element");
            }
            if (StringUtils.isEmpty((String)parentModel.getArtifactId())) {
                throw new ProjectBuildingException("Missing artifactId element from parent element");
            }
            if (StringUtils.isEmpty((String)parentModel.getVersion())) {
                throw new ProjectBuildingException("Missing version element from parent element");
            }
            File parentDescriptor = null;
            MavenProject p = this.getCachedProject(parentModel.getGroupId(), parentModel.getArtifactId(), parentModel.getVersion());
            if (p != null) {
                model = p.getModel();
                parentDescriptor = p.getFile();
            } else {
                model = null;
            }
            String parentRelativePath = parentModel.getRelativePath();
            if (model == null && projectDir != null && StringUtils.isNotEmpty((String)parentRelativePath)) {
                parentDescriptor = new File(projectDir, parentRelativePath);
                try {
                    parentDescriptor = parentDescriptor.getCanonicalFile();
                }
                catch (IOException e) {
                    this.getLogger().debug("Failed to canonicalize potential parent POM: '" + parentDescriptor + "'", (Throwable)e);
                    parentDescriptor = null;
                }
                if (parentDescriptor != null && parentDescriptor.exists()) {
                    String candidateParentVersion;
                    Model candidateParent = this.readModel(parentDescriptor);
                    String candidateParentGroupId = candidateParent.getGroupId();
                    if (candidateParentGroupId == null && candidateParent.getParent() != null) {
                        candidateParentGroupId = candidateParent.getParent().getGroupId();
                    }
                    if ((candidateParentVersion = candidateParent.getVersion()) == null && candidateParent.getParent() != null) {
                        candidateParentVersion = candidateParent.getParent().getVersion();
                    }
                    if (parentModel.getGroupId().equals(candidateParentGroupId) && parentModel.getArtifactId().equals(candidateParent.getArtifactId()) && parentModel.getVersion().equals(candidateParentVersion)) {
                        model = candidateParent;
                        this.getLogger().debug("Using parent-POM from the project hierarchy at: '" + parentModel.getRelativePath() + "' for project: " + project.getId());
                    } else {
                        this.getLogger().debug("Invalid parent-POM referenced by relative path '" + parentModel.getRelativePath() + "' in parent specification in " + project.getId() + ":" + "\n  Specified: " + parentModel.getId() + "\n  Found:     " + candidateParent.getId());
                    }
                }
            }
            Artifact parentArtifact = null;
            if (model == null) {
                parentArtifact = this.artifactFactory.createParentArtifact(parentModel.getGroupId(), parentModel.getArtifactId(), parentModel.getVersion());
                ArrayList remoteRepositories = new ArrayList(aggregatedRemoteWagonRepositories);
                remoteRepositories.addAll(parentSearchRepositories);
                model = this.findModelFromRepository(parentArtifact, remoteRepositories, localRepository);
            }
            File parentProjectDir = null;
            if (parentDescriptor != null) {
                parentProjectDir = parentDescriptor.getParentFile();
            }
            MavenProject parent = this.assembleLineage(model, lineage, localRepository, parentProjectDir, parentSearchRepositories, aggregatedRemoteWagonRepositories, externalProfileManager);
            parent.setFile(parentDescriptor);
            project.setParent(parent);
            project.setParentArtifact(parentArtifact);
        }
        return project;
    }

    private List injectActiveProfiles(ProfileManager profileManager, Model model) throws ProjectBuildingException {
        List activeProfiles;
        if (profileManager != null) {
            try {
                activeProfiles = profileManager.getActiveProfiles();
            }
            catch (ProfileActivationException e) {
                throw new ProjectBuildingException("Failed to calculate active build profiles.", e);
            }
            Iterator it = activeProfiles.iterator();
            while (it.hasNext()) {
                org.apache.maven.model.Profile profile = (org.apache.maven.model.Profile)it.next();
                this.profileInjector.inject(profile, model);
            }
        } else {
            activeProfiles = Collections.EMPTY_LIST;
        }
        return activeProfiles;
    }

    private void loadProjectExternalProfiles(ProfileManager profileManager, File projectDir) throws ProfileActivationException {
        if (projectDir != null) {
            try {
                ProfilesRoot root = this.profilesBuilder.buildProfiles(projectDir);
                if (root != null) {
                    List active = root.getActiveProfiles();
                    if (active != null && !active.isEmpty()) {
                        profileManager.explicitlyActivate(root.getActiveProfiles());
                    }
                    Iterator it = root.getProfiles().iterator();
                    while (it.hasNext()) {
                        Profile rawProfile = (Profile)it.next();
                        org.apache.maven.model.Profile converted = ProfilesConversionUtils.convertFromProfileXmlProfile((Profile)rawProfile);
                        profileManager.addProfile(converted);
                    }
                }
            }
            catch (IOException e) {
                throw new ProfileActivationException("Cannot read profiles.xml resource from directory: " + projectDir, e);
            }
            catch (XmlPullParserException e) {
                throw new ProfileActivationException("Cannot parse profiles.xml resource from directory: " + projectDir, e);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model readModel(File file) throws ProjectBuildingException {
        Model model;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            model = this.readModel(reader);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ProjectBuildingException("Could not find the model file '" + file.getAbsolutePath() + "'.", e);
                catch (IOException e2) {
                    throw new ProjectBuildingException("Failed to build model from file '" + file.getAbsolutePath() + "'.\nError: '" + e2.getLocalizedMessage() + "'", e2);
                }
                catch (XmlPullParserException e3) {
                    throw new ProjectBuildingException("Failed to parse model from file '" + file.getAbsolutePath() + "'.\nError: '" + e3.getLocalizedMessage() + "'", e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return model;
    }

    private Model readModel(Reader reader) throws IOException, XmlPullParserException, InvalidModelException {
        StringWriter sw = new StringWriter();
        IOUtil.copy((Reader)reader, (Writer)sw);
        String modelSource = sw.toString();
        if (modelSource.indexOf("<modelVersion>4.0.0") < 0) {
            throw new InvalidModelException("Invalid POM (not v4.0.0 modelVersion)");
        }
        StringReader sReader = new StringReader(modelSource);
        return this.modelReader.read((Reader)sReader);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model readModel(URL url) throws ProjectBuildingException {
        Model model;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(url.openStream());
            model = this.readModel(reader);
        }
        catch (IOException e) {
            try {
                throw new ProjectBuildingException("Failed build model from URL '" + url.toExternalForm() + "'\nError: '" + e.getLocalizedMessage() + "'", e);
                catch (XmlPullParserException e2) {
                    throw new ProjectBuildingException("Failed to parse model from URL '" + url.toExternalForm() + "'\nError: '" + e2.getLocalizedMessage() + "'", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return model;
    }

    private MavenProject getCachedProject(String groupId, String artifactId, String version) {
        return (MavenProject)this.modelCache.get(DefaultMavenProjectBuilder.createCacheKey(groupId, artifactId, version));
    }

    private static String createCacheKey(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }

    protected Set createPluginArtifacts(List plugins) throws ProjectBuildingException {
        HashSet<Artifact> pluginArtifacts = new HashSet<Artifact>();
        Iterator i = plugins.iterator();
        while (i.hasNext()) {
            Artifact artifact;
            Plugin p = (Plugin)i.next();
            String version = StringUtils.isEmpty((String)p.getVersion()) ? "RELEASE" : p.getVersion();
            try {
                artifact = this.artifactFactory.createPluginArtifact(p.getGroupId(), p.getArtifactId(), VersionRange.createFromVersionSpec((String)version));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new ProjectBuildingException("Unable to parse plugin version", e);
            }
            if (artifact == null) continue;
            pluginArtifacts.add(artifact);
        }
        return pluginArtifacts;
    }

    protected Set createReportArtifacts(List reports) throws ProjectBuildingException {
        HashSet<Artifact> pluginArtifacts = new HashSet<Artifact>();
        if (reports != null) {
            Iterator i = reports.iterator();
            while (i.hasNext()) {
                Artifact artifact;
                ReportPlugin p = (ReportPlugin)i.next();
                String version = StringUtils.isEmpty((String)p.getVersion()) ? "RELEASE" : p.getVersion();
                try {
                    artifact = this.artifactFactory.createPluginArtifact(p.getGroupId(), p.getArtifactId(), VersionRange.createFromVersionSpec((String)version));
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException("Unable to parse plugin version", e);
                }
                if (artifact == null) continue;
                pluginArtifacts.add(artifact);
            }
        }
        return pluginArtifacts;
    }

    protected Set createExtensionArtifacts(List extensions) throws ProjectBuildingException {
        HashSet<Artifact> extensionArtifacts = new HashSet<Artifact>();
        if (extensions != null) {
            Iterator i = extensions.iterator();
            while (i.hasNext()) {
                Artifact artifact;
                Extension ext = (Extension)i.next();
                String version = StringUtils.isEmpty((String)ext.getVersion()) ? "RELEASE" : ext.getVersion();
                try {
                    artifact = this.artifactFactory.createExtensionArtifact(ext.getGroupId(), ext.getArtifactId(), VersionRange.createFromVersionSpec((String)version));
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException("Unable to parse extension version", e);
                }
                if (artifact == null) continue;
                extensionArtifacts.add(artifact);
            }
        }
        return extensionArtifacts;
    }

    public MavenProject buildStandaloneSuperProject(ArtifactRepository localRepository) throws ProjectBuildingException {
        Model superModel = this.getSuperModel();
        superModel.setGroupId("org.apache.maven");
        superModel.setArtifactId("super-pom");
        superModel.setVersion("2.0");
        DefaultProfileManager profileManager = new DefaultProfileManager(this.container);
        profileManager.addProfiles(superModel.getProfiles());
        List activeProfiles = this.injectActiveProfiles(profileManager, superModel);
        MavenProject project = new MavenProject(superModel);
        project.setActiveProfiles(activeProfiles);
        project.setOriginalModel(superModel);
        try {
            List remoteRepositories = this.buildArtifactRepositories(superModel);
            project = this.processProjectLogic("<Super-POM>", project, remoteRepositories, null, null);
            project.setExecutionRoot(true);
            return project;
        }
        catch (ModelInterpolationException e) {
            throw new ProjectBuildingException("Error building super-project", e);
        }
    }

    private Model getSuperModel() throws ProjectBuildingException {
        URL url = (class$org$apache$maven$project$DefaultMavenProjectBuilder == null ? (class$org$apache$maven$project$DefaultMavenProjectBuilder = DefaultMavenProjectBuilder.class$("org.apache.maven.project.DefaultMavenProjectBuilder")) : class$org$apache$maven$project$DefaultMavenProjectBuilder).getResource("pom-4.0.0.xml");
        return this.readModel(url);
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

