/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public final class ProjectUtils {
    private ProjectUtils() {
    }

    public static List buildArtifactRepositories(List repositories, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer container) throws ProjectBuildingException {
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        Iterator i = repositories.iterator();
        while (i.hasNext()) {
            Repository mavenRepo = (Repository)i.next();
            ArtifactRepository artifactRepo = ProjectUtils.buildArtifactRepository(mavenRepo, artifactRepositoryFactory, container);
            if (repos.contains(artifactRepo)) continue;
            repos.add(artifactRepo);
        }
        return repos;
    }

    public static ArtifactRepository buildDeploymentArtifactRepository(DeploymentRepository repo, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer container) throws ProjectBuildingException {
        if (repo != null) {
            String id = repo.getId();
            String url = repo.getUrl();
            ArtifactRepositoryLayout layout = ProjectUtils.getRepositoryLayout((RepositoryBase)repo, container);
            return artifactRepositoryFactory.createDeploymentArtifactRepository(id, url, layout, repo.isUniqueVersion());
        }
        return null;
    }

    public static ArtifactRepository buildArtifactRepository(Repository repo, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer container) throws ProjectBuildingException {
        if (repo != null) {
            String id = repo.getId();
            String url = repo.getUrl();
            ArtifactRepositoryLayout layout = ProjectUtils.getRepositoryLayout((RepositoryBase)repo, container);
            ArtifactRepositoryPolicy snapshots = ProjectUtils.buildArtifactRepositoryPolicy(repo.getSnapshots());
            ArtifactRepositoryPolicy releases = ProjectUtils.buildArtifactRepositoryPolicy(repo.getReleases());
            return artifactRepositoryFactory.createArtifactRepository(id, url, layout, snapshots, releases);
        }
        return null;
    }

    private static ArtifactRepositoryPolicy buildArtifactRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = null;
        String checksumPolicy = null;
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new ArtifactRepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }

    private static ArtifactRepositoryLayout getRepositoryLayout(RepositoryBase mavenRepo, PlexusContainer container) throws ProjectBuildingException {
        ArtifactRepositoryLayout repositoryLayout;
        String layout = mavenRepo.getLayout();
        try {
            repositoryLayout = (ArtifactRepositoryLayout)container.lookup(ArtifactRepositoryLayout.ROLE, layout);
        }
        catch (ComponentLookupException e) {
            throw new ProjectBuildingException("Cannot find layout implementation corresponding to: '" + layout + "' for remote repository with id: '" + mavenRepo.getId() + "'.", e);
        }
        return repositoryLayout;
    }
}

