/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.VersionRange;

public class AttachedArtifact
extends DefaultArtifact {
    private final Artifact parent;

    public AttachedArtifact(Artifact parent, String type, String classifier) {
        super(parent.getGroupId(), parent.getArtifactId(), parent.getVersionRange(), parent.getScope(), type, classifier, parent.getArtifactHandler(), parent.isOptional());
        this.parent = parent;
        if (type == null || type.trim().length() < 1) {
            throw new InvalidArtifactRTException(this.getGroupId(), this.getArtifactId(), this.getVersion(), type, "Attached artifacts must specify a type.");
        }
        if (classifier == null || classifier.trim().length() < 1) {
            throw new InvalidArtifactRTException(this.getGroupId(), this.getArtifactId(), this.getVersion(), type, "Attached artifacts must specify a classifier.");
        }
    }

    public ArtifactHandler getArtifactHandler() {
        return this.parent.getArtifactHandler();
    }

    public String getArtifactId() {
        return this.parent.getArtifactId();
    }

    public List getAvailableVersions() {
        return this.parent.getAvailableVersions();
    }

    public String getBaseVersion() {
        return this.parent.getBaseVersion();
    }

    public ArtifactFilter getDependencyFilter() {
        return this.parent.getDependencyFilter();
    }

    public List getDependencyTrail() {
        return this.parent.getDependencyTrail();
    }

    public String getDownloadUrl() {
        return this.parent.getDownloadUrl();
    }

    public String getGroupId() {
        return this.parent.getGroupId();
    }

    public ArtifactRepository getRepository() {
        return this.parent.getRepository();
    }

    public String getScope() {
        return this.parent.getScope();
    }

    public String getType() {
        return this.parent.getType();
    }

    public String getVersion() {
        return this.parent.getVersion();
    }

    public VersionRange getVersionRange() {
        return this.parent.getVersionRange();
    }

    public boolean isOptional() {
        return this.parent.isOptional();
    }

    public boolean isRelease() {
        return this.parent.isRelease();
    }

    public boolean isSnapshot() {
        return this.parent.isSnapshot();
    }
}

