/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.validation;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.codehaus.plexus.util.StringUtils;

public class DefaultModelValidator
implements ModelValidator {
    public ModelValidationResult validate(Model model) {
        Reporting reporting;
        Build build;
        ModelValidationResult result = new ModelValidationResult();
        this.validateStringNotEmpty("modelVersion", result, model.getModelVersion());
        this.validateStringNotEmpty("groupId", result, model.getGroupId());
        this.validateStringNotEmpty("artifactId", result, model.getArtifactId());
        this.validateStringNotEmpty("packaging", result, model.getPackaging());
        this.validateStringNotEmpty("version", result, model.getVersion());
        Iterator it = model.getDependencies().iterator();
        while (it.hasNext()) {
            Dependency d = (Dependency)it.next();
            this.validateSubElementStringNotEmpty(d, "dependencies.dependency.artifactId", result, d.getArtifactId());
            this.validateSubElementStringNotEmpty(d, "dependencies.dependency.groupId", result, d.getGroupId());
            this.validateSubElementStringNotEmpty(d, "dependencies.dependency.type", result, d.getType());
            this.validateSubElementStringNotEmpty(d, "dependencies.dependency.version", result, d.getVersion());
            if ("system".equals(d.getScope()) && StringUtils.isEmpty((String)d.getSystemPath())) {
                result.addMessage("For dependency " + d + ": system-scoped dependency must specify systemPath.");
                continue;
            }
            if ("system".equals(d.getScope()) || !StringUtils.isNotEmpty((String)d.getSystemPath())) continue;
            result.addMessage("For dependency " + d + ": only dependency with system scope can specify systemPath.");
        }
        DependencyManagement mgmt = model.getDependencyManagement();
        if (mgmt != null) {
            Iterator it2 = mgmt.getDependencies().iterator();
            while (it2.hasNext()) {
                Dependency d = (Dependency)it2.next();
                this.validateSubElementStringNotEmpty(d, "dependencyManagement.dependencies.dependency.artifactId", result, d.getArtifactId());
                this.validateSubElementStringNotEmpty(d, "dependencyManagement.dependencies.dependency.groupId", result, d.getGroupId());
                if ("system".equals(d.getScope()) && StringUtils.isEmpty((String)d.getSystemPath())) {
                    result.addMessage("For managed dependency " + d + ": system-scoped dependency must specify systemPath.");
                    continue;
                }
                if ("system".equals(d.getScope()) || !StringUtils.isNotEmpty((String)d.getSystemPath())) continue;
                result.addMessage("For managed dependency " + d + ": only dependency with system scope can specify systemPath.");
            }
        }
        if ((build = model.getBuild()) != null) {
            Iterator it3 = build.getPlugins().iterator();
            while (it3.hasNext()) {
                Plugin p = (Plugin)it3.next();
                this.validateStringNotEmpty("build.plugins.plugin.artifactId", result, p.getArtifactId());
                this.validateStringNotEmpty("build.plugins.plugin.groupId", result, p.getGroupId());
            }
        }
        if ((reporting = model.getReporting()) != null) {
            Iterator it4 = reporting.getPlugins().iterator();
            while (it4.hasNext()) {
                ReportPlugin p = (ReportPlugin)it4.next();
                this.validateStringNotEmpty("reporting.plugins.plugin.artifactId", result, p.getArtifactId());
                this.validateStringNotEmpty("reporting.plugins.plugin.groupId", result, p.getGroupId());
            }
        }
        this.forcePluginExecutionIdCollision(model, result);
        return result;
    }

    private void forcePluginExecutionIdCollision(Model model, ModelValidationResult result) {
        List plugins;
        Build build = model.getBuild();
        if (build != null && (plugins = build.getPlugins()) != null) {
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                Plugin plugin = (Plugin)it.next();
                try {
                    plugin.getExecutionsAsMap();
                }
                catch (IllegalStateException collisionException) {
                    result.addMessage(collisionException.getMessage());
                }
            }
        }
    }

    private boolean validateStringNotEmpty(String fieldName, ModelValidationResult result, String string) {
        if (!this.validateNotNull(fieldName, result, string)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        result.addMessage("'" + fieldName + "' is missing.");
        return false;
    }

    private boolean validateSubElementStringNotEmpty(Object subElementInstance, String fieldName, ModelValidationResult result, String string) {
        if (!this.validateSubElementNotNull(subElementInstance, fieldName, result, string)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        result.addMessage("In " + subElementInstance + ":\n\n       -> '" + fieldName + "' is missing.");
        return false;
    }

    private boolean validateNotNull(String fieldName, ModelValidationResult result, Object object) {
        if (object != null) {
            return true;
        }
        result.addMessage("'" + fieldName + "' is missing.");
        return false;
    }

    private boolean validateSubElementNotNull(Object subElementInstance, String fieldName, ModelValidationResult result, Object object) {
        if (object != null) {
            return true;
        }
        result.addMessage("In " + subElementInstance + ":\n\n       -> '" + fieldName + "' is missing.");
        return false;
    }
}

