/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.interpolation;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.interpolation.BuildTimestampValueSource;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.interpolation.PathTranslatingPostProcessor;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractStringBasedModelInterpolator
extends AbstractLogEnabled
implements ModelInterpolator,
Initializable {
    private static final List PROJECT_PREFIXES = Arrays.asList("pom.", "project.");
    private static final List TRANSLATED_PATH_EXPRESSIONS;
    private PathTranslator pathTranslator;
    private Interpolator interpolator;
    private RecursionInterceptor recursionInterceptor;

    protected AbstractStringBasedModelInterpolator(PathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
    }

    protected AbstractStringBasedModelInterpolator() {
    }

    public Model interpolate(Model model, Map context) throws ModelInterpolationException {
        return this.interpolate(model, context, true);
    }

    public Model interpolate(Model model, Map context, boolean strict) throws ModelInterpolationException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)context);
        return this.interpolate(model, null, new DefaultProjectBuilderConfiguration().setExecutionProperties(props), true);
    }

    public Model interpolate(Model model, File projectDir, ProjectBuilderConfiguration config, boolean debugEnabled) throws ModelInterpolationException {
        StringWriter sWriter = new StringWriter(1024);
        MavenXpp3Writer writer = new MavenXpp3Writer();
        try {
            writer.write((Writer)sWriter, model);
        }
        catch (IOException e) {
            throw new ModelInterpolationException("Cannot serialize project model for interpolation.", e);
        }
        String serializedModel = sWriter.toString();
        serializedModel = this.interpolate(serializedModel, model, projectDir, config, debugEnabled);
        StringReader sReader = new StringReader(serializedModel);
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        try {
            model = modelReader.read((Reader)sReader);
        }
        catch (IOException e) {
            throw new ModelInterpolationException("Cannot read project model from interpolating filter of serialized version.", e);
        }
        catch (XmlPullParserException e) {
            throw new ModelInterpolationException("Cannot read project model from interpolating filter of serialized version.", e);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String interpolate(String src, Model model, File projectDir, ProjectBuilderConfiguration config, boolean debug) throws ModelInterpolationException {
        try {
            List valueSources = this.createValueSources(model, projectDir, config);
            List postProcessors = this.createPostProcessors(model, projectDir, config);
            String string = this.interpolateInternal(src, valueSources, postProcessors, debug);
            return string;
        }
        finally {
            this.interpolator.clearAnswers();
        }
    }

    protected List createValueSources(Model model, final File projectDir, final ProjectBuilderConfiguration config) {
        String timestampFormat = "yyyyMMdd-HHmm";
        Properties modelProperties = model.getProperties();
        if (modelProperties != null) {
            timestampFormat = modelProperties.getProperty("maven.build.timestamp.format", timestampFormat);
        }
        PrefixedObjectValueSource modelValueSource1 = new PrefixedObjectValueSource(PROJECT_PREFIXES, (Object)model, false);
        ObjectBasedValueSource modelValueSource2 = new ObjectBasedValueSource((Object)model);
        PrefixedValueSourceWrapper basedirValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                if (projectDir != null && "basedir".equals(expression)) {
                    return projectDir.getAbsolutePath();
                }
                return null;
            }
        }, PROJECT_PREFIXES, true);
        ArrayList<Object> valueSources = new ArrayList<Object>(8);
        valueSources.add(basedirValueSource);
        valueSources.add((Object)new BuildTimestampValueSource(config.getBuildStartTime(), timestampFormat));
        valueSources.add(modelValueSource1);
        valueSources.add(new MapBasedValueSource((Map)config.getUserProperties()));
        valueSources.add(new PrefixedValueSourceWrapper((ValueSource)new MapBasedValueSource((Map)modelProperties), PROJECT_PREFIXES, true));
        valueSources.add(new MapBasedValueSource((Map)config.getExecutionProperties()));
        valueSources.add(new AbstractValueSource(false){

            public Object getValue(String expression) {
                return config.getExecutionProperties().getProperty("env." + expression);
            }
        });
        valueSources.add(modelValueSource2);
        return valueSources;
    }

    protected List createPostProcessors(Model model, File projectDir, ProjectBuilderConfiguration config) {
        return Collections.singletonList(new PathTranslatingPostProcessor(PROJECT_PREFIXES, TRANSLATED_PATH_EXPRESSIONS, projectDir, this.pathTranslator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String interpolateInternal(String src, List valueSources, List postProcessors, boolean debug) throws ModelInterpolationException {
        if (src.indexOf("${") < 0) {
            return src;
        }
        Logger logger = this.getLogger();
        String result = src;
        AbstractStringBasedModelInterpolator abstractStringBasedModelInterpolator = this;
        synchronized (abstractStringBasedModelInterpolator) {
            Iterator iterator2;
            Iterator it = valueSources.iterator();
            while (it.hasNext()) {
                ValueSource vs = (ValueSource)it.next();
                this.interpolator.addValueSource(vs);
            }
            it = postProcessors.iterator();
            while (it.hasNext()) {
                InterpolationPostProcessor postProcessor = (InterpolationPostProcessor)it.next();
                this.interpolator.addPostProcessor(postProcessor);
            }
            try {
                List feedback;
                try {
                    result = this.interpolator.interpolate(result, this.recursionInterceptor);
                }
                catch (InterpolationException e) {
                    throw new ModelInterpolationException(e.getMessage(), e);
                }
                if (debug && (feedback = this.interpolator.getFeedback()) != null && !feedback.isEmpty()) {
                    logger.debug("Maven encountered the following problems during initial POM interpolation:");
                    Object last = null;
                    Iterator it2 = feedback.iterator();
                    while (it2.hasNext()) {
                        Object next = it2.next();
                        if (next instanceof Throwable) {
                            if (last == null) {
                                logger.debug("", (Throwable)next);
                                continue;
                            }
                            logger.debug(String.valueOf(last), (Throwable)next);
                            continue;
                        }
                        if (last != null) {
                            logger.debug(String.valueOf(last));
                        }
                        last = next;
                    }
                    if (last != null) {
                        logger.debug(String.valueOf(last));
                    }
                }
                this.interpolator.clearFeedback();
                Object var13_13 = null;
                iterator2 = valueSources.iterator();
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                Iterator iterator2 = valueSources.iterator();
                while (iterator2.hasNext()) {
                    ValueSource vs = (ValueSource)iterator2.next();
                    this.interpolator.removeValuesSource(vs);
                }
                iterator2 = postProcessors.iterator();
                while (iterator2.hasNext()) {
                    InterpolationPostProcessor postProcessor = (InterpolationPostProcessor)iterator2.next();
                    this.interpolator.removePostProcessor(postProcessor);
                }
                throw throwable;
            }
            while (iterator2.hasNext()) {
                ValueSource vs = (ValueSource)iterator2.next();
                this.interpolator.removeValuesSource(vs);
            }
            iterator2 = postProcessors.iterator();
            while (iterator2.hasNext()) {
                InterpolationPostProcessor postProcessor = (InterpolationPostProcessor)iterator2.next();
                this.interpolator.removePostProcessor(postProcessor);
            }
        }
        return result;
    }

    protected abstract Interpolator createInterpolator();

    public final void initialize() throws InitializationException {
        this.interpolator = this.createInterpolator();
        this.recursionInterceptor = new PrefixAwareRecursionInterceptor((Collection)PROJECT_PREFIXES);
    }

    protected final Interpolator getInterpolator() {
        return this.interpolator;
    }

    static {
        ArrayList<String> translatedPrefixes = new ArrayList<String>();
        translatedPrefixes.add("build.directory");
        translatedPrefixes.add("build.outputDirectory");
        translatedPrefixes.add("build.testOutputDirectory");
        translatedPrefixes.add("build.sourceDirectory");
        translatedPrefixes.add("build.testSourceDirectory");
        translatedPrefixes.add("build.scriptSourceDirectory");
        translatedPrefixes.add("reporting.outputDirectory");
        TRANSLATED_PATH_EXPRESSIONS = translatedPrefixes;
    }
}

