/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.path;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Resource;
import org.apache.maven.project.path.PathTranslator;

public class DefaultPathTranslator
implements PathTranslator {
    private static final String[] BASEDIR_EXPRESSIONS = new String[]{"${basedir}", "${pom.basedir}", "${project.basedir}"};
    private static final String FILE_SEPARATOR = File.separator;

    public void alignToBaseDirectory(Model model, File basedir) {
        if (basedir == null) {
            return;
        }
        Build build = model.getBuild();
        if (build != null) {
            Resource resource;
            build.setDirectory(this.alignToBaseDirectory(build.getDirectory(), basedir));
            build.setSourceDirectory(this.alignToBaseDirectory(build.getSourceDirectory(), basedir));
            build.setTestSourceDirectory(this.alignToBaseDirectory(build.getTestSourceDirectory(), basedir));
            Iterator i = build.getResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
            }
            i = build.getTestResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
            }
            if (build.getFilters() != null) {
                ArrayList<String> filters = new ArrayList<String>();
                Iterator i2 = build.getFilters().iterator();
                while (i2.hasNext()) {
                    String filter = (String)i2.next();
                    filters.add(this.alignToBaseDirectory(filter, basedir));
                }
                build.setFilters(filters);
            }
            build.setOutputDirectory(this.alignToBaseDirectory(build.getOutputDirectory(), basedir));
            build.setTestOutputDirectory(this.alignToBaseDirectory(build.getTestOutputDirectory(), basedir));
            Reporting reporting = model.getReporting();
            if (reporting != null) {
                reporting.setOutputDirectory(this.alignToBaseDirectory(reporting.getOutputDirectory(), basedir));
            }
        }
    }

    public String alignToBaseDirectory(String path, File basedir) {
        if (basedir == null) {
            return path;
        }
        if (path == null) {
            return null;
        }
        String s = this.stripBasedirToken(path);
        if (this.requiresBaseDirectoryAlignment(s)) {
            s = new File(new File(basedir, s).toURI().normalize()).getAbsolutePath();
        }
        s = s.replace('/', File.separatorChar);
        s = s.replace('\\', File.separatorChar);
        return s;
    }

    private String stripBasedirToken(String s) {
        if (s != null) {
            String basedirExpr = null;
            for (int i = 0; i < BASEDIR_EXPRESSIONS.length && !s.startsWith(basedirExpr = BASEDIR_EXPRESSIONS[i]); ++i) {
                basedirExpr = null;
            }
            if (basedirExpr != null) {
                s = s.length() > basedirExpr.length() ? this.chopLeadingFileSeparator(s.substring(basedirExpr.length())) : ".";
            }
        }
        return s;
    }

    private String chopLeadingFileSeparator(String path) {
        if (path != null && (path.startsWith("/") || path.startsWith("\\"))) {
            path = path.substring(1);
        }
        return path;
    }

    private boolean requiresBaseDirectoryAlignment(String s) {
        if (s != null) {
            File f = new File(s);
            return !s.startsWith(FILE_SEPARATOR) && !f.isAbsolute();
        }
        return false;
    }

    public void unalignFromBaseDirectory(Model model, File basedir) {
        if (basedir == null) {
            return;
        }
        Build build = model.getBuild();
        if (build != null) {
            Resource resource;
            build.setDirectory(this.unalignFromBaseDirectory(build.getDirectory(), basedir));
            build.setSourceDirectory(this.unalignFromBaseDirectory(build.getSourceDirectory(), basedir));
            build.setTestSourceDirectory(this.unalignFromBaseDirectory(build.getTestSourceDirectory(), basedir));
            build.setScriptSourceDirectory(this.unalignFromBaseDirectory(build.getScriptSourceDirectory(), basedir));
            Iterator i = build.getResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                resource.setDirectory(this.unalignFromBaseDirectory(resource.getDirectory(), basedir));
            }
            i = build.getTestResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                resource.setDirectory(this.unalignFromBaseDirectory(resource.getDirectory(), basedir));
            }
            if (build.getFilters() != null) {
                ArrayList<String> filters = new ArrayList<String>();
                Iterator i2 = build.getFilters().iterator();
                while (i2.hasNext()) {
                    String filter = (String)i2.next();
                    filters.add(this.unalignFromBaseDirectory(filter, basedir));
                }
                build.setFilters(filters);
            }
            build.setOutputDirectory(this.unalignFromBaseDirectory(build.getOutputDirectory(), basedir));
            build.setTestOutputDirectory(this.unalignFromBaseDirectory(build.getTestOutputDirectory(), basedir));
            Reporting reporting = model.getReporting();
            if (reporting != null) {
                reporting.setOutputDirectory(this.unalignFromBaseDirectory(reporting.getOutputDirectory(), basedir));
            }
        }
    }

    public String unalignFromBaseDirectory(String path, File basedir) {
        String base;
        if (basedir == null) {
            return path;
        }
        if (path == null) {
            return null;
        }
        if ((path = path.trim()).startsWith(base = basedir.getAbsolutePath())) {
            path = this.chopLeadingFileSeparator(path.substring(base.length()));
        }
        if (!new File(path).isAbsolute()) {
            path = path.replace('\\', '/');
        }
        return path;
    }
}

