/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationCustom;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=ProfileActivator.class, hint="custom")
public class CustomActivator
implements ProfileActivator,
LogEnabled {
    @Requirement
    private PlexusContainer container;
    private Logger logger;

    public boolean canDetermineActivation(Profile profile, ProfileActivationContext context) throws ProfileActivationException {
        ProfileActivator activator;
        ActivationCustom custom;
        Activation activation = profile.getActivation();
        if (activation != null && (custom = activation.getCustom()) != null && (activator = this.loadProfileActivator(custom, context)) != null) {
            return activator.canDetermineActivation(profile, context);
        }
        return false;
    }

    private ProfileActivator loadProfileActivator(ActivationCustom custom, ProfileActivationContext context) throws ProfileActivationException {
        ProfileActivator activator;
        block5: {
            String type;
            block4: {
                type = custom.getType();
                activator = null;
                try {
                    activator = (ProfileActivator)this.container.lookup(ProfileActivator.class, type);
                }
                catch (ComponentLookupException e) {
                    if (context.isCustomActivatorFailureSuppressed()) break block4;
                    throw new ProfileActivationException("Cannot find custom ProfileActivator: " + type + ". \nPerhaps you're missing a build extension?", e);
                }
            }
            XmlPlexusConfiguration configuration = new XmlPlexusConfiguration((Xpp3Dom)custom.getConfiguration());
            BasicComponentConfigurator configurator = new BasicComponentConfigurator();
            try {
                configurator.configureComponent((Object)activator, (PlexusConfiguration)configuration, this.container.getContainerRealm());
            }
            catch (ComponentConfigurationException e) {
                if (context.isCustomActivatorFailureSuppressed()) break block5;
                throw new ProfileActivationException("Failed to configure custom ProfileActivator: " + type + ".", e);
            }
        }
        return activator;
    }

    public boolean isActive(Profile profile, ProfileActivationContext context) throws ProfileActivationException {
        ActivationCustom custom = profile.getActivation().getCustom();
        ProfileActivator activator = this.loadProfileActivator(custom, context);
        return activator.isActive(profile, context);
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(0, "CustomActivator-instantiated");
        }
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

